;;; -*- mode: lisp; package: drive-info.ffi -*-
;;;
;;; File: drive-info/ffi/kernel32.l
;;;
;;; License:
;;;
;;;   Copyright (c) 2007 MIYAMUKO Katsuyuki.
;;;
;;;   drive-info is released under an MIT license.
;;;   See drive-info/docs/MIT-LICENSE for full license.
;;;

(eval-when (:compile-toplevel :load-toplevel :execute)
  (require "drive-info/ffi/package")
  (require "drive-info/ffi/macros")
  (require "drive-info/ffi/types")
  )

(in-package :drive-info.ffi)

(c:*define-dll-entry
  LONG
  GetDriveType ((char *)  ;; lpRootPathName   // [gfBNg
                )
  "kernel32" "GetDriveTypeA")

(c:*define-dll-entry
  BOOL
  GetVolumeInformation (LPCSTR    ;; lpRootPathName,             // [gfBNg
                        LPCSTR    ;; lpVolumeNameBuffer,         // {[obt@
                        DWORD     ;; nVolumeNameSize,            // Oobt@̃TCY
                        (DWORD *) ;; lpVolumeSerialNumber,       // {[̃VAԍ
                        (DWORD *) ;; lpMaximumComponentLength,   // t@C̍ő̒
                        (DWORD *) ;; lpFileSystemFlags,          // t@CVXẽIvV
                        LPCSTR    ;; lpFileSystemNameBuffer,     // t@CVXei[obt@
                        DWORD     ;; nFileSystemNameSize         // t@CVXei[obt@̃TCY
                        )
  "kernel32" "GetVolumeInformationA")

(c:*define-dll-entry
  DWORD
  GetLogicalDrives ()
  "kernel32" "GetLogicalDrives")

(c:*define-dll-entry
  BOOL
  GetDiskFreeSpaceEx (LPCSTR              ;; lpDirectoryName,         // fBNg
                      (ULARGE_INTEGER *)  ;; lpFreeBytesAvailable,    // ĂяopłoCg
                      (ULARGE_INTEGER *)  ;; lpTotalNumberOfBytes,    // fBXNŜ̃oCg
                      (ULARGE_INTEGER *)  ;; lpTotalNumberOfFreeBytes // fBXNŜ̋󂫃oCg
                      )
  "kernel32" "GetDiskFreeSpaceExA")


(provide "drive-info/ffi/kernel32")

;;; End
