=begin

= drive-info - _hCȕ擾郉Cu

  * Author: MIYAMUKO Katsuyuki ((<URL:mailto:miyamuko (at) gmail.com>))
  * Home: ((<URL:http://miyamuko.s56.xrea.com/xyzzy/drive-info/intro.htm>))
  * Version: 1.1.0


== SYNOPSIS

=== API

  (require "drive-info/api")
  (use-package :drive-info.api)

  (get-logical-drive-letters)  ;; => (#\C #\D)
  (get-fixed-logical-drives)   ;; => ("C:\\")
  (get-drive-type #\d)         ;; => :cdrom
  (drive-exist-p "d")          ;; => t

  ;; SŒfBXN uhCu  {[  t@CVXe  󂫗̈%v\
  (labels ((x (alist &rest path)
             (reduce #'(lambda (node path)
                         (or (cdr (assoc path node))
                             (return-from x)))
                     path
                     :initial-value alist)))
    (dolist (drive (get-fixed-logical-drives))
      (let ((info (get-drive-info drive)))
        (with-output-to-temp-buffer ("*drive list*")
          (format t "~A  ~10A  ~10A  ~1F%~%"
                  (x info :drive :name)
                  (x info :volume :volume-name)
                  (x info :volume :file-system-name)
                  (x info :space :free-bytes%))))))


=== UI

  * hCű󂫗eʂ|bvAbv\

      M-x drive-info-popup-disk-free-space-kuma--


== DESCRIPTION

drive-info ̓hCu擾郉CułB
get-disk-usage ł͎擾łȂ擾\łB

ȉ̋@\pł܂B

  * hCüꗗ擾
  * pĂȂhCüꗗ擾
  * ŒfBXÑhCüꗗ擾
  * hCu݂邩ǂ
  * hCũ^Cv (CD-ROM? tbs[? n[hfBXN? Ȃ) 擾
  * hCű󂫗eʁEgpeʂ擾
  * hCȕڍׂȏ擾

{Iɂ̓CułȒPȃtgGh܂B

  * hCű󂫗eʂ|bvAbv\ł܂B


== INSTALL

((<NetInstaller|URL:http://www7a.biglobe.ne.jp/~hat/xyzzy/ni.html>)) ŃCXg[ꍇ 4 ȍ~A
NetInstaller + (({ni-autoload})) gĂl 5 ȍ~ OK łB

(1) A[JCu_E[h܂B

    ((<URL:http://miyamuko.s56.xrea.com/xyzzy/archives/drive-info.zip>))

(2) A[JCuWJāA$XYZZY/site-lisp zɃt@CRs[܂B

(3) ~/.xyzzy ܂ $XYZZY/site-lisp/siteinit.l Ɉȉ̃R[hǉ܂B

        ;; drive-info
        (require "drive-info")

(4) ݒ𔽉f邽 xyzzy ċNĂB

    siteinit.l ɋLqꍇɂ͍ă_vKvłB

(5) M-x drive-info-popup-disk-free-space-kuma-- ŋ󂫗eʂ\ł܂B

(6) CuƂėpꍇ drive-info.api pbP[W
    use Ă package prefix ȗł܂B

      (require "drive-info")
      (in-package :your-cool-application)
      (use-package :drive-info.api)


== MODULE

=== PACKAGE

drive-info ͈ȉ̃pbP[W𗘗pĂ܂B

  * drive-info.api

    Cu̒`Bʖ (nickname)  driveB

  * drive-info.ffi

    pB

  * editor

    tgGh̒`B

=== EXPORT

  * drive-info.api

    * ((< drive-info-version >))
    * ((< drive-info-api-version >))
    * ((< get-drive-info >))
    * ((< get-logical-drives >))
    * ((< get-logical-drive-letters >))
    * ((< get-fixed-logical-drives >))
    * ((< get-fixed-logical-drive-letters >))
    * ((< get-free-logical-drives >))
    * ((< get-free-logical-drive-letters >))
    * ((< drive-exist-p >))
    * ((< get-drive-type >))
    * ((< get-volume-information >))
    * ((< get-disk-free-space >))
    * ((< drive-name >))
    * ((< drive-letter >))

  * editor

    * ((< drive-info-popup-disk-free-space-kuma-- >))

  * drive-info-ffi

    pȂ̂ŏȗBBB


=== VARIABLE

ȂB


=== COMMAND

==== editor pbP[W

--- drive-info-popup-disk-free-space-kuma--

    hCű󂫗eʂ|bvAbvăOt\܂B


=== FUNCTION

==== drive-info.api pbP[W

ȉ̊֐ׂ͂ drive-info.api pbP[WŒ`Ă܂B

TvR[hׂ͂ drive-info.api  use ĂƂO
package prefix ȗĂ܂B

root-dir ɂƂ֐̓hCu ( or ) pXȂǂwł܂B
ȉ̌Ăяoׂ͂ėLłB

  (drive-exist-p #\x)
  (drive-exist-p #\Y)
  (drive-exist-p "z")
  (drive-exist-p "z:")
  (drive-exist-p "Y:/foo/bar")


--- drive-info-version

    drive-info ̃o[WԂ܂B
    o[W major.minor.teeny Ƃ`łB

    ꂼ̔ԍ͕K 1 ɂ̂ŁAȉ̂悤ɔr邱Ƃł܂
    (Ruby Ɠł :-)B

        (if (string<= "1.1.0" (drive-info-version))
            (1.1.0 ȍ~ŗLȏ)
          (1.1.0 Õo[Wł̏))

    drive-info.api 𗘗pAvP[VĂāA
     API Ă邩ǂ̔肵ꍇ
    ((<URL:drive-info.api:drive-info-api-version>))
    𗘗pĂB

--- drive-info-api-version

    call-seq:
      (layered-window-api-version) => 1

    drive-info API ̃o[WԂ܂B
    o[W͒PȐlłB

    drive-info.api pbP[WŒ`Ă API ɒǉEύXꍇ
    CNg܂B

--- get-logical-drives

    call-seq:
        (get-logical-drives) => (drive namess...)

    ݂ShCũXg擾܂B
    hCu͑啶łB

      (get-logical-drives) 
      ;; => ("C:\\" "D:\\")

--- get-logical-drive-letters

    call-seq:
        (get-logical-drive-letters) => (drive letters...)

    ݂ShCũhCũXg擾܂B
    hCu͑啶łB

      (get-logical-drive-letters) 
      ;; => (#\C #\D)

--- get-free-logical-drives

    call-seq:
        (get-free-logical-drives) => (drive namess...)

    ݂ȂShCũXg擾܂B
    hCu͑啶łB

      (get-free-logical-drives)  
      ;; => ("A:\\" "B:\\" ... "Z:\\")

--- get-free-logical-drive-letters

    call-seq:
        (get-free-logical-drive-letters) => (drive letters...)

    ݂ShCũhCũXg擾܂B
    hCu͑啶łB

      (get-free-logical-drive-letters) 
      ;; => (#\A #\B ... #\Z)

--- get-fixed-logical-drives

    call-seq:
        (get-fixed-logical-drives) => (drive namess...)

    ݂ŒfBXÑhCũXg擾܂B

      (get-fixed-logical-drives) 
      ;; => ("C:\\")

--- get-fixed-logical-drive-letters

    call-seq:
        (get-fixed-logical-drive-letters) => (drive letters...)

    ݂ŒfBXÑhCũXg擾܂B

      (get-fixed-logical-drive-letters) 
      ;; => (#\C)

--- drive-exist-p

    call-seq:
        (drive-exist-p root-dir) => t or nil

    w肵hCu݂邩ǂ肵܂B

    ɂ̓hCufBNgw肵܂B
    nil w肷 (default-directory) ̃hCȕ擾܂B

--- get-drive-info

    call-seq:
        (get-drive-info root-dir) => (alist)

    drive-info Ŏ擾\ȑS擾܂B

    ɂ̓hCufBNgw肵܂B
    nil w肷 (default-directory) ̃hCȕ擾܂B

    ȉ̂悤ȃXgԂ܂B

      ((:drive
        (:name . <hCu^[>)
        (:type . <hCu^Cv>))

       (:volume
        (:volume-name . <{[>)
        (:volume-serial-number . <{[̃VAԍ>)
        (:maximum-component-length . <t@C̍ő̒>)
        (:file-system-flags
         ((:case-sensitive-search . <t or nil>)
          (:case-preserved-names . <t or nil>)
          (:unicode-on-disk . <t or nil>)
          (:persistent-acls . <t or nil>)
          (:file-compression . <t or nil>)
          (:volume-quotas . <t or nil>)
          (:supports-sparse-files . <t or nil>)
          (:supports-reparse-points . <t or nil>)
          (:supports-remote-storage . <t or nil>)
          (:volume-is-compressed . <t or nil>)
          (:supports-object-ids . <t or nil>)
          (:supports-encryption . <t or nil>)
          (:named-streams . <t or nil>)
          (:read-only-volume . <t or nil>)))
        (:file-system-name . <t@CVXe>))
       (:space
        (:free-bytes-available . <ĂяopłoCg>)
        (:total-number-of-bytes . <fBXNŜ̃oCg>)
        (:total-number-of-free-bytes . <fBXNŜ̋󂫃oCg>)
        (:total-number-of-used-bytes . <fBXNŜ̎gpoCg>)
        (:free-bytes% . <fBXNŜ̋󂫗e%>)
        (:used-bytes% . <fBXNŜ̎gpe%>)))

    * hCu^[:  "C:\\", "D:\\" ȂǕŕԂB
    * hCu^Cv: :unknown, :no-root-dir, :removable, :fixed, :remote, :cdrom, :ramdisk ̂ǂꂩB
    * {[: "[J fBXN" ȂǁB}CRs[^Ō閼OB
    * t@CVXe: "NTFS" ȂǁB

--- get-drive-type

    call-seq:
        (get-drive-type root-dir) => :keyword

    hCu^Cv擾܂B

    ɂ̓hCufBNgw肵܂B
    nil w肷 (default-directory) ̃hCȕ擾܂B

      (get-drive-type "C:")
      ;; => :fixed

      (get-drive-type #\d)
      ;; => :cdrom

    hCu^Cv͈ȉ̃L[[ĥꂩԂ܂B

      : :unknown
            hCu̎ނ𔻕ʂł܂łB
      : :no-root-dir
             w̃[gfBNg݂܂B
             Ƃ΁ApXɃ{[}EgĂ܂
             itH[}bgAfBA}ĂȂȂǁjB
      : :removable
             ̃fBXŃAhCuo܂B
      : :fixed
             ̃fBXŃAhCuo܂B
      : :remote
             ̃hCúA[gilbg[NjhCułB
      : :cdrom
             ̃hCúACD-ROM hCułB
      : :ramdisk
             ̃hCúARAM fBXNłB

--- get-volume-information

    call-seq:
        (get-volume-information root-dir) => (alist)

    t@CVXeƃ{[Ɋւ擾܂B

    ɂ̓hCufBNgw肵܂B
    nil w肷 (default-directory) ̃hCȕ擾܂B

    ȉ̂悤ȃXgԂ܂B

      ((:volume-name . <{[>)
       (:volume-serial-number . <{[̃VAԍ>)
       (:maximum-component-length . <t@C̍ő̒>)
       (:file-system-flags
        ((:case-sensitive-search . <t or nil>)
         (:case-preserved-names . <t or nil>)
         (:unicode-on-disk . <t or nil>)
         (:persistent-acls . <t or nil>)
         (:file-compression . <t or nil>)
         (:volume-quotas . <t or nil>)
         (:supports-sparse-files . <t or nil>)
         (:supports-reparse-points . <t or nil>)
         (:supports-remote-storage . <t or nil>)
         (:volume-is-compressed . <t or nil>)
         (:supports-object-ids . <t or nil>)
         (:supports-encryption . <t or nil>)
         (:named-streams . <t or nil>)
         (:read-only-volume . <t or nil>)))
       (:file-system-name . <t@CVXe>))

    t@CVXeIvV̈Ӗ͈ȉ̂ƂłB

      : :case-sensitive-search
          t@C̑啶Ə̋ʂT|[gĂ܂B

      : :case-preserved-names
          fBXNɃt@CL^ƂɁA啶Əʂĕۑ܂B

      : :unicode-on-disk
          Unicode ̃t@CT|[gĂāAfBXNł\܂B

      : :persistent-acls
          ACLiANZX䃊Xgj̕ۑƓKps܂B
          Ƃ΁ANTFS  ACL ̕ۑƓKps܂AFAT  ACL T|[gĂ܂B

      : :file-compression
          t@Cx[ẌkT|[gĂ܂B

      : :volume-quotas
          fBXNNH[^ifBXNgpʂ̊蓖ċ@\jT|[gĂ܂B

      : :supports-sparse-files
          Xp[Xt@Ciaȃt@CAgp̗̈悪A܂͓lt@Cj
          T|[gĂ܂B

      : :supports-reparse-points
          ĉ̓|CgT|[gĂ܂B

      : :supports-remote-storage
          [gXg[WT|[gĂ܂B

      : :volume-is-compressed
          w肳ꂽ{[́Ak{[iƂ΁ADoubleSpace ̃{[jłB

      : :supports-object-ids
          IuWFNgʎqT|[gĂ܂B

      : :supports-encryption
          Ít@CVXeiEFSjT|[gĂ܂B

      : :named-streams
          OtXg[T|[gĂ܂B

      : :read-only-volume
          ݕsłB

--- get-disk-free-space

    call-seq:
        (get-disk-free-space root-dir) => (alist)

    {[̗eʂɊւ擾܂B

    ɂ̓hCufBNgw肵܂B
    nil w肷 (default-directory) ̃hCȕ擾܂B

    ȉ̂悤ȃXgԂ܂B

      ((:free-bytes-available . <ĂяopłoCg>)
       (:total-number-of-bytes . <fBXNŜ̃oCg>)
       (:total-number-of-free-bytes . <fBXNŜ̋󂫃oCg>)
       (:total-number-of-used-bytes . <fBXNŜ̎gpoCg>)
       (:free-bytes% . <fBXNŜ̋󂫗e%>)
       (:used-bytes% . <fBXNŜ̎gpe%>))

--- drive-name

    call-seq:
        (drive-name root-dir) => drive name

    w肳ꂽfBNg̃hCu擾܂B

      (drive-name "c:\\hoge")
      ;; => "C:\\"

      (drive-name #\C)
      ;; => "C:\\"

    ɂ̓hCufBNgw肵܂B
    nil w肷 nil Ԃ܂B

    ȉ̓_ pathname-device Ƃ͈Ⴂ܂B

      * nil w肷 nil Ԃ܂B
        (pathname-device ̓G[)B
      * At@xbgꕶnƃhCu^[Ƃĉ߂܂
        (pathname-device ̓fBNgƂĉ߂ default-directory ̃hCuԂ)B
      * #\C ȂǕw\łB
      * hCu^[͏ɑ啶B
      * ":\\" tĂB

    ̊֐̓hCȗ݃`FbN͂܂B

--- drive-letter

    call-seq:
        (drive-letter root-dir) => drive letter

    w肳ꂽfBNg̃hCu^[擾܂B
    K啶ŕԂ܂B

      (drive-letter "c:\\hoge")
      ;; => #\C

      (drive-letter #\c)
      ;; => #\C

    ɂ̓hCufBNgw肵܂B
    nil w肷 nil Ԃ܂B

    ̊֐̓hCȗ݃`FbN͂܂B


=== EXPORT

==== editor

editor pbP[W͈ȉ̃R}h export Ă܂B

* drive-info-popup-disk-free-space-kuma--

==== drive-info.api

drive-info.api pbP[W͈ȉ̊֐ export Ă܂B

* get-drive-info
* get-logical-drives
* get-drive-type
* get-volume-information
* get-disk-free-space
* drive-exist-p

* volume-name
* volume-serial-number
* maximum-component-length
* file-system-flags
* file-system-name

* free-bytes-available
* total-number-of-bytes
* total-number-of-free-bytes
* total-number-of-used-bytes
* free-bytes%
* used-bytes%


== TODO

* fBXN擾
  * DeviceIoControl
  * Win32_DiskDrive


== KNOWN BUGS

ȂB


== AUTHORS

݂ނ 䂫 (((<URL:mailto:miyamuko (at) gmail.com>)))


== SEE ALSO

  : GetLogicalDrives
        ((<URL:http://msdn.microsoft.com/library/ja/jpfileio/html/_win32_getlogicaldrives.asp>))
  : GetDriveType
        ((<URL:http://msdn.microsoft.com/library/ja/jpfileio/html/_win32_getdrivetype.asp>))
  : GetVolumeInformation
        ((<URL:http://msdn.microsoft.com/library/ja/jpfileio/html/_win32_getvolumeinformation.asp>))
  : GetDiskFreespaceEx
        ((<URL:http://msdn.microsoft.com/library/ja/jpfileio/html/_win32_getdiskfreespaceex.asp>))
  
  : û``ǂXvev⏕TCg
        ((<URL:http://dokoaa.com/kuma.html>))
  : AsciiArtHeadline  AA ڂ DB
        ((<URL:http://tecstar.ddo.jp/aa_video/aadb/select.cgi?page=10&rowcount=5&baa=1&word=%92%DE%82%E8>))


== COPYRIGHT

drive-info  MIT/X CZXɂėp\łB

See drive-info/docs/MIT-LICENSE for full license.


== NEWS

<<<NEWS.rd

=end
