;;; diff-backup.l --- obNAbvt@CƂdiff\

;; Author: rufein 
;; Created: 2008-03-15
;; Version: 0.0.2
;; Keywords: Text

;; Licence:
;; 
;; diff-backup.l  MIT license ɊÂėp\łB
;; 
;; Copyright (C) 2008 rufein.
;;
;; Permission is hereby granted, free of charge, to any person obtaining a copy
;; of this software and associated documentation files (the "Software"), to deal
;; in the Software without restriction, including without limitation the rights
;; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
;; copies of the Software, and to permit persons to whom the Software is
;; furnished to do so, subject to the following conditions:
;;
;; The above copyright notice and this permission notice shall be included in
;; all copies or substantial portions of the Software.
;;
;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
;; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
;; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
;; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
;; THE SOFTWARE.

;;; Commentary:
;;
;; == Tv
;; obNAbvt@CƂdiff\܂B
;; 
;; obNAbvƂݒɂȂĂȂΈӖ̂ȂgłB
;; gpꍇ́Ac[ -> ʐݒ -> obNAbvt@C ŁA
;; obNAbvt@C Ƀ`FbNĂB
;;
;; === ӓ_
;; ȉ̏ꍇmFĂ܂B
;; (1) obNAbvt@CIWĩt@CƓfBNgɍ쐬ꍇ(*backup-directory*  nil ̏ꍇ)
;;     "obNAbvt@C"ȊO̓ftHĝ܂܂Ȃ炱ɂĂ͂܂͂łB
;; (2) obNAbvfBNgȉ̂悤ɐݒ肵Ăꍇ
;;       (require "backup")
;;       (setq *backup-directory* "C:/path/to/backup")
;;       (setq *hierarchic-backup-directory* t)
;;     *backup-directory* ɃXgݒ肵A"/"܂܂ȂݒɂĂÁA
;;     *hierarchic-backup-directory*  nil ɂȂĂꍇ͖mFłB
;; 
;; 
;; == CXg[
;; NetInstallerŃCXg[ꍇ(1),(2)͕Kv܂B
;; 
;; (1) diff-backup.lzh_E[hēWJAdiff-backup.lsite-lispȉɕۑĂB
;; (2) .xyzzy 
;;     (require "diff-backup")
;;     ƂĂB
;; (3) L[oChݒ肷ꍇ
;;     (global-set-key #\S-#\F10 'diff-backup)
;;     ȂǂƂĂB(Shift+F10 Ɋ蓖Ăꍇ)
;;
;; == gp@
;; obNAbvt@CƂdiffƂ肽obt@IāA
;;  M-x diff-backup
;; ƂĂB
;; 
;; ̓L[oChݒ肵ĎsĂB
;; 
;; ftHgł͍ŐV(1O)̃obNAbvt@CƂdiff\܂A
;;   C-u 2 diff-backup
;; ƂƁA2ÕobNAbvt@CƂdiff\܂B
;;

;;; Change log:
;; * 2008-03-15  ver 0.0.1
;;   *  쐬
;; * 2008-03-20  ver 0.0.2
;;   * diff-backup̈ύX
;;   * obNAbvt@Č̐K\C
;;   * NetInstallerΉ
;;

;;; Code:

(provide "diff-backup")

(in-package "editor")
(require "diff")
(require "backup")

(export
 '(diff-backup))

(defun diff-backup (&optional (count 1))
  "obNAbvt@CƂdiff\"
  (interactive "p")
  (let* ((original (get-buffer-file-name (selected-buffer)))
	 (backup (get-backup-file-name original count)))
    (unless backup
      (error "obNAbvt@C܂B"))
    (diff original
	  backup)))

(defun get-backup-file-name (file-absolute-path-name count)
  "obNAbvt@C̃pXԂB
file-absolute-path-name ̓IWĩt@C̐΃pXB
count ɉÔ̂w肷B"
  ;  (car (list-backup-files (get-backup-base-file-name file-absolute-path-name))))
  (let ((backup-files (list-backup-files (get-backup-base-file-name file-absolute-path-name)))
	(backup))
    (and (> count 0)
	 (<= count (length backup-files))
	 (setf backup (nth (- count 1) backup-files)))
    backup))

(defun list-backup-files (base-file-name)
  "obNAbvt@C̈ꗗXgŎ擾B
base-file-name̓obNAbvt@C̊ƂȂt@CB(΃pX)
C:/original/foo.txt ̃obNAbvt@C̈ꗗ擾ɂ́A
C:/path/to/backup/C/original/foo.txt ƂpXnKvB"
  (let* ((directory-name (directory-namestring base-file-name))
	 (backup-files (directory directory-name :absolute t :recursive nil :file-only t )))
    (sort
     (remove-if-not #'(lambda (x)
			(string-match (format nil "^~A\.??[0-9]*~~$" base-file-name) x))
		    backup-files)
     #'file-newer-than-file-p)))

(defun get-backup-base-file-name (file-absolute-path-name)
  "obNAbvt@C̊ƂȂt@C擾B
file-absolute-path-name ̓IWĩt@C̐΃pXB"
  (if *backup-directory*
      (merge-pathnames
       (substitute-string file-absolute-path-name ":" "")
       *backup-directory*)
    file-absolute-path-name))

;;; diff-backup.l ends here
