;;; -*- Mode: Lisp; Package: EDITOR -*-
;;; csv-mode.l --- Comma Separated Value file editing mode for xyzzy

;; Copyright (C) 2001-2006 OHKUBO Hiroshi <ohkubo@s53.xrea.com>

;; Author: OHKUBO Hiroshi <ohkubo@s53.xrea.com>
;; Version: 0.0.3.0
;; Time-stamp: <2006/10/21 19:39:23 +0900>

;;; Commentary:

;; Description:
;;
;;  CSV/TSVt@CҏWpW[[hłB
;;

;; Installation:
;;
;;      1. A[JCuWJ csv-mode.l  $XYZZY/site-lisp 
;;         Rs[܂B
;;
;;      2. oCgRpC܂B
;;
;;              M-x byte-compile-file
;;              Byte compile file: $XYZZY/site-lisp/csv-mode.l
;;
;;      3. *.csv/*.tsv ǂ݂񂾂ƂɎI csv-mode 
;;         邽߂ɁAȉ̃R[hǉ܂B
;;
;;         ~/.xyzzy ɒǉꍇ
;;              (export '(ed::csv-mode  ed::tsv-mode) "ed")
;;              (autoload 'csv-mode "csv-mode" t)
;;              (autoload 'tsv-mode "csv-mode" t)
;;              (pushnew '("\\.csv$" . csv-mode) *auto-mode-alist* :test 'equal)
;;              (pushnew '("\\.tsv$" . tsv-mode) *auto-mode-alist* :test 'equal)
;;
;;         $XYZZY/site-lisp/siteinit.l ɒǉꍇ
;;              (in-package "editor")
;;              (export '(csv-mode tsv-mode))
;;              (autoload 'csv-mode "csv-mode" t)
;;              (autoload 'tsv-mode "csv-mode" t)
;;              (pushnew '("\\.csv$" . csv-mode) *auto-mode-alist* :test 'equal)
;;              (pushnew '("\\.tsv$" . csv-mode) *auto-mode-alist* :test 'equal)
;;              (in-package "user")
;;
;;      4. L̐ݒ𔽉f邽߂ɁAxyzzy ċN܂B
;;         siteinit.l ɋLqꍇ Ctrl L[ Shift L[Ȃ
;;         xyzzy ċNA_vt@Cč\z܂B
;;

;; Uninstallation:
;;
;;      1. csv-mode.l ɊւLq폜܂B
;;
;;      2. siteinit.l ɋLqĂꍇ Ctrl L[ Shift L[
;;         Ȃ xyzzy ċNA_vt@Cč\z܂B
;;

;; Usage:
;;
;;      M-x csv-mode
;;      M-x tsv-mode
;;

;; Key bind:
;;
;;      ESC TAB     s񂩂̕⊮
;;      C-c C-e     ҏW_CAO
;;      C-c M-C-e   IҏW_CAO
;;      C-u C-c C-e 
;;      C-c C-v     ݍse popup \
;;      C-c C-w     ݍse window \
;;      C-c C-s     ƕ@Iă\[g
;;
;;      C-c C-i     ̑}^ǉ
;;      C-c C-d     ̍폜
;;      C-c C-c     ̓
;;
;;      C-c C-o     񕝂ŏ
;;      C-c C-a     񕝂𑵂
;;
;;      C-c C-x     sƗ̓
;;
;;      C-c C-b     r݂͂ɕϊ
;;      C-c C-h     HTML ɕϊ
;;
;;      C-c C-t     sڂwb_Ƃ邩ǂ̃gO
;;      C-c C-,     Zp[^̕ύX
;;      C-c C-;     s\̕ύX
;;
;;      C-n         sɈړBs\pEBhEɓe\B
;;      C-p         OsɈړBs\pEBhEɓe\B
;;      M-n         s̓Ɉړ
;;      C-Down      
;;      M-p         Os̓Ɉړ
;;      C-Up        
;;      TAB         ̗Ɉړ
;;      M-f         
;;      C-Right     
;;      M-b         O̗Ɉړ
;;      C-Left      
;;

;; Customize:
;;
;;      {ݒ
;;          (require "csv-mode")
;;          (setq-default csv-header-flag t)                 ; t, nil
;;          (setq-default csv-max-column-number-strict nil)  ; t, nil
;;          (setq-default csv-separator-char #\,)            ; <character>
;;          (setq-default csv-encode-string :except-integer) ; t, nil, :except-integer
;;          (setq *csv-edit-dialog-width* 256)                 ; <integer>
;;          (setq *csv-edit-dialog-header-width* 50)           ; <integer>
;;          (setq-default csv-edit-dialog-move :next)        ; :next, :previous, nil
;;          (setq *csv-line-number* t)         ; t, nil, <OTHER (:remain)>
;;          (setq *csv-cursor-line* t)         ; t, nil, <OTHER (:remain)>
;;          (setq *csv-buffer-fold-width* nil) ; t, nil, <integer>, <OTHER (:remain)>
;;
;;      popup-list g킸~jobt@ԍ
;;          (require "csv-mode")
;;          (define-key *csv-mode-map* '(#\C-c #\C-i) 'csv-insert-column)
;;          (define-key *csv-mode-map* '(#\C-c #\C-d) 'csv-delete-column)
;;          (define-key *csv-mode-map* '(#\C-c #\C-c) 'csv-change-column)
;;

;; Changes:
;;
;;      [Version 0.0.3.0]
;;      Thu, 24 Aug 2006 00:05:37 +0900
;;        Eʉ݋L \ $ ܂܂ĂĂ}b`悤
;;           *csv-number-regexp* XVB
;;
;;      Mon, 31 Jul 2006 00:25:30 +0900
;;        Ee֐̏CBp邽߂ nconc  append ɈꕔύXB
;;
;;      Sun, 16 Jul 2006 21:32:53 +0900
;;        Ecsv-record-next-record, csv-record-previous-record ǉ
;;
;;      Tue, 11 Jul 2006 00:39:10 +0900
;;        Ecsv-record-edit ֐ǉB
;;        Ecsv-position-box  csv-box-position ɕύX
;;        Ecsv-lcenter-box  csv-box-lcenter ɕύX
;;        Ecsv-rcenter-box  csv-box-rcenter ɕύX
;;        Ecsv-center-box  csv-box-center ɕύX
;;        Ecsv-left-box  csv-box-left ɕύX
;;        Ecsv-right-box  csv-box-right ɕύX
;;
;;      Sat, 08 Jul 2006 20:59:56 +0900
;;        Ecsv-change-record-newline  csv-record-change-newline ɕύXB
;;        Ecsv-view-line-on-record-window  csv-record-view-line ɕύXB
;;        Ecsv-set-record-buffer  csv-record-set-buffer ɕύXB
;;        Ecsv-view-record-buffer  csv-record-view-buffer ɕύXB
;;
;;      Sun, 02 Jul 2006 01:34:14 +0900
;;        E֐ csv-change-newline  csv-change-record-newline ɕύXB
;;        Eϐ csv-newline-char  csv-record-newline-char ɕύXB
;;
;;      Mon, 26 Jun 2006 00:32:04 +0900
;;        Ecsv-get-column-list ֐gB
;;           (decode max-column-number to) ɁBteύXB
;;        Ecsv-max-column-number ֐ŁASs𒲂ׂۂ̒l̃LbV
;;          悤ɍXVB
;;          obt@[Jϐ
;;            csv-max-column-number-strict-cache
;;          ֐
;;            csv-max-column-number-strict-cache-set
;;            csv-max-column-number-strict-cache-get
;;            csv-max-column-number-strict-cache-valid-p
;;          ǉB
;;
;;      Wed, 21 Jun 2006 00:30:39 +0900
;;        Ei[COɂ퓮삷悤 csv-sort XVB
;;        Ei[COɂ퓮삷悤 csv-convert-to-box XVB
;;        ESs񐔂łȂ csv-convert-to-box G[ԂĂ
;;          ̂CB
;;        Ei[COɂ퓮삷悤 csv-convert-to-html XVB
;;
;;      Tue, 20 Jun 2006 00:50:02 +0900
;;        Ecsv-get-column-list ̈̏ύX(to decode)(decode to)B
;;          tāAe֐`ύXB
;;        Ecsv-header-line-p ֐`B
;;        Ecsv-get-header-column-list ֐`B
;;
;;      Mon, 19 Jun 2006 00:07:29 +0900
;;        Ecsv-change-row-column CB
;;          obt@ csv-separator-char ł͂ȂAꎞobt@
;;           csv-separator-char ŏo͂Ă̂CB
;;        Ecsv-edit-dialog XVB
;;          - next-line-add-newlines ̍l߁AKvȂΏɐVKs
;;            ǉ悤ɁB
;;          - sҏW邱ƂɁAundo Eݒ肷悤ɁB
;;
;;      Fri, 16 Jun 2006 00:01:27 +0900
;;        Ecsv-change-row-column ǉB
;;        Ecsv-max-line-number CB
;;
;;      Mon, 05 Jun 2006 00:52:05 +0900
;;        EDOCSTRING ǉB
;;        Ecsv-next-line-keep-column ̒`ύXB
;;          sړs̏ꍇ͌ړȂ悤ɁB
;;        Ecsv-get-column-list `B
;;        Ecsv-view-line XVB
;;        Ecsv-do-completion `ύXB
;;        Ecsv-select-insert-column, csv-select-delete-column,
;;          csv-select-change-column, csv-select-sort XVB
;;          popup-list \ł 0 pfBOB
;;
;;      Fri, 26 May 2006 00:39:41 +0900
;;        E*csv-mode-local-map*  csv-mode-local-map ɕύXB
;;        Ecsv-view-record-burrer  csv-view-record-buffer ɏCB
;;        Ecsv-next-line ̒`ύXB
;;        Ecsv-forward-column, csv-backward-column ̒`ύXB
;;
;;      Wed, 11 Jan 2006 00:56:45 +0900
;;        Ecsv-convert-to-box CB
;;          - Ώۃobt@ɕ񂪉ȂꍇG[ƂȂ̂CB
;;            (܂[vɂȂ悤)
;;
;;      Thu, 24 Nov 2005 00:32:51 +0900
;;        Ecsv-max-line-number CB
;;
;;      Sat, 08 Oct 2005 13:57:09 +0900
;;        E[AhXύXB
;;        ECZX(CBSDCZX)LځB
;;
;;      Sat, 08 Jan 2005 06:52:29 +0900
;;        ERgCB
;;        Edefvar-local Œ`ϐ̃V{ *xxx*  xxx ɕύXB
;;          - *csv-header-flag*              -> csv-header-flag
;;          - *csv-max-column-number-strict* -> csv-max-column-number-strict
;;          - *csv-separator-char*           -> csv-separator-char
;;          - *csv-encode-string*            -> csv-encode-string
;;          - *csv-newline-char*             -> csv-newline-char
;;          - *csv-edit-dialog-move*         -> csv-edit-dialog-move
;;        Exyzzy 0.2.2.234 Ή
;;          - "lr oSVbN"  "MS UI Gothic"
;;          - pJiSpJiɕύXB
;;
;;      Tue, 12 Oct 2004 18:44:36 +0900
;;        Ecsv-convert-to-box ł́AJ̒llƌȂꍇ́A
;;          eZɉE񂹂ɂ悤ɕύXB
;;          csv-convert-to-html ͊̂܂ܐuB
;;        Ecsv-join-string-list  str-list  nil nꂽꍇA
;;          G[̂CB
;;
;;      Tue, 06 Apr 2004 15:03:32 +0900
;;        Ecsv-change-row-column ǉB
;;        E*csv-buffer-temp* ǉB
;;
;;      Sun, 09 Nov 2003 04:36:50 +0900
;;        Ecsv-view-line-on-window -> csv-view-line-on-record-window ɁB
;;
;;      Sat, 08 Nov 2003 13:50:46 +0900
;;        Ecsv-view-mode -> csv-record-mode ɖ̕ύX
;;
;;      Thu, 06 Nov 2003 11:30:48 +0900
;;        Ecsv-adjust-column ̍ہẪ݂J͉E񂹂悤ɁB
;;
;;      Wed, 05 Nov 2003 01:16:28 +0900
;;        Ecsv-lcenter-box, csv-rcenter-box ǉB
;;        E\[g̍ہA"," ܂܂Ă悢悤ɕύXB
;;
;;      Wed, 29 Oct 2003 10:22:05 +0900
;;        Ecsv-convert-to-box, csv-convert-to-html ̍ہẪ݂J
;;          E񂹂ɂ悤ɁB
;;          csv-convert-to-box, csv-convert-to-html CA
;;          csv-column-numberp-list, csv-curretn-line-column-numberp-list,
;;          *csv-number-regexp* ǉB
;;        Er͂ݕ\̃[h csv-box-mode 쐬B
;;          r͂݃Z̃Z^OAAE ǉB
;;          csv-center-box, csv-left-box, csv-right-box
;;
;;      Tue, 16 Sep 2003 19:02:57 +0900
;;        Ecsv-view-mode ֘AXVB
;;
;;      Thu, 22 May 2003 13:13:20 +0900
;;        Emenu ̃R[hCB
;;
;;      [Version 0.0.2.1]
;;      Mon, 19 May 2003 00:33:59 +0900
;;        Emenu ̃R[hCB
;;          M-x csv-mode sтɃj[̂CB
;;
;;      [Version 0.0.2.0]
;;      Sun, 27 Apr 2003 23:20:56 +0900
;;        Enconc ̕ps悭҂R[ĥCB
;;        Ecsv-next-line, csv-previous-line ̖̂
;;          csv-next-line-keep-column, csv-previous-line-keep-column ɕύXB
;;        Exyzzy Part8 704 ̃ACfA
;;          csv-view-line-on-window, csv-change-newline,
;;          csv-next-line, csv-previous-line VɒǉB
;;        ENetInstaller Ή
;;        ȆB
;;
;;      Sat, 08 Mar 2003 23:50:22 +0900
;;        E*csv-buffer-convert*  "*CSV: Convert*" ɁB
;;
;;      [Version 0.0.0.13]
;;      Fri, 07 Mar 2003 02:03:01 +0900
;;        Emenu  tag ̊ԈႢCB
;;        Ecsv-toggle-local-line-number, csv-toggle-local-cursor-line ǉB
;;
;;      Tue, 04 Mar 2003 00:31:37 +0900
;;        E*csv-line-number*, *csv-cursor-line*,
;;          *csv-buffer-fold-width* wǉB
;;
;;      [Version 0.0.0.12]
;;      Mon, 03 Mar 2003 00:42:48 +0900
;;        Ecsv-menu-update XVB
;;          menu \Ԃl悤ɁB
;;
;;      [Version 0.0.0.11]
;;      Thu, 15 Aug 2002 16:13:48 +0900
;;        Etdict t@CҏŴ߂ tsv-mode ǉB
;;          A*csv-tsv-separator-char* p~
;;
;;      [Version 0.0.0.10]
;;      Mon, 27 May 2002 01:23:05 +0900
;;        Eʐݒ́uȈԂۑvɃ`FbNĂ
;;          buffer-local j[Ȃ_CB(thanks YMTZ )
;;        E*csv-mode-hook*  *csv-mode-map* ύXĂfȂ_
;;          Ƃ肠CB
;;          csv-set-separator  csv-update-keymap ɖ̕ύXB
;;          ɔ̕ύXB
;;          *csv-mode-map* ύX csv-update-keymap ĂԕKv
;;          ܂B
;;
;;      Mon, 18 Feb 2002 01:01:26 +0900
;;        Ecsv-edit-dialog ̈ړCB
;;
;;      [Version 0.0.0.9]
;;      Mon, 14 Jan 2002 05:20:05 +0900
;;        Ecsv-edit-dialog, csv-selection-edit-dialog
;;        E*csv-header-flag-default* *csv-max-column-number-strict-default*
;;          *csv-separator-char-default* p~B
;;          *csv-header-flag* *csv-max-column-number-strict*
;;          *csv-separator-char*  buffer local ȕϐɁB
;;        E*csv-max-column-number-strict* dlύX
;;           nil : 擪sƌݍŝ傫񐔂ő񐔂Ƃ݂Ȃ
;;           t   : Ss𒲂אmȍő񐔂o
;;        Ecsv-next-line, csv-previous-line,
;;          csv-forward-column, csv-backward-column,
;;          csv-insert-column, csv-delete-column, csv-change-column CB
;;        Enext-line-add-newlines l悤ɁB
;;        ȆB
;;
;;      [Version 0.0.0.8]
;;      Mon, 14 Jan 2002 05:20:05 +0900
;;        Ej[B
;;        EC-[letter] ̃L[oChgpĂ̂𑼂ɕύXB
;;        E⊮͌̓CB
;;        Ecsv-convert-to-box CB
;;        Econvert ʏo̓obt@̕\CB
;;        ȆB
;;
;;      Thu, 01 Nov 2001 18:29:36 +0900
;;        Ecsv-convert-to-html  & < > ϊ悤ɁB
;;
;;      Thu, 01 Nov 2001 02:26:20 +0900
;;        Econvert ʏo̓obt@̕\܂ԂȂ悤ɁB
;;        E񒆂 ~ ꍇA(csv-convert-to-box) 
;;          usȃtH[}bgwqvƂȂoOCB
;;        E蔲 csv-convert-to-html
;;
;;      [Version 0.0.0.7]
;;      Wed, 31 Oct 2001 17:25:42 +0900
;;        Et@ĈȂobt@ csv-mode ɂłȂoOCB
;;
;;      [Version 0.0.0.6]
;;      Mon, 22 Oct 2001 23:23:48 +0900
;;        Ecsv-convert-to-box
;;          macro œeWJ邱Ƃł܂ÂB
;;
;;      Sun, 21 Oct 2001 07:49:46 +0900
;;        Eϐ̕ύX
;;          *csv-max-column-strict-default* 
;;          *csv-max-column-number-strict-default* 
;;        Eread-only t@Cւ̑ΏB
;;
;;      [Version 0.0.0.5]
;;      Fri, 19 Oct 2001 20:38:34 +0900
;;        E\[g̏C^x̉P
;;
;;      [Version 0.0.0.4]
;;      Fri, 19 Oct 2001 12:59:18 +0900
;;        E*csv-header-flag*  *csv-header-flag-default* ɕύXB
;;        E*csv-separator-char*  *csv-separator-char-default* ɕύXB
;;        E*csv-tsv-separator-char*
;;          gq tsv ̏ꍇ separator characterB
;;          character w肵Ăꍇ separator  character ɁB
;;        E*csv-max-column-number-strict-default*
;;          t           : Ss𒲂אmȒlo
;;          nil         : ݂̍s̗񐔂ő񐔂Ƃ݂Ȃ
;;          t, nil ȊO : sڂwb_Ƃ݂ȂĂꍇAݍsƈsڂ̑傫
;;                        łȂꍇ݂͌̍s̗񐔂ő񐔂Ƃ݂Ȃ
;;        E܂ɏd̂ŁA(long-operation) ɂB
;;
;;      Thu, 18 Oct 2001 05:46:56 +0900
;;        E\[g@ǉ₷悤ɏCB
;;
;;      [Version 0.0.0.3]
;;      Thu, 18 Oct 2001 01:38:25 +0900
;;        EftHgňsڂwb_ƔF悤ɕύXB
;;        Ewb_̏ꍇ͕⊮͂Ƀwb_܂܂Ȃ悤ɁB
;;        E\[gCB
;;
;;      [Version 0.0.0.2]
;;      Wed, 17 Oct 2001 23:09:23 +0900
;;        Ȇ}^ǉE폜EB
;;        E\[gB
;;        Esڂwb_ƂĂ邩ǂmode-lineɕ\B
;;
;;      [Version 0.0.0.1]
;;      Wed, 17 Oct 2001 04:06:17 +0900
;;        Eō쐬B
;;

;; Todo:
;;
;;      EHTML ϊɊւ
;;        E󔒃ZɑSpXy[X邩ǂB
;;        E^O啶ɂ邩ǂB
;;        EURL NB
;;        E^CgȂǂ܂񂾊S HTML ɕϊďo
;;      EZp[^̒uBiũt@CɕssłȂ̔fj
;;      E_uNH[g̕tEB
;;      ẼJ}̕tEB
;;      E񕝂𑵂ۂ̉E񂹁B
;;

;; Specification:
;;
;;      Ewb_sF
;;          - csv-header-flag  nil ̏ꍇ̓wb_sȂB
;;          - csv-header-flag  non-nil ̏ꍇ (point-min) |Cg
;;            镨s
;;      EősF
;;          - (point-max) |Cg̑镨sB
;;            A(point-max) |Cgł (bolp)  t ̏ꍇ
;;            (s̏ꍇ)́Au(point-max) |Cg̑镨s - 1vB
;;
;;      EԍAsԍƂ 1 IWB
;;
;;      EEɃXy[X܂݂ꍇ͕ `"' ŋށB
;;      E_uNH[g `"' 𕶎񒆂Ɋ܂߂ꍇ͗[ `"' ŋ񂾏ŁA
;;        `""' ƂB
;;
;;

;; Licence:
;;
;;    csv-mode ͏CBSDCZXɊÂėp\łB
;;    <http://www.opensource.org/licenses/bsd-license.php>
;;
;;
;;    Copyright (C) 2001-2006, OHKUBO Hiroshi.  All rights reserved.
;;
;;    Redistribution and use in source and binary forms, with or without
;;    modification, are permitted provided that the following conditions
;;    are met:
;;
;;    1. Redistributions of source code must retain the above copyright
;;       notice, this list of conditions and the following disclaimer.
;;
;;    2. Redistributions in binary form must reproduce the above copyright
;;       notice, this list of conditions and the following disclaimer in
;;       the documentation and/or other materials provided with the
;;       distribution.
;;
;;    3. Neither the name of the University nor the names of its
;;       contributors may be used to endorse or promote products derived
;;       from this software without specific prior written permission.
;;
;;    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;;    ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;;    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;;    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;;    OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;;    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
;;    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
;;    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
;;    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
;;    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
;;    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;;

;;; Code:

(provide "csv-mode")

(in-package "editor")

(export '(*csv-mode-hook*
          *csv-mode-update-keymap-hook*
          *csv-mode-map*
          *csv-mode-syntax-table*
          *csv-sort-method-list*
          *csv-keyword-file*
          *csv-regexp-keyword-list*
          *csv-line-number*
          *csv-cursor-line*
          *csv-buffer-fold-width*
          csv-max-column-number-strict
          csv-header-flag
          csv-separator-char
          csv-encode-string
          *csv-edit-dialog-width*
          *csv-edit-dialog-header-width*
          csv-edit-dialog-move
          *csv-record-mode-hook*
          *csv-record-mode-map*
          *csv-record-mode-syntax-table*
          csv-record-newline-char
          *csv-menu-name*
          *csv-menu-position*
          *csv-menu*))

(export '(csv-mode
          tsv-mode
          csv-change-separator
          csv-toggle-header-flag
          csv-view-line
          csv-edit-dialog
          csv-selection-edit-dialog
          csv-forward-column
          csv-backward-column
          csv-next-line
          csv-previous-line
          csv-next-line-keep-column
          csv-previous-line-keep-column
          csv-do-completion
          csv-optimize-column
          csv-adjust-column
          csv-change-row-column
          csv-convert-to-html
          csv-convert-to-box
          csv-select-insert-column
          csv-select-delete-column
          csv-select-change-column
          csv-insert-column
          csv-delete-column
          csv-change-column
          csv-select-sort
          csv-toggle-local-line-number
          csv-toggle-local-cursor-line
          csv-record-change-newline
          csv-record-view-line
          csv-record-toggle-view-line
          csv-record-edit
          csv-record-next-record
          csv-record-previous-record))

(defconstant *csv-version* "0.0.3.0"
  "csv-mode: o[W")

(defvar *csv-line-number* t
  "csv-mode: sԍ\w (t, nil, <OTHER (:remain)>)")
(defvar *csv-cursor-line* t
  "csv-mode: sJ[\\w (t, nil, <OTHER (:remain)>)")
(defvar *csv-buffer-fold-width* nil
  "csv-mode: eLXg܂Ԃw (t, nil, <integer>, <OTHER (:remain)>)")

(defvar-local csv-max-column-number-strict nil
  "csv-mode: ő񐔂ǂ̒xmɋ߂邩
t   : Ss𒲂אmȍő񐔂o
nil : sڂƌݍŝ傫񐔂ő񐔂Ƃ݂Ȃ")
(defvar-local csv-header-flag t
  "csv-mode: sڂwb_Ƃ݂Ȃ (t, nil)")
(defvar-local csv-separator-char #\,
  "csv-mode: ̋؂蕶")
(defvar-local csv-encode-string :except-integer
  "csv-mode: ́u\"vł̊
t               : Sāu\"vŊ
:except-integer : lȊOu\"vŊ
nil             : K{̏ꍇ̂݁u\"vŊ")
(defvar-local csv-record-newline-char #\;
  "csv-mode: csv-record-view-line ɉs\镶")

(defvar *csv-edit-dialog-width* 245
  "csv-mode: _CAO̕")
(defvar *csv-edit-dialog-header-width* 48
  "csv-mode: _CAOł̃wb_̕")
(defvar-local csv-edit-dialog-move :next
  "csv-mode: _CAOҏW̕
:next     : sɈړ
:previous : OsɈړ
̑    : ړȂ")

(defvar *csv-sort-method-list*
  (list
   (list "  ([Aa][Zz])"
         #'(lambda (str-a str-b)
             (cond
              ((string-lessp str-a str-b) -1)
              ((string-equal str-a str-b)  0)
              (t 1))))
   (list "  (AZaz)"
         #'(lambda (str-a str-b)
             (cond
              ((string< str-a str-b) -1)
              ((string= str-a str-b)  0)
              (t 1))))
   (list " ~ ([Zz][Aa])"
         #'(lambda (str-a str-b)
             (cond
              ((string-greaterp str-a str-b) -1)
              ((string-equal str-a str-b)  0)
              (t 1))))
   (list " ~ (zaZA)"
         #'(lambda (str-a str-b)
             (cond
              ((string> str-a str-b) -1)
              ((string= str-a str-b)  0)
              (t 1))))
   (list "  ()"
         #'(lambda (str-a str-b)
             (setq str-a (substitute-string str-a "," ""))
             (setq str-b (substitute-string str-b "," ""))
             (let (int-a int-b)
               (if (string-match "^-?[1-9][0-9]*$" str-a)
                   (setq int-a (parse-integer (match-string 0))))
               (if (string-match "^-?[1-9][0-9]*$" str-b)
                   (setq int-b (parse-integer (match-string 0))))
               (cond
                ((and int-a int-b)
                 (cond
                  ((< int-a int-b) -1)
                  ((= int-a int-b)  0)
                  (t 1)))
                (int-a -1)
                (int-b  1)
                (t 0)))))
   (list " ~ (偨)"
         #'(lambda (str-a str-b)
             (setq str-a (substitute-string str-a "," ""))
             (setq str-b (substitute-string str-b "," ""))
             (let (int-a int-b)
               (if (string-match "^-?[1-9][0-9]*$" str-a)
                   (setq int-a (parse-integer (match-string 0))))
               (if (string-match "^-?[1-9][0-9]*$" str-b)
                   (setq int-b (parse-integer (match-string 0))))
               (cond
                ((and int-a int-b)
                 (cond
                  ((> int-a int-b) -1)
                  ((= int-a int-b)  0)
                  (t 1)))
                (int-a -1)
                (int-b  1)
                (t 0)))))
   (list "󗓂𖖔"
         #'(lambda (str-a str-b)
             (cond
              ((and (string= str-a "") (string= str-b "")) 0)
              ((string= str-b "") -1)
              ((string= str-a "")  1)
              (t 0))))
   (list "󗓂擪"
         #'(lambda (str-a str-b)
             (cond
              ((and (string= str-a "") (string= str-b "")) 0)
              ((string= str-a "") -1)
              ((string= str-b "")  1)
              (t 0))))
   (list "~"
         #'(lambda (str-a str-b)
             (let ((char-a (if (string= str-a "") #\SPC (char str-a 0)))
                   (char-b (if (string= str-b "") #\SPC (char str-b 0))))
               (cond
                ((char= char-a #\)
                 (case char-b ((#\) 0) (t -1)))
                ((char= char-a #\)
                 (case char-b ((#\) 1) ((#\) 0) (t -1)))
                ((char= char-a #\)
                 (case char-b ((#\ #\) 1) ((#\) 0) (t -1)))
                ((char= char-a #\)
                 (case char-b ((#\ #\ #\) 1) ((#\) 0) (t -1)))
                ((char= char-a #\)
                 (case char-b ((#\ #\ #\ #\) 1) ((#\) 0) (t -1)))
                ((char= char-a #\~)
                 (case char-b ((#\ #\ #\ #\ #\) 1) ((#\~) 0) (t -1)))
                (t
                 (case char-b ((#\ #\ #\ #\ #\ #\~) 1) (t 0)))))))
   )
  "csv-mode: \[g@̃Xg")

(defvar *csv-www-special-chars-alist* '(("&amp;" . "&")
                                        ("&nbsp;" . " ")
                                        ("&lt;" . "<")
                                        ("&gt;" . ">")
                                        ("&quot;" . "\""))
  "csv-mode: csv-convert-to-html ɕϊꕶ̑Ή")

(defvar *csv-buffer-convert* "*CSV: Convert*"
  "csv-mode: ϊo̓obt@")
(defvar *csv-buffer-record* "*CSV: Record*"
  "csv-mode: R[hpobt@")
(defvar *csv-buffer-temp* " *CSV: Temp*"
  "csv-mode: e|obt@")

(defvar *csv-mode-hook* nil
  "csv-mode: [htbN")
(defvar *csv-mode-update-keymap-hook* nil
  "csv-mode: L[}bvXVftbN")

(defvar *csv-keyword-file* "CSV"
  "csv-mode: L[[ht@C")
(defvar *csv-keyword-hash-table* nil
  "csv-mode: L[[hnbVe[u")
(defvar *csv-regexp-keyword-list* nil
  "csv-mode: K\L[[hXg")

(defvar *csv-mode-map* nil
  "csv-mode: Local keymap")
(unless *csv-mode-map*
  (setq *csv-mode-map* (make-sparse-keymap))
  (define-key *csv-mode-map* #\M-TAB 'csv-do-completion)
  (define-key *csv-mode-map* #\TAB 'csv-forward-column)
  (define-key *csv-mode-map* #\C-n 'csv-next-line)
  (define-key *csv-mode-map* #\C-p 'csv-previous-line)
  (define-key *csv-mode-map* #\Down 'csv-next-line)
  (define-key *csv-mode-map* #\Up 'csv-previous-line)
  (define-key *csv-mode-map* #\M-n 'csv-next-line-keep-column)
  (define-key *csv-mode-map* #\M-p 'csv-previous-line-keep-column)
  (define-key *csv-mode-map* #\M-f 'csv-forward-column)
  (define-key *csv-mode-map* #\M-b 'csv-backward-column)
  (define-key *csv-mode-map* #\C-Down 'csv-next-line-keep-column)
  (define-key *csv-mode-map* #\C-Up   'csv-previous-line-keep-column)
  (define-key *csv-mode-map* #\C-Right'csv-forward-column)
  (define-key *csv-mode-map* #\C-Left 'csv-backward-column)
  (define-key *csv-mode-map* '(#\C-c #\C-w) 'csv-record-view-line)
  (define-key *csv-mode-map* '(#\C-c #\C-\,) 'csv-change-separator)
  (define-key *csv-mode-map* '(#\C-c #\C-\;) 'csv-record-change-newline)
  (define-key *csv-mode-map* '(#\C-c #\C-v) 'csv-view-line)
  (define-key *csv-mode-map* '(#\C-c #\C-t) 'csv-toggle-header-flag)
  (define-key *csv-mode-map* '(#\C-c #\C-o) 'csv-optimize-column)
  (define-key *csv-mode-map* '(#\C-c #\C-a) 'csv-adjust-column)
  (define-key *csv-mode-map* '(#\C-c #\C-x) 'csv-change-row-column)
  (define-key *csv-mode-map* '(#\C-c #\C-b) 'csv-convert-to-box)
  (define-key *csv-mode-map* '(#\C-c #\C-h) 'csv-convert-to-html)
  (define-key *csv-mode-map* '(#\C-c #\C-i) 'csv-select-insert-column)
  (define-key *csv-mode-map* '(#\C-c #\C-d) 'csv-select-delete-column)
  (define-key *csv-mode-map* '(#\C-c #\C-c) 'csv-select-change-column)
  (define-key *csv-mode-map* '(#\C-c #\C-s) 'csv-select-sort)
  (define-key *csv-mode-map* '(#\C-c #\C-e) 'csv-edit-dialog)
  (define-key *csv-mode-map* '(#\C-c #\M-C-e) 'csv-selection-edit-dialog))

(defvar *csv-mode-syntax-table* nil
  "csv-mode: Syntax table")
(unless *csv-mode-syntax-table*
  (setq *csv-mode-syntax-table* (make-syntax-table))
  (set-syntax-string *csv-mode-syntax-table* #\"))

;;;###autoload
(defun csv-mode (&optional separator-char)
  "Major mode for editing CSV file."
  (interactive)
  (kill-all-local-variables)
  (setq buffer-mode 'csv-mode)
  (use-syntax-table *csv-mode-syntax-table*)
  (and *csv-keyword-file*
       (null *csv-keyword-hash-table*)
       (setq *csv-keyword-hash-table*
             (load-keyword-file *csv-keyword-file* t)))
  (when *csv-keyword-hash-table*
    (make-local-variable 'keyword-hash-table)
    (setq keyword-hash-table *csv-keyword-hash-table*))
  (make-local-variable 'regexp-keyword-list)
  (setq regexp-keyword-list *csv-regexp-keyword-list*)
  (case *csv-line-number*
    ((t)
     (set-local-window-flags (selected-buffer)
                             *window-flag-line-number* t))
    ((nil)
     (set-local-window-flags (selected-buffer)
                             *window-flag-line-number* nil)))
  (case *csv-cursor-line*
    ((t)
     (set-local-window-flags (selected-buffer)
                             *window-flag-cursor-line* t))
    ((nil)
     (set-local-window-flags (selected-buffer)
                             *window-flag-cursor-line* nil)))
  (if (or (eq *csv-buffer-fold-width* t)
          (eq *csv-buffer-fold-width* nil)
          (integerp *csv-buffer-fold-width*))
      (set-buffer-fold-width *csv-buffer-fold-width*))
  (when separator-char
    (setq csv-separator-char separator-char))
  (make-local-variable 'csv-mode-local-map)
  (csv-set-mode-name)
  (insert-csv-menu)
  (run-hooks '*csv-mode-hook*)
  (csv-update-keymap))

;;;###autoload
(defun tsv-mode ()
  "Major mode for editing TSV file."
  (interactive)
  (csv-mode #\TAB))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; header ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun csv-toggle-header-flag ()
  "csv-mode: sڂwb_Ƃ݂ȂǂgO"
  (interactive)
  (setq csv-header-flag (not csv-header-flag))
  (csv-set-mode-name))

(defun csv-set-mode-name ()
  "csv-mode: sڂwb_Ƃ݂ȂĂ邩ǂ[hCɔf"
  (if csv-header-flag
      (setq mode-name "CSV[H]")
    (setq mode-name "CSV"))
  (refresh-screen))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; separator ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; separator ̓́iƕt鏈j
(defun csv-insert-separator ()
  "csv-mode: Zp[^̓"
  (interactive "*")
  (if overwrite-mode
      (overwrite-char csv-separator-char)
    (insert csv-separator-char)))

;; separator ̕ύX
(defun csv-change-separator ()
  "csv-mode: Zp[^ƔF镶̕ύX"
  (interactive)
  (let (input)
    (setq input (read-string (format nil "Separator Character (~S): " csv-separator-char)))
    (when (plusp (length input))
      (setq csv-separator-char (char input 0))
      (csv-update-keymap))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ړ ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun csv-next-line (&optional (n 1))
  "csv-mode: ̍sɈړBs\pEBhEɓe\B
F
  n  ړs
߂lFړꍇ   t
        ړȂꍇ nil"
  (interactive "p")
  (let ((goal-column (goal-column)))
    (when (next-line n)
      (if (and (find-buffer *csv-buffer-record*)
               (get-buffer-window *csv-buffer-record*))
          (csv-record-view-line))
      (set-goal-column goal-column)
      t)))

(defun csv-previous-line (&optional (n 1))
  "csv-mode: O̍sɈړBs\pEBhEɓe\B
F
  n  ړs
߂lFړꍇ   t
        ړȂꍇ nil"
  (interactive "p")
  (csv-next-line (- n)))

(defun csv-forward-line ()
  (goto-eol)
  (forward-char))

(defun csv-forward-column (&optional (n 1))
  "csv-mode: ̗(̊Jn|Cg)Ɉړ
F
  n  ړ
߂lF
  lŁAړ̌ʒuÅJn|CgAI|Cg"
  (interactive "p")
  (when (minusp n)
    (return-from csv-forward-column (csv-backward-column (- n))))
  (let ((csv-current-column-number (csv-current-column-number))
        (csv-line-max-column-number (csv-line-max-column-number)))
    ;; sPʂ̈ړ
    (while (> (+ csv-current-column-number n) csv-line-max-column-number)
      (decf n (1+ (- csv-line-max-column-number csv-current-column-number)))
      (if (forward-line)
          (progn
            (setq csv-current-column-number 1)
            (setq csv-line-max-column-number (csv-line-max-column-number)))
        (return-from csv-forward-column (csv-goto-column csv-line-max-column-number))))
    ;; sPʈړAsł̗ړ
    (csv-goto-column (+ n csv-current-column-number))))

(defun csv-backward-column (&optional (n 1))
  "csv-mode: O̗(̊Jn|Cg)Ɉړ
F
  n  ړ
߂lF
  lŁAړ̌ʒuÅJn|CgAI|Cg"
  (interactive "p")
  (when (minusp n)
    (return-from csv-backward-column (csv-forward-column (- n))))
  (let ((csv-current-column-number (csv-current-column-number)))
    ;; sPʂ̈ړ
    (while (>= n csv-current-column-number)
      (decf n csv-current-column-number)
      (if (backward-line)
          (progn
            (goto-eol)
            (setq csv-current-column-number (csv-line-max-column-number)))
        (return-from csv-backward-column (csv-goto-column 1))))
    ;; sPʈړAsł̗ړ
    (csv-goto-column (- csv-current-column-number n))))

(defun csv-next-line-keep-column (&optional (n 1))
  "csv-mode: ێ܂܎̍sɈړ
̐擪|CgֈړBsړłȂꍇ́AړȂB
F
  n  ړs
߂lFsړꍇ
           lŁAړ̌ʒuÅJn|CgAI|Cg
        sړȂꍇ
           nil"
  (interactive "p")
  (let ((column-number (csv-current-column-number)))
    (unless (or (eq *last-command* 'csv-next-line-keep-column)
                (eq *last-command* 'csv-previous-line-keep-column))
      (csv-set-goal-column column-number))
    (when (csv-next-line n)
      (csv-goto-column (max column-number (csv-goal-column))))))

(defun csv-previous-line-keep-column (&optional (n 1))
  "csv-mode: ێ܂ܑO̍sɈړ
̐擪|CgֈړBsړłȂꍇ́AړȂB
F
  n  ړs
߂lFsړꍇ
           lŁAړ̌ʒuÅJn|CgAI|Cg
        sړȂꍇ
           nil"
  (interactive "p")
  (csv-next-line-keep-column (- n)))

(defvar-local csv-goal-column nil)
(defun csv-goal-column ()
  "csv-mode: CSVt@C̃S[擾
߂lFCSVt@C̃S["
  csv-goal-column)
(defun csv-set-goal-column (csv-column)
  "csv-mode: CSVt@C̃S[ݒ肷
F
  csv-column  CSVt@C̃S["
  (setq csv-goal-column csv-column))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; \ ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun csv-view-line (&optional (decode t))
  "csv-mode: ݂̍s̓e\"
  (interactive)
  (let* ((max-column-number (csv-max-column-number))
         (column-list (csv-get-column-list decode max-column-number))
         header-list digit)
    ;; ešo쐬
    (if csv-header-flag
        (setq header-list (csv-get-header-column-list decode max-column-number))
      (progn
        (setq digit (length (format nil "~D" max-column-number)))
        (dotimes (i max-column-number)
          (push (format nil "~V,'0D" digit (1+ i)) header-list))
        (setq header-list (nreverse header-list))))
    ;; oƒl̘A
    (dotimes (i max-column-number)
      (setf (nth i column-list)
            (concat (nth i header-list) ": " (nth i column-list))))
    ;; \
    (popup-string (format nil "s: ~D  F ~D~%~A~A"
                          (csv-current-line-number) (csv-current-column-number)
                          "----------------\n"
                          (csv-join-string-list "\n" column-list))
                  (point))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun csv-do-completion ()
  "csv-mode: s񂩂̕⊮"
  (interactive "*")
  (let ((opoint (point))
        (column-number (csv-current-column-number))
        (line-number (csv-current-line-number))
        line-list column-list str
        prefix len from to)
    (long-operation
      (save-excursion
        (multiple-value-bind (current-column column-from column-to)
            (csv-goto-column column-number :tail nil)
          (setq from column-from)
          (setq to column-to)
          (setq prefix (buffer-substring column-from opoint))
          (setq len (length prefix))
          (goto-char (point-min))
          (when csv-header-flag
            (csv-forward-line))
          (while (not (eobp))
            (do-events)
            (when (/= line-number (csv-current-line-number))
              (setq column-list (csv-get-column-list))
              (when (>= (length column-list) column-number)
                (setq str (nth (1- column-number) column-list))
                (if (and (string/= str "")
                         (>= (length str) len)
                         (string-equal prefix (substring str 0 len)))
                    (pushnew str line-list :test 'string=))))
            (csv-forward-line)))))
    (popup-list (stable-sort line-list #'string<)
                #'(lambda (str)
                    (if (string/= (buffer-substring from to) str)
                        (progn
                          (delete-region from to)
                          (insert str))
                      (goto-char to))
                    (if (= column-number (csv-max-column-number))
                        (csv-forward-column)
                      (cond
                       ((eolp)
                        (insert csv-separator-char))
                       ((char= csv-separator-char (char-after (point)))
                        (forward-char))))
                    (refresh-screen))
                from)))

(defun csv-selection-edit-dialog ()
  "csv-mode: ݂̍s̓e_CAOőIҏW"
  (interactive)
  (csv-edit-dialog t))

(defun csv-edit-dialog (&optional selection)
  "csv-mode: ݂̍s̓e_CAOŕҏW"
  (interactive "p")
  (let ((max-column-number (csv-max-column-number))
        (column-number (csv-current-column-number))
        column-list header-list control-list column-symbol-list
        (column-choices-list (list '()))
        column-list-initializers column-index-initializers
        combobox)
    ;; ȇS񃊃Xg̎擾
    (when selection
      (long-operation
        (save-excursion
          (goto-char (point-min))
          (when csv-header-flag
            (csv-forward-line))
          (while (not (eobp))
            (do-events)
            (setq column-list (csv-get-column-list t))
            ;; ܂ł̃JIo^XbgAݍs̃J菭Ȃꍇ
            ;; JIo^XbgL
            (dotimes (i (- (length column-list) (length column-choices-list)))
              (setq column-choices-list (nconc column-choices-list (list '()))))
            ;; JIo^XbgɁAݍs̊eJ̒lǉ
            (dotimes (i (length column-list))
              (if (string/= "" (elt column-list i))
                  (pushnew (elt column-list i) (elt column-choices-list i) :test 'string=)))
            (csv-forward-line))
          (setq column-choices-list
                (mapcar #'(lambda (lst) (stable-sort lst #'string<)) column-choices-list))
          ;; wb_őJ̏ꍇAwb_sɍ킹ăJIXbgL
          (setq max-column-number (max max-column-number (length column-choices-list)))
          (dotimes (i (- max-column-number (length column-choices-list)))
            (setq column-choices-list (nconc column-choices-list (list '())))))))
    ;; column p symbol ̐
    (dotimes (i max-column-number)
      (push (make-symbol (concat "column" (format nil "~D" i))) column-symbol-list))
    ;; column-list-initializers
    (when selection
      (dotimes (i max-column-number)
        (push (cons (elt column-symbol-list i) (elt column-choices-list i))
              column-list-initializers))
      (setq column-list-initializers (nreverse column-list-initializers)))
    
    ;; ̎擾
    (if csv-header-flag
        (setq header-list (csv-get-header-column-list t))
      (let ((digit (length (format nil "~D" max-column-number))))
        (dotimes (i max-column-number)
          (push (format nil "~V,'0D" digit (1+ i)) header-list))
        (setq header-list (nreverse header-list))))

    ;; es̏
    (loop
      (if (or (not selection) (csv-header-line-p))
          (setq combobox nil)
        (setq combobox t))
      
      ;; ݍs decode l̎擾
      (setq column-list (csv-get-column-list t))

      ;; column-index-initializers
      (when combobox
        (setq column-index-initializers nil)
        (let (pos)
          (dotimes (i (length column-list))
            (setq pos (position (elt column-list i) (elt column-choices-list i) :test 'string=))
            (when pos
              (push (cons (elt column-symbol-list i) pos) column-index-initializers)))))

      ;; dialog p control ̏
      (setq control-list nil)
      ;; ݂̗񂩂͂B
      (let (j)
        (dotimes (i (- max-column-number (1- column-number)))
          (setq j (+ i (1- column-number)))
          (push `(:static nil ,(nth j header-list) #x50020000
                  1 ,(+ (* j 15) 3) ,*csv-edit-dialog-header-width* 8)
                control-list)
          (push (if combobox
                    `(:combobox ,(elt column-symbol-list j)
                      ,(nth j column-list) #x50210842
                      ,(+ 1 *csv-edit-dialog-header-width* 1) ,(+ (* j 15) 1)
                      ,(- *csv-edit-dialog-width* 1 *csv-edit-dialog-header-width* 1 1) 72)
                  `(:edit ,(elt column-symbol-list j)
                    ,(nth j column-list) #x50810080
                    ,(+ 1 *csv-edit-dialog-header-width* 1) ,(+ (* j 15) 1)
                    ,(- *csv-edit-dialog-width* 1 *csv-edit-dialog-header-width* 1 1) 14))
                control-list)))
      ;;
      (push `(:button nil "" #x50000007
              ,(- *csv-edit-dialog-width* 2 (* (+ 26 1) 4) 26 2 (* (+ 2 50) 2) 2)
              ,(- (* max-column-number 15) 2)
              ,(+ 2 (* (+ 26 1) 4) 26 2) 22) control-list)
      (push `(:button move-nil "(&F)" #x50000009
              ,(- *csv-edit-dialog-width* (* (+ 26 1) 4) 26 2 (* (+ 2 50) 2) 2)
              ,(+ (* max-column-number 15) 6)
              26 10) control-list)
      (push `(:button move-next "(&N)" #x50000009
              ,(- *csv-edit-dialog-width* (* (+ 26 1) 3) 26 2 (* (+ 2 50) 2) 2)
              ,(+ (* max-column-number 15) 6)
              26 10) control-list)
      (push `(:button move-previous "O(&P)" #x50000009
              ,(- *csv-edit-dialog-width* (* (+ 26 1) 2) 26 2 (* (+ 2 50) 2) 2)
              ,(+ (* max-column-number 15) 6)
              26 10) control-list)
      (push `(:button move-jump "(&J)" #x50000009
              ,(- *csv-edit-dialog-width* (* (+ 26 1) 1) 26 2 (* (+ 2 50) 2) 2)
              ,(+ (* max-column-number 15) 6)
              26 10) control-list)
      (push `(:edit move-jump-line nil #x50810086
              ,(- *csv-edit-dialog-width* 26 2 (* (+ 2 50) 2) 2)
              ,(+ (* max-column-number 15) 4)
              26 14) control-list)
      (push `(:spin move-jump-line-spin nil #x500000b6
              ,(- *csv-edit-dialog-width* 16 2 (* (+ 2 50) 2) 2)
              ,(+ (* max-column-number 15) 4)
              10 14) control-list)
      ;;
      (push `(:button IDOK "OK" #x50010001
              ,(- *csv-edit-dialog-width* 50 2 50 2) ,(+ (* max-column-number 15) 4)
              50 14) control-list)
      (push `(:button IDCANCEL "LZ" #x50010000
              ,(- *csv-edit-dialog-width* 50 2) ,(+ (* max-column-number 15) 4)
              50 14) control-list)
      ;;
      (dotimes (i (1- column-number))
        (push `(:static nil ,(nth i header-list) #x50020000
                1 ,(+ (* i 15) 3) ,*csv-edit-dialog-header-width* 8)
              control-list)
        (push (if combobox
                  `(:combobox ,(elt column-symbol-list i)
                    ,(nth i column-list) #x50210842
                    ,(+ 1 *csv-edit-dialog-header-width* 1) ,(+ (* i 15) 1)
                    ,(- *csv-edit-dialog-width* 1 *csv-edit-dialog-header-width* 1 1) 72)
                `(:edit ,(elt column-symbol-list i)
                  ,(nth i column-list) #x50810080
                  ,(+ 1 *csv-edit-dialog-header-width* 1) ,(+ (* i 15) 1)
                  ,(- *csv-edit-dialog-width* 1 *csv-edit-dialog-header-width* 1 1) 14))
              control-list))
      (setq control-list (nreverse control-list))
      (multiple-value-bind (result data)
          (dialog-box
           `(dialog 0 0 ,*csv-edit-dialog-width* ,(+ (* max-column-number 15) 2 19)
                    (:caption ,(concat (cond
                                        ((csv-header-line-p) "wb_ҏW")
                                        (combobox            "IҏW")
                                        (t                   "ҏW"))
                                       (if (> (csv-current-line-number) (csv-max-line-number))
                                           (format nil " (VK:~D)" (csv-current-line-number))
                                         (format nil " (~D/~D: ~D)"
                                                 (csv-current-line-number)
                                                 (csv-max-line-number)
                                                 (csv-current-column-number)))))
                    (:font 9 "MS UI Gothic")
                    (:control
                     ,@control-list
                     ))
           (if combobox
               `(,(cons (case csv-edit-dialog-move
                          (:next 'move-next)
                          (:previous 'move-previous)
                          (t 'move-nil))
                        t)
                 ,(cons 'move-jump-line (format nil "~D" (csv-current-line-number)))
                 ,@column-list-initializers
                 ,@column-index-initializers)
             `(,(cons (case csv-edit-dialog-move
                        (:next 'move-next)
                        (:previous 'move-previous)
                        (t 'move-nil))
                      t)
               ,(cons 'move-jump-line (format nil "~D" (csv-current-line-number)))
               ))
           `((move-jump-line-spin :min 1 :max ,(1+ (csv-max-line-number)))
             (move-jump-line :min 1 :max ,(1+ (csv-max-line-number))
                             :range-error ,(format nil "1 ȏ ~D ȉw肵Ă" (1+ (csv-max-line-number)))
                             :type integer :type-error "l͂Ă")
             (move-nil :disable (move-jump-line move-jump-line-spin))
             (move-next :disable (move-jump-line move-jump-line-spin))
             (move-previous :disable (move-jump-line move-jump-line-spin))
             (move-jump :enable (move-jump-line move-jump-line-spin))))
        ;; L[{[h̓͂SĎ̂ĂB
        (while (read-char-no-hang *keyboard* nil nil nil))
        (when (eq result 'IDOK)
          ;; ړtO̍XV
          (cond
           ((cdr (assoc 'move-nil data))
            (setq csv-edit-dialog-move nil))
           ((cdr (assoc 'move-next data))
            (setq csv-edit-dialog-move :next))
           ((cdr (assoc 'move-previous data))
            (setq csv-edit-dialog-move :previous)))
          ;; ҏW
          (let ((column-list (csv-get-column-list nil max-column-number)) str modify)
            (dotimes (i max-column-number)
              (setq str (cdr (assoc (elt column-symbol-list i) data)))
              (setq str (string-trim " " str))
              (if (csv-need-encode-p str)
                  (setq str (csv-encode-string str)))
              (unless (csv-string-equal (elt column-list i) str)
                (setq modify t)
                (unless (csv-encoded-string-p str)
                  (setq str (csv-encode-string str)))
                (setf (elt column-list i) str)
                ;; column-choices-list XV
                (when combobox
                  (setq str (csv-decode-string str))
                  (unless (position str (elt column-choices-list i) :test 'string=)
                    (setf (elt column-choices-list i)
                          (merge 'list (elt column-choices-list i) (list str) #'string<))
                    (setf (elt column-list-initializers i)
                          (cons (elt column-symbol-list i) (elt column-choices-list i)))))))
            (when modify
              (csv-goto-column
               (prog1
                   (csv-current-column-number)
                 (delete-region (progn (goto-bol) (point)) (progn (goto-eol) (point)))
                 (insert (csv-join-string-list csv-separator-char column-list)))))))
        ;; ړ̍sɈړ
        (if (eq result 'IDOK)
            (cond
             ((cdr (assoc 'move-jump data))
              (goto-line (cdr (assoc 'move-jump-line data)))
              (when (> (csv-current-line-number) (csv-max-line-number))
                (goto-eol)
                (insert "\n")))
             (csv-edit-dialog-move
              (case csv-edit-dialog-move
                (:next
                 (unless (csv-next-line-keep-column)
                   (goto-eol)
                   (insert "\n")))
                (:previous
                 (unless (csv-previous-line-keep-column)
                   (return)))))
             (t (return)))
          (return))
        (refresh-screen))
      (undo-boundary))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; 񑀍 ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun csv-select-insert-column ()
  "csv-mode: ̑}^ǉ (popup-list)"
  (interactive "*")
  (let* ((max-column-number (csv-max-column-number))
         (digit (length (format nil "~D" max-column-number)))
         column-list)
    (save-excursion
      (if csv-header-flag
          (goto-char (point-min)))
      (setq column-list (csv-get-column-list t max-column-number)))
    (dotimes (i (length column-list))
      (setf (nth i column-list)
            (format nil "~V,'0D: ~A" digit (1+ i) (nth i column-list))))
    (setq column-list
          (nconc column-list (list (format nil "~V,'0D: [ɒǉ]" digit 0))))
    (message "}̈ʒuIĉ")
    (popup-list column-list #'(lambda (str)
                                (let (column-number)
                                  (string-match "[0-9]+" str)
                                  (setq column-number (parse-integer (match-string 0)))
                                  (csv-insert-column column-number max-column-number)
                                  (refresh-screen)))
                (point))))

(defun csv-insert-column (column-number &optional max-column-number)
  "csv-mode: ̑}^ǉ (minibuffer)"
  (interactive "*nInsert Column: ")
  (if (plusp column-number)
      (message " ~D ɑ}܂" column-number)
    (message "ǉ܂"))
  (long-operation
    (let ((ocolumn-number (csv-current-column-number))
          column-list modify)
      (unless max-column-number
        (setq max-column-number (csv-max-column-number)))
      (if (and (plusp column-number)
               (>= ocolumn-number column-number))
          (incf ocolumn-number))
      (save-excursion
        (goto-char (point-min))
        (while (not (eobp))
          (setq modify nil)
          (setq column-list (csv-get-column-list))
          (if (zerop column-number)
              (when (= (length column-list) max-column-number)
                (setq column-list (append column-list '("")))
                (setq modify t))
            (when (>= (length column-list) column-number)
              (setq column-list (append (subseq column-list 0 (1- column-number))
                                        '("")
                                        (subseq column-list (1- column-number))))
              (setq modify t)))
          (when modify
            (delete-region (progn (goto-bol) (point)) (progn (goto-eol) (point)))
            (insert (csv-join-string-list csv-separator-char column-list)))
          (csv-forward-line)))
      (csv-goto-column ocolumn-number))))

(defun csv-select-delete-column ()
  "csv-mode: ̍폜 (popup-list)"
  (interactive "*")
  (let* ((max-column-number (csv-max-column-number))
         (digit (length (format nil "~D" max-column-number)))
         column-list)
    (save-excursion
      (if csv-header-flag
          (goto-char (point-min)))
      (setq column-list (csv-get-column-list t max-column-number)))
    (dotimes (i (length column-list))
      (setf (nth i column-list)
            (format nil "~V,'0D: ~A" digit (1+ i) (nth i column-list))))
    (message "폜Iĉ")
    (popup-list column-list #'(lambda (str)
                                (let (column-number)
                                  (string-match "[0-9]+" str)
                                  (setq column-number (parse-integer (match-string 0)))
                                  (csv-delete-column column-number)
                                  (refresh-screen)))
                (point))))

(defun csv-delete-column (column-number)
  "csv-mode: ̍폜 (minibuffer)"
  (interactive "*nDelete Column: ")
  (message " ~D 폜܂" column-number)
  (long-operation
    (let ((ocolumn-number (csv-current-column-number))
          column-list)
      (if (> ocolumn-number column-number)
          (decf ocolumn-number))
      (save-excursion
        (goto-char (point-min))
        (while (not (eobp))
          (setq column-list (csv-get-column-list))
          (when (>= (length column-list) column-number)
            (setq column-list (append (subseq column-list 0 (1- column-number))
                                      (subseq column-list column-number)))
            (delete-region (progn (goto-bol) (point)) (progn (goto-eol) (point)))
            (insert (csv-join-string-list csv-separator-char column-list)))
          (csv-forward-line)))
      (csv-goto-column ocolumn-number))))

(defun csv-select-change-column ()
  "csv-mode: ̓ (popup-list)"
  (interactive "*")
  (let* ((max-column-number (csv-max-column-number))
         (digit (length (format nil "~D" max-column-number)))
         column-list)
    (save-excursion
      (if csv-header-flag
          (goto-char (point-min)))
      (setq column-list (csv-get-column-list t max-column-number)))
    (dotimes (i (length column-list))
      (setf (nth i column-list)
            (format nil "~V,'0D: ~A" digit (1+ i) (nth i column-list))))
    (message "ꊷPڂ̗Iĉ")
    (popup-list column-list
                #'(lambda (str)
                    (let (column-number-A)
                      (string-match "[0-9]+" str)
                      (setq column-number-A (parse-integer (match-string 0)))
                      (message " ~D ƓꊷIĉ" column-number-A)
                      (popup-list (append (subseq column-list 0 (1- column-number-A))
                                          (subseq column-list column-number-A))
                                  #'(lambda (str)
                                      (let (column-number-B)
                                        (string-match "[0-9]+" str)
                                        (setq column-number-B (parse-integer (match-string 0)))
                                        (csv-change-column column-number-A column-number-B)
                                        (refresh-screen)))
                                  (point))))
                (point))))

(defun csv-change-column (column-number-A column-number-B)
  "csv-mode: ̓ (minibuffer)"
  (interactive "*nChange Column A: \nnfor Column B: ")
  (message " ~D Ɨ ~D ꊷ܂" column-number-A column-number-B)
  (long-operation
    (let ((ocolumn-number (csv-current-column-number))
          column-list col-A col-B)
      (if (< column-number-A column-number-B)
          (setq col-A column-number-A col-B column-number-B)
        (setq col-A column-number-B col-B column-number-A))
      (save-excursion
        (goto-char (point-min))
        (while (not (eobp))
          (setq column-list (csv-get-column-list))
          (when (>= (length column-list) col-A)
            (dotimes (i (- col-B (length column-list)))
              (setq column-list (nconc column-list '(""))))
            (setq column-list (append (subseq column-list 0 (1- col-A))
                                      (subseq column-list (1- col-B) col-B)
                                      (subseq column-list col-A (1- col-B))
                                      (subseq column-list (1- col-A) col-A)
                                      (subseq column-list col-B)))
            (delete-region (progn (goto-bol) (point)) (progn (goto-eol) (point)))
            (insert (csv-join-string-list csv-separator-char column-list)))
          (csv-forward-line)))
      (csv-goto-column ocolumn-number))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; s ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun csv-select-sort ()
  "csv-mode: wɎw@Ń\[g (popup-list)"
  (interactive "*")
  (let* ((max-column-number (csv-max-column-number))
         (digit (length (format nil "~D" max-column-number)))
         column-list)
    (save-excursion
      (if csv-header-flag
          (goto-char (point-min)))
      (setq column-list (csv-get-column-list t max-column-number)))
    (dotimes (i (length column-list))
      (setf (nth i column-list)
            (format nil "~V,'0D: ~A" digit (1+ i) (nth i column-list))))
    (message "\[g̊ƂIĉ")
    (popup-list column-list
                #'(lambda (str)
                    (let (column-number
                          (sort-method-string-list (make-list (length *csv-sort-method-list*)))
                          (digit (length (format nil "~D" (length *csv-sort-method-list*)))))
                      (dotimes (i (length *csv-sort-method-list*))
                        (setf (nth i sort-method-string-list)
                              (format nil "~V,'0D: ~A" digit (1+ i) (car (nth i *csv-sort-method-list*)))))
                      (string-match "[0-9]+" str)
                      (setq column-number (parse-integer (match-string 0)))
                      (message " ~D ̃\[g̕@Iĉ" column-number)
                      (popup-list sort-method-string-list
                                  #'(lambda (str)
                                      (let (num)
                                        (string-match "[0-9]+" str)
                                        (setq num (parse-integer (match-string 0)))
                                        (message " ~D  [~A] Ń\[g܂"
                                                 column-number (car (nth (1- num) *csv-sort-method-list*)))
                                        (long-operation
                                          (csv-sort column-number (cadr (nth (1- num) *csv-sort-method-list*))))))
                                  (point))
                      (refresh-screen)))
                (point))))

(defun csv-sort (column-number predicate)
  "csv-mode: \[g̓֐"
  (let ((temp-buffer (create-new-buffer *csv-buffer-temp*))
        (ocolumn-number (csv-current-column-number))
        (oline-number (csv-current-line-number))
        (max-line-number (csv-max-line-number))
        line-number-and-string-list line-number-list
        (line-number-offset 0) base-line-number)
    ;; \[g̃L[ƂȂɂXg쐬
    (goto-char (point-min))
    (setq base-line-number (csv-current-line-number))
    (while (not (eobp))
      (push (cons (+ base-line-number line-number-offset)
                  (or (nth (1- column-number) (csv-get-column-list t)) ""))
            line-number-and-string-list)
      (csv-forward-line)
      (incf line-number-offset))
    (setq line-number-and-string-list (nreverse line-number-and-string-list))
    ;; \[gpr֐̒`
    (flet ((stable-predicate (num-str-A num-str-B)
             (let ((num-A (car num-str-A)) (num-B (car num-str-B))
                   (str-A (cdr num-str-A)) (str-B (cdr num-str-B)))
               (case (funcall predicate str-A str-B)
                 ( 1 nil)
                 (-1 t)
                 ( 0 (< num-A num-B))
                 (t nil)))))
      (if csv-header-flag
          (setq line-number-and-string-list
                (append (subseq line-number-and-string-list 0 1)
                        (stable-sort (subseq line-number-and-string-list 1) #'stable-predicate)))
        (setq line-number-and-string-list
              (stable-sort line-number-and-string-list #'stable-predicate))))
    ;; VKsłȂȂ΁A\[gɈړׂsԍXV
    (setq line-number-list (mapcar #'car line-number-and-string-list))
    (if (<= oline-number max-line-number)
        (setq oline-number (+ base-line-number (position oline-number line-number-list))))
    ;; ꎞobt@Ƀ\[gςݕo
    (with-output-to-buffer (temp-buffer)
      (dolist (line-number line-number-list)
        (goto-line line-number)
        (format t "~A~%"
                (buffer-substring (progn (goto-bol) (point)) (progn (goto-eol) (point))))))
    ;; obt@̉sK؂
    (when (progn (goto-char (point-max)) (not (bolp)))
      (save-excursion
        (set-buffer temp-buffer)
        (goto-char (point-max))
        (delete-backward-char)))
    ;; ݂̃obt@ɔf
    (delete-region (point-min) (point-max))
    (insert-buffer temp-buffer)
    (delete-buffer temp-buffer)
    (goto-line oline-number)
    (csv-goto-column ocolumn-number))
  (refresh-screen))

(defun csv-get-cell-string (line-number column-number &optional decode)
  "csv-mode: ws̎w̕Ԃ"
  (let (column-list)
    (save-excursion
      (goto-line line-number)
      (setq column-list (csv-get-column-list))
      (if (< (length column-list) column-number)
          ""
        (let ((cell-string (nth (1- column-number) column-list)))
          (if decode
              (csv-decode-string cell-string)
            cell-string))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ϊ ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun csv-set-buffer-convert ()
  "csv-mode: ϊo͗pobt@̏"
  (save-excursion
    (get-buffer-create *csv-buffer-convert*)
    (erase-buffer *csv-buffer-convert*)
    (set-buffer *csv-buffer-convert*)
    (set-local-window-flags (selected-buffer) *window-flag-cursor-line* t)
    (set-buffer-fold-width nil)
    (make-local-variable 'need-not-save)
    (setq need-not-save t)))

(defun csv-optimize-column ()
  "csv-mode: Sse̍E̔p󔒂폜"
  (interactive "*")
  (let ((column-number (csv-current-column-number))
        column-list (max-column-number 0))
    (long-operation
      (save-excursion
        (goto-char (point-min))
        (while (not (eobp))
          (setq column-list (csv-get-column-list))
          (when (> (length column-list) max-column-number)
            (setq max-column-number (length column-list)))
          (dotimes (i (length column-list))
            (setf (nth i column-list) (string-trim " " (nth i column-list))))
          (delete-region (progn (goto-bol) (point)) (progn (goto-eol) (point)))
          (insert (csv-join-string-list csv-separator-char column-list))
          (csv-forward-line))))
    (csv-max-column-number-strict-cache-set max-column-number)
    (csv-goto-column column-number)))

(defun csv-adjust-column ()
  "csv-mode: Ss𑵂̗̕"
  (interactive "*")
  (let ((column-number (csv-current-column-number))
        (column-numberp-list (csv-column-numberp-list))
        column-list column-width-list column-width
        from to (max-column-number 0))
    (long-operation
      (save-excursion
        ;; column-width-list ̍쐬
        (goto-char (point-min))
        (while (not (eobp))
          (do-events)
          (setq column-list (csv-get-column-list))
          (setq from (point))
          (dotimes (i (length column-list))
            (setq to (+ from (length (nth i column-list))))
            (setq column-width (- (progn (goto-char to) (current-column))
                                  (progn (goto-char from) (current-column))))
            (setq from (1+ to))
            (cond
             ((<= (length column-width-list) i)
              (setq column-width-list (nconc column-width-list (list column-width))))
             ((< (nth i column-width-list) column-width)
              (setf (nth i column-width-list) column-width))))
          (csv-forward-line))
        ;; sϊ
        (goto-char (point-min))
        (while (not (eobp))
          (do-events)
          (setq column-list (csv-get-column-list))
          (when (> (length column-list) max-column-number)
            (setq max-column-number (length column-list)))
          (delete-region (progn (goto-bol) (point)) (progn (goto-eol) (point)))
          (dotimes (i (length column-list))
            (setf (nth i column-list)
                  (format nil (if (nth i column-numberp-list) "~VA" "~V@A")
                          (nth i column-width-list) (nth i column-list))))
          (insert (csv-join-string-list csv-separator-char column-list))
          (csv-forward-line))))
    (csv-max-column-number-strict-cache-set max-column-number)
    (csv-goto-column column-number)))

(defun csv-change-row-column ()
  "csv-mode: sƗ̓"
  (interactive "*")
  (let ((temp-buffer (create-new-buffer *csv-buffer-temp*))
        (max-column-number (csv-max-column-number t))
        (separator-char csv-separator-char)
        current-column-number column-number column-list line-number
        (next-max-column-number 0))
    (long-operation
      (save-excursion
        (set-buffer temp-buffer)
        (goto-char (point-min))
        (insert "\n" max-column-number))
      (goto-char (point-min))
      (while (not (eobp))
        (incf next-max-column-number)
        (setq column-list (csv-get-column-list nil max-column-number))
        (save-excursion
          (set-buffer temp-buffer)
          (goto-char (point-min))
          (dolist (str column-list)
            (goto-eol)
            (insert separator-char str)
            (forward-line)))
        (csv-forward-line))
      (save-excursion
        (set-buffer temp-buffer)
        (goto-char (point-min))
        (while (not (eobp))
          (delete-char)
          (csv-forward-line)))
      (delete-region (point-min) (point-max))
      (insert-buffer temp-buffer)
      (delete-buffer temp-buffer)
      (csv-max-column-number-strict-cache-set (max next-max-column-number 1))
      (goto-char (point-min)))))

(defun csv-convert-to-html ()
  "csv-mode: HTML ɏϊʃobt@ɏo"
  (interactive)
  (long-operation
    (let ((max-column-number (csv-max-column-number t))
          (column-numberp-list (csv-column-numberp-list)))
      (save-excursion
        (flet ((csv-convert-to-html-string ()
                 (with-output-to-string (so)
                   (let (column-str)
                     (format so "<tr>")
                     (do ((column (csv-get-column-list t) (cdr column))
                          (rest-column-number max-column-number (1- rest-column-number))
                          (column-numberp column-numberp-list (cdr column-numberp)))
                         ((zerop rest-column-number))
                       (setq column-str (car column))
                       (if (and (stringp column-str) (not (string-equal "" column-str)))
                           (format so "<td~A>~A</td>"
                                   (if (car column-numberp) " align=\"right\"" "")
                                   (csv-www-convert-special-chars column-str))
                         (format so "<td>@</td>")))
                     (format so "</tr>")))))
          (csv-set-buffer-convert)
          (goto-char (point-min))
          (with-output-to-buffer (*csv-buffer-convert*)
            (format t "<table border>~%")
            (while (not (eobp))
              (format t "~A~%" (csv-convert-to-html-string))
              (csv-forward-line))
            (format t "</table>~%"))))
      (unless (get-buffer-window *csv-buffer-convert*)
        (split-window)
        (set-buffer *csv-buffer-convert*)))))

(defun csv-www-convert-special-chars (str)
  "csv-mode: csv-convert-to-html œꕶϊ"
  (let (from to)
    (dolist (y *csv-www-special-chars-alist*)
      (setq from (cdr y))
      (setq to (car y))
      (setq str (substitute-string str from to))))
  str)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; CSV BOX ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun csv-convert-to-box (&optional (decode t))
  "csv-mode: rt񕝌Œɏϊʃobt@ɏo"
  (interactive)
  (long-operation
    (let ((max-column-width-list (csv-max-column-width-list decode))
;          (column-numberp-list (csv-column-numberp-list))
          line-head-string line-tail-string line-separator-string)
      (save-excursion
        ;; ő񕝂̒lɐ؂グ
        (setq max-column-width-list
              (mapcar #'(lambda (num) (if (evenp num) num (1+ num)))
                      max-column-width-list))
        ;; d؂蕶̍쐬
        (setq line-head-string
              (with-output-to-string (so)
                (if max-column-width-list
                    (progn
                      (format so "")
                      (do ((width-list max-column-width-list (cdr width-list)))
                          ((null (cdr width-list))
                           (format so "~V@{~A~:*~}" (/ (car width-list) 2) "")
                           (format so "~%"))
                        (format so "~V@{~A~:*~}" (/ (car width-list) 2) "")
                        (format so "")))
                  (format so "~%"))))
        (setq line-separator-string
              (substitute-string
               (substitute-string
                (substitute-string line-head-string "" "") "" "") "" ""))
        (setq line-tail-string
              (substitute-string
               (substitute-string
                (substitute-string line-head-string "" "") "" "") "" ""))
        ;;
        (flet ((csv-convert-to-box-string ()
                 (with-output-to-string (so)
                   (format so "")
                   (do ((column (csv-get-column-list decode) (cdr column))
                        (column-width (csv-column-width-list decode) (cdr column-width))
                        (max-column-width max-column-width-list (cdr max-column-width))
;                        (column-numberp column-numberp-list (cdr column-numberp))
                        )
                       ((null max-column-width))
                     (format so (if ;(car column-numberp)
                                    (string-match *csv-number-regexp* (or (car column) "")) "~VA" "~V@A")
                             (car max-column-width) (or (car column) ""))))))
          ;; ϊo͗pobt@̏
          (csv-set-buffer-convert)
          (save-excursion
            (set-buffer *csv-buffer-convert*)
            (csv-box-mode))
          ;; ϊo
          (goto-char (point-min))
          (with-output-to-buffer (*csv-buffer-convert*)
            (format t "~A" line-head-string)
            (while (not (eobp))
              (format t "~A~%" (csv-convert-to-box-string))
              (goto-eol)
              (if (and (forward-char) (not (eobp)))
                  (format t "~A" line-separator-string)))
            (format t "~A" line-tail-string))))
      (unless (get-buffer-window *csv-buffer-convert*)
        (split-window)
        (set-buffer *csv-buffer-convert*)))))

(defun csv-box-position (left right center)
  (let ((ocolumn (current-column))
        from to str spaces left-spaces right-spaces)
    (save-excursion
      (when (and (or left right center)
                 (prog1 (scan-buffer "" :reverse t) (setq from (1+ (point))))
                 (prog1 (scan-buffer "" :no-dup t) (setq to (point))))
        (setq str (buffer-substring from to))
        (string-match "^\\( *\\)\\(.*?\\)\\( *\\)$" str)
        (setq str (match-string 2))
        (setq spaces (+ (length (match-string 1)) (length (match-string 3))))
        (cond
         (center
          (setq left-spaces
                (if (not right) (floor spaces 2) (ceiling spaces 2)))
          (setq right-spaces (- spaces left-spaces)))
         (right
          (setq left-spaces spaces)
          (setq right-spaces 0))
         (left
          (setq left-spaces 0)
          (setq right-spaces spaces)))
        (goto-char from)
        (delete-region from to)
        (insert (format nil "~VA~A~VA" left-spaces "" str right-spaces ""))))
    (goto-column ocolumn)))
(defun csv-box-lcenter ()
  "csv-mode: r̊ԂōZ^O"
  (interactive)
  (csv-box-position t nil t))
(defun csv-box-rcenter ()
  "csv-mode: r̊ԂŉEZ^O"
  (interactive)
  (csv-box-position nil t t))
(defun csv-box-center ()
  "csv-mode: r̊ԂŃZ^O"
  (interactive)
  (csv-box-position nil nil t))
(defun csv-box-left ()
  "csv-mode: r̊Ԃō"
  (interactive)
  (csv-box-position t nil nil))
(defun csv-box-right ()
  "csv-mode: r̊ԂŉE"
  (interactive)
  (csv-box-position nil t nil))

(defvar *csv-box-mode-hook* nil)

(defvar *csv-box-mode-map* nil)
(unless *csv-box-mode-map*
  (setq *csv-box-mode-map* (make-sparse-keymap))
  (define-key *csv-box-mode-map* #\C-Up 'csv-box-rcenter)
  (define-key *csv-box-mode-map* #\C-Down 'csv-box-lcenter)
  (define-key *csv-box-mode-map* #\C-Left 'csv-box-left)
  (define-key *csv-box-mode-map* #\C-Right 'csv-box-right))

(defvar *csv-box-mode-syntax-table* nil)
(unless *csv-box-mode-syntax-table*
  (setq *csv-box-mode-syntax-table* (make-syntax-table)))

(defun csv-box-mode ()
  (interactive)
;  (kill-all-local-variables)
  (setq buffer-mode 'csv-box-mode)
  (setq mode-name "CSV Box")
  (use-keymap *csv-box-mode-map*)
  (use-syntax-table *csv-box-mode-syntax-table*)
  (run-hooks '*csv-box-mode-hook*))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ϊ (GR[h, fR[h) ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun csv-decode-string (str)
  "fR[h(蔲)
O̘A锼p󔒂菜A_uNH[gO"
  (if (null str)
      ""
    (let* ((str (string-trim " " str))
           (len (length str))
           return-str)
      (if (< len 2)
          str
        (progn
          (if (and (eql (schar str 0) #\")
                   (eql (schar str (1- len)) #\"))
              (setq return-str (substring str 1 (1- len)))
            (setq return-str str))
          (substitute-string return-str "\"\"" "\""))))))

;; GR[h
(defun csv-encode-string (str)
  "obt@[Jϐ csv-encode-string ̒lɏ] str GR[h"
  (unless (stringp str)
    (return-from csv-encode-string nil))
  (setq str (string-trim " " str))
  (if (or (eq csv-encode-string t)
          (csv-need-encode-p str)
          (and (eq csv-encode-string :except-integer)
               (not (string-match "^-?[0-9]+$" str))))
      (concat "\"" (substitute-string str "\"" "\"\"") "\"")
    str))

(defun csv-need-encode-p (str)
  "encode K{ǂ"
  (if (and (stringp str)
           (or (find csv-separator-char str) (find #\" str)))
      t nil))

(defun csv-encoded-string-p (str)
  (setq str (string-trim " " str))
  (let ((len (length str))
        quote-flag)
    (unless (and (string str) (plusp len))
      (return-from csv-encoded-string-p nil))
    (if (char= (char str 0) #\")
        (setq str (substring str 1))
      (return-from csv-encoded-string-p nil))
    (decf len)
    (if (and (plusp len) (char= (char str (1- len)) #\"))
        (setq str (substring str 0 (1- len)))
      (return-from csv-encoded-string-p nil))
    (decf len)
    (dotimes (i len)
      (cond
       ((char= (char str i) #\")
        (setq quote-flag (not quote-flag)))
       (t
        (if quote-flag
            (return-from csv-encoded-string-p nil)))))
    t))

;;
(defun csv-string-equal (string1 string2)
  (if (null string1) (setq string1 ""))
  (if (null string2) (setq string2 ""))
  (setq string1 (string-trim " " string1))
  (setq string2 (string-trim " " string2))
  (if (csv-encoded-string-p string1)
      (setq string1 (csv-decode-string string1)))
  (if (csv-encoded-string-p string2)
      (setq string2 (csv-decode-string string2)))
  (string-equal string1 string2))

;; keymap ̍XV
(defun csv-update-keymap ()
  (setq csv-mode-local-map (copy-keymap *csv-mode-map*))
  (use-keymap csv-mode-local-map)
  (define-key csv-mode-local-map csv-separator-char
              'csv-insert-separator)
  (run-hooks '*csv-mode-update-keymap-hook*))

;; ݂̗
(defun csv-current-column-number ()
  (length (csv-get-column-list nil nil (point))))

;; ݂̍s
(defun csv-current-line-number ()
  (current-line-number))

(defun csv-header-line-p ()
  "csv-mode: wb_s"
  (and csv-header-flag
       (save-excursion
         (goto-bol)
         (= (point) (point-min)))))

;; s
(defun csv-max-line-number ()
  "csv-mode: ősԂ
obt@sŝݏꍇ́A̍s̓JEgȂ"
  (save-excursion
    (goto-char (point-max))
    (if (bolp)
        (1- (current-line-number))
      (current-line-number))))

;; ݂̍s̗
(defun csv-line-max-column-number ()
  (save-excursion
    (goto-eol)
    (csv-current-column-number)))

;; ő̗
;; csv-max-column-number-strict ̒lōő񐔂̐m͈قȂ
(defvar-local csv-max-column-number-strict-cache nil)
(defun csv-max-column-number-strict-cache-set (max-column-number)
  (setq csv-max-column-number-strict-cache
        (list max-column-number (buffer-modified-count) (point-min) (point-max))))
(defun csv-max-column-number-strict-cache-get ()
  (nth 0 csv-max-column-number-strict-cache))
(defun csv-max-column-number-strict-cache-valid-p ()
  (and (eql (nth 1 csv-max-column-number-strict-cache) (buffer-modified-count))
       (eql (nth 2 csv-max-column-number-strict-cache) (point-min))
       (eql (nth 3 csv-max-column-number-strict-cache) (point-max))))
(defun csv-max-column-number (&optional strict)
  "csv-mode: ő̗񐔂Ԃ"
  (let ((max-column-number 0) column-number)
    (save-excursion
      (cond
       ;; LbVLȏꍇ
       ((csv-max-column-number-strict-cache-valid-p)
        (setq max-column-number (csv-max-column-number-strict-cache-get)))
       ;; LbVŁAmȁuő̗񐔁v𒲂ׂꍇ
       ((or csv-max-column-number-strict strict)
        (long-operation
          (goto-char (point-min))
          (while (not (eobp))
            (setq column-number (csv-line-max-column-number))
            (if (< max-column-number column-number)
                (setq max-column-number column-number))
            (csv-forward-line))
          (csv-max-column-number-strict-cache-set max-column-number)))
       ;; LbVŁAݍsƐ擪ŝ݂uő̗񐔁v𒲂ׂꍇ
       (t
        (setq max-column-number (csv-line-max-column-number))
        (goto-char (point-min))
        (setq column-number (csv-line-max-column-number))
        (if (< max-column-number column-number)
            (setq max-column-number column-number)))))
    max-column-number))

;; Ɉړ
(defun csv-goto-column (csv-column-number &key tail)
  "w肳ꂽɈړB
ړs\Ȓl csv-column-number Ɏw肳ꂽꍇ́Aړ\Ȕ͈͂
ړB
F
  csv-column-number ړCSV
  tail              non-nil ̏ꍇACSV̐擪łȂɈړ
߂lF
  lŁAړ̌ʒuÅJn|CgAI|Cg"
  (let (column-list
        (line-max-column-number (csv-line-max-column-number))
        (csv-col csv-column-number) (offset 0)
        from to)
    (goto-bol)
    (unless (plusp csv-col)
      (setq csv-col 1))
    (if (< line-max-column-number csv-col)
      (setq csv-col line-max-column-number))
    (setq column-list (csv-get-column-list))
    (dotimes (i (1- csv-col))
      (incf offset (1+ (length (pop column-list)))))
    (setq from (+ (point) offset))
    (incf offset (length (pop column-list)))
    (setq to (+ (point) offset))
    (if tail
        (goto-char to)
      (goto-char from))
    (values (current-column) from to)))

(defun csv-get-column-list (&optional decode max-column-number to)
  "ݍs𕪊Ae̕Ԃ
F
  decode           : 
  max-column-number: 
  to               : (csv-current-column-number) ł̂ݎgpB
                     ΏۂƂ閖̃|Cg
                     w肪Ȃꍇ́As̃|Cg
߂lF
  ẽ̕Xg"
  (save-excursion
    (let (columns line len c quote-p (start 0))
      (unless to
        (goto-eol)
        (setq to (point)))
      (goto-bol)
      (setq line (buffer-substring (point) to))
      (setq len (length line))
      (dotimes (index len)
        (setq c (schar line index))
        (if (eql c #\")
            (setq quote-p (not quote-p))
          (when (and (eql c csv-separator-char)
                     (not quote-p))
            (if decode
                (push (csv-decode-string (substring line start index)) columns)
              (push (substring line start index) columns))
            (setq start (1+ index)))))
      (if decode
          (push (csv-decode-string (substring line start)) columns)
        (push (substring line start) columns))
      (if max-column-number
          (append (reverse columns) (make-list (- max-column-number (length columns))
                                               :initial-element ""))
        (nreverse columns)))))

(defun csv-get-header-column-list (&optional (decode t) max-column-number)
  "wb_s𕪊Ae̕Ԃ
F
  decode: 
  max-column-number: 
߂lF
  ẽ̕Xg"
  (save-excursion
    (goto-char (point-min))
    (csv-get-column-list decode max-column-number)))

(defun csv-column-width-list (&optional decode)
  "csv-mode: ݍs̊e̕"
  (mapcar 'count-column (csv-get-column-list decode)))

(defun csv-max-column-width-list (&optional decode)
  "csv-mode: e̍ő̕"
  (let (max-column-width-list column-width-list cmax-column-width-list)
    (save-excursion
      (goto-char (point-min))
      (while (not (eobp))
        (do-events)
        (setq column-width-list (csv-column-width-list decode))
        (if (> (length column-width-list) (length max-column-width-list))
            (setq max-column-width-list
                  (append max-column-width-list
                          (make-list (- (length column-width-list) (length max-column-width-list))
                                     :initial-element 0))))
        (do ((width-list column-width-list (cdr width-list))
             (max-width-list max-column-width-list (cdr max-width-list)))
            ((null width-list))
          (if (< (car max-width-list) (car width-list))
              (rplaca max-width-list (car width-list))))
        (csv-forward-line))
      max-column-width-list)))

;; ݍs̊e񂪐
(defvar *csv-number-regexp*
  (compile-regexp "^\\(\\|#N/A\\|[\\$]?[-+]?[0-9,]*\\(\\.[0-9]*\\)?\\(E[-+]?[0-9]+\\)?\\)$")
  "Ɣ肷鐳K\")
(defun csv-column-numberp-list ()
  (let (numberp-list current-line-column-numberp-list diff-length)
    (save-excursion
      (goto-char (point-min))
      (when csv-header-flag
        (csv-forward-line))
      (while (not (eobp))
        (do-events)
        (setq current-line-column-numberp-list
              (mapcar #'(lambda (str)
                          (string-match *csv-number-regexp* str))
                      (csv-get-column-list t)))
        (setq diff-length (- (length numberp-list) (length current-line-column-numberp-list)))
        (if (plusp diff-length)
            (setq current-line-column-numberp-list
                  (nconc current-line-column-numberp-list
                         (make-list diff-length :initial-element t)))
          (setq numberp-list
                (nconc numberp-list
                       (make-list (- diff-length) :initial-element t))))
        (setq numberp-list
              (mapcar #'(lambda (x y) (if (and x y) t nil))
                      numberp-list current-line-column-numberp-list))
        (csv-forward-line))
      numberp-list)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; CSV RECORD ֘A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar *csv-record-header-tag* 'csv-record-header
  "csv-record-mode: wb_^O")
(defvar *csv-record-header-attribute* '(:bold t :foreground 1)
  "csv-record-mode: wb_\")

(defvar *csv-record-mode-syntax-table* nil
  "csv-record-mode: Syntax table")
(unless *csv-record-mode-syntax-table*
  (setq *csv-record-mode-syntax-table* (make-syntax-table))
  (set-syntax-string *csv-record-mode-syntax-table* #\"))

(defvar *csv-record-mode-hook* nil)

(defvar *csv-record-mode-map* nil
  "csv-record-mode: Local keymap")
(unless *csv-record-mode-map*
  (setq *csv-record-mode-map* (make-sparse-keymap))
  (define-key *csv-record-mode-map* #\RET 'csv-record-edit)
  (define-key *csv-record-mode-map* #\n 'csv-record-next-record)
  (define-key *csv-record-mode-map* #\p 'csv-record-previous-record))

(defun csv-record-mode ()
  "csv-record-mode: R[h\EҏW[h"
  (kill-all-local-variables)
  (setq buffer-mode 'csv-record-mode)
  (setq mode-name "CSV Record")
  (use-syntax-table *csv-record-mode-syntax-table*)
  (set-buffer-fold-width nil)
  (make-local-variable 'need-not-save)
  (setq need-not-save t)
  (make-local-variable 'mode-line-format)
  (make-local-variable 'csv-record-source-buffer)
  (make-local-variable 'csv-record-source-buffer-modified-count)
  (make-local-variable 'csv-record-source-buffer-line-number)
  (use-keymap *csv-record-mode-map*)
  (toggle-read-only t)
  (run-hooks '*csv-record-mode-hook*))

(defun csv-record-change-newline ()
  "csv-mode: s\ƔF镶̕ύX"
  (interactive)
  (let (input)
    (setq input (read-string (format nil "Newline Character (~S): " csv-record-newline-char)))
    (when (plusp (length input))
      (setq csv-record-newline-char (char input 0))
      (when (and (boundp 'csv-record-source-buffer)
                 (bufferp csv-record-source-buffer)
                 (not (deleted-buffer-p csv-record-source-buffer)))
        (save-excursion
          (set-buffer csv-record-source-buffer)
          (setq csv-record-newline-char (char input 0))))
      csv-record-newline-char)))

(defun csv-record-set-buffer (&optional (decode t))
  "csv-mode: R[hobt@AlZbg"
  (save-excursion
    (let* ((max-column-number (csv-max-column-number))
           (column-list (csv-get-column-list decode max-column-number))
           header-list max-header-width
           (obuffer (selected-buffer))
           (obuffer-modified-count (buffer-modified-count))
           (oline-number (current-line-number)))
      ;; header-list 쐬
      (if csv-header-flag
          (progn
            (setq header-list (csv-get-header-column-list decode max-column-number))
            (setq max-header-width (length (format nil "~D" max-column-number)))
            (dotimes (i max-column-number)
              (setf (nth i header-list)
                    (format nil "~V,'0D ~A" max-header-width (1+ i) (nth i header-list))))
            (setq max-header-width (apply #'max (mapcar #'count-column header-list))))
        (progn
          (setq max-header-width (length (format nil "~D" max-column-number)))
          (dotimes (i max-column-number)
            (push (format nil "~V,'0D" max-header-width (1+ i)) header-list))
          (setq header-list (nreverse header-list))))

      ;; buffer 
      (get-buffer-create *csv-buffer-record*)
      (erase-buffer *csv-buffer-record*)
      (save-excursion
        (set-buffer *csv-buffer-record*)
        (csv-record-mode)
        (setq csv-record-source-buffer obuffer)
        (setq csv-record-source-buffer-modified-count obuffer-modified-count)
        (setq csv-record-source-buffer-line-number oline-number)
        (setq mode-line-format (concat "--%*- %b (%M)"
                                       (format nil "  Source: ~A:(~D)  "
                                               (buffer-name csv-record-source-buffer)
                                               csv-record-source-buffer-line-number)
                                       "[%k:%l] %P %f"))
        ;; csv-record-source-buffer ̃obt@[JϐRs[
        (setq csv-header-flag
              (buffer-local-value csv-record-source-buffer 'csv-header-flag))
        (setq csv-max-column-number-strict
              (buffer-local-value csv-record-source-buffer 'csv-max-column-number-strict))
        (setq csv-separator-char
              (buffer-local-value csv-record-source-buffer 'csv-separator-char))
        (setq csv-encode-string
              (buffer-local-value csv-record-source-buffer 'csv-encode-string))
        (setq csv-record-newline-char
              (buffer-local-value csv-record-source-buffer 'csv-record-newline-char))

        ;; o
        (toggle-read-only nil)
        (let ((header-list header-list)
              (kept-undo-information nil))
          (declare (special kept-undo-information))
          (dotimes (i max-column-number)
            (dolist (x (or (and csv-record-newline-char
                                (split-string (nth i column-list) csv-record-newline-char))
                           '("")))
              (apply #'set-text-attribute
                     (append
                      (list
                       (point)
                       (progn
                         (if (stringp (nth i header-list))
                             (insert (format nil "~V@A : " max-header-width (nth i header-list)))
                           (insert (format nil "~V@A * " max-header-width  "")))
                         (point))
                       *csv-record-header-tag*)
                      *csv-record-header-attribute*))
              (insert (format nil "~A~%" x))
              (setf (nth i header-list) nil))))
        (set-buffer-modified-p nil *csv-buffer-record*)
        (undo-boundary)
        (toggle-read-only t)
        (goto-char (point-min))))))

(defun csv-record-view-buffer ()
  "csv-mode: R[hpobt@̕\"
  (let (org-window)
    (unless (get-buffer-window *csv-buffer-record*)
      (split-window)
      (setq org-window (selected-window))
      (other-window)
      (set-buffer *csv-buffer-record*)
      (set-window org-window))))

(defun csv-record-view-line (&optional (decode t))
  "csv-mode: ݂̍s̓eR[hpEBhEɕ\"
  (interactive)
  (csv-record-set-buffer decode)
  (csv-record-view-buffer))

(defun csv-record-toggle-view-line (&optional (decode t))
  "csv-mode: R[hpEBhE̕\gO"
  (interactive)
  (unless (eq buffer-mode 'csv-mode)
    (return-from csv-record-toggle-view-line))
  (let ((owindow (selected-window)))
    (if (and (find-buffer *csv-buffer-record*)
             (get-buffer-window *csv-buffer-record*))
        (progn
          (set-window (get-buffer-window *csv-buffer-record*))
          (delete-window)
          (set-window owindow))
      (csv-record-view-line))))

(defun csv-record-get-column-list ()
  "csv-record-mode: R[hpobt@Jl̃Xg擾"
  (let (column-list value
        (record-newline-char-str (string csv-record-newline-char)))
    (unless (and (bufferp csv-record-source-buffer)
                 (not (deleted-buffer-p csv-record-source-buffer)))
      (return-from csv-record-get-column-list nil))
    (save-excursion
      (goto-char (point-min))
      (while (not (eobp))
        (multiple-value-bind (from to tag)
            (find-text-attribute *csv-record-header-tag* :start (point))
          (unless from
            (return))
          (setq value (buffer-substring to (progn (goto-eol) (point))))
          (if (char= #\: (char-after (- to 2)))
              (push value column-list)
            (setf (car column-list)
                  (concat (car column-list) record-newline-char-str value)))
          (forward-char)))
      (reverse column-list))))

(defun csv-record-edit ()
  "csv-record-mode: R[hҏW"
  (interactive)
  (flet ((csv-record-source-buffer-valid-p-or-return ()
           (unless (and (boundp 'csv-record-source-buffer)
                        (bufferp csv-record-source-buffer)
                        (not (deleted-buffer-p csv-record-source-buffer)))
             (message "obt@݂Ȃ߁Ãobt@ŕҏWł܂B")
             (return-from csv-record-edit nil))
           (when (buffer-local-value csv-record-source-buffer 'buffer-read-only)
             (message "obt@ҏWs̂߁Ãobt@ŕҏWł܂B")
             (return-from csv-record-edit nil))
           (unless (eql csv-record-source-buffer-modified-count
                        (buffer-modified-count csv-record-source-buffer))
             (message "obt@ҏWĂ邽߁Ãobt@ł͕ҏWł܂B")
             (return-from csv-record-edit nil))))
    (let (value column header
          column-from column-to max-header-width
          column-list)
      ;; obt@`FbN
      (csv-record-source-buffer-valid-p-or-return)

      (save-excursion
        ;; JJnsɈړ
        (goto-bol)
        (while (not (looking-at "[0-9]"))
          (unless (previous-line)
            (return)))
        (setq column-from (point))
        ;; wb_擾
        (multiple-value-bind (from to tag)
            (find-text-attribute *csv-record-header-tag* :start (point))
          (unless from
            (message "obt@̏񂪕słB")
            (return-from csv-record-edit nil))
          (setq header (string-right-trim " " (buffer-substring from (- to 3))))
          ;; wb_擾
          (goto-char (- to 3))
          (setq max-header-width (current-column))
          (goto-char column-from))
        ;; J̒l擾
        (loop
          (multiple-value-bind (from to tag)
              (find-text-attribute *csv-record-header-tag* :start (point))
            (unless from
              (return))
            (setq value (buffer-substring to (progn (goto-eol) (point))))

            (if (char= #\: (char-after (- to 2)))
                (setq column value)
              (setq column (concat column (string csv-record-newline-char) value))))
          (unless (forward-char)
            (return))
          (when (or (looking-at "[0-9]") (eobp))
            (return)))
        (setq column-to (point)))

      ;; Vl[U擾
      (setq value (read-string (concat header ": ") :default column))
      (setq value (substitute-string value "\n" (string csv-record-newline-char)))

      ;; obt@`FbN
      (csv-record-source-buffer-valid-p-or-return)

      ;; record obt@XV
      (toggle-read-only nil)
      (delete-region column-from column-to)
      (goto-char column-from)
      (dolist (x (or (and csv-record-newline-char
                          (split-string value csv-record-newline-char))
                     '("")))
        (apply #'set-text-attribute
               (append
                (list
                 (point)
                 (progn
                   (if (stringp header)
                       (insert (format nil "~V@A : " max-header-width header))
                     (insert (format nil "~V@A * " max-header-width  "")))
                   (point))
                 *csv-record-header-tag*)
                *csv-record-header-attribute*))
        (set-text-attribute (point)
                            (progn (insert (format nil "~A~%" x)) (point))
                            nil)
        (setq header nil))
      (toggle-read-only t)
      (goto-char column-from)

      ;; \[Xobt@XV
      (setq column-list (csv-record-get-column-list))
      (save-excursion
        (set-buffer csv-record-source-buffer)
        (goto-line (buffer-local-value *csv-buffer-record* 'csv-record-source-buffer-line-number))
        (delete-region (point) (progn (goto-eol) (point)))
        (setq column-list (mapcar 'csv-encode-string column-list))
        (insert (csv-join-string-list csv-separator-char column-list))
        (when (eobp)
          (insert "\n")
          (backward-line))
        (goto-bol))

      ;; csv-record-source-buffer-modified-count XV
      (setq csv-record-source-buffer-modified-count
            (buffer-modified-count csv-record-source-buffer)))))

(defun csv-record-next-record (&optional (n 1))
  "csv-record-mode: ̃R[h\"
  (interactive)
  (unless (eq (selected-buffer) (find-buffer *csv-buffer-record*))
    (return-from csv-record-next-record nil))
  (let ((window-conf (current-window-configuration))
        (source-buffer-line-number csv-record-source-buffer-line-number)
        column-str source-buffer-point org-window)
    (save-excursion
      ;; JJnsɈړ
      (goto-bol)
      (while (not (looking-at "[0-9]+"))
        (unless (previous-line)
          (return)))
      (setq column-str (match-string 0)))
    (goto-line csv-record-source-buffer-line-number)
    (if (get-buffer-window csv-record-source-buffer)
        (set-window (get-buffer-window csv-record-source-buffer))
      (set-buffer csv-record-source-buffer))
    (goto-line source-buffer-line-number)
    (csv-next-line n)
    (setq source-buffer-point (point))
    (csv-record-view-line)
    (set-window-configuration window-conf)
    (when (get-buffer-window csv-record-source-buffer)
      (setq org-window (selected-window))
      (set-window (get-buffer-window csv-record-source-buffer))
      (goto-char source-buffer-point)
      (set-window org-window))
    (scan-buffer (format nil "^~A " column-str) :regexp t)))

(defun csv-record-previous-record (&optional (n 1))
  "csv-record-mode: ÕR[h\"
  (interactive)
  (csv-record-next-record (- n)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ėp֐
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun csv-join-string-list (join str-list)
  (if (characterp join)
      (setq join (string join)))
  (if (and (stringp join) str-list)
      (let (corrected-join)
        (setq corrected-join (substitute-string join "~" "~~"))
        (substring (format nil (concat "~{" corrected-join "~A~}") str-list)
                   (length join)))
    ""))

(defun csv-window-flag-valid-p (flag)
  (let (valid local)
    (multiple-value-bind (on off)
        (get-local-window-flags (selected-buffer))
      (cond
       ((plusp (logand off flag))
        (setq valid nil)
        (setq local t))
       ((plusp (logand on flag))
        (setq valid t)
        (setq local t))
       ((plusp (logand (get-window-flags) flag))
        (setq valid t)
        (setq local nil))
       (t
        (setq valid nil)
        (setq local nil))))
    (values valid local)))

(defun csv-toggle-local-window-flag (flag &optional (arg nil sv))
  (set-local-window-flags (selected-buffer)
                          flag
                          (if sv
                              arg
                            (not (csv-window-flag-valid-p flag)))))

(defun csv-toggle-local-line-number (&optional (arg nil sv))
  (interactive)
  (if sv
      (csv-toggle-local-window-flag *window-flag-line-number* arg)
    (csv-toggle-local-window-flag *window-flag-line-number*)))

(defun csv-toggle-local-cursor-line (&optional (arg nil sv))
  (interactive)
  (if sv
      (csv-toggle-local-window-flag *window-flag-cursor-line* arg)
    (csv-toggle-local-window-flag *window-flag-cursor-line*)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; j[
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar *csv-menu-name*  "CSV(&C)"
  "csv-mode: j[")
(defvar *csv-menu-position* 'ed::help
  "csv-mode: j[ʒu")
(defvar *csv-menu* nil
  "csv-mode: j[")
(defun init-csv-menu ()
  (setq *csv-menu*
        (let ((menu (create-popup-menu 'csv)))
          (add-menu-item menu nil "s񂩂̕⊮(& )..."
                         'csv-do-completion)
          (add-menu-item menu nil "ҏW_CAO(&E)..."
                         'csv-edit-dialog)
          (add-menu-item menu nil "IҏW_CAO(&F)..."
                         'csv-selection-edit-dialog)
          (add-menu-item menu nil "ݍse\(&V)"
                         'csv-view-line)
          (add-menu-item menu nil "ݍseEBhE\(&W)"
                         'csv-record-view-line)
          (add-menu-item menu nil "\[g(&S)..."
                         'csv-select-sort)
          (add-menu-separator menu)
          (add-menu-item menu nil "̑}/ǉ(&I)..."
                         'csv-select-insert-column)
          (add-menu-item menu nil "̍폜(&D)..."
                         'csv-select-delete-column)
          (add-menu-item menu nil "̓(&C)..."
                         'csv-select-change-column)
          (add-menu-separator menu)
          (add-menu-item menu nil "񕝂̍œK(&O)"
                         'csv-optimize-column)
          (add-menu-item menu nil "񕝂𑵂(&A)"
                         'csv-adjust-column)
          (add-menu-separator menu)
          (add-menu-item menu nil "sE̓(&X)"
                         'csv-change-row-column)
          (add-menu-separator menu)
          (add-menu-item menu nil "r݂͂ɕϊ(&B)"
                         'csv-convert-to-box)
          (add-menu-item menu nil "HTML ɕϊ(&H)"
                         'csv-convert-to-html)
          (add-menu-separator menu)
          (add-menu-item menu nil "擪swb_(&T)"
                         'csv-toggle-header-flag
                         #'(lambda ()
                             (and csv-header-flag :check)))
          (add-menu-item menu nil "Zp[^FύX(&,)..."
                         'csv-change-separator)
          (add-menu-item menu nil "s\FύX(&;)..."
                         'csv-record-change-newline)
          (add-menu-separator menu)
          (add-menu-item menu nil "Sāu\"vŊ (&1)"
                         #'(lambda ()
                             (interactive)
                             (setq csv-encode-string t))
                         #'(lambda ()
                             (and (eq csv-encode-string t) :check)))
          (add-menu-item menu nil "ȊOu\"vŊ (&2)"
                         #'(lambda ()
                             (interactive)
                             (setq csv-encode-string :except-integer))
                         #'(lambda ()
                             (and (eq csv-encode-string :except-integer) :check)))
          (add-menu-item menu nil "K{̏ꍇ̂݁u\"vŊ (&3)"
                         #'(lambda ()
                             (interactive)
                             (setq csv-encode-string nil))
                         #'(lambda ()
                             (and (not (eq csv-encode-string t))
                                  (not (eq csv-encode-string :except-integer)) :check)))
          (add-menu-separator menu)
          (add-menu-item menu nil "Ssאmɍő񐔂߂(&1)"
                         #'(lambda ()
                             (interactive)
                             (setq csv-max-column-number-strict t))
                         #'(lambda ()
                             (and csv-max-column-number-strict :check)))
          (add-menu-item menu nil "ݍsƐ擪s𒲂ׂ(&2)"
                         #'(lambda ()
                             (interactive)
                             (setq csv-max-column-number-strict nil))
                         #'(lambda ()
                             (and (not csv-max-column-number-strict) :check)))
          (add-menu-separator menu)
          (add-menu-item menu 'cursor-line "sJ[\(&+)"
                         'csv-toggle-local-cursor-line
                         #'(lambda ()
                             (and (csv-window-flag-valid-p *window-flag-cursor-line*)
                                  :check)))
          (add-menu-item menu 'line-number "sԍ(&#)"
                         'csv-toggle-local-line-number
                         #'(lambda ()
                             (and (csv-window-flag-valid-p *window-flag-line-number*)
                                  :check)))
          menu)))

(init-csv-menu)

(defun insert-csv-menu (&key (menu (current-menu))
                             (position *csv-menu-position*)
                             (menu-name *csv-menu-name*))
  "csv-mode: CSVj[ǉ[Jj[̐ݒ"
  (when (menup menu)
    (setq menu (copy-menu-items menu (create-menu)))
    (delete-csv-menu menu)
    (cond
     ((and (numberp position) (integerp position))
      (insert-popup-menu menu position *csv-menu* menu-name))
     ((and (symbolp position) (get-menu-position menu position))
      (insert-popup-menu menu (get-menu-position menu position)
                         *csv-menu* menu-name))
     (t
      (add-popup-menu menu *csv-menu* menu-name)))
    (use-local-menu menu)))
(defun delete-csv-menu (&optional (menu (current-menu)))
  "csv-mode: j[폜"
  (let (ret)
    (if (menup menu)
        (while (delete-menu menu 'ed::csv)
          (setq ret t)))
    ret))
(defun insert-csv-menu-all-buffers ()
  "csv-mode: Ñ[Jj[̐ݒ"
  (save-excursion
    (dolist (buffer (buffer-list))
      (set-buffer buffer)
      (when (eq buffer-mode 'csv-mode)
        (insert-csv-menu)))))

;; uȈԂۑvݒ莞ɑΏ
(unless *app-menu*
  ;; local-menu ͑̃j[SĐꂽɕύXׂȂ̂
  ;; *init-app-menus-hook* łȂ *post-startup-hook* ɂĂ݂B
  (add-hook '*post-startup-hook* 'insert-csv-menu-all-buffers))

;;; csv-mode.l ends here
