;;; -*- Mode: Lisp; Last modified: <2007/12/31 01:13:20> -*-
;;;
;;; This file is not part of xyzzy.
;;;
;;;   clipselect.l --- Nbv{[hIē\t
;;;
;;;     by HIE Masahiro <madoinu@ybb.ne.jp>
#|

Tv

  xyzzy т̑̃AvP[VNbv{[hɃRs[
  f[^̗쐬A|bvAbvXgIē\t܂B

  ZNV΁A㏑ē\t܂B

  ɗɑ݂镶Rs[ꍇ́A̗vf폜āA
  炽߂Đ擪vfƂĒǉ܂B

  ̒ɉs܂܂ꍇ́Aw肵ɒuăXg
  ɕ\܂B

  Xgɕ\镶́A*clipselect-string-length* Ŏw肵
  l܂ł\܂B񂪏ȗĂꍇ́A " ..."
  \܂B

  nonentity ́Au܂낿Ղxyzzyv
         http://members.tripod.co.jp/zauberer/microtips/xyzzy.html
  ɂ clipstore.l QlɁAclipview.l g킹ĂA
  Ă݂܂Bnonentity ɂ́Aclipview.l ̓zz
  ĂӂłB

  ܂ł clipselect-yank ́A{c
                              http://member.nifty.ne.jp/seiya-suda/
   yank-select QlɂĂ܂B́ALO
  Iē\t܂B


CXg[

  1. clipview.l  clipselect.l  ~/site-lisp ɃRs[B

  2. .xyzzy  siteinit.l Ɉȉ̋LqǉB

      (require "clipselect")

g:

  EIē\t  M-x clipselect
  Eclipboard Ɠؑ    M-x clipselect-toggle-sync

ݒ

  EL[oCh

      (define-key ctl-x-map #\Insert 'clipselect-paste)
      (define-key ctl-x-map #\y 'clipselect-yank)
      (define-key ctl-x-map #\F9 'clipselect-yank-selection)

    ƂB


XV

  [Version 1.05] 2007-12-31 ()
  ECZX(MITCZX)LځB

  [Version 1.04.1] 2004/07/04 ()
  EҏWj[ɂǉł悤ɂB
  EuZNVO\tvB
  Eclipselect  clipselect-paste ɕύXB

  [Version 2003.05.13]
  EENbNj[֒ǉB
  Eyankselect  clipselect-yank ɕύXB

  [Version 1.03] 2003/04/09 ()
  EXg̕\𐧌邽߂ɁA popup-menu g悤ɂB
  Esʂ̕ɒuĕ\ł悤ɂB
  Eclipselect-sync  clipselect-toggle-sync ɕύXB
  E܂ŁAyankselect B
  E clipview.l V̂ɂBinonentity 񂠂肪Ƃ܂Bj

  [Version 1.02.1] 2003/01/15 ()
  EIp hook ̒ǉ/폜𒚔Jɂ悤ɂB

  [Version 1.02] 2003/01/15 ()
  EォN xyzzy ɏIƁAclipboard Ɠ
    ȂȂsCBij

  [Version 1.01] 2003/01/14 ()
  Eclipselect-copy, clipselect-kill svȂƂɍCt폜B
  E*clipselect-sync*, clipselect-sync ǉB
  Ef[^̃zCgXy[Xщs폜Ȃ悤ɂB
  Eclipselect-clear, *clipselect-enable-self-owner* 폜B
  Eclipselect-viewer-hook 폜Aclipselect-push ɂ܂Ƃ߂B

  [Version 1.00] 2002/12/30 ()
  EB


CZX

  clipselect.l MITCZXɊÂėp\łB
  <http://www.opensource.org/licenses/mit-license.php>

Copyright (c) 2002-2007 HIE Masahiro

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

|#

(eval-when (:compile-toplevel :load-toplevel :execute)
  (require "clipview"))

(provide "clipselect")


;;;  ;;;
;;;   ϐݒiKɃJX^}CY邠j
;;;  ;;;

;;; xyzzy N clipboard ƓJn
(defvar *clipselect-sync* t)

;;; ۑ闚̐
(defvar *clipselect-ring-max* 16)

;;; |bvAbvj[̕\
(defvar *clipselect-string-length* 50)

;;; su镶
(defvar *clipselect-new-line-char* "")

;;; ҏWj[֒ǉ
(defvar *clipselect-add-menu* t)

;;; V[gJbgj[֒ǉ
(defvar *clipselect-add-popup-menu* t)

;;; j[}ʒu
(defvar *clipselect-menu-position* 4)

(defvar *clipselect-ring* nil)


;;;  ;;;
;;;   Nbv{[h𑀍
;;;  ;;;

(defun clipselect-paste ()
  "clipselect: Nbv{[h̗Iē\t"
  (interactive "*")
  (let ((menu (create-popup-menu nil))
	from to)
    (dotimes (arg (length *clipselect-ring*))
      (let* ((str (string (nth arg *clipselect-ring*)))
	     (shortstr (if *clipselect-new-line-char*
			   (substitute-string str "\n" *clipselect-new-line-char*)
			 str)))
	(add-menu-item menu 'clipselect
		       (if (< (length shortstr) *clipselect-string-length*)
			   shortstr
			 (concat (substring shortstr 0 *clipselect-string-length*) " ..."))
		       #'(lambda ()
			   (interactive)
			   (selection-start-end (start end)
			     (delete-region start end))
			   (insert str)))))
    (track-popup-menu menu)))

;;; ֐Ƃ̌݊
(setf (symbol-function 'clipselect) 'clipselect-paste)

#|
;;; OɎgĂ
(defun clipselect-paste ()
  "clipselect: Nbv{[h̗Iē\t"
  (interactive "*")
  (let (from to)
    (selection-start-end (start end)
      (setq from start)(setq to end))
    (popup-list *clipselect-ring*
		#'(lambda (str)
		    (when (and from to)
		      (delete-region from to))
		    (insert str)
		    (refresh-screen)))))
|#

(defun clipselect-toggle-sync ()
  "clipselect: Nbv{[hƂ̓؂ւ"
  (interactive)
  (if *clipselect-sync*
      (progn (setq *clipselect-sync* nil)
	(win-user::delete-clipboard-viewer-hook 'clipselect-push)
	(delete-hook '*kill-xyzzy-hook* 'clipselect-exit)
	(message "clipselect-sync stop."))
    (progn (setq *clipselect-sync* t)
      (win-user::add-clipboard-viewer-hook 'clipselect-push)
      (add-hook '*kill-xyzzy-hook* 'clipselect-exit)
      (message "clipselect-sync start."))))

(defun clipselect-push ()
  (let ((str (get-clipboard-data)))
    (when str
      (setq *clipselect-ring* (remove str *clipselect-ring* :test #'string=))
      (setq *clipselect-ring*
	    (ed::push-kill-ring str *clipselect-ring* *clipselect-ring-max*)))))

(defun clipselect-exit ()
  (win-user::delete-clipboard-viewer-hook 'clipselect-push))


;;;  ;;;
;;;   *kill-ring*/*selection-ring* 
;;;  ;;;

(defun clipselect-yank ()
  "clipselect: LOIē\t"
  (interactive "*")
  (let ((menu (create-popup-menu nil))
	from to)
    (dotimes (arg (length *kill-ring*))
      (let* ((str (car (ed::current-kill arg t)))
	     (shortstr (if *clipselect-new-line-char*
			   (substitute-string str "\n" *clipselect-new-line-char*)
			 str)))
	(add-menu-item menu 'yankselect
		       (if (< (length shortstr) *clipselect-string-length*)
			   shortstr
			 (concat (substring shortstr 0 *clipselect-string-length*) " ..."))
		       #'(lambda ()
			   (interactive)
			   (selection-start-end (start end)
			     (delete-region start end))
			   (insert str)))))
    (track-popup-menu menu)))

(defun clipselect-yank-selection ()
  "clipselect: ZNVOIē\t"
  (interactive "*")
  (let ((menu (create-popup-menu nil))
	from to)
    (dotimes (arg (length *selection-ring*))
      (let* ((str (cdr (ed::current-selection arg t)))
	     (shortstr (if *clipselect-new-line-char*
			   (substitute-string str "\n" *clipselect-new-line-char*)
			 str)))
	(add-menu-item menu 'clipselect2
		       (if (< (length shortstr) *clipselect-string-length*)
			   shortstr
			 (concat (substring shortstr 0 *clipselect-string-length*) " ..."))
		       #'(lambda ()
			   (interactive)
			   (selection-start-end (start end)
			     (delete-region start end))
			   (insert str)))))
    (track-popup-menu menu)))


;;;  ;;;
;;;   j[
;;;  ;;;

;;; ҏWj[ɒǉ
;;;   OHKUBO  multiple-replace.l 璸 m(_ _)m
(defun clipselect-insert-menu (&key menu position head-sep tail-sep)
  (if (and (not (menup menu)) (menup *app-menu*))
      (setq menu (get-menu *app-menu* 'ed::edit)))
  (when (menup menu)
    ;(clipselect-delete-menu menu)
    (unless (and (numberp position) (integerp position) (not (minusp position))
		 (get-menu menu position t))
      (setq position -1)
      (while (get-menu menu (incf position) t)))
    (decf position)
    (if (and head-sep
	     (not (minusp position))
	     (get-menu menu position t))
	(insert-menu-separator menu (incf position) 'clipselect-sep))
    (insert-menu-item menu (incf position) nil
		      "Iē\t(&H)..."
		      'clipselect-paste
		      #'(lambda ()
			  (unless *clipselect-ring*
			    :disable)))
    (insert-menu-item menu (incf position) nil
		      "LOIē\t(&K)..."
		      'clipselect-yank
		      #'(lambda ()
			  (unless *kill-ring*
			    :disable)))
    (insert-menu-item menu (incf position) nil
		      "ZNVOIē\t(&Y)..."
		      'clipselect-yank-selection
		      #'(lambda ()
			  (unless *selection-ring*
			    :disable)))
    (if (and tail-sep
	     (get-menu menu (incf position) t))
	(insert-menu-separator menu position 'clipselect-sep))))

;;; V[gJbgj[ɒǉ
(defun clipselect-insert-popup-menu ()
  (let (pos menu)
    (setq pos *clipselect-menu-position*)
    (setq menu *app-popup-menu*)
    (setq pos (1- pos))
    (insert-menu-separator menu (incf pos))
    (insert-menu-item menu (incf pos) nil
		      "Iē\t(&H)..."
		      'clipselect-paste
		      #'(lambda ()
			  (unless *clipselect-ring*
			    :disable)))
    (insert-menu-item menu (incf pos) nil
		      "LOIē\t(&K)..."
		      'clipselect-yank
		      #'(lambda ()
			  (unless *kill-ring*
			    :disable)))
    (insert-menu-item menu (incf pos) nil
		      "ZNVOIē\t(&Y)..."
		      'clipselect-yank-selection
		      #'(lambda ()
			  (unless *selection-ring*
			    :disable)))
    (insert-menu-separator menu (incf pos))))


;;;  ;;;
;;;   N̏
;;;  ;;;

(defun clipselect-init ()
  (when *clipselect-add-menu*
    (clipselect-insert-menu :position 7 :head-sep t :tail-sep t))
  (when *clipselect-add-popup-menu*
    (clipselect-insert-popup-menu))
  (when *clipselect-sync*
    (win-user::add-clipboard-viewer-hook 'clipselect-push)
    (add-hook '*kill-xyzzy-hook* 'clipselect-exit)))

(add-hook '*init-app-menus-hook* #'clipselect-init)


;;; clipselect.l ends here.
