;;; -*- Mode: Lisp; Package: USER; Last modified: "2006/05/14 23:33:25" -*-
;;;
;;; This file is not part of xyzzy.
;;;
;;;  chcolor.l --- obt@́u\Fvؑւ
;;;

;;;  Tv:
;;;
;;;    xyzzy Part7 348, 354, 355, 361, 374 CсC
;;;    xyzzy̎g킩ʃV܂2 959 
;;;    ̐Fݒ xyzzy Part7 420 ̕@ŕύXĎ
;;;    Ă݂B
;;;
;;;    ݒt@Cǂݏ邠n߁A낢
;;;    SANO Masatoshi ɂĒ܂B

;;;  CXg[:
;;;
;;;    1. fBNg chcolor  ~/site-lisp ɃRs[B
;;;
;;;    2. .xyzzy ƂɈȉ̋LqǉB
;;;
;;;        (load-library "chcolor/chcolor")

;;;  g:
;;;
;;;    E\FIA\FύX
;;;
;;;        M-x chcolor
;;;
;;;      [\FύX]
;;;         \Fݒp^[t@CIA݃obt@ɔf
;;;         B
;;;
;;;      [Fɖ߂]
;;;         xyzzy.ini ɐݒ肳Ăp^[ŕ\āAJob
;;;         t@́Achcolor ɂύX͍sȂ悤ɂB
;;;
;;;      [Jobt@ύX]
;;;         ݒ肵p^[Jobt@ɂKp邩ǂ
;;;         ؑւB
;;;
;;;      [ɑSẴobt@ύX]
;;;         \FύX́AɑSẴobt@ύX邩ǂ̐ؑւB
;;;
;;;      [\Ft@C֕ۑ]
;;;         ݐݒ肳Ă\Fp^[t@CɏoB
;;;
;;;      [\FύXI]
;;;         Jobt@́Achcolor ɂύX͍sȂ悤
;;;         ɂB
;;;
;;;    Ep^[t@CIāA\FύX
;;;
;;;        ǂAchcolor-specify-file sB

;;;  ݒ:
;;;
;;;    EL[oCh
;;;
;;;       (global-set-key #\M-e 'chcolor)
;;;
;;;      ƂB
;;;
;;;    Ep^[ԍw肵āA\FύX
;;;
;;;        ese-fortune(V1.07 ȍ~)ł́AuvɂB
;;;
;;;          (add-hook '*ese-fortune-mode-hook*
;;;               #'(lambda () (chcolor-specify-file "")))

;;;   CZX
;;;  
;;;    chcolor.l  NYSL Version 0.9982 ɏ]܂B
;;;  
;;;      NYSL - http://www.kmonos.net/nysl/
;;;  
;;;    A. {\tgEFA Everyone'sWare łB̃\tgɂllA
;;;       ̍̂̂Ɠ悤ɁARɗp邱Ƃo܂B
;;;  
;;;      A-1. t[EFAłB҂͎gpv܂B
;;;      A-2. L}̂̔@킸ARɓ]ځEĔzzł܂B
;;;      A-3. Ȃނ ρEvOł̗p sĂ\܂B
;;;      A-4. ύX̂╔IɎgp̂́AȂ̂̂ɂȂ܂B
;;;           Jꍇ́AȂ̖ỎōsĉB
;;;  
;;;    B. ̃\tg𗘗p邱ƂɂĐQɂāA҂
;;;       ӔC𕉂Ȃ̂Ƃ܂Be̐ӔCɂĂpB
;;;  
;;;    C. Ґli HIE MasahiroCSANO Masatoshi ɋA܂B쌠
;;;       ͕܂B
;;;  
;;;    D. ȏ̂ŔA\[XEsoCȋoɓKp܂B

;;;  XV:
;;;
;;;    [Version 1.02] 2006/05/14 ()
;;;    EWindows XP ŐFݒ̕ۑłȂȂĂ̂CB
;;;      ēcɊӁB
;;;    ECZXKpB
;;;
;;;    [Version 1.01] 2002/12/10 ()
;;;    EFt@CɕۑłȂȂĂ̂CB
;;;    E\FύXPxłsɁAǂ hook ŁA
;;;      chcolor-specify-file sƁAȍ~̃obt@ŁA
;;;      ̈Ӑ}\FłȂȂĂ܂̂CB
;;;
;;;    [Version 1.00] 2002/12/03 ()
;;;    Echcolor ƂB

(provide "chcolor")

(eval-when (:compile-toplevel :load-toplevel :execute)
  (require "foreign"))

(defvar *chcolor-refresh-next-buffer* t
  "chcolor: Jobt@ύX")

(defvar *chcolor-refresh-all* t
  "chcolor: ɑSẴobt@ύX")

(defvar *chcolor-ini-dir* (concat (si:system-root) "site-lisp/chcolor/ini/")
  "chcolor: \Fp^[ݒt@C̕ۑꏊ")

(defvar *chcolor-table* nil
  "chcolor: \Fp^[")

(defvar *chcolor-keylist*
  '("textColor" "backColor" "ctlColor" "selectionTextColor" "selectionBackColor"
    "kwdColor1" "kwdColor2" "kwdColor3" "stringColor" "commentColor" "tagColor"
    "cursorColor" "caretColor" "imeCaretColor" "linenum" "reverse"
    "unselectedModeLineFg" "unselectedModeLineBg" "modeLineFg" "modeLineBg")
  "chcolor: ini file ̃L[̃Xg")

(defvar *chcolor-menu* nil)

(defun chcolor-init ()
  "chcolor: menu ̍XV"
  (setq *chcolor-menu*
	(define-popup-menu
	  ;----------------------------------------------------------------------------
	  (:item nil "\FύX(&O)" 'chcolor-select-file)
	  ;----------------------------------------------------------------------------
	  :sep
	  (:item nil "obt@Fɖ߂(&D)"
	   #'(lambda ()(interactive)(set-buffer-colors nil)))
	  (:item nil "Sobt@Fɖ߂(&R)"
	   #'(lambda ()(interactive)(setq *chcolor-table* nil)(chcolor-set -1 t)))
	  ;----------------------------------------------------------------------------
	  :sep
	  (:item nil "Jobt@ύX(&N)" 'chcolor-toggle-refresh-next-buffer
	   #'(lambda ()(and *chcolor-refresh-next-buffer* :check)))
	  (:item nil "ɑSẴobt@ύX(&A)" 'chcolor-toggle-refresh-all
	   #'(lambda ()(and *chcolor-refresh-all* :check)))
	  ;----------------------------------------------------------------------------
	  :sep
	  (:item nil "\Ft@C֕ۑ(&S)"
	   #'(lambda ()(interactive)
	       (chcolor-set)(refresh-screen)
	       (and (yes-or-no-p "ݕ\Ft@Cɕۑ܂B")
		    (chcolor-save-to-ini
		     (read-file-name "FileName: " :default *chcolor-ini-dir*)
		     *chcolor-keylist*))))
	  ;----------------------------------------------------------------------------
	  :sep
	  (:item nil "\FύXI(&Q)"
	   #'(lambda ()(interactive)(setq *chcolor-table* nil)(chcolor-stop-hook))
	   #'(lambda ()(unless *chcolor-table* :disable)))
	  ;----------------------------------------------------------------------------
	  )))

(defun chcolor ()
  (interactive)
  (unless *chcolor-menu* (chcolor-init))
  (track-popup-menu *chcolor-menu*))

(defun chcolor-select-file ()
  "chcolor: ݒt@CI\FύX"
  (interactive)
  (toggle-ime nil)
  (multiple-value-bind (file result)
      (let ((*filer-last-file-mask* '("*")))
	(filer *chcolor-ini-dir* nil "\Fp^[̑I" nil))
    (when result
      (unless (file-directory-p file)
	(let (nextbuf)
	  (if *chcolor-refresh-next-buffer* (setq nextbuf 1)(setq nextbuf -1))
	  (setq *chcolor-table* (chcolor-load-from-ini file *chcolor-keylist*))
	  (chcolor-set nextbuf *chcolor-refresh-all*))))))

(defun chcolor-set (&optional nextbuf all)
  "chcolor: \Fp^[gĕ\FύX"
  (let (tbl)
    (if *chcolor-table*
	(setq tbl (make-array 20 :initial-contents *chcolor-table*))
      (setq tbl nil))
    (if all
	(let ((sb (buffer-name (selected-buffer))))
	  (dolist (buf (buffer-list))
	    (set-buffer buf)(set-buffer-colors tbl))
	  (set-buffer sb))
      (set-buffer-colors tbl))
    (when nextbuf
      (cond ((= nextbuf  1)(chcolor-start-hook))
	    ((= nextbuf -1)(chcolor-stop-hook))))))

(defun chcolor-specify-file (file)
  "chcolor: ݒt@Cw肵ĕ\FύX"
  (let (tbl pn)
    (if file
	(progn (setq pn (merge-pathnames file *chcolor-ini-dir*))
	  (when (file-exist-p pn)
	    (setq tbl (make-array 20 :initial-contents
				  (chcolor-load-from-ini pn *chcolor-keylist*)))))
      (setq tbl nil))
    (set-buffer-colors tbl)))

(defun chcolor-toggle-refresh-next-buffer ()
  "chcolor: Jobt@ύX邩ǂ̐ؑւ"
  (interactive)
  (if *chcolor-refresh-next-buffer*
      (setq *chcolor-refresh-next-buffer* nil)
    (progn
      (setq *chcolor-refresh-next-buffer* t)(chcolor-set))))

(defun chcolor-toggle-refresh-all ()
  "chcolor: ɑSẴobt@ύX邩ǂ̐ؑւ"
  (interactive)
  (if *chcolor-refresh-all*
      (setq *chcolor-refresh-all* nil)
    (progn
      (setq *chcolor-refresh-all* t)(chcolor-set nil t))))

(defun chcolor-start-hook ()
  "chcolor: Jobt@ɂ chcolor Kp"
  (add-hook '*fundamental-mode-hook* 'chcolor-hook))

(defun chcolor-stop-hook ()
  "chcolor: Jobt@ɂ chcolor KpȂ悤"
  (delete-hook '*fundamental-mode-hook* 'chcolor-hook))

(defun chcolor-hook ()
  (and *chcolor-refresh-next-buffer* (chcolor-set)))


(let ((dll "kernel32"))
  (c:define-dll-entry c:int chcolor-get-private-profile-string-a
    ((c:char *) (c:char *) (c:char *) (c:char *) c:int (c:char *))
    dll "GetPrivateProfileStringA")
  (c:define-dll-entry c:int chcolor-write-private-profile-string-a
    ((c:char *) (c:char *) (c:char *) (c:char *))
    dll "WritePrivateProfileStringA"))

(defun chcolor-get-private-profile-string (App Key Def Size File)
  "chcolor: ini file l擾"
  (let ((chunk (si:make-chunk nil Size)))
    (chcolor-get-private-profile-string-a (si:make-string-chunk App)
			      (si:make-string-chunk Key)
			      (si:make-string-chunk Def)
			      chunk
			      Size
			      (si:make-string-chunk File))
    (si:unpack-string chunk 0)))

(defun chcolor-write-private-profile-string (App Key Str File)
  "chcolor: ini file ֒lۑ"
  (chcolor-write-private-profile-string-a (si:make-string-chunk App)
			      (si:make-string-chunk Key)
			      (si:make-string-chunk Str)
			      (si:make-string-chunk File)))

(defun chcolor-load-from-ini (file kl)
  "chcolor: ini file \Fp^[擾"
  (mapcar #'(lambda (str)
	      (let ((ret 0))
		(setq str (string-downcase
			   (chcolor-get-private-profile-string "Colors" str "#0" 100 file)))
		(dotimes (i (length str))
		  (cond
		   ((lower-case-p (char str i))
		    (setq ret (* 16 (+ ret(- (char-code (char str i)) 87)))))
		   ((digit-char-p (char str i))
		    (setq ret (* 16 (+ ret(- (char-code (char str i)) 48)))))))
		(setq ret (/ ret 16))))
	  kl))

(defun chcolor-save-to-ini (file kl)
  "chcolor: ini file ֕\Fp^[ۑ"
  (let ((tw))
    (if *chcolor-table* (setq tw *chcolor-table*)
      (setq tw (chcolor-load-from-ini (chcolor-get-xyzzy-ini-name) kl)))
    (mapcar #'(lambda (Key Val)
		(chcolor-write-private-profile-string "Colors"  Key (format nil "#~X" Val) file))
	    kl tw)))

(defun chcolor-get-xyzzy-ini-name ()
  "chcolor: xyzzy.ini ̃tpX擾"
  (merge-pathnames "xyzzy.ini" (user-config-path)))


;;;
;;;  End of chcolor.l
;;;
