;;; -*- Mode: Lisp; Package: ChangeLogMemo -*-
;;;
;;; changelogmemo/draft.l
;;;
;;; Last updated: "2006-02-22"
;;;

(provide "changelogmemo/buffer-info")

(in-package "changelogmemo")

(defstruct buffer-info
  string point window-line file major-mode minor-mode-list read-only mark
  narrow modified-p fold-width fill-column need-not-save auto-save ime-mode
  encoding eol-code)

(defun get-buffer-info ()
  (let ((string) (point (point)) (window-line (get-window-line))
	(file (get-buffer-file-name))
	(major-mode buffer-mode) (minor-mode-list (get-minor-mode-list))
	(read-only buffer-read-only)
	(mark (mark t)) (narrow)
	(modified-p (buffer-modified-p))
	(fold-width (buffer-fold-width)) (column fill-column)
	(not-save need-not-save) (auto auto-save)
	(ime-mode (get-ime-mode))
	(encoding (buffer-fileio-encoding))
	(eol-code (buffer-eol-code))
	(beg (point-min)) (end (point-max))
	(info (make-buffer-info)))
    (widen)
    (when (or (/= beg (point-min)) (/= end (point-max)))
      (setq narrow (cons beg end)))
    (setq string (buffer-substring (point-min) (point-max)))
    (setf (buffer-info-string info) string)
    (setf (buffer-info-point info) point)
    (setf (buffer-info-window-line info) window-line)
    (setf (buffer-info-file info) file)
    (setf (buffer-info-major-mode info) major-mode)
    (setf (buffer-info-minor-mode-list info) minor-mode-list)
    (setf (buffer-info-read-only info) read-only)
    (setf (buffer-info-mark info) mark)
    (setf (buffer-info-narrow info) narrow)
    (setf (buffer-info-modified-p info) modified-p)
    (setf (buffer-info-fold-width info) fold-width)
    (setf (buffer-info-fill-column info) column)
    (setf (buffer-info-need-not-save info) not-save)
    (setf (buffer-info-auto-save info) auto)
    (setf (buffer-info-ime-mode info) ime-mode)
    (setf (buffer-info-encoding info) encoding)
    (setf (buffer-info-eol-code info) eol-code)
    info))

;; session.l  list-buffer-info ؗp
(defun get-minor-mode-list ()
  (mapcan #'(lambda (mode)
	      (let ((var (and (consp mode) (car mode))))
		(and (symbolp var)
		     (boundp var)
		     (symbol-value var)
		     (list var))))
	  *minor-mode-alist*))

(defun restore-buffer-info (info)
  (let ((string (buffer-info-string info))
	(point (buffer-info-point info))
	(window-line (buffer-info-window-line info))
	(file (buffer-info-file info))
	(major-mode (buffer-info-major-mode info))
	(minor-mode-list (buffer-info-minor-mode-list info))
	(read-only (buffer-info-read-only info))
	(mark (buffer-info-mark info))
	(narrow (buffer-info-narrow info))
	(modified-p (buffer-info-modified-p info))
	(fold-width (buffer-info-fold-width info))
	(column (buffer-info-fill-column info))
	(not-save (buffer-info-need-not-save info))
	(auto (buffer-info-auto-save info))
	(ime-mode (buffer-info-ime-mode info))
	(encoding (buffer-info-encoding info))
	(eol-code (buffer-info-eol-code info)))
    (and (fboundp major-mode) (funcall major-mode))
    (mapc #'(lambda (f) (and (fboundp f) (funcall f))) minor-mode-list)
    (setq buffer-read-only read-only)
    (setq need-not-save not-save)
    (setq auto-save auto)
    (set-buffer-fold-width fold-width)
    (setq fill-column column)
    (set-buffer-file-name nil);G[邽
    (erase-buffer (selected-buffer))
    (insert string)
    (goto-char point)
    (recenter window-line)
    (set-buffer-file-name file)
    (and mark (set-mark mark))
    (and narrow (narrow-to-region (car narrow) (cdr narrow)))
    (and *save-buffer-ime-mode* (toggle-ime ime-mode))
    (set-buffer-fileio-encoding encoding)
    (set-buffer-eol-code eol-code)
    (set-buffer-modified-p modified-p)
    t))
