;;; -*- Mode: Lisp; Package: EDITOR -*-
;;; box-fixation-mode.l --- rҏWp}Ci[/W[[h

;; Copyright (C) 2001-2005 OHKUBO Hiroshi <ohkubo@s53.xrea.com>

;; Author: OHKUBO Hiroshi <ohkubo@s53.xrea.com>
;; Time-stamp: <2005/10/08 14:28:01 +0900>

;;; Commentary:

;; Description:
;;
;;  rҏWs߂̃}Ci[/W[[hłB
;;
;;  r[h (box-drawings-mode) ŋLqrACSV[h
;;  ϊr̈ʒuŒ肵ҏWsꍇɎgp܂B
;;
;;  rԂ͈̔͂𒴉߂͂sꍇAߕsɓ͂܂B
;;  rĂ莟sɓ͂łȂꍇ́Ařpsǉ
;;  Œߕ͂܂B
;;

;; Installation:
;;
;;      1. A[JCuWJ box-fixation-mode.l  $XYZZY/site-lisp 
;;         Rs[܂B
;;         toolbar-box-fixation.bmp  $XYZZY/etc ɃRs[܂B
;;
;;      2. oCgRpC܂B
;;
;;              M-x byte-compile-file
;;              Byte compile file: $XYZZY/site-lisp/box-fixation-mode.l
;;
;;      3. ~/.xyzzy ܂ $XYZZY/site-lisp/siteinit.l Ɉȉ̃R[h
;;         ǉ܂B
;;
;;              (require "box-fixation-mode")
;;
;;      4. L̐ݒ𔽉f邽߂ɁAxyzzy ċN܂B
;;         siteinit.l ɋLqꍇ Ctrl L[ Shift L[Ȃ
;;         xyzzy ċNA_vt@Cč\z܂B
;;

;; Uninstallation:
;;
;;      1. ESC ESC (ed::box-fixation-mode-uninstall) ƃ^CvA
;;         box-fixation-mode.l ֘Ȁ xyzzy 폜܂B
;;
;;      2. box-fixation-mode.l ɊւLq폜܂B
;;
;;      3. siteinit.l ɋLqĂꍇ Ctrl L[ Shift L[
;;         Ȃ xyzzy ċNA_vt@Cč\z܂B
;;

;; Usage:
;;
;;      M-x box-fixation-mode
;;      M-x box-fixation-minor-mode
;;

;; Key bind:
;;
;;      box-fixation-mode
;;
;;      C-f      lāA̕ֈړ
;;      C-b      lāAO̕ֈړ
;;      C-n      lāAsֈړ
;;      C-p      lāAOsֈړ
;;      C-a      s͍sɈړ
;;      C-e      sɈړ
;;      M-f      ̗̗sɈړ
;;      M-b      O̗̗sɈړ
;;      Right    lāA̕ֈړ
;;      Left     lāAO̕ֈړ
;;      Down     lāAsֈړ
;;      Up       lāAOsֈړ
;;
;;      RET      s̕s擪ɑ}DKvɉVKsǉ
;;      LFD      s̕񂩂Ȃ鎟s쐬DKvɉVKsǉ
;;      Delete   폜
;;      C-d      폜
;;      C-h      ̕폜
;;      C-k      lāAsL
;;      C-w      lāA[WLOɒǉA폜
;;      M-w      lāA[WLOɒǉ
;;      M-C-w    ̃LŃLAyh悤ɐݒ
;;      M-Up     Z^O(E)
;;      M-Down   Z^O()
;;      M-Left   
;;      M-Right  E
;;
;;
;;      box-fixation-minor-mode
;;
;;      L[oChȂ
;;

;; Setting example:
;;
;;      (require "box-fixation-mode")
;;      ;; box-fixation-minor-mode ɃL[oChǉ
;;      (define-key *box-fixation-minor-mode-map* #\M-Up
;;                  'box-fixation-reposition-rcenter)
;;      (define-key *box-fixation-minor-mode-map* #\M-Down
;;                  'box-fixation-reposition-lcenter)
;;      (define-key *box-fixation-minor-mode-map* #\M-Left
;;                  'box-fixation-reposition-left)
;;      (define-key *box-fixation-minor-mode-map* #\M-Right
;;                  'box-fixation-reposition-right)
;;

;; Changes:
;;
;;      Sat, 08 Oct 2005 14:26:25 +0900
;;        E[AhXύXB
;;        ECZX(CBSDCZX)LځB
;;
;;      Fri, 15 Apr 2005 00:21:58 +0900
;;        Exyzzy 0.2.2.234 Ή
;;          - pJiSpJiɕύXB
;;          - box-fixation-insert-menu-items XVB
;;            urҏW[hvj[ǉʒũftHg
;;            urv̉ɁB
;;        EurҏW[hvj[ftHgŒǉ悤ɁB
;;        ERgCB
;;
;;      Wed, 02 Feb 2005 00:23:03 +0900
;;        Ec[o[ǉB
;;        Ebox-fixation-mode-uninstall ǉB
;;
;;      Sat, 08 Jan 2005 00:36:27 +0900
;;        E쐬
;;
;;      Wed, 05 Jan 2005 20:16:24 +0900
;;        E쐬Jn
;;

;; Specification:
;;
;;      ETABΉB
;;      E{IɁAs̕ҏWɂ̂ݑΉB
;;      E(0x84A0) ͌rƂĈAb(0x8162) ͌rƂĈȂB
;;      ErF(Shift_JIS  0x849F-0x84BE 0x81A8-0x81AB)
;;          
;;          
;;          
;;          
;;

;; Restriction:
;;
;;      EZNVł̕ҏW͖lB
;;      Enarrowing Ԃł͖̓lB
;;

;; Todo:
;;
;;      EsɌrȂꍇ̊e֐̒B
;;      Ebox-fixation-insert  "\n" ΉɂB
;;

;; Licence:
;;
;;    box-fixation-mode ͏CBSDCZXɊÂėp\łB
;;    <http://www.opensource.org/licenses/bsd-license.php>
;;
;;
;;    Copyright (C) 2001-2005, OHKUBO Hiroshi.  All rights reserved.
;;
;;    Redistribution and use in source and binary forms, with or without
;;    modification, are permitted provided that the following conditions
;;    are met:
;;
;;    1. Redistributions of source code must retain the above copyright
;;       notice, this list of conditions and the following disclaimer.
;;
;;    2. Redistributions in binary form must reproduce the above copyright
;;       notice, this list of conditions and the following disclaimer in
;;       the documentation and/or other materials provided with the
;;       distribution.
;;
;;    3. Neither the name of the University nor the names of its
;;       contributors may be used to endorse or promote products derived
;;       from this software without specific prior written permission.
;;
;;    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;;    ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;;    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;;    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;;    OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;;    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
;;    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
;;    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
;;    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
;;    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
;;    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;;

#|

                          Description: rҏWs 
                          ߂̃}Ci[/W[ 
                          [hłBr[h (box-dr
awings-mode) ŋLqr 
ACSV[hŕϊr̈ʒu 
肵ҏWsꍇɎgp܂Br                
Ԃ͈̔͂                
                        ߂̈́                
          s
                              ꍇAߕs
                              ɓ͂
                              ܂BrĂ脫
                              sɓ͂łȂꍇ
                              ́Ařpsǉ
                              Œߕ͂
                              ܂B                

|#

;;; Code:

(provide "box-fixation-mode")

(require "boxdraw")

(in-package "editor")

(export '(box-fixation-minor-mode
          box-fixation-mode
          ;;
          box-fixation-beginning-of-line
          box-fixation-beginning-of-line-or-goto-bol
          box-fixation-end-of-line
          box-fixation-forward-column
          box-fixation-backward-column
          box-fixation-forward-char
          box-fixation-backward-char
          box-fixation-forward-line
          box-fixation-backward-line
          box-fixation-next-line
          box-fixation-previous-line
          ;;
          box-fixation-delete-region
          box-fixation-clear-region
          box-fixation-delete-char
          box-fixation-delete-backward-char
          box-fixation-copy-region-as-kill
          box-fixation-append-next-kill
          box-fixation-kill-region
          box-fixation-copy-region-to-clipboard
          box-fixation-kill-region-to-clipboard
          box-fixation-kill-line
          box-fixation-open-line
          box-fixation-newline
          box-fixation-newline-for-always
          box-fixation-newline-for-not-blank
          box-fixation-reposition-left
          box-fixation-reposition-right
          box-fixation-reposition-center
          box-fixation-reposition-lcenter
          box-fixation-reposition-rcenter
          ;;
          box-fixation-insert-menu-items
          box-fixation-delete-menu
          ;;
          *box-fixation-mode-hook*
          *box-fixation-minor-mode-map*
          *box-fixation-mode-map*
          *box-fixation-mode-syntax-table*
          *box-fixation-keyword-hash-table*
          *box-fixation-keyword-file*
          *box-fixation-regexp-keyword-list*
          *box-fixation-mode-abbrev-table*))

(defvar *box-fixation-mode-hook* nil)

(defvar-local box-fixation-minor-mode nil)

(defvar *box-fixation-minor-mode-map* nil)
(unless *box-fixation-minor-mode-map*
  (setq *box-fixation-minor-mode-map* (make-sparse-keymap)))

(defvar *box-fixation-mode-map* nil)
(unless *box-fixation-mode-map*
  (setq *box-fixation-mode-map* (make-sparse-keymap))
  ;; ړ
  (define-key *box-fixation-mode-map* #\C-f 'box-fixation-forward-char)
  (define-key *box-fixation-mode-map* #\C-b 'box-fixation-backward-char)
  (define-key *box-fixation-mode-map* #\C-n 'box-fixation-next-line)
  (define-key *box-fixation-mode-map* #\C-p 'box-fixation-previous-line)
  (define-key *box-fixation-mode-map* #\C-a 'box-fixation-beginning-of-line-or-goto-bol)
  (define-key *box-fixation-mode-map* #\C-e 'box-fixation-end-of-line)
  (define-key *box-fixation-mode-map* #\M-f 'box-fixation-forward-column)
  (define-key *box-fixation-mode-map* #\M-b 'box-fixation-backward-column)
  (define-key *box-fixation-mode-map* #\Right 'box-fixation-forward-char)
  (define-key *box-fixation-mode-map* #\Left 'box-fixation-backward-char)
  (define-key *box-fixation-mode-map* #\Down 'box-fixation-next-line)
  (define-key *box-fixation-mode-map* #\Up 'box-fixation-previous-line)
  ;; ҏW
  (define-key *box-fixation-mode-map* #\RET 'box-fixation-newline)
  (define-key *box-fixation-mode-map* #\LFD 'box-fixation-newline-for-not-blank)
  (define-key *box-fixation-mode-map* #\Delete 'box-fixation-delete-char)
  (define-key *box-fixation-mode-map* #\C-d 'box-fixation-delete-char)
  (define-key *box-fixation-mode-map* #\C-h 'box-fixation-delete-backward-char)
  (define-key *box-fixation-mode-map* #\C-k 'box-fixation-kill-line)
  (define-key *box-fixation-mode-map* #\C-w 'box-fixation-kill-region)
  (define-key *box-fixation-mode-map* #\M-w 'box-fixation-copy-region-as-kill)
  (define-key *box-fixation-mode-map* #\M-C-w 'box-fixation-append-next-kill)
  (define-key *box-fixation-mode-map* #\M-Up 'box-fixation-reposition-rcenter)
  (define-key *box-fixation-mode-map* #\M-Down 'box-fixation-reposition-lcenter)
  (define-key *box-fixation-mode-map* #\M-Left 'box-fixation-reposition-left)
  (define-key *box-fixation-mode-map* #\M-Right 'box-fixation-reposition-right))

(defvar *box-fixation-mode-syntax-table* nil)
(unless *box-fixation-mode-syntax-table*
  (setq *box-fixation-mode-syntax-table* (make-syntax-table))
  (set-syntax-symbol *text-mode-syntax-table* #\&)
  (set-syntax-symbol *text-mode-syntax-table* #\*)
  (set-syntax-symbol *text-mode-syntax-table* #\+)
  (set-syntax-symbol *text-mode-syntax-table* #\-)
  (set-syntax-symbol *text-mode-syntax-table* #\/)
  (set-syntax-symbol *text-mode-syntax-table* #\<)
  (set-syntax-symbol *text-mode-syntax-table* #\=)
  (set-syntax-symbol *text-mode-syntax-table* #\>)
  (set-syntax-symbol *text-mode-syntax-table* #\_)
  (set-syntax-symbol *text-mode-syntax-table* #\|))

(defvar *box-fixation-keyword-hash-table* nil)

(defvar *box-fixation-keyword-file* "BoxFix")

(defvar *box-fixation-regexp-keyword-list* nil)

(defvar *box-fixation-mode-abbrev-table* nil)
(unless *box-fixation-mode-abbrev-table*
  (define-abbrev-table '*box-fixation-mode-abbrev-table*))

(defconstant *box-fixation-chars-regexp*
  (compile-regexp (concat "[" (mapcar #'car *box-drawings-chars*) "]")))

(defvar *box-fixation-minimal-column-width* 2 "ŏ")

(defvar *box-fixation-target-buffer* nil)
(defvar *box-fixation-target-line* nil)
(defvar *box-fixation-target-modified-count* nil)
(defvar *box-fixation-column-alist* nil)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Ŋ{֐
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(let (target-buffer target-line target-modified-count cache-column-alist)
  (defun box-fixation-get-column-alist ()
    "ݍsAJArȂ alist 𐶐ԂB"
    (if (and (eq target-buffer (selected-buffer))
             (eql target-line (current-line-number))
             (eql target-modified-count (buffer-modified-count)))
        cache-column-alist
      (let ((goal-column (goal-column)) (match-data (match-data))
            limit box-fixation-column-alist)
        (save-excursion
          (goto-eol)
          (setq limit (point))
          (goto-bol)
          (while (scan-buffer *box-fixation-chars-regexp* :limit limit)
            (push (cons (current-column) (char-after (point)))
                  box-fixation-column-alist)
            (unless (forward-char)
              (return))))
        (store-match-data match-data)
        (set-goal-column goal-column)
        (setq target-buffer (selected-buffer)
              target-line (current-line-number)
              target-modified-count (buffer-modified-count))
        (setq cache-column-alist (nreverse box-fixation-column-alist))))))

(defun box-fixation-get-left-column-alist (column-alist column)
  "column-alist  column 荶̕ԂB
column ƈv̂͊܂܂ȂB"
  (let (left-column-alist)
    (dolist (x column-alist)
      (if (< (car x) column)
          (push x left-column-alist)
        (return)))
    (nreverse left-column-alist)))

(defun box-fixation-get-right-column-alist (column-alist column)
  "column-alist  column ܂݉E̕ԂB"
  (member column column-alist :test #'<= :key #'car))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; {֐
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun box-fixation-get-side-column-elements (column-alist column)
  "column-alist  column ͂ޗTCh̕ values ŕԂB
݂ȂTCh̏ nil ƂB"
  (values (car (last (box-fixation-get-left-column-alist column-alist column)))
          (car (box-fixation-get-right-column-alist column-alist column))))

(defun box-fixation-get-column-width (&optional (left-column-element nil left-column-element-sv)
                                                (right-column-element nil right-column-element-sv))
  "ԂB
right-column-element  nil ̏ꍇ͖ӖlƂ nil ԂB"
  (when (and (not left-column-element-sv) (not right-column-element-sv))
    (multiple-value-setq (left-column-element right-column-element)
      (box-fixation-get-side-column-elements
       (box-fixation-get-column-alist) (current-column))))
  (if right-column-element
      (- (car right-column-element)
         (if left-column-element
             (+ (car left-column-element) (char-columns (cdr left-column-element)))
           0))
    nil))

(defun box-fixation-line-p ()
  "J[\r̂sɂ邩
߂lF
  t   J[\r̂sɂ
  nil J[\r̂sɂȂ"
  (if (box-fixation-get-column-alist) t nil))

(defun box-fixation-column-p ()
  "J[\(񂪑}\ȕ̂)ɂ邩
߂lF
  t   J[\񂪑}\ȕ̂ɂ
  nil J[\񂪑}\ȕ̂ɂȂ"
  (let ((column-width (box-fixation-get-column-width)))
    (or (null column-width) (>= column-width *box-fixation-minimal-column-width*))))

(defun box-fixation-right-most-column-p ()
  "J[\ŉE(E[s̗)ɂ邩
߂lF
  t   J[\ŉEɂ
  nil J[\ŉEɂȂ"
  (and (box-fixation-column-p)
       (null (box-fixation-get-right-column-alist
              (box-fixation-get-column-alist) (current-column)))))

(defun box-fixation-bolp ()
  "J[\sɂ邩
߂lF
  t   J[\sɂ
  nil J[\sɂȂ"
  (and (or (bolp)
           (save-excursion
             (backward-char)
             (looking-at *box-fixation-chars-regexp*)))
       (box-fixation-column-p)))

(defun box-fixation-eolp ()
  "J[\sɂ邩
߂lF
  t   J[\sɂ
  nil J[\sɂȂ"
  (or (eolp)
      (and (looking-at *box-fixation-chars-regexp*)
           (box-fixation-column-p))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ړ֐
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun box-fixation-goto-bol ()
  "sɈړ
߂lF
  t   J[\sɂ (J[\ړĂȂĂ t)
  nil J[\sɂȂ"
  (let ((column-alist (box-fixation-get-column-alist))
        left-column-element right-column-element goto-point)
    (save-excursion
      (loop
        (multiple-value-setq (left-column-element right-column-element)
          (box-fixation-get-side-column-elements column-alist (current-column)))
        (if left-column-element
            (if (box-fixation-column-p)
                (progn
                  (goto-column (car left-column-element))
                  (forward-char)
                  (setq goto-point (point))
                  (return))
              (goto-column (car left-column-element)))
          (progn
            (when (box-fixation-column-p)
              (goto-bol)
              (setq goto-point (point)))
            (return)))))
    (when goto-point
      (goto-char goto-point))))

(defun box-fixation-goto-eol ()
  "sɈړ
߂lF t"
  (let ((column-alist (box-fixation-get-column-alist))
        left-column-element right-column-element)
    (loop
      (multiple-value-setq (left-column-element right-column-element)
        (box-fixation-get-side-column-elements
         column-alist (current-column)))
      (if right-column-element
          (progn
            (goto-column (car right-column-element))
            (if (box-fixation-column-p)
                (return)
              (forward-char)))
        (progn
          (goto-eol)
          (return)))))
  t)

(defun box-fixation-left-column-exist-p ()
  "J[\荶ɗ񂪑݂邩
߂lF
  t   J[\荶ɗ񂪑݂
  nil J[\荶ɗ񂪑݂Ȃ"
  (save-excursion
    (and (not (bolp))
         (backward-char)
         (box-fixation-goto-bol))))

(defun box-fixation-goto-bol-no-dup (&optional (arg 1))
  "sɈړBɗsɂꍇ͑O̗sɈړB
߂lF
  t   J[\ړ
  nil J[\ړȂ"
  (let ((point (point)))
    (while (and (plusp arg) (box-fixation-left-column-exist-p))
      (decf arg)
      (backward-char)
      (box-fixation-goto-bol))
    (/= point (point))))

(defun box-fixation-goto-eol-no-dup (&optional (arg 1))
  "sɈړBɗsɂꍇ͎̗sɈړB
߂lF
  t   J[\ړ
  nil J[\ړȂ"
  (let ((point (point)))
    (while (and (not (eolp)) (plusp arg))
      (decf arg)
      (forward-char)
      (box-fixation-goto-eol))
    (/= point (point))))

(defun box-fixation-beginning-of-line (&optional (arg 1))
  "sɈړB
box-fixation-goto-bol-no-dup  interactive 
߂lF
  t   J[\ړ
  nil J[\ړȂ"
  (interactive "p")
  (box-fixation-goto-bol-no-dup arg))

(defun box-fixation-beginning-of-line-or-goto-bol (&optional (arg 1))
  "s͍sɈړB
߂lF
  t   J[\ړ
  nil J[\ړȂ"
  (interactive "p")
  (let ((point (point)))
    (or (box-fixation-goto-bol-no-dup arg)
        (goto-bol))
    (/= point (point))))

(defun box-fixation-end-of-line (&optional (arg 1))
  "sɈړB
box-fixation-goto-eol-no-dup  interactive 
  t   J[\ړ
  nil J[\ړȂ"
  (interactive "p")
  (box-fixation-goto-eol-no-dup arg))

(defun box-fixation-forward-column (&optional (arg 1))
  "J[\O̗ɈړB
ړłȂꍇ́AJ[\ړȂB
߂lF
  t   ʂ̗Ɉړ
  nil ʂ̗ɈړȂ (J[\ړȂ)"
  (interactive "p")
  (let (moved goto-point)
    (save-excursion
      (cond ((plusp arg)
             (when (box-fixation-column-p)
               (box-fixation-goto-eol))
             (while (plusp arg)
               (setq moved (or moved (box-fixation-goto-eol-no-dup)))
               (decf arg))
             (box-fixation-goto-bol))
            ((minusp arg)
             (when (box-fixation-column-p)
               (box-fixation-goto-bol))
             (while (minusp arg)
               (setq moved (or moved (box-fixation-goto-bol-no-dup)))
               (incf arg))))
      (setq goto-point (point)))
    (when moved
      (goto-char goto-point))))

(defun box-fixation-backward-column (&optional (arg 1))
  "J[\̗ɈړB
ړłȂꍇ́AJ[\ړȂB
߂lF
  t   ʂ̗Ɉړ
  nil ʂ̗ɈړȂ (J[\ړȂ)"
  (interactive "p")
  (box-fixation-forward-column (- arg)))

(defun box-fixation-get-next-line-destination-columns ()
  "ړƂȂ蓾As column ̃XgԂB"
  (unless (box-fixation-column-p)
    (return-from box-fixation-get-next-line-destination-columns nil))
  (let (left-column right-column destination-columns)
    (save-excursion
      (box-fixation-goto-bol)
      (setq left-column (current-column))
      (box-fixation-goto-eol)
      (unless (eolp)
        (setq right-column (current-column)))
      (unless (forward-line)
        (return-from box-fixation-get-next-line-destination-columns nil))
      (unless (box-fixation-column-p)
        (box-fixation-forward-column))
      (loop
        (when (and
               ;; sA̗s
               (or (null right-column)
                   (< (current-column) right-column))
               ;; sA̗sE
               (or (progn (box-fixation-goto-eol) (eolp))
                   (< left-column (current-column))))
          (box-fixation-goto-bol)
          (push (current-column) destination-columns))
        (unless (box-fixation-forward-column)
          (return))))
    (nreverse destination-columns)))

(defun box-fixation-get-previous-line-destination-columns ()
  "ړƂȂ蓾AOs column ̃XgԂB"
  (unless (box-fixation-column-p)
    (return-from box-fixation-get-previous-line-destination-columns nil))
  (let (left-column right-column destination-columns)
    (save-excursion
      (box-fixation-goto-bol)
      (setq left-column (current-column))
      (box-fixation-goto-eol)
      (unless (eolp)
        (setq right-column (current-column)))
      (unless (backward-line)
        (return-from box-fixation-get-previous-line-destination-columns nil))
      (unless (box-fixation-column-p)
        (box-fixation-forward-column))
      (loop
        (when (and
               ;; sA̗s
               (or (null right-column)
                   (< (current-column) right-column))
               ;; sA̗sE
               (or (progn (box-fixation-goto-eol) (eolp))
                   (< left-column (current-column))))
          (box-fixation-goto-bol)
          (push (current-column) destination-columns))
        (unless (box-fixation-forward-column)
          (return))))
    (nreverse destination-columns)))

(defun box-fixation-forward-char (&optional (arg 1))
  "lĎ̕ֈړB
߂lF
  t   ړ
  nil ړĂȂ"
  (interactive "p")
  (let ((point (point)) column)
    (cond ((plusp arg)
           (while (plusp arg)
             (decf arg)
             (if (or (box-fixation-eolp)
                     (save-excursion
                       (forward-char)
                       (and (not (eolp)) (box-fixation-eolp))))
                 (when (setq column (car (box-fixation-get-next-line-destination-columns)))
                   (forward-line)
                   (goto-column column))
               (forward-char))))
          ((minusp arg)
           (while (minusp arg)
             (incf arg)
             (if (box-fixation-bolp)
                 (when (setq column (car (box-fixation-get-previous-line-destination-columns)))
                   (backward-line)
                   (goto-column column)
                   (box-fixation-goto-eol)
                   (unless (eolp)
                     (backward-char)))
               (backward-char)))))
    (/= point (point))))

(defun box-fixation-backward-char (&optional (arg 1))
  "lđO̕ֈړB
߂lF
  t   ړ
  nil ړĂȂ"
  (interactive "p")
  (box-fixation-forward-char (- arg)))

(defun box-fixation-forward-line (&optional (arg 1))
  "lĎs̗sֈړB
߂lF
  integer  ړs (+ / -)
  nil      ړĂȂ"
  (interactive "p")
  (let ((moved 0) column)
    (cond ((plusp arg)
           (while (plusp arg)
             (decf arg)
             (cond ((not (box-fixation-column-p))
                    (when (next-line)
                      (incf moved)))
                   ((setq column (car (box-fixation-get-next-line-destination-columns)))
                    (forward-line)
                    (goto-column column)
                    (incf moved))
                   (t
                    (return)))))
          ((minusp arg)
           (while (minusp arg)
             (incf arg)
             (cond ((not (box-fixation-column-p))
                    (when (previous-line)
                      (decf moved)))
                   ((setq column (car (box-fixation-get-previous-line-destination-columns)))
                    (backward-line)
                    (goto-column column)
                    (decf moved))
                   (t
                    (return))))))
    (when (/= moved 0)
      moved)))

(defun box-fixation-backward-line (&optional (arg 1))
  "lđOs̗sֈړB
߂lF
  integer  ړs (+ / -)
  nil      ړĂȂ"
  (interactive "p")
  (box-fixation-forward-line (- arg)))

(defun box-fixation-next-line (&optional (arg 1))
  "lĎsֈړB
߂lF
  t   ړ
  nil ړĂȂ"
  (interactive "p")
  (let ((goal-column (goal-column)))
    (when (box-fixation-forward-line arg)
      (cond ((< goal-column (save-excursion (box-fixation-goto-bol) (current-column)))
             (box-fixation-goto-bol))
            ((< (save-excursion (box-fixation-goto-eol) (current-column)) goal-column)
             (box-fixation-goto-eol))
            (t
             (goto-column goal-column)
             (set-goal-column goal-column)))
      t)))

(defun box-fixation-previous-line (&optional (arg 1))
  "lđOsֈړB
߂lF
  t   ړ
  nil ړĂȂ"
  (interactive "p")
  (box-fixation-next-line (- arg)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ҏW֐
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun box-fixation-region-to-region-list (from to)
  "[Wӎ[W̃XgɕϊB"
  (save-excursion
    (if (> from to) (rotatef from to))
    (goto-char from)
    (unless (box-fixation-column-p)
      (return-from box-fixation-region-to-region-list nil))
    (when (= from to)
      (return-from box-fixation-region-to-region-list nil))
    (let (region-list column)
      (loop
        ;; sPʂňړłꍇ͍sPʂňړ
        (box-fixation-goto-eol)
        (if (<= (point) to)
            (progn
              (push (cons from (point)) region-list)
              (unless (setq column (car (box-fixation-get-next-line-destination-columns)))
                (return))
              (forward-line)
              (goto-column column)
              (setq from (point))
              (unless (< (point) to)
                (return)))
          ;; Pʂňړ
          (progn
            (box-fixation-goto-bol)
            (while (< (point) to)
              (unless (box-fixation-forward-char)
                (return)))
            (push (cons from (point)) region-list)
            (return))))
      (nreverse region-list))))

(defun box-fixation-buffer-substring (from to &optional (trim-type :both) add-newline)
  "lA[W̕擾
F
  TRIM-TYPE
    :left     eA󔒍폜
    :right    eAE󔒍폜
    :both     eAE󔒍폜
    LȊO  E̋󔒂폜Ȃ

ADD-NEWLINE
    nil       e񖖔ɉsǉȂ
    non-nil   e񖖔ɉsǉ"
  (let* ((string-list (mapcar #'(lambda (x) (buffer-substring (car x) (cdr x)))
                              (box-fixation-region-to-region-list from to))))
    (setq string-list
          (case trim-type
            (:left  (mapcar #'(lambda (x) (string-left-trim " " x)) string-list))
            (:right (mapcar #'(lambda (x) (string-right-trim " " x)) string-list))
            (:both  (mapcar #'(lambda (x) (string-trim " " x)) string-list))
            (t      string-list)))
    (when add-newline
      (setq string-list
            (append (mapcar #'(lambda (x) (concat x "\n")) (butlast string-list))
                    (last string-list))))
    (apply #'concat string-list)))

(defun box-fixation-delete-region (from to &optional (unit :line))
  "lA[W폜
ŉȄꍇ͋󔒂⊮Ȃ
F
  UNIT
    :line         sPʂōl
    :blank-line   󔒍so܂ł͈̔͂l
    :column       Ŝl
    LȊO      폜Al߂Ȃ
߂lFt
ӁF
  ݂ UNIT u:linevuLȊOv̏ꍇ̂ݎς݁B"
  (interactive "*r")
  (let ((region-list (box-fixation-region-to-region-list from to))
        region column-width)
    (if (> from to) (rotatef from to))
    (case unit
      (:line
       (save-excursion
         (setq region-list (nreverse region-list))
         ;; Ō̍s
         (setq region (pop region-list))
         (when region
           (setq column-width (- (progn (goto-char (cdr region)) (current-column))
                                 (progn (goto-char (car region)) (current-column))))
           (unless (box-fixation-right-most-column-p)
             (box-fixation-goto-eol)
             (insert " " column-width))
           (delete-region (car region) (cdr region)))
         ;; ŌȊO̍s
         (dolist (region region-list)
           (setq column-width (- (progn (goto-char (cdr region)) (current-column))
                                 (progn (goto-char (car region)) (current-column))))
           (delete-region (car region) (cdr region))
           (unless (box-fixation-right-most-column-p)
             (insert " " column-width))))
       (goto-char from))
      (:blank-line ; 
       nil)
      (:column     ; 
       nil)
      (t
       (save-excursion
         (dolist (region (nreverse region-list))
           (setq column-width (- (progn (goto-char (cdr region)) (current-column))
                                 (progn (goto-char (car region)) (current-column))))
           (delete-region (car region) (cdr region))
           (unless (box-fixation-right-most-column-p)
             (insert " " column-width))))
       (goto-char from))))
  t)

(defun box-fixation-clear-region (from to)
  "lA[W󔒂ɒuB
߂lFt"
  (interactive "*r")
  (box-fixation-delete-region from to nil))

(defun box-fixation-delete-char (&optional (arg 1))
  "lAw蕶폜B
߂lFt"
  (interactive "*p")
  (box-fixation-delete-region (point)
                              (progn
                                (box-fixation-forward-char arg)
                                (point))))

(defun box-fixation-delete-backward-char (&optional (arg 1))
  "lAw蕶̕폜B
߂lFt"
  (interactive "*p")
  (box-fixation-delete-char (- arg)))

(defun box-fixation-copy-region-as-kill (from to &optional (trim-type :both) add-newline)
  "lA[WLOɒǉ
߂lFt"
  (interactive "r")
  (setq *clipboard-newer-than-kill-ring-p* nil
        *kill-ring-newer-than-clipboard-p* t)
  (let ((text (box-fixation-buffer-substring from to trim-type add-newline)))
    (if (eq *last-command* 'box-fixation-kill-region)
        (kill-append text (> from to))
      (kill-new text)))
  (when (and (interactive-p)
             (null *executing-macro*))
    (message "Region copied"))
  t)

(defun box-fixation-append-next-kill ()
  "LŃAyh悤ɐݒ"
  (interactive)
  (setq *last-command* 'box-fixation-kill-region)
  (setq *this-command* 'box-fixation-kill-region))

(defun box-fixation-kill-region (from to &optional (trim-type :both) add-newline)
  "lA[WLOɒǉA[W폜"
  (interactive "*r")
  (setq *this-command* 'box-fixation-kill-region)
  (box-fixation-copy-region-as-kill from to trim-type add-newline)
  (box-fixation-delete-region from to))

(defun box-fixation-copy-region-to-clipboard (from to &optional (trim-type :both) add-newline)
  "lA[WNbv{[hɃRs["
  (interactive "r")
  (copy-to-clipboard (box-fixation-buffer-substring from to trim-type add-newline)))

(defun box-fixation-kill-region-to-clipboard (from to)
  "lA[WNbv{[hɃRs[A[W폜"
  (interactive "*r")
  (box-fixation-copy-region-to-clipboard from to)
  (box-fixation-delete-region from to))

(defun box-fixation-kill-line ()
  "lAsL"
  (interactive "*")
  (unless (box-fixation-column-p)
    (return-from box-fixation-kill-line (kill-line)))
  (box-fixation-kill-region
   (point)
   (progn (box-fixation-goto-eol) (point))
   (if (box-fixation-right-most-column-p) nil :right)))

(defun box-fixation-string-line (&optional (trim-type :both))
  "̕ԂB
Ԃɂ͍E̋󔒕͊܂܂ȂB"
  (save-excursion
    (if (box-fixation-column-p)
        (box-fixation-buffer-substring
         (progn (box-fixation-goto-bol) (point))
         (progn (box-fixation-goto-eol) (point))
         trim-type)
      "")))

(defun box-fixation-delete-line ()
  "̕폜B
폜AsɈړB
߂lFݕs"
  (when (box-fixation-column-p)
    (box-fixation-delete-region
     (progn (box-fixation-goto-bol) (point))
     (progn (box-fixation-goto-eol) (point)))))

(defun box-fixation-open-line (&optional (arg 1))
  "sɌps}B
F
  ARG          : }s"
  (interactive "*p")
  (save-excursion
    (let (next-column-alist)
      (dolist (x (box-fixation-get-column-alist))
        (cond ((plusp (logand (or (cdr (assoc (cdr x) *box-drawings-chars*)) 0)
                              *box-drawings-s*))
               (push (cons (car x) #\) next-column-alist))
              ((plusp (logand (or (cdr (assoc (cdr x) *box-drawings-chars*)) 0)
                              *box-drawings-ss*))
               (push (cons (car x) #\) next-column-alist))))
      (setq next-column-alist (nreverse next-column-alist))
      (goto-eol)
      (while (plusp arg)
        (decf arg)
        (insert "\n")
        (dolist (x next-column-alist)
          (insert " " (- (car x) (current-column)))
          (insert (cdr x)))))))

(defun box-fixation-insert-1 (string &optional extra-string)
  "݂̍sAJɕ}B
͂ݏo͖߂lŕԂB
F
  STRING       : }
  EXTRA-STRING : }}߂ɉoꂽ

߂lF
  (values <> string extra-string <}I|Cg>)
  <>      :  t Ȃ nil
  STRING            : ŗ^ꂽ string ̂A}łȂ̕
  EXTRA-STRING      : ŗ^ꂽ string }ɂĉoꂽ
  <}I|Cg>: string }I|CgB
                      string }ȂꍇAɑ}Ăꍇ nil"
  (when (or (not (stringp string)) (string= string ""))
    (setq string nil))
  (when (or (not (stringp extra-string)) (string= extra-string ""))
    (setq extra-string nil))
  (when (and (null string) (null extra-string))
    (return-from box-fixation-insert-1 (values t nil nil (point))))
  (save-excursion
    (let ((buffer (selected-buffer))
          (column-alist (box-fixation-get-column-alist))
          (column (current-column)) left-column-element right-column-element
          goto-point limit-column string-length)
      ;; LȗłȂꍇ͏I
      (unless (box-fixation-column-p)
        (return-from box-fixation-insert-1 (values nil string extra-string nil)))
      (multiple-value-setq (left-column-element right-column-element)
        (box-fixation-get-side-column-elements column-alist column))
      ;; EɌrȂΑSđ}ĐI
      (unless right-column-element
        (when string
          (insert string)
          (setq goto-point (point)))
        (when extra-string
          (insert extra-string))
        (return-from box-fixation-insert-1 (values t nil nil goto-point)))
      ;; EɌrꍇ
      ;; ĚrAɌč폜\ȋ󔒂폜
      (setq limit-column (car right-column-element))
      (goto-column limit-column)
      (delete-region (point)
                     (progn
                       (skip-chars-backward " ")
                       (when (< (current-column) column)
                         (goto-column column))
                       (point)))
      (insert "\n")
      (backward-char)
      ;;
      (goto-column column)
      ;; string }
      (when string
        (setq string-length (length string))
        (dotimes (i (1+ string-length) (progn (insert string) (setq string nil)))
          (when (< limit-column (count-column (substring string 0 i) column buffer))
            (insert (substring string 0 (1- i)))
            (setq string (substring string (1- i)))
            (return)))
        (unless string
          (setq goto-point (point))))
      ;; string }ȂꍇAXy[X␳
      (when string
        (insert " " (- limit-column (current-column))))
      (setq column (current-column))
      ;; extra-string Ƃ肠}
      (when extra-string
        (insert extra-string)
        (setq extra-string nil))
      (goto-eol)
      ;; extra-string L^
      (when (< limit-column (current-column))
        (goto-column limit-column)
        (setq extra-string (buffer-substring (point) (progn (goto-eol) (point))))
        (delete-region (point) (progn (goto-column limit-column) (point))))
      ;; Xy[X␳
      (insert " " (- limit-column (current-column)))
      (delete-char)
      (values t string extra-string goto-point))))

(defun box-fixation-insert (string &optional extra-string)
  "}B"
  (let (valid-p goto-point tmp-goto-point column)
    (save-excursion
      (multiple-value-setq (valid-p string extra-string tmp-goto-point)
        (box-fixation-insert-1 string extra-string))
      (unless valid-p
        (insert string)
        (return-from box-fixation-insert nil))
      (when tmp-goto-point
        (setq goto-point tmp-goto-point))
      (while (or string extra-string)
        (unless (setq column (car (box-fixation-get-next-line-destination-columns)))
          (box-fixation-open-line)
          (setq column (car (box-fixation-get-next-line-destination-columns))))
        (next-line)
        (goto-column column)
        (multiple-value-setq (valid-p string extra-string tmp-goto-point)
          (box-fixation-insert-1 string extra-string))
        (when tmp-goto-point
          (setq goto-point tmp-goto-point))))
    (when goto-point
      (goto-char goto-point))))

(defun box-fixation-newline (&optional (arg 1) newline-type)
  "sB
F
  ARG          : s
  NEWLINE-TYPE : :always      ɎsɐVKs}
                 :not-blank   s̗ blank łȂꍇ̂ݎsɐVKs}
                 nil          s̐擪ɘABKvɉĐVKs}
߂lF t"
  (interactive "*p")
  (unless (box-fixation-column-p)
    (return-from box-fixation-newline t))
  (let (extra-string point column)
    (while (plusp arg)
      (decf arg)
      (setq point (point))
      (box-fixation-goto-eol)
      (setq extra-string (box-fixation-buffer-substring
                          point (point)
                          (if (box-fixation-right-most-column-p) nil :right)))
      (box-fixation-delete-region point (point))
      (setq column (car (box-fixation-get-next-line-destination-columns)))
      (when (or (not column)
                (eq newline-type :always)
                (and (eq newline-type :not-blank)
                     (save-excursion
                       (forward-line)
                       (goto-column column)
                       (string/= (box-fixation-string-line) ""))))
        (box-fixation-open-line)
        (setq column (car (box-fixation-get-next-line-destination-columns))))
      (next-line)
      (if column
          (goto-column column)
        (goto-bol))
      (box-fixation-insert nil extra-string)))
  t)

(defun box-fixation-newline-for-always (&optional (arg 1))
  "VKs}AsB
߂lF t"
  (interactive "*p")
  (box-fixation-newline arg :always))

(defun box-fixation-newline-for-not-blank (&optional (arg 1))
  "s̗ blank łȂꍇ̂ݐVKs}AsB
߂lF t"
  (interactive "*p")
  (box-fixation-newline arg :not-blank))

(defun box-fixation-reposition (left right center)
  "̕/E/Z^OB
ӁF
  ^uΉ"
  (unless (box-fixation-column-p)
    (return-from box-fixation-reposition nil))
  (when (box-fixation-right-most-column-p)
    (return-from box-fixation-reposition nil))
  (let ((column (current-column))
        (column-width (box-fixation-get-column-width))
        string string-width diff-width)
    (setq string (box-fixation-string-line))
    (setq string-width (count-column string))
    (setq diff-width (- column-width string-width))
    (box-fixation-delete-line)
    (cond (center
           (forward-char (floor diff-width 2))
           (when (and (plusp diff-width) (oddp diff-width) right)
             (forward-char)))
          (right
           (forward-char diff-width)))
    (box-fixation-insert string)
    (goto-column column)))

(defun box-fixation-reposition-left ()
  "̕񂹂B"
  (interactive "*")
  (box-fixation-reposition t nil nil))

(defun box-fixation-reposition-right ()
  "̕E񂹂B"
  (interactive "*")
  (box-fixation-reposition nil t nil))

(defun box-fixation-reposition-center ()
  "̕Z^OB"
  (interactive "*")
  (box-fixation-reposition nil nil t))

(defun box-fixation-reposition-lcenter ()
  "̕Z^O()B"
  (interactive "*")
  (box-fixation-reposition t nil t))

(defun box-fixation-reposition-rcenter ()
  "̕Z^O(E)B"
  (interactive "*")
  (box-fixation-reposition nil t t))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; }Ci[[h/W[[hp֐
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun box-fixation-column-study ()
  "*pre-command-hook* o^p"
  (when (or box-fixation-minor-mode
            (eq buffer-mode 'box-fixation-mode))
    (setq *box-fixation-target-buffer* (selected-buffer)
          *box-fixation-target-line* (current-line-number)
          *box-fixation-target-modified-count* (buffer-modified-count)
          *box-fixation-column-alist* (box-fixation-get-column-alist))))

(defun box-fixation-column-restore ()
  "*post-command-hook* o^p"
  ;; Y𖞂ȂΏI (1)
  (unless (and
           ;; box-fixation-minor-mode/box-fixation-mode ̃obt@ł
           (or box-fixation-minor-mode
               (eq buffer-mode 'box-fixation-mode))
           ;; R}hOAsɌr݂
           *box-fixation-column-alist*
           ;; R}hOŃobt@
           (eq *box-fixation-target-buffer* (selected-buffer))
           ;; R}hOŕҏWĂ
           (not (eql *box-fixation-target-modified-count* (buffer-modified-count)))
           ;; R}hOōsԍ
           (eql *box-fixation-target-line* (current-line-number))
           ;; R}h undo łȂ
           (not (eq *this-command* 'undo)))
    (setq *box-fixation-column-alist* nil)
    (return-from box-fixation-column-restore))
  (let ((pre-column-alist (copy-alist *box-fixation-column-alist*))
        (post-column-alist (box-fixation-get-column-alist))
        (post-column (current-column))
        (goal-column (goal-column)) (point (point))
        pre-left-column-alist pre-right-column-alist
        post-left-column-alist post-right-column-alist
        pre-left-column-element pre-right-column-element
        post-left-column-element post-right-column-element
        pre-column-width post-column-width diff-column-width
        string extra-string goto-point)
    ;; Y𖞂ȂΏI (2)
    (unless (and
             ;; R}hAJ[\EɌr݂
             (progn
               (multiple-value-setq (post-left-column-element post-right-column-element)
                 (box-fixation-get-side-column-elements post-column-alist post-column))
               post-right-column-element)
             ;; R}hOŌr̎ނ̏o
             (equal (mapcar #'cdr pre-column-alist)
                    (mapcar #'cdr post-column-alist))
             ;; R}hOŃR}hƂJ[\̌ȑoʒuSv
             (progn
               (setq post-left-column-alist
                     (box-fixation-get-left-column-alist post-column-alist post-column)
                     post-right-column-alist
                     (box-fixation-get-right-column-alist post-column-alist post-column))
               (setq pre-left-column-alist
                     (butlast pre-column-alist (length post-right-column-alist))
                     pre-right-column-alist
                     (last pre-column-alist (length post-right-column-alist)))
               (equal (mapcar #'car pre-left-column-alist) (mapcar #'car post-left-column-alist)))
             ;; R}hOŃR}hƂJ[\ĚȑoԊuSv
             (equal (maplist #'(lambda (x) (if (cdr x) (- (cadr x) (car x)) nil))
                             (mapcar #'car pre-right-column-alist))
                    (maplist #'(lambda (x) (if (cdr x) (- (cadr x) (car x)) nil))
                             (mapcar #'car post-right-column-alist)))
             ;; R}hÕJ[\ʒuJ *box-fixation-minimal-column-width* ȏ
             (progn
               (setq pre-left-column-element (car (last pre-left-column-alist))
                     pre-right-column-element (car pre-right-column-alist))
               (setq pre-column-width (box-fixation-get-column-width
                                       pre-left-column-element pre-right-column-element))
               (>= pre-column-width *box-fixation-minimal-column-width*)))
      (return-from box-fixation-column-restore))
    ;; C
    (setq post-column-width (box-fixation-get-column-width
                             post-left-column-element post-right-column-element))
    (setq diff-column-width (- post-column-width pre-column-width))
    (cond
     ;; ςȂꍇ (I)
     ((zerop diff-column-width)
      t)
     ;; ւ񂾏ꍇ (I)
     ((minusp diff-column-width)
      (goto-column (car post-right-column-element))
      (insert " " (- diff-column-width))
      (goto-column post-column)
      (set-goal-column goal-column))
     ;; яoꍇ
     (t
      ;; ݈ʒuR}hỎErȍ~̃J̋󔒂폜
      ;; (󔒂폜JɈړ)
      (delete-region
       (progn (goto-column (car post-right-column-element)) (point))
       (progn
         (skip-chars-backward " ")
         (when (< (point) point)
           (goto-char point))
         (when (< (current-column) (car pre-right-column-element))
           (goto-column (car pre-right-column-element)))
         (point)))
      (if (= (current-column) (car pre-right-column-element))
          ;; 󔒕ŁAяołꍇ (I)
          (progn
            (goto-char point)
            (set-goal-column goal-column))
        ;; 󔒕ŁAяołȂꍇ
        (let ((string-right-point (point)) insert-point)
          (if (< (car pre-right-column-element) post-column)
              ;; ݈ʒuяoĂꍇ
              (progn
                (when (< point string-right-point)
                  (setq extra-string (buffer-substring point string-right-point)))
                (goto-column (car pre-right-column-element))
                (when (< (point) point)
                  (setq string (buffer-substring (point) point))))
            ;; ݈ʒu͔яoĂȂꍇ
            (progn
              (setq goto-point point)
              (goto-column (car pre-right-column-element))
              (setq extra-string (buffer-substring (point) string-right-point))))
          (delete-region (point) string-right-point)
          (setq insert-point (point))
          (insert " " (- (car pre-right-column-element) (current-column)))
          (goto-char insert-point)
          (box-fixation-insert string extra-string)
          (when goto-point
            (goto-char goto-point)
            (set-goal-column goal-column))))))))

(defun box-fixation-minor-mode (&optional (arg nil sv))
  "rŒ肵ҏWp}Ci[[h"
  (interactive "p")
  (toggle-mode 'box-fixation-minor-mode arg sv)
  (update-mode-line t)
  (if box-fixation-minor-mode
      (progn
        (set-minor-mode-map *box-fixation-minor-mode-map*)
        (add-hook '*pre-command-hook* 'box-fixation-column-study)
        (add-hook '*post-command-hook* 'box-fixation-column-restore))
    (progn
      (unset-minor-mode-map *box-fixation-minor-mode-map*)
      (setq *box-fixation-column-alist* nil)
      (dolist (buffer
               (buffer-list)
               (progn
                 (delete-hook '*pre-command-hook* 'box-fixation-column-study)
                 (delete-hook '*post-command-hook* 'box-fixation-column-restore)))
        (when (or (eq (buffer-local-value buffer 'buffer-mode) 'box-fixation-mode)
                  (buffer-local-value buffer 'box-fixation-minor-mode))
          (return))))))
(pushnew '(box-fixation-minor-mode . "BoxFix") *minor-mode-alist* :key #'car)

(defun box-fixation-mode ()
  "rŒ肵ҏWpW[[h"
  (interactive)
  (kill-all-local-variables)
  (setq buffer-mode 'box-fixation-mode)
  (setq mode-name "BoxFix")
  (use-keymap *box-fixation-mode-map*)
  (use-syntax-table *box-fixation-mode-syntax-table*)
  (and *box-fixation-keyword-file*
       (null *box-fixation-keyword-hash-table*)
       (setq *box-fixation-keyword-hash-table*
             (load-keyword-file *box-fixation-keyword-file* t)))
  (when *box-fixation-keyword-hash-table*
    (make-local-variable 'keyword-hash-table)
    (setq keyword-hash-table *box-fixation-keyword-hash-table*))
  (make-local-variable 'regexp-keyword-list)
  (setq regexp-keyword-list *box-fixation-regexp-keyword-list*)
  (setq *local-abbrev-table* *box-fixation-mode-abbrev-table*)
  (add-hook '*pre-command-hook* 'box-fixation-column-study)
  (add-hook '*post-command-hook* 'box-fixation-column-restore)
  (run-hooks '*box-fixation-mode-hook*))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; j[֐
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun box-fixation-insert-menu-items (&key menu pre-tag position head-sep tail-sep)
  "box-fixation-minor-mode j[ɒǉ"
  (if (and (not (menup menu)) (menup *app-menu*))
      (setq menu (get-menu *app-menu* 'ed::tools)))
  (when (menup menu)
    (box-fixation-delete-menu menu)
    (unless (or pre-tag position)
      (setq pre-tag 'ed::box-drawings-toggle-line-type))
    (when (and pre-tag
               (setq position (get-menu-position menu pre-tag)))
      (incf position))
    (unless (and (numberp position) (integerp position) (not (minusp position))
                 (get-menu menu position t))
      (setq position -1)
      (while (get-menu menu (incf position) t)))
    (decf position)
    (if (and head-sep
             (not (minusp position))
             (get-menu menu position t))
        (insert-menu-separator menu (incf position) 'box-fixation-mode-sep))
    (insert-menu-item menu (incf position) 'box-fixation-minor-mode
                      "rҏW[h(&H)"
                      'box-fixation-minor-mode
                      #'(lambda () (and box-fixation-minor-mode :check)))
    (if (and tail-sep
             (get-menu menu (incf position) t))
        (insert-menu-separator menu position 'box-fixation-mode-sep))))

(defun box-fixation-delete-menu (&optional menu)
  "box-fixation-minor-mode j[폜"
  (if (and (not (menup menu)) (menup *app-menu*))
      (setq menu (get-menu *app-menu* 'ed::file)))
  (when (menup menu)
    (while (delete-menu menu 'box-fixation-minor-mode))
    (while (delete-menu menu 'box-fixation-mode-sep))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; c[o[֐
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun tool-bar-update-box-fixation-minor-mode ()
  (and box-fixation-minor-mode :check))

(defun tool-bar-update-box-drawings-mode ()
  (and *box-drawings-mode* :check))

(defun tool-bar-update-box-drawings-thick-line ()
  (values (unless *box-drawings-mode*
            :disable)
          (if (eq *box-drawings-line-type* '*box-drawings-thick-line*)
              :check)))

(defun box-fixation-tool-bar ()
  (create-tool-bar
   'box-fixation-tool-bar
   (merge-pathnames "toolbar-box-fixation.bmp" (etc-path))
   '(("r[h" 0 box-drawings-mode tool-bar-update-box-drawings-mode)
     ("r" 1 box-drawings-toggle-line-type tool-bar-update-box-drawings-thick-line)
     ("rҏW[h" 2 box-fixation-minor-mode tool-bar-update-box-fixation-minor-mode))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ACXg[
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun box-fixation-mode-uninstall ()
  (delete-command-bar 'box-fixation-tool-bar)
  (box-fixation-delete-menu))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Ǎݎݒ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-command-bar 'box-fixation-tool-bar "rҏW(&H)")
(if (menup ed::*app-menu*)
    (box-fixation-insert-menu-items)
  (add-hook 'ed::*init-app-menus-hook*
            #'(lambda () (box-fixation-insert-menu-items))))

;;; box-fixation-mode.l ends here
