; -*- Mode: Lisp; Package: editor -*-

#|
= banner - 傫ȕŕo͂

* Author:  miyamuko ((<URL:mailto:miyamuko (at) mtb.biglobe.ne.jp>))
* URL: ((<URL:http://miyamuko.s56.xrea.com/xyzzy/banner.html>))
* Version: $Id: banner.l,v 1.7 2004/08/09 14:02:59 miyamuko Exp $


== 

Unix ɂ banner R}ḧڐAłB

BDF tHgΓ{ꂾ낤 AA 낤ɂł܂B


== CXg[

((<NetInstaller|URL:http://www.mirai.ne.jp/~gyo/xyzzy/ni.html>)) ŃCXg[ꍇ 3 ȍ~A
NetInstaller + (({ni-autoload})) gĂl 4 ȍ~ OK łB

(1) A[JCu_E[h܂B

    ((<URL:http://miyamuko.s56.xrea.com/xyzzy/archives/banner.zip>))

(2) A[JCuWJāA$XYZZY/site-lisp zɃt@CRs[܂B

(3) ~/.xyzzy ܂ $XYZZY/site-lisp/siteinit.l Ɉȉ̃R[hǉ܂B

        ;; banner
        (require "banner")

(4) ݒ𔽉f邽 xyzzy ċNĂB

    siteinit.l ɋLqꍇɂ͍ă_vKvłB

(5) BDF tHgȂɂCXg[܂B

(6) BDF tHgɂ킹 ((<*banner-bdf-font-selecter*>)) ݒ肵܂B

(7) 剻[Wɂ M-x banner-region ܂
    M-x banner Ń~jobt@͂ĂB


== t@X

=== R}h

--- (banner str)

    w肳ꂽ傫 ((<*banner-output-buffer-name*>)) 
    o͂܂B

--- (banner-region start end)

    w肳ꂽ[W̕傫 ((<*banner-output-buffer-name*>)) 
    o͂܂B


=== ֐

--- (ed::banner-internal str &optional formatter)

    w肳ꂽ傫 ((<*banner-output-buffer-name*>)) 
    o͂܂B

    ȗ\ȑ2ɂ͈ȉ̏o͊֐w肵܂B
    ftHg (({ed::banner-output-horizontally})) łB

--- (ed::banner-output-vertically glyphs)

    c banner o͂܂B
    (({ed::banner-internal})) ̈Ɏw肵܂B

--- (ed::banner-output-horizontally glyphs)

     banner o͂܂B
    (({ed::banner-internal})) ̈Ɏw肵܂B


=== ϐ

--- *bdf-directory-list*

    BDF tHguĂfBNgw肵܂B
    ftHg $XYZZY/fonts/bdf łB

        ;; Meadow  font directory ǉ
        (pushnew "D:/Tools/Meadow/fonts/bdf" *bdf-directory-list*)

--- *banner-output-buffer-name*

    o̓obt@̖OĂ܂B

--- *banner-font-fg-char*
--- *banner-font-bg-char*

    ꂼtHg`镶Ɣwiݒ肵܂B

        ;; lpŃCAEg
        (setf *banner-font-fg-char* "")
        (setf *banner-font-bg-char* "")

    Ȃ

        
        
        
        
        
        
        
        
        
        
        
        

--- *banner-bdf-font-selecter*

    镶ɑΉ BDF tHg̃t@CԂ
    ֐ݒ肵܂B

    ((*̕ϐ͕Kݒ肵ĂB*))

        ;; monafont 𗘗p
        (setf *banner-bdf-font-selecter*
              #'(lambda (c)
                  (cond ((kanji-char-p c)
                         ; AЂ炪ȁAJ^Ji
                         "monak12.bdf")
                        ((kana-char-p c)
                         ; 锼pJi
                         "mona6x12r.bdf")
                        (t
                         ; ̑
                         "mona6x12a.bdf"))))

        ;; K12 𗘗p
        (setf *banner-bdf-font-selecter*
              #'(lambda (c)
                  (cond ((kanji-char-p c)
                         ; AЂ炪ȁAJ^Ji
                         "k12x10.bdf")
                        (t
                         ; ̑
                         "k6x10.bdf"))))

    tHg낱ςꍇ̓LbVقłB

        ; LbV
        (setf ed::*bdf-glyph-cache* nil)


== ꂩ邩Ȃ

* BDF tHg encoding ƌ悤ɂB
  *  sjis ߑłCB
* TrueType tHgg悤ɂ ()B
  * Win32 API ΂Ă΂ł邩Ȃ...?
* ttf2bdf ŕϊ bdf tHgg悤ɂB
  * ނsLB
* tHg̐ݒ܂ƂɂB


== ֘A邩Ȃy[W

: BDFt@CtH[}bg
    ((<URL:http://hp.vector.co.jp/authors/VA013241/font/bdf.html>))

: i[tHg
    ((<URL:http://monafont.sourceforge.net/>))

: (X11 𒆐SƂ)t[̓{rbg}bvtHgꗗ
    ((<URL:http://kappa.allnet.ne.jp/kanou/fonts/x11bdfs.html>))


== CZX

banner ͏C BSD CZXɊÂėp\łB

  Copyright (C) 2003-2004 MIYAMUKO Katsuyuki. All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

  1 Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer as the first lines
  of this file unmodified.

  2 Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.
|#

(provide "banner")
(in-package "editor")

(export '(*bdf-directory-list*
          *banner-output-buffer-name*
          *banner-font-fg-char*
          *banner-font-bg-char*
          *banner-bdf-font-selecter*
          banner
          banner-vertically
          banner-region
          banner-region-vertically))

;; ----------------------------------------------------------------------
;; variables

(defvar *bdf-directory-list*
  (list (merge-pathnames "fonts/bdf" (si::system-root))))
(defvar *banner-output-buffer-name* "*banner*")
(defvar *banner-font-fg-char* "##")
(defvar *banner-font-bg-char* "  ")
(defvar *banner-bdf-font-selecter* nil)


;; ----------------------------------------------------------------------
;; commands

(defun banner (str &optional fold-width)
  "banner: w肳ꂽ banner  ()"
  (interactive "sBanner: \np")
  (banner-internal str fold-width))

(defun banner-vertically (str)
  "banner: w肳ꂽ banner  (c)"
  (interactive "sBanner: ")
  (banner str 1))

(defun banner-region (start end &optional fold-width)
  "banner: w肳ꂽ[W̕ banner  ()"
  (interactive "r\np")
  (if (< end start) (rotatef start end))
  (banner-internal (buffer-substring start end) fold-width))

(defun banner-region-vertically (start end)
  "banner: w肳ꂽ[W̕ banner  (c)"
  (interactive "r")
  (banner-region start end 1))

;; ----------------------------------------------------------------------
;; functions

(defmacro dolist-with-progress-message ((msg var listform &optional (resultform ''nil)) &body body)
  `(let ((len (length ,listform))
         (current 0))
     (do* ((#1=#:tailvar ,listform (cdr #1#))
           (,var (car #1#) (car #1#)))
         ((null #1#) ,resultform)
       (incf current)
       (message ,msg (floor (* (/ current len) 100)))
       ,@body)))

(defun banner-internal (str fold-width)
  "banner: w肳ꂽ banner "
  (unless *banner-bdf-font-selecter*
    (error "*banner-bdf-font-selecter* ݒ肵Ă"))
  (long-operation
    (with-output-to-temp-buffer (*banner-output-buffer-name*)
      (dolist-with-progress-message
       ("~D %" line (split-string str #\LFD))
       (do-events)
       (banner-output (map 'list 'bdf-get-glyph line) fold-width))))
  (switch-to-buffer *banner-output-buffer-name*))

(defun banner-output (glyphs &optional fold-width)
  "banner: tHgo͂"
  (let ((p 0)
        (glyph-len (length glyphs)))
    (unless fold-width
      (setf fold-width glyph-len))
    (while (< p glyph-len)
      (apply #'mapcar #'(lambda (&rest line)
                          (format t "~{~A~}" line)
                          (terpri))
             (subseq glyphs p (min glyph-len (+ p fold-width))))
      (incf p fold-width))))

(defun banner-dispose ()
  (interactive)
  (setf *bdf-glyph-cache* nil)
  (bdf-kill-all-buffers))

;;

(defvar *bdf-glyph-cache* nil
  "banner: ǂݍ񂾃tHg̃LbV")

(defun bdf-get-glyph (c)
  "banner: LbVɂ΂̃tHgԂ"
  (let ((jis-code (char-jis-code c)))
    (unless *bdf-glyph-cache*
      (setf *bdf-glyph-cache* (make-hash-table)))
    (unless (gethash jis-code *bdf-glyph-cache*)
      (setf (gethash jis-code *bdf-glyph-cache*)
            (bdf-get-glyph-internal
             (bdf-find-file (funcall *banner-bdf-font-selecter* c))
             jis-code)))
    (gethash jis-code *bdf-glyph-cache*)))

(defun bdf-get-glyph-internal (bdfbuffer jis-code)
  "banner: BDF t@C͂ătHg擾"
  (let ((width nil)
        (result))
    ;; setup buffer
    (set-buffer bdfbuffer)
    (goto-char (point-min))

    ;; scan glyph
    (unless (scan-buffer (format nil "^ENCODING ~D\\>" jis-code) :regexp t)
      ;; use DEFAULT_CHAR if not found.
      (if (scan-buffer "^DEFAULT_CHAR \\([0-9]+\\)\\>" :regexp t)
          (return-from bdf-get-glyph-internal
            (bdf-get-glyph bdfbuffer
                           (code-char (parse-integer (match-string 1)))))
        nil))

    ;; clipping
    (save-restriction
      (narrow-to-region (point)
                        (progn
                          (scan-buffer "^ENDCHAR\\>" :regexp t :tail t)
                          (point)))
      (goto-char (point-min))

      ;; get width
      (scan-buffer (format nil "^DWIDTH +\\([0-9]+\\) +[0-9]+" jis-code)
                   :regexp t :tail t)
      (setf width (parse-integer (match-string 1)))

      ;; get glyph info
      (scan-buffer "^BITMAP\\>" :regexp t)
      (while (and (forward-line 1)
                  (not (looking-at "^ENDCHAR\\>")))
        (push (bdf-expand-glyph width
                                (buffer-substring (progn (goto-bol) (point))
                                                  (progn (goto-eol) (point))))
              result))
      (reverse result))))

(defun bdf-expand-glyph (width hex)
  "banner: BDF Font ̏WJ"
  (substitute-string
   (substitute-string
    (substring (format nil "~V,'0B" width (hex-to-int hex))
               0 width)
    "1" *banner-font-fg-char*)
   "0" *banner-font-bg-char*))

(defvar *bdf-find-file-buffers* nil
  "banner: open  BDF font  buffer")

(defun bdf-find-file (bdfname)
  "banner: w肳ꂽ BDF font  font path T buffer ɓǂݍށB
argument: tHg
return: tHgǂݍ buffer"
  (let ((bufname (concat " " bdfname)))
    (if (find-buffer bufname)
        (return-from bdf-find-file (find-buffer bufname)))
    (dolist (dir *bdf-directory-list*)
      (when (file-exist-p (merge-pathnames bdfname dir))
        (let ((buffer (get-buffer-create bufname)))
          (set-buffer buffer)
          (insert-file (merge-pathnames bdfname dir))
          (push buffer *bdf-find-file-buffers*) ;cache
          (return-from bdf-find-file buffer))))
    (error "BDF Font Ȃł" bdfname)))

(defun bdf-kill-all-buffers ()
  "banner: ǂݍ BDF font ׂč폜B"
  (dolist (buffer *bdf-find-file-buffers*)
    (if (member buffer (buffer-list))
        (delete-buffer buffer)))
  (setf *bdf-find-file-buffers* nil))

;; ----------------------------------------------------------------------
;; util

(defun char-jis-code (c)
  "banner:  JIS R[hɕϊ"
  (if (kanji-char-p c)
      (let ((jis (map-internal-to-jis (string c))))
        (logior (ash (char-code (char jis 3)) 8)
                (char-code (char jis 4))))
    (char-code c)))

(defun hex-to-int (hex)
  "banner: 16i 10 ilɂ"
  (let ((result 0)
        (digits (map 'list
                     #'(lambda (c)
                         (cond ((char<= #\0 c #\9)
                                (- (char-code c) (char-code #\0)))
                               ((char<= #\a (char-downcase c) #\f)
                                (+ 10 (- (char-code (char-downcase c))
                                         (char-code #\a))))))
                     hex)))
    (dolist (d digits)
      (if d (setf result (+ (ash result 4) d))))
    result))

;;
;; $Id: banner.l,v 1.7 2004/08/09 14:02:59 miyamuko Exp $
;;
