; $Id: popup.l 3 2003-01-25 20:35:51Z torihat $

(eval-when (:compile-toplevel :load-toplevel :execute)
  (require "2ch/macro"))

(provide "2ch/popup")

(in-package "2ch")

(defvar *popup-menu-list*
  '((2ch-menu popup-buffer-menu nil)
    (2ch-board popup-buffer-board nil)
    (2ch-search popup-buffer-search nil)
    (2ch-tracking popup-buffer-tracking nil)
    (2ch-thread popup-buffer-thread nil)
    (2ch-view popup-buffer-view nil)
    (2ch-grep popup-buffer-grep nil)
    (2ch-bookmark popup-buffer-bookmark nil)
    (2ch-history popup-buffer-history nil)
    (2ch-form popup-buffer-form nil)
    (2ch-form-new popup-buffer-form-new nil)
    (2ch-http popup-buffer-http nil)))

(defun 2ch-mouse-right-press ()
  (interactive)
  (set-window *last-mouse-window*)
  (continue-pre-selection)
  (goto-last-mouse-point)
  ;(refresh-screen)
  (popup-menu-popup))

(defun thread-popup ()
  (interactive)
  (set-window *last-mouse-window*)
  (continue-pre-selection)
  (goto-last-mouse-point)
  (refresh-screen)
  (let ((menu (thread-popup-menu)))
    (when menu
      (track-popup-menu menu))))

(defun thread-popup-menu ()
  (let* ((attr (multiple-value-list (find-text-attribute-point (point))))
	 (number (thread-current-number))
	 (type (attr-tag attr))
	 (menu (popup-menu))
	 pos)
    (unless menu
      (return-from thread-popup-menu))
    (while (delete-menu menu 'thread-history))
    (while (delete-menu menu 'thread-aborn))
    (while (delete-menu menu 'thread-attr))
    (while (delete-menu menu 'thread-link))
    (while (delete-menu menu 'thread-anchor))
    (setq pos (get-menu-position menu 'thread-update))
    (unless pos
      (return-from thread-popup-menu menu))
    (when *thread-history*
      (insert-menu-item menu pos 'thread-history
			"߂"
			'thread-history-back)
      (incf pos)
      (insert-menu-separator menu pos 'thread-history)
      (incf pos))
    (when number
      (let ((aborn-p (thread-aborn-p number)))
	(insert-menu-item menu pos 'thread-aborn
			  "ځ["
			  'thread-aborn-add
			  #'(lambda () (and aborn-p :disable)))
	(incf pos)
	(insert-menu-item menu pos 'thread-aborn
			  "ځ["
			  'thread-aborn-del
			  #'(lambda () (or aborn-p :disable)))
	(incf pos)
	(insert-menu-separator menu pos 'thread-attr)
	(incf pos)))
    (cond ((eq type 'anchor)
	   (insert-popup-menu menu pos (popup-menu-anchor) "ԍ̔")
	   (insert-menu-separator menu (1+ pos) 'thread-attr))
	  ((eq type 'link)
	   (insert-popup-menu menu pos (popup-menu-link) "URL")
	   (insert-menu-separator menu (1+ pos) 'thread-attr))
    )
    menu))

(defun popup-menu-anchor ()
  (let ((menu (create-popup-menu 'thread-anchor)))
    (add-menu-item menu nil "փWv"
		   'thread-jump)
    (add-menu-item menu nil "|bvAbv"
		   'thread-anchor-popup)
    (add-menu-item menu nil "_CAO\"
		   'thread-anchor-popup-msgbox)
    menu))

(defun popup-menu-link ()
  (let ((menu (create-popup-menu 'thread-link)))
    (add-menu-item menu nil "J"
		   'thread-jump)
    (add-menu-item menu nil "uEUŊJ"
		   'thread-jump-in-browser)
    (add-menu-item menu nil "Rs["
		   'thread-link-copy)
    menu))

(defun popup-menu-popup ()
  (let ((menu (popup-menu)))
    (unless menu
      (return-from popup-menu-popup))
    (track-popup-menu menu)))

(defun popup-menu (&optional force)
  (let ((menu (popup-menu-menu (popup-menu-list buffer-mode)))
	func)
    (when (or force
	      (not menu))
      (when (setq func (popup-menu-func (popup-menu-list buffer-mode)))
	(setq menu (funcall func))
	(setf (popup-menu-menu (popup-menu-list buffer-mode)) menu)))
    (or menu *app-popup-menu*)))

(defun popup-menu-add (menu)
  (add-menu-separator menu nil)
  (add-popup-menu menu *app-popup-menu* "̑")
  (add-menu-separator menu nil)
  (add-popup-menu menu (popup-menu-bookmark) "ubN}[N")
  (add-popup-menu menu (popup-menu-history) "")
  (add-menu-separator menu nil)
  (add-menu-item menu nil
		 "...ɂ"
		 'version)
  (add-menu-item menu nil "2chgbvy[W"
		 'open-browser-index)
  (add-menu-separator menu nil)
  (add-menu-item menu nil "XN[Abv"
		 'thread-clean-dat)
  (add-menu-item menu nil "IC[h"
		 'toggle-online
		 #'(lambda () (when *online* :check)))
  (add-menu-item menu nil "I"
		 'exit)
  menu)

(defun popup-menu-bookmark ()
  (let ((menu (create-popup-menu '2ch-bookmark)))
    (add-menu-item menu nil "J"
		   'bookmark-open
		   #'(lambda () (unless *bookmark-list* :disable)))
    (add-menu-separator menu nil)
    (add-menu-item menu nil "i"
		   'bookmark-next
		   #'(lambda () (unless *bookmark-list* :disable)))
    (add-menu-item menu nil "߂"
		   'bookmark-previous
		   #'(lambda () (unless *bookmark-list* :disable)))
    menu))

(defun popup-menu-history ()
  (let ((menu (create-popup-menu '2ch-history)))
    (add-menu-item menu nil "J"
		   'history-open
		   #'(lambda () (unless (or *history-back* *history-forward*) :disable)))
    (add-menu-separator menu nil)
    (add-menu-item menu nil "i"
		   'history-next
		   #'(lambda () (unless *history-forward* :disable)))
    (add-menu-item menu nil "߂"
		   'history-previous
		   #'(lambda () (unless *history-back* :disable)))
    menu))

(defun popup-buffer-menu ()
  (let ((menu (create-popup-menu '2ch-menu)))
    (add-menu-item menu nil "I"
		   'menu-select)
    (add-menu-item menu nil "JeS֖߂"
		   'menu-back-category)
    (add-menu-item menu nil "JeSJ"
		   'menu-category-open)
    (add-menu-item menu nil "JeS"
		   'menu-category-close)
    (add-menu-item menu nil "XgXV"
		   'menu-update)
    (add-menu-item menu nil "XgēǍ"
		   'menu-reload)
    (add-menu-separator menu nil)
    (add-menu-item menu nil (format nil "~AO[vXV" *tracking-name*)
		   'menu-tracking-update)
    (add-menu-item menu nil (format nil "~AXV" *tracking-name*)
		   'tracking-update-full)
    (add-menu-item menu nil "XVꂽXꗗ\"
		   'tracking-show-updated
		   #'(lambda () (unless *tracking-uplist* :disable)))
    (add-menu-item menu nil "̍XVꂽXJ"
		   'menu-tracking-uplist-next
		   #'(lambda () (unless *tracking-uplist* :disable)))
    (add-menu-separator menu nil)
    (add-menu-item menu nil (format nil "~ÃO[vǉ" *tracking-name*)
		   'menu-tracking-add)
    (add-menu-item menu nil (format nil "~Aɔǉ" *favorits-name*)
		   'menu-favorits-add)
    (add-menu-item menu nil (format nil "~AURLǉ" *favorits-name*)
		   'favorits-add-from-url)
    (add-menu-item menu nil (format nil "O[v폜")
		   'menu-del)
    (add-menu-item menu nil (format nil "~A̔؂" *favorits-name*)
		   'menu-cut)
    (add-menu-item menu nil (format nil "~Aɔ\t" *favorits-name*)
		   'menu-paste)
    (add-menu-separator menu nil)
    (add-menu-item menu nil (format nil "~ÃXꗗXV" *favorits-name*)
		   'favorits-update)
    (add-menu-item menu nil "JeS̃XꗗXV"
		   'menu-category-board-update)
    (add-menu-item menu nil "S̃XꗗXV"
		   'menu-category-board-update-all)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "JeSSĊJ"
		   'menu-category-open-all)
    (add-menu-item menu nil "JeSSĕ"
		   'menu-category-close-all)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "uEUŊJ"
		   'menu-board-open-browser)
    (add-menu-item menu nil "URLRs["
		   'menu-board-url-copy)
    (add-menu-item menu nil "Rs["
		   'menu-board-name-copy)
    (add-menu-item menu nil "URLRs["
		   'menu-board-url-name-copy)
    (add-menu-item menu nil "̔ɂ..."
		   'menu-board-rule)
    (add-menu-separator menu nil)
    (add-popup-menu menu (popup-buffer-menu-search) "X^Cg")
    (setq menu (popup-menu-add menu))
    menu))

(defun popup-buffer-menu-search ()
  (let ((menu (create-popup-menu '2ch-menu-search)))
    (add-menu-item menu nil "S"
		   'menu-all-search)
    (add-menu-item menu nil "S+XV"
		   'menu-all-search-reload)
    (add-menu-item menu nil "S+擾"
		   'menu-all-search-force)
    (add-menu-item menu nil "S+擾+XV"
		   'menu-all-search-force-reload)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "JeS"
		   'menu-category-search)
    (add-menu-item menu nil "JeS+XV"
		   'menu-category-search-reload)
    (add-menu-item menu nil "JeS+擾"
		   'menu-category-search-force)
    (add-menu-item menu nil "JeS+擾+XV"
		   'menu-category-search-force-reload)
    (add-menu-separator menu nil)
    (add-menu-item menu nil ""
		   'menu-board-search)
    menu))

(defun popup-buffer-board ()
  (let ((menu (create-popup-menu '2ch-menu-board)))
    (add-menu-item menu nil "XJ"
		   'board-select)
    (add-menu-item menu nil "XJ(w)"
		   'board-select-lines)
    (add-menu-item menu nil (format nil "X~Aɒǉ" *tracking-name*)
		   'board-tracking-add-dialog)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "uEUŊJ"
		   'board-open-browser)
    (add-menu-item menu nil "URLRs["
		   'board-url-copy)
    (add-menu-item menu nil "Rs["
		   'board-name-copy)
    (add-menu-item menu nil "URLRs["
		   'board-url-name-copy)
    (add-menu-item menu nil "̔ɂ..."
		   'board-rule)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "XuEUŊJ"
		   'tracking-thread-open-browser)
    (add-menu-item menu nil "XURLRs["
		   'tracking-thread-url-copy)
    (add-menu-item menu nil "X^CgRs["
		   'tracking-thread-title-copy)
    (add-menu-item menu nil "X^CgURLRs["
		   'tracking-thread-url-title-copy)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "XꗗXV"
		   'board-update)
    (add-menu-item menu nil "Xꗗēǂݍ"
		   'board-reload)
;    (add-menu-separator menu nil)
;    (add-menu-item menu nil "VXĂ"
;		   'board-form)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "Xf[^폜"
		   'tracking-thread-delete-dat)
    (add-menu-item menu nil "Xf[^폜iSj"
		   'tracking-thread-delete-dat-tbk)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "X^Cg..."
		   'board-search)
    (add-menu-item menu nil "..."
		   'board-grep-dialog)
    (add-menu-item menu nil "Xꗗ"
		   'board-show-read-dat)
    (add-menu-item menu nil "XꗗiߋOj"
		   'board-show-read-dat-kako)
    (add-menu-item menu nil "..Ԃ̐VXꗗ"
		   'board-new-show)
    (add-menu-separator menu nil)
    (add-popup-menu menu (popup-menu-mark-set) "}[Nt")
    (add-popup-menu menu (popup-menu-mark-unset) "}[NO")
    (add-popup-menu menu (popup-menu-mark-cmd-search) "}[NX")
    (add-menu-separator menu nil)
    (add-menu-item menu nil ""
		   'board-close)
    (popup-menu-add menu)))

(defun popup-buffer-tracking ()
  (let ((menu (create-popup-menu '2ch-menu-tracking)))
    (add-menu-item menu nil "XJ"
		   'tracking-select)
    (add-menu-item menu nil "̍XVXJ"
		   'tracking-next-updated)
    (add-menu-item menu nil "̔ŃXJ"
		   'tracking-open-in-board)
    (add-menu-item menu nil "X폜"
		   'tracking-del)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "XuEUŊJ"
		   'tracking-thread-open-browser)
    (add-menu-item menu nil "XURLRs["
		   'tracking-thread-url-copy)
    (add-menu-item menu nil "X^CgRs["
		   'tracking-thread-title-copy)
    (add-menu-item menu nil "X^CgURLRs["
		   'tracking-thread-url-title-copy)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "XꗗXV"
		   'tracking-reload)
    (add-menu-item menu nil "̃XXV"
		   'tracking-update-current)
    (add-menu-item menu nil "XSčXV"
		   'tracking-update-all)
    (add-menu-item menu nil "Xёւ"
		   'tracking-sort-dialog)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "XߋOɂ"
		   'tracking-change-kako)
    (add-menu-item menu nil "Xʏ탍Oɂ"
		   'tracking-change-dat)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "X؂"
		   'tracking-cut)
    (add-menu-item menu nil "XRs["
		   'tracking-copy)
    (add-menu-item menu nil "X\t"
		   'tracking-paste)
    (add-menu-separator menu nil)
    (add-popup-menu menu (popup-menu-mark-set) "}[Nt")
    (add-popup-menu menu (popup-menu-mark-unset) "}[NO")
    (add-popup-menu menu (popup-menu-mark-cmd) "}[NX")
    (add-menu-separator menu nil)
    (add-menu-item menu nil "Xf[^폜"
		   'tracking-thread-delete-dat)
    (add-menu-item menu nil "Xf[^폜iSj"
		   'tracking-thread-delete-dat-tbk)
    (add-menu-separator menu nil)
    (add-menu-item menu nil ""
		   'tracking-quit)
    (popup-menu-add menu)))

(defun popup-menu-mark-set ()
  (let ((menu (create-popup-menu '2ch-menu-mark-set)))
    (add-menu-item menu nil ""
		   'tracking-mark-set)
    (add-menu-item menu nil "S"
		   'tracking-mark-set-all)
    (add-menu-item menu nil "]"
		   'tracking-mark-set-reverse)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "ߋO"
		   'tracking-mark-set-kako)
    (add-menu-item menu nil "ǂX"
		   'tracking-mark-set-tracking)
    (add-menu-item menu nil "ǂXȊO"
		   'tracking-mark-set-tracking-reverse)
    (add-menu-item menu nil "XVȂX..."
		   'tracking-mark-set-old)
    (add-menu-item menu nil "JĂȂX..."
		   'tracking-mark-set-nouse)
    (add-menu-item menu nil "K\..."
		   'tracking-mark-set-query)
    menu))

(defun popup-menu-mark-unset ()
  (let ((menu (create-popup-menu '2ch-menu-mark-unset)))
    (add-menu-item menu nil ""
		   'tracking-mark-unset
		   #'(lambda () (unless board-mark :disable)))
    (add-menu-item menu nil "S"
		   'tracking-mark-unset-all
		   #'(lambda () (unless board-mark :disable)))
    menu))

(defun popup-menu-mark-cmd ()
  (let ((menu (create-popup-menu '2ch-menu-cmd)))
    (add-menu-item menu nil "ꗗ폜"
		   'tracking-del-marked
		   #'(lambda () (unless board-mark :disable)))
    (add-menu-item menu nil "؂"
		   'tracking-cut-marked
		   #'(lambda () (unless board-mark :disable)))
    (add-menu-item menu nil "Rs["
		   'tracking-copy-marked
		   #'(lambda () (unless board-mark :disable)))
    (add-menu-item menu nil "..."
		   'tracking-send-marked-dialog
		   #'(lambda () (unless board-mark :disable)))
    (add-menu-item menu nil "XV"
		   'tracking-update-marked
		   #'(lambda () (unless board-mark :disable)))
    (add-menu-item menu nil "Xf[^폜"
		   'tracking-thread-delete-marked-dat
		   #'(lambda () (unless board-mark :disable)))
    (add-menu-item menu nil "Xf[^폜iSj"
		   'tracking-thread-delete-marked-dat-tbk
		   #'(lambda () (unless board-mark :disable)))
    menu))

(defun popup-menu-mark-cmd-search ()
  (let ((menu (create-popup-menu '2ch-menu-cmd)))
    (add-menu-item menu nil "Rs["
		   'tracking-copy-marked
		   #'(lambda () (unless board-mark :disable)))
    (add-menu-item menu nil "..."
		   'search-send-marked-dialog
		   #'(lambda () (unless board-mark :disable)))
    (add-menu-item menu nil "Xf[^폜"
		   'tracking-thread-delete-marked-dat
		   #'(lambda () (unless board-mark :disable)))
    (add-menu-item menu nil "Xf[^폜iSj"
		   'tracking-thread-delete-marked-dat-tbk
		   #'(lambda () (unless board-mark :disable)))
    menu))

(defun popup-buffer-search ()
  (let ((menu (create-popup-menu '2ch-menu-search)))
    (add-menu-item menu nil "XJ"
		   'search-select)
    (add-menu-item menu nil "XJ(w)"
		   'search-select-lines)
    (add-menu-item menu nil (format nil "X~Aɒǉ" *tracking-name*)
		   'board-tracking-add-dialog)
    (add-menu-item menu nil (format nil "ꗗ~AƂĕۑ" *tracking-name*)
		   'search-save-as-tracking)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "XuEUŊJ"
		   'tracking-thread-open-browser)
    (add-menu-item menu nil "XURLRs["
		   'tracking-thread-url-copy)
    (add-menu-item menu nil "X^CgRs["
		   'tracking-thread-title-copy)
    (add-menu-item menu nil "X^CgURLRs["
		   'tracking-thread-url-title-copy)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "Xf[^폜"
		   'tracking-thread-delete-dat)
    (add-menu-item menu nil "Xf[^폜iSj"
		   'tracking-thread-delete-dat-tbk)
    (add-menu-separator menu nil)
    (add-popup-menu menu (popup-menu-mark-set) "}[Nt")
    (add-popup-menu menu (popup-menu-mark-unset) "}[NO")
    (add-popup-menu menu (popup-menu-mark-cmd-search) "}[NX")
    (add-menu-separator menu nil)
    (add-menu-item menu nil ""
		   'board-close)
    (popup-menu-add menu)))

(defun popup-buffer-thread ()
  (let ((menu (create-popup-menu '2ch-menu-thread)))
    (add-menu-item menu 'thread-update "XXV"
		   'thread-update)
    (add-menu-item menu nil "Xēǂݍ"
		   'thread-reload)
    (add-menu-separator menu nil)
    (add-popup-menu menu (popup-thread-move) "ړ")
    (add-menu-separator menu nil)
    (add-menu-item menu nil "L_CAOŊJ"
		   'thread-view-current)
    (add-menu-item menu nil "L_CAOŊJ(͈͎w)"
		   'thread-view-range)
    (add-menu-item menu nil "LuEUŊJ"
		   'thread-view-current-in-browser)
    (add-menu-item menu nil "LuEUŊJ(͈͎w)"
		   'thread-view-range-in-browser)
    (add-menu-separator menu nil)
    (add-menu-item menu nil ""
		   'thread-form)
    (add-menu-item menu nil "ԐM"
		   'thread-reply)
    (add-menu-item menu nil "܂Ƃ߂ĕԐM"
		   'thread-reply-range)
    (add-menu-item menu nil "݂\"
		   'view-show)
    (add-menu-separator menu nil)
    (add-menu-item menu nil (format nil "X~Aɒǉ" *tracking-name*)
		   'thread-tracking-add-dialog)
    (add-menu-item menu nil "XURLRs["
		   'thread-url-copy)
    (add-menu-item menu nil "X^CgRs["
		   'thread-title-copy)
    (add-menu-item menu nil "X^CgURLRs["
		   'thread-url-title-copy)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "XuEUŊJ"
		   'thread-open-browser)
    (add-menu-item menu nil "XURLŎw"
		   'thread-open-2ch-url)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "|bvAbv[h"
		   'thread-popup-mode
		   #'(lambda () (when *thread-popup-mode* :check)))
    (add-menu-item menu nil "̔ɂ..."
		   'thread-board-rule)
    (add-menu-item menu nil ""
		   'thread-quit)
    (popup-menu-add menu)))

(defun popup-thread-move ()
  (let ((menu (create-popup-menu 'thread-move)))
    (add-menu-item menu nil "y[W"
		   'thread-next-page)
    (add-menu-item menu nil "Oy[W"
		   'thread-previous-page)
    (add-menu-item menu nil "̔"
		   'thread-next-article)
    (add-menu-item menu nil "O̔"
		   'thread-previous-article)
    (add-menu-item menu nil "̃^O"
		   'thread-next-tag)
    (add-menu-item menu nil "Õ^O"
		   'thread-previous-tag)
    (add-menu-item menu nil "ԍփWv"
		   'thread-goto)
    menu))

(defun popup-buffer-view ()
  (let ((menu (create-popup-menu '2ch-menu-view)))
    (add-menu-item menu 'view-update "\XV"
		   'view-update)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "Wv"
		   'view-jump)
    (add-menu-item menu nil "߂"
		   'thread-history-back)
    (add-menu-item menu nil "̃XJ"
		   'view-open-thread)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "y[W"
		   'next-page)
    (add-menu-item menu nil "Oy[W"
		   'previous-page)
    (add-menu-item menu nil "̔"
		   'view-next-article)
    (add-menu-item menu nil "O̔"
		   'view-previous-article)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "폜"
		   'view-delete-current)
    (add-menu-item menu nil "tH[ŊJ"
		   'view-create-form)
    (add-menu-separator menu nil)
    (add-menu-item menu nil ""
		   'view-quit)
    (popup-menu-add menu)))

(defun popup-buffer-grep ()
  (let ((menu (create-popup-menu '2ch-menu-grep)))
    (add-menu-item menu nil "Wv"
		   'grep-jump)
    (add-menu-item menu nil "̃XJ"
		   'grep-open-thread)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "y[W"
		   'next-page)
    (add-menu-item menu nil "Oy[W"
		   'previous-page)
    (add-menu-item menu nil "̔"
		   'view-next-article)
    (add-menu-item menu nil "O̔"
		   'view-previous-article)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "̃}b`"
		   'grep-next-match)
    (add-menu-item menu nil "Õ}b`"
		   'grep-previous-match)
    (add-menu-separator menu nil)
    (add-menu-item menu nil ""
		   'grep-quit)
    (popup-menu-add menu)))

(defun popup-buffer-form ()
  (let ((menu (create-popup-menu '2ch-menu-form)))
    (add-menu-item menu nil "𑗐M"
		   'form-post)
    (add-menu-item menu nil "sageM"
		   'form-post-sage)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "ۑ"
		   'form-save)
    (add-menu-item menu nil "O̔"
		   'form-article-saved-previous)
    (add-menu-item menu nil "̔"
		   'form-article-saved-next)
    (add-menu-item menu nil "폜"
		   'form-article-current-del)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "sageɂ"
		   'form-sage)
    (add-menu-item menu nil "OI"
		   'popup-form-name-menu)
    (add-menu-item menu nil "[I"
		   'popup-form-addr-menu)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "Oo^"
		   'form-name-add)
    (add-menu-item menu nil "[o^"
		   'form-addr-add)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "pLtyank"
		   'form-cite-yank)
    (add-menu-item menu nil "pLt\t"
		   'form-cite-paste)
    (add-menu-item menu nil "Xy[Xϊ"
		   'form-body-convert)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "X֖߂"
		   'form-back)
    (add-menu-item menu nil "̔ɂ..."
		   'form-board-rule)
    (add-menu-item menu nil ""
		   'form-delete)
    (popup-menu-add menu)))

(defun popup-buffer-form-new ()
  (let ((menu (create-popup-menu '2ch-menu-form-new)))
    (add-menu-item menu nil "𑗐M"
		   'form-post-new)
    (add-menu-item menu nil "sageM"
		   'form-post-new-sage)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "ۑ"
		   'form-save-new)
    (add-menu-item menu nil "O̔"
		   'form-article-saved-new-previous)
    (add-menu-item menu nil "̔"
		   'form-article-saved-new-next)
    (add-menu-item menu nil "폜"
		   'form-article-current-del-new)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "sageɂ"
		   'form-sage)
    (add-menu-item menu nil "OI"
		   'popup-form-name-menu)
    (add-menu-item menu nil "[I"
		   'popup-form-addr-menu)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "Oo^"
		   'form-name-add)
    (add-menu-item menu nil "[o^"
		   'form-addr-add)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "pLtyank"
		   'form-cite-yank)
    (add-menu-item menu nil "pLt\t"
		   'form-cite-paste)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "X֖߂"
		   'form-back)
    (add-menu-item menu nil ""
		   'form-delete)
    (popup-menu-add menu)))

(defun popup-buffer-http ()
  (let ((menu (create-popup-menu '2ch-menu-http)))
    (add-menu-item menu nil "wb_\"
		   'http-show-status)
    (add-menu-item menu nil ""
		   'http-quit)
    (popup-menu-add menu)))

(defun popup-buffer-bookmark ()
  (let ((menu (create-popup-menu '2ch-menu-bookmark)))
    (add-menu-item menu nil "ubN}[NփWv"
		   'bookmark-select)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "ubN}[N폜"
		   'bookmark-delete)
    (add-menu-item menu nil "ubN}[N؂"
		   'bookmark-cut)
    (add-menu-item menu nil "ubN}[N\t"
		   'bookmark-paste)
    (add-menu-separator menu nil)
    (add-menu-item menu nil ""
		   'bookmark-quit)
    (popup-menu-add menu)))

(defun popup-buffer-history ()
  (let ((menu (create-popup-menu '2ch-menu-history)))
    (add-menu-item menu nil "Wv"
		   'history-select)
    (add-menu-separator menu nil)
    (add-menu-item menu nil "̗폜"
		   'history-delete)
    (add-menu-item menu nil "NA["
		   'history-clear)
    (add-menu-separator menu nil)
    (add-menu-item menu nil ""
		   'bookmark-quit)
    (popup-menu-add menu)))
