/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.output;

import java.awt.EventQueue;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public final class OutputDocument
implements Document {
    public static final AttributeSet attrs = new TrivialAttributeSet();
    final RootElement rootElement;
    private DocElement[] docElements = new DocElement[100];
    private int docElementsCount;
    private final DocElement lastDocElement = new DocElement(0, "", false);
    private int length = 0;
    private final Position startPosition = new SimplePosition(0);
    private final Position endPosition = new EndPosition();
    private final Element[] rootElements;
    private Map<Object, Object> properties;
    private DocumentListener[] docListeners;
    int cachedOffsetStart = -1;
    int cachedOffsetEnd = -1;
    int cachedIndex = -1;

    OutputDocument() {
        this.rootElement = new RootElement();
        this.rootElements = new Element[]{this.rootElement};
        this.docElements[0] = this.lastDocElement;
        this.docElementsCount = 1;
    }

    public int getLength() {
        return this.length;
    }

    public void addDocumentListener(DocumentListener documentListener) {
        if (documentListener == null) {
            return;
        }
        if (this.docListeners == null) {
            this.docListeners = new DocumentListener[1];
            this.docListeners[0] = documentListener;
        } else {
            DocumentListener[] documentListenerArray = this.docListeners;
            this.docListeners = new DocumentListener[documentListenerArray.length + 1];
            System.arraycopy(documentListenerArray, 0, this.docListeners, 0, documentListenerArray.length);
            this.docListeners[documentListenerArray.length] = documentListener;
        }
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        if (documentListener == null) {
            return;
        }
        if (this.docListeners == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.docListeners.length; ++i) {
            if (this.docListeners[i] != documentListener) continue;
            n = i;
            break;
        }
        if (n != -1) {
            if (this.docListeners.length == 1) {
                this.docListeners = null;
            } else {
                DocumentListener[] documentListenerArray = this.docListeners;
                this.docListeners = new DocumentListener[documentListenerArray.length - 1];
                if (n != 0) {
                    System.arraycopy(documentListenerArray, 0, this.docListeners, 0, n);
                }
                if (n != documentListenerArray.length - 1) {
                    System.arraycopy(documentListenerArray, n + 1, this.docListeners, n, documentListenerArray.length - (n + 1));
                }
            }
        }
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    public Object getProperty(Object object) {
        return this.properties != null ? this.properties.get(object) : null;
    }

    public void putProperty(Object object, Object object2) {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>(7);
        }
        this.properties.put(object, object2);
    }

    public void remove(int n, int n2) throws BadLocationException {
        this.checkLocation(n);
        assert (false) : "modification is not supported";
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        int n2;
        Object object;
        this.checkLocation(n);
        if (n != this.getLength()) {
            assert (false) : "modification is not supported";
            return;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return;
        }
        if (this.docElementsCount == this.docElements.length) {
            object = this.docElements;
            n2 = ((DocElement[])object).length;
            int n4 = n2 < 100000 ? n2 * 2 : n2 * 14 / 10;
            this.docElements = new DocElement[n4];
            System.arraycopy(object, 0, this.docElements, 0, this.docElementsCount - 1);
        }
        object = new DocElement(n, string, attributeSet != null);
        n2 = this.docElementsCount - 1;
        this.docElements[n2] = object;
        this.docElements[this.docElementsCount++] = this.lastDocElement;
        this.lastDocElement.offset = n + n3;
        this.length += n3;
        this.fireTextAppended((DocElement)object, n2);
    }

    int getElementIndex(int n) {
        int n2;
        int n3;
        int n4;
        if (this.cachedIndex != -1) {
            if (n == this.cachedOffsetStart || n > this.cachedOffsetStart && n < this.cachedOffsetEnd) {
                return this.cachedIndex;
            }
            if (n == this.cachedOffsetEnd) {
                DocElement docElement = this.docElements[this.cachedIndex + 1];
                assert (docElement.offset == n);
                ++this.cachedIndex;
                this.cachedOffsetStart = this.cachedOffsetEnd;
                this.cachedOffsetEnd = this.cachedOffsetStart + docElement.length;
                return this.cachedIndex;
            }
        }
        if (n == 0) {
            return 0;
        }
        if (n >= this.length) {
            return this.docElementsCount - 1;
        }
        if (this.cachedIndex == -1) {
            n4 = 0;
            n3 = this.docElementsCount - 1;
        } else if (n > this.cachedOffsetEnd) {
            n4 = this.cachedIndex + 1;
            n3 = this.docElementsCount - 1;
        } else {
            n4 = 0;
            n3 = this.cachedIndex;
        }
        int n5 = 0;
        while (n3 - n4 > 3) {
            ++n5;
            n2 = (n4 + n3 + 1) / 2;
            if (this.docElements[n2].offset >= n) {
                n3 = n2;
                continue;
            }
            n4 = n2;
        }
        n2 = n4;
        while (this.docElements[n2].offset < n) {
            ++n5;
            ++n2;
        }
        if (this.docElements[n2].offset != n) {
            --n2;
        }
        DocElement docElement = this.docElements[n2];
        if (this.cachedIndex == -1 || n2 >= this.cachedIndex) {
            this.cachedIndex = n2;
            this.cachedOffsetStart = docElement.offset;
            this.cachedOffsetEnd = docElement.offset + docElement.length;
        }
        return n2;
    }

    private void fireTextAppended(DocElement docElement, int n) {
        if (this.docListeners != null) {
            DocInsertEvent docInsertEvent = new DocInsertEvent(docElement, n);
            for (int i = 0; i < this.docListeners.length; ++i) {
                this.docListeners[i].insertUpdate(docInsertEvent);
            }
        }
    }

    public String getText(int n, int n2) throws BadLocationException {
        this.checkLocation(n);
        if (n2 < 0) {
            throw new BadLocationException("negative length", n);
        }
        if (n + n2 > this.getLength()) {
            throw new BadLocationException("(offset[" + n + "] + length[" + n2 + "]) go beyond total length[" + this.getLength() + ']', this.getLength());
        }
        if (n2 == 0) {
            return "";
        }
        int n3 = this.getElementIndex(n);
        DocElement docElement = this.docElements[n3];
        if (n == docElement.offset && n2 == docElement.length) {
            return docElement.getString();
        }
        if (n + n2 <= docElement.offset + docElement.length) {
            return docElement.getString().substring(n - docElement.offset, n - docElement.offset + n2);
        }
        int n4 = n + n2;
        StringBuilder stringBuilder = new StringBuilder(n2);
        if (docElement.offset == n) {
            docElement.appendToBuf(stringBuilder);
        } else {
            docElement.appendToBuf(stringBuilder, n);
        }
        while (true) {
            docElement = this.docElements[++n3];
            if (docElement.offset >= n4) break;
            docElement.appendToBuf(stringBuilder);
        }
        if (n4 > docElement.offset) {
            docElement.appendToBuf(stringBuilder, docElement.offset, n4);
        }
        return stringBuilder.toString();
    }

    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.checkLocation(n);
        if (n2 < 0) {
            throw new BadLocationException("negative length", n);
        }
        if (n2 == 0) {
            segment.array = new char[0];
            segment.offset = 0;
            segment.count = 0;
            return;
        }
        if (n + n2 > this.getLength()) {
            throw new BadLocationException("too long text requested", this.getLength());
        }
        int n3 = this.getElementIndex(n);
        DocElement docElement = this.docElements[n3];
        if (n == docElement.offset && n2 == docElement.length) {
            segment.array = docElement.getChars();
            segment.offset = 0;
            segment.count = n2;
        } else if (n + n2 <= docElement.offset + docElement.length) {
            segment.array = docElement.getChars();
            segment.offset = n - docElement.offset;
            segment.count = n2;
        } else if (segment.isPartialReturn()) {
            segment.array = docElement.getChars();
            segment.offset = n - docElement.offset;
            segment.count = docElement.offset + docElement.length - n;
        } else {
            int n4 = n + n2;
            char[] cArray = new char[n2];
            int n5 = docElement.offset + docElement.length - n;
            System.arraycopy(docElement.getChars(), n - docElement.offset, cArray, 0, n5);
            while (true) {
                docElement = this.docElements[++n3];
                if (docElement.offset >= n4) break;
                System.arraycopy(docElement.getChars(), 0, cArray, n5, docElement.length);
                n5 += docElement.length;
            }
            if (docElement.offset < n4) {
                System.arraycopy(docElement.getChars(), 0, cArray, n5, n4 - docElement.offset);
            }
            segment.array = cArray;
            segment.offset = 0;
            segment.count = n2;
        }
    }

    public Position getStartPosition() {
        return this.startPosition;
    }

    public Position getEndPosition() {
        return this.endPosition;
    }

    public Position createPosition(int n) throws BadLocationException {
        this.checkLocation(n);
        return n != this.length ? new SimplePosition(n) : new EndPosition();
    }

    private void checkLocation(int n) throws BadLocationException {
        if (n < 0) {
            throw new BadLocationException("negative offset", n);
        }
        if (n > this.length) {
            throw new BadLocationException("offset > length (" + this.length + ')', n);
        }
    }

    public Element[] getRootElements() {
        return this.rootElements;
    }

    public Element getDefaultRootElement() {
        return this.rootElement;
    }

    public void render(Runnable runnable) {
        assert (EventQueue.isDispatchThread());
        runnable.run();
    }

    final class DocElement
    implements Element {
        int offset;
        final int length;
        String text;
        char[] chars;
        final boolean isError;

        DocElement(int n, String string, boolean bl) {
            this.offset = n;
            this.text = string;
            this.chars = null;
            this.length = string.length();
            this.isError = bl;
        }

        char[] getChars() {
            if (this.chars == null) {
                this.chars = this.text.toCharArray();
                this.text = null;
            }
            return this.chars;
        }

        String getString() {
            if (this.text == null) {
                this.text = new String(this.chars);
                this.chars = null;
            }
            return this.text;
        }

        void appendToBuf(StringBuilder stringBuilder) {
            if (this.text != null) {
                stringBuilder.append(this.text);
            } else {
                assert (this.chars != null);
                stringBuilder.append(this.chars);
            }
        }

        void appendToBuf(StringBuilder stringBuilder, int n) {
            int n2 = n - this.offset;
            if (this.text != null) {
                stringBuilder.append(this.text, n2, this.length);
            } else {
                assert (this.chars != null);
                stringBuilder.append(this.chars, n2, this.length - n2);
            }
        }

        void appendToBuf(StringBuilder stringBuilder, int n, int n2) {
            if (this.text != null) {
                stringBuilder.append(this.text, n - this.offset, n2 - this.offset);
            } else {
                assert (this.chars != null);
                stringBuilder.append(this.chars, n - this.offset, n2 - n);
            }
        }

        public Document getDocument() {
            return OutputDocument.this;
        }

        public Element getParentElement() {
            return OutputDocument.this.rootElement;
        }

        public String getName() {
            return "DocElement";
        }

        public AttributeSet getAttributes() {
            return attrs;
        }

        public int getStartOffset() {
            return this.offset;
        }

        public int getEndOffset() {
            return this.offset + this.length;
        }

        public int getElementIndex(int n) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public int getElementCount() {
            return 0;
        }

        public Element getElement(int n) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public boolean isLeaf() {
            return true;
        }
    }

    private final class DocInsertEvent
    implements DocumentEvent,
    DocumentEvent.ElementChange {
        private final int index;
        private final DocElement docElem;
        private Element[] childrenAdded;

        private DocInsertEvent(DocElement docElement, int n) {
            this.docElem = docElement;
            this.index = n;
        }

        public int getOffset() {
            return this.docElem.offset;
        }

        public int getLength() {
            return this.docElem.length;
        }

        public Document getDocument() {
            return OutputDocument.this;
        }

        public DocumentEvent.EventType getType() {
            return DocumentEvent.EventType.INSERT;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            return element == OutputDocument.this.rootElement ? this : null;
        }

        public Element getElement() {
            return OutputDocument.this.rootElement;
        }

        public int getIndex() {
            return this.index;
        }

        public Element[] getChildrenRemoved() {
            return null;
        }

        public Element[] getChildrenAdded() {
            if (this.childrenAdded == null) {
                this.childrenAdded = new Element[]{this.docElem};
            }
            return this.childrenAdded;
        }
    }

    private final class EndPosition
    implements Position {
        private EndPosition() {
        }

        public int getOffset() {
            assert (EventQueue.isDispatchThread());
            return OutputDocument.this.getLength();
        }
    }

    final class RootElement
    implements Element {
        private static final String ROOT_NAME = "root element";

        RootElement() {
        }

        public Document getDocument() {
            return OutputDocument.this;
        }

        public Element getParentElement() {
            return null;
        }

        public String getName() {
            return ROOT_NAME;
        }

        public AttributeSet getAttributes() {
            return attrs;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return OutputDocument.this.getLength();
        }

        public int getElementIndex(int n) {
            return OutputDocument.this.getElementIndex(n);
        }

        public int getElementCount() {
            return OutputDocument.this.docElementsCount;
        }

        public Element getElement(int n) {
            return OutputDocument.this.docElements[n];
        }

        DocElement getDocElement(int n) {
            return OutputDocument.this.docElements[n];
        }

        public boolean isLeaf() {
            return false;
        }
    }

    private static final class SimplePosition
    implements Position {
        private final int offset;

        SimplePosition(int n) {
            this.offset = n;
        }

        public int getOffset() {
            assert (EventQueue.isDispatchThread());
            return this.offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrivialAttributeSet
    implements AttributeSet {
        private static final String NAME = "Trivial Attribute Set";

        private TrivialAttributeSet() {
        }

        @Override
        public int getAttributeCount() {
            return 1;
        }

        @Override
        public boolean isDefined(Object object) {
            return object.equals(NameAttribute);
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            return attributeSet.getAttributeCount() == 1 && NAME.equals(attributeSet.getAttribute(NameAttribute));
        }

        @Override
        public AttributeSet copyAttributes() {
            return this;
        }

        @Override
        public Object getAttribute(Object object) {
            return NameAttribute.equals(object) ? NAME : null;
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return Collections.enumeration(Collections.singleton(NameAttribute));
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            if (object == null) {
                throw new IllegalArgumentException();
            }
            return NameAttribute.equals(object) && NAME.equals(object2);
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            int n = attributeSet.getAttributeCount();
            return n == 0 || n == 1 && NAME.equals(attributeSet.getAttribute(NameAttribute));
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }
    }
}

