/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.HashMap;
import java.util.List;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.SyntaxElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxParserContext
implements Cloneable {
    private CharSequence sourceText;
    private HashMap<String, Object> properties;
    private List<SyntaxElement> elements;
    private DTD dtd;

    public static SyntaxParserContext createContext(CharSequence charSequence) {
        return new SyntaxParserContext(charSequence);
    }

    private SyntaxParserContext(CharSequence charSequence) {
        this.sourceText = charSequence;
    }

    public synchronized SyntaxParserContext setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
        return this;
    }

    public synchronized Object getProperty(String string) {
        return this.properties.get(string);
    }

    public synchronized String getPropertyAsString(String string) {
        if (this.properties == null) {
            return null;
        }
        Object object = this.properties.get(string);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public synchronized boolean isPropertyEnabled(String string) {
        return Boolean.parseBoolean(this.getPropertyAsString(string));
    }

    protected SyntaxParserContext clone() {
        SyntaxParserContext syntaxParserContext = SyntaxParserContext.createContext(this.sourceText);
        syntaxParserContext.properties = this.properties == null ? null : (HashMap)this.properties.clone();
        syntaxParserContext.dtd = this.dtd;
        syntaxParserContext.elements = this.elements;
        return syntaxParserContext;
    }

    public CharSequence getSourceText() {
        return this.sourceText;
    }

    public SyntaxParserContext setDTD(DTD dTD) {
        this.dtd = dTD;
        return this;
    }

    public DTD getDTD() {
        return this.dtd;
    }

    List<SyntaxElement> getElements() {
        return this.elements;
    }

    SyntaxParserContext setElements(List<SyntaxElement> list) {
        this.elements = list;
        return this;
    }
}

