/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.db.util.DataComboBoxModel;

public final class DataComboBoxSupport {
    private final DataComboBoxModel dataModel;
    private final boolean allowAdding;
    private Object previousItem = null;
    private Object previousNonSpecialItem = null;
    private boolean performingNewItemAction = false;
    final Object NEW_ITEM = new Object(){

        public String toString() {
            return DataComboBoxSupport.this.dataModel.getNewItemDisplayName();
        }
    };

    DataComboBoxSupport(JComboBox jComboBox, DataComboBoxModel dataComboBoxModel, boolean bl) {
        this.dataModel = dataComboBoxModel;
        this.allowAdding = bl;
        jComboBox.setEditable(false);
        jComboBox.setModel(new ItemComboBoxModel());
        jComboBox.setRenderer(new ItemListCellRenderer());
        jComboBox.addActionListener(new ItemActionListener());
        jComboBox.addPopupMenuListener(new ItemPopupMenuListener());
    }

    public static void connect(JComboBox jComboBox, DataComboBoxModel dataComboBoxModel) {
        DataComboBoxSupport.connect(jComboBox, dataComboBoxModel, true);
    }

    public static void connect(JComboBox jComboBox, DataComboBoxModel dataComboBoxModel, boolean bl) {
        new DataComboBoxSupport(jComboBox, dataComboBoxModel, bl);
    }

    private boolean isSpecialItem(Object object) {
        return object == this.NEW_ITEM;
    }

    private void setPreviousNonSpecialItem(JComboBox jComboBox) {
        if (jComboBox.getSelectedItem() == this.NEW_ITEM) {
            jComboBox.setSelectedItem(this.previousNonSpecialItem);
        }
    }

    private final class ItemActionListener
    implements ActionListener {
        private ItemActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            final JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            Object object = jComboBox.getSelectedItem();
            if (object == DataComboBoxSupport.this.NEW_ITEM) {
                DataComboBoxSupport.this.performingNewItemAction = true;
                try {
                    jComboBox.setPopupVisible(false);
                    DataComboBoxSupport.this.dataModel.newItemActionPerformed();
                }
                finally {
                    DataComboBoxSupport.this.performingNewItemAction = false;
                }
                DataComboBoxSupport.this.setPreviousNonSpecialItem(jComboBox);
                final Object object2 = jComboBox.getSelectedItem();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jComboBox.setSelectedItem(object2);
                    }
                });
            }
        }
    }

    private class ItemComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ListDataListener {
        public ItemComboBoxModel() {
            this.getDelegate().addListDataListener(this);
        }

        public Object getElementAt(int n) {
            if (DataComboBoxSupport.this.allowAdding) {
                if (this.getSize() == 1) {
                    if (n == 0) {
                        return DataComboBoxSupport.this.NEW_ITEM;
                    }
                    throw new IllegalStateException("Index out of bounds: " + n);
                }
                if (n >= 0 && n < this.getDelegate().getSize()) {
                    return this.getDelegate().getElementAt(n);
                }
                if (n == this.getSize() - 1) {
                    return DataComboBoxSupport.this.NEW_ITEM;
                }
                throw new IllegalStateException("Index out of bounds: " + n);
            }
            return this.getDelegate().getElementAt(n);
        }

        public int getSize() {
            if (DataComboBoxSupport.this.allowAdding) {
                return this.getDelegate().getSize() == 0 ? 1 : this.getDelegate().getSize() + 1;
            }
            return this.getDelegate().getSize();
        }

        public void setSelectedItem(Object object) {
            DataComboBoxSupport.this.previousItem = this.getDelegate().getSelectedItem();
            if (!DataComboBoxSupport.this.isSpecialItem(DataComboBoxSupport.this.previousItem)) {
                DataComboBoxSupport.this.previousNonSpecialItem = DataComboBoxSupport.this.previousItem;
            }
            this.getDelegate().setSelectedItem(object);
        }

        public Object getSelectedItem() {
            return this.getDelegate().getSelectedItem();
        }

        public Object getPreviousItem() {
            return DataComboBoxSupport.this.previousItem;
        }

        private ComboBoxModel getDelegate() {
            return DataComboBoxSupport.this.dataModel.getListModel();
        }

        private int getItemIndex(Object object) {
            if (object == null) {
                return -1;
            }
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).equals(object)) continue;
                return i;
            }
            return -1;
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            throw new UnsupportedOperationException("This is currently not supported.");
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            throw new UnsupportedOperationException("This is currently not supported.");
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private class ItemListCellRenderer
    extends DefaultListCellRenderer {
        private ItemListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            JLabel jLabel = (JLabel)component;
            if (object != null && !DataComboBoxSupport.this.isSpecialItem(object)) {
                String string = DataComboBoxSupport.this.dataModel.getItemDisplayName(object);
                jLabel.setText(DataComboBoxSupport.this.dataModel.getItemDisplayName(object));
                jLabel.setToolTipText(DataComboBoxSupport.this.dataModel.getItemTooltipText(object));
            } else if (object != null) {
                jLabel.setText(object.toString());
                jLabel.setToolTipText(null);
            }
            return jLabel;
        }
    }

    private final class ItemPopupMenuListener
    implements PopupMenuListener {
        private ItemPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (!DataComboBoxSupport.this.performingNewItemAction) {
                DataComboBoxSupport.this.setPreviousNonSpecialItem((JComboBox)popupMenuEvent.getSource());
            }
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            if (!DataComboBoxSupport.this.performingNewItemAction) {
                DataComboBoxSupport.this.setPreviousNonSpecialItem((JComboBox)popupMenuEvent.getSource());
            }
        }
    }
}

