/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class DriverNode
extends BaseNode {
    private static final String PREFERREDICONBASE = "org/netbeans/modules/db/resources/driverPrefered.gif";
    private static final String FOLDER = "Driver";
    private DatabaseDriver databaseDriver;

    public static DriverNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        DriverNode driverNode = new DriverNode(nodeDataLookup, nodeProvider);
        driverNode.setup();
        return driverNode;
    }

    private DriverNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(nodeDataLookup, FOLDER, nodeProvider);
    }

    protected void initialize() {
        StringBuffer stringBuffer = new StringBuffer();
        JDBCDriver jDBCDriver = (JDBCDriver)this.getLookup().lookup(JDBCDriver.class);
        for (int i = 0; i < jDBCDriver.getURLs().length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            String string = jDBCDriver.getURLs()[i].getFile();
            if (Utilities.isWindows()) {
                string = string.substring(1);
            }
            stringBuffer.append(string);
        }
        this.databaseDriver = new DatabaseDriver(jDBCDriver.getDisplayName(), jDBCDriver.getClassName(), stringBuffer.toString(), jDBCDriver);
    }

    public DatabaseDriver getDatabaseDriver() {
        return this.databaseDriver;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    JDBCDriver jDBCDriver = DriverNode.this.databaseDriver.getJDBCDriver();
                    if (jDBCDriver != null) {
                        JDBCDriverManager.getDefault().removeDriver(jDBCDriver);
                    }
                }
                catch (DatabaseException databaseException) {
                    Exceptions.printStackTrace((Throwable)databaseException);
                }
            }
        });
    }

    public String getName() {
        return this.databaseDriver.getName();
    }

    public String getDisplayName() {
        return this.databaseDriver.getName();
    }

    public String getIconBase() {
        return PREFERREDICONBASE;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(DriverNode.class, (String)"ND_Driver");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DriverNode.class);
    }
}

