/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CatalogNode
extends BaseNode {
    private static final String ICONBASE = "org/netbeans/modules/db/resources/database.gif";
    private static final String FOLDER = "Catalog";
    private String name = "";
    private String htmlName = null;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Catalog> catalogHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static CatalogNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        CatalogNode catalogNode = new CatalogNode(nodeDataLookup, nodeProvider);
        catalogNode.setup();
        return catalogNode;
    }

    private CatalogNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(new ChildNodeFactory((Lookup)nodeDataLookup), nodeDataLookup, FOLDER, nodeProvider);
    }

    protected void initialize() {
        this.setupNames();
        this.connection.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("defaultCatalog")) {
                    CatalogNode.this.updateProperties();
                }
            }
        });
    }

    private void setupNames() {
        boolean bl;
        MetadataModel metadataModel = this.connection.getMetadataModel();
        boolean bl2 = bl = !this.connection.getConnector().isDisconnected();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Catalog catalog = (Catalog)CatalogNode.this.catalogHandle.resolve(metadata);
                        CatalogNode.this.renderNames(catalog);
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, metadataModelException, true);
            }
        }
    }

    protected void updateProperties() {
        this.setupNames();
        super.updateProperties();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getHtmlDisplayName() {
        return this.htmlName;
    }

    private void renderNames(Catalog catalog) {
        if (catalog == null) {
            this.name = "";
        } else {
            this.name = catalog.getName();
            if (this.name == null) {
                this.name = "Default";
            }
        }
        if (catalog != null) {
            boolean bl = false;
            String string = this.connection.getDefaultCatalog();
            bl = string != null ? string.equals(this.name) : catalog.isDefault();
            this.htmlName = bl ? "<b>" + this.name + "</b>" : null;
        }
    }

    public String getIconBase() {
        return ICONBASE;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(CatalogNode.class, (String)"ND_Catalog");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CatalogNode.class);
    }
}

