/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.util.DataComboBoxModel;
import org.netbeans.modules.db.util.DataComboBoxSupport;
import org.openide.util.NbBundle;

public final class DatabaseExplorerUIs {
    private DatabaseExplorerUIs() {
    }

    public static void connect(JComboBox jComboBox, ConnectionManager connectionManager) {
        DataComboBoxSupport.connect(jComboBox, new ConnectionDataComboBoxModel(connectionManager));
    }

    private static final class ConnectionComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final ConnectionManager connectionManager;
        private final List connectionList;
        private Object selectedItem;

        public ConnectionComboBoxModel(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            this.connectionList = new ArrayList();
            this.connectionList.addAll(Arrays.asList(connectionManager.getConnections()));
            Collections.sort(this.connectionList, new ConnectionComparator());
        }

        public void setSelectedItem(Object object) {
            this.selectedItem = object;
        }

        public Object getElementAt(int n) {
            return this.connectionList.get(n);
        }

        public int getSize() {
            return this.connectionList.size();
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public void addSelectedConnection(DatabaseConnection databaseConnection) {
            this.selectedItem = databaseConnection;
            this.connectionList.add(databaseConnection);
            Collections.sort(this.connectionList, new ConnectionComparator());
            this.fireContentsChanged(this, 0, this.connectionList.size());
        }
    }

    private static final class ConnectionComparator
    implements Comparator {
        private ConnectionComparator() {
        }

        public boolean equals(Object object) {
            return object instanceof ConnectionComparator;
        }

        public int compare(Object object, Object object2) {
            if (object == null) {
                return object2 == null ? 0 : -1;
            }
            if (object2 == null) {
                return 1;
            }
            String string = ((DatabaseConnection)object).getDisplayName();
            String string2 = ((DatabaseConnection)object2).getDisplayName();
            if (string == null) {
                return string2 == null ? 0 : -1;
            }
            return string2 == null ? 1 : string.compareToIgnoreCase(string2);
        }
    }

    private static final class ConnectionDataComboBoxModel
    implements DataComboBoxModel {
        private final ConnectionManager connectionManager;
        private final ConnectionComboBoxModel comboBoxModel;

        public ConnectionDataComboBoxModel(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            this.comboBoxModel = new ConnectionComboBoxModel(connectionManager);
        }

        public String getItemTooltipText(Object object) {
            return ((DatabaseConnection)object).toString();
        }

        public String getItemDisplayName(Object object) {
            return ((DatabaseConnection)object).getDisplayName();
        }

        public void newItemActionPerformed() {
            HashSet<DatabaseConnection> hashSet = new HashSet<DatabaseConnection>(Arrays.asList(this.connectionManager.getConnections()));
            this.connectionManager.showAddConnectionDialog(null);
            DatabaseConnection[] databaseConnectionArray = this.connectionManager.getConnections();
            if (databaseConnectionArray.length == hashSet.size()) {
                return;
            }
            for (int i = 0; i < databaseConnectionArray.length; ++i) {
                if (hashSet.contains(databaseConnectionArray[i])) continue;
                this.comboBoxModel.addSelectedConnection(databaseConnectionArray[i]);
                break;
            }
        }

        public String getNewItemDisplayName() {
            return NbBundle.getMessage(DatabaseExplorerUIs.class, (String)"LBL_NewDbConnection");
        }

        public ComboBoxModel getListModel() {
            return this.comboBoxModel;
        }
    }
}

