/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.api;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OffsetRange
implements Comparable<OffsetRange> {
    public static final OffsetRange NONE = new OffsetRange(0, 0);
    private final int start;
    private final int end;

    public OffsetRange(int n, int n2) {
        assert (n >= 0);
        assert (n2 >= n);
        this.start = n;
        this.end = n2;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    public boolean overlaps(OffsetRange offsetRange) {
        if (offsetRange == NONE) {
            return false;
        }
        if (this == NONE) {
            return false;
        }
        return this.end > offsetRange.start && this.start < offsetRange.end;
    }

    public OffsetRange boundTo(int n, int n2) {
        assert (n <= n2);
        assert (this != NONE);
        int n3 = this.start;
        int n4 = this.end;
        if (n4 > n2) {
            n4 = n2;
            if (n3 > n2) {
                n3 = n2;
            }
        }
        if (n3 < n) {
            n3 = n;
            if (n4 < n) {
                n4 = n;
            }
        }
        return new OffsetRange(n3, n4);
    }

    public String toString() {
        if (this == NONE) {
            return "OffsetRange[NONE]";
        }
        return "OffsetRange[" + this.start + "," + this.end + ">";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != OffsetRange.class) {
            return false;
        }
        OffsetRange offsetRange = (OffsetRange)object;
        if (this.start != offsetRange.start) {
            return false;
        }
        return this.end == offsetRange.end;
    }

    public int hashCode() {
        return this.start;
    }

    public boolean containsInclusive(int n) {
        if (this == NONE) {
            return false;
        }
        return n >= this.getStart() && n <= this.getEnd();
    }

    @Override
    public int compareTo(OffsetRange offsetRange) {
        if (this.start != offsetRange.start) {
            return this.start - offsetRange.start;
        }
        return this.end - offsetRange.end;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }
}

