/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extexecution.input;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputReader;
import org.netbeans.api.extexecution.input.InputReaders;

public class FileInputReader
implements InputReader {
    private static final Logger LOGGER = Logger.getLogger(FileInputReader.class.getName());
    private static final int BUFFER_SIZE = 512;
    private final InputReaders.FileInput.Provider fileProvider;
    private final char[] buffer = new char[512];
    private InputReaders.FileInput currentFile;
    private Reader reader;
    private long fileLength;
    private boolean closed;

    public FileInputReader(InputReaders.FileInput.Provider provider) {
        assert (provider != null);
        this.fileProvider = provider;
    }

    public int readInput(InputProcessor inputProcessor) {
        int n;
        block12: {
            if (this.closed) {
                throw new IllegalStateException("Already closed reader");
            }
            n = 0;
            try {
                InputReaders.FileInput fileInput = this.fileProvider.getFileInput();
                if (this.currentFile != fileInput && (this.currentFile == null || !this.currentFile.equals(fileInput)) || this.fileLength > this.currentFile.getFile().length() || this.reader == null) {
                    if (this.reader != null) {
                        this.reader.close();
                    }
                    this.currentFile = fileInput;
                    if (this.currentFile != null && this.currentFile.getFile().exists() && this.currentFile.getFile().canRead()) {
                        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.currentFile.getFile()), this.currentFile.getCharset()));
                    }
                    if (this.fileLength > 0L) {
                        inputProcessor.reset();
                    }
                    this.fileLength = 0L;
                }
                if (this.reader == null) {
                    return n;
                }
                int n2 = this.reader.read(this.buffer);
                if (n2 > 0) {
                    this.fileLength += (long)n2;
                    n += n2;
                    if (inputProcessor != null) {
                        char[] cArray = new char[n2];
                        System.arraycopy(this.buffer, 0, cArray, 0, n2);
                        inputProcessor.processInput(cArray);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.INFO, null, exception);
                if (this.reader == null) break block12;
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, null, exception);
                }
            }
        }
        return n;
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }
}

