/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.input;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputReader;
import org.openide.util.Cancellable;
import org.openide.util.Parameters;

public final class InputReaderTask
implements Runnable,
Cancellable {
    private static final Logger LOGGER = Logger.getLogger(InputReaderTask.class.getName());
    private static final int DELAY = 50;
    private final InputReader inputReader;
    private final InputProcessor inputProcessor;
    private final boolean draining;
    private boolean cancelled;
    private boolean running;

    private InputReaderTask(InputReader inputReader, InputProcessor inputProcessor, boolean bl) {
        this.inputReader = inputReader;
        this.inputProcessor = inputProcessor;
        this.draining = bl;
    }

    @NonNull
    public static InputReaderTask newTask(@NonNull InputReader inputReader, @NullAllowed InputProcessor inputProcessor) {
        Parameters.notNull((CharSequence)"reader", (Object)inputReader);
        return new InputReaderTask(inputReader, inputProcessor, false);
    }

    @NonNull
    public static InputReaderTask newDrainingTask(@NonNull InputReader inputReader, @NullAllowed InputProcessor inputProcessor) {
        Parameters.notNull((CharSequence)"reader", (Object)inputReader);
        return new InputReaderTask(inputReader, inputProcessor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        Object v0;
        IOException iOException22;
        boolean bl;
        block39: {
            InputReaderTask inputReaderTask;
            InputReaderTask inputReaderTask2 = this;
            synchronized (inputReaderTask2) {
                if (this.running) {
                    throw new IllegalStateException("Already running task");
                }
                this.running = true;
            }
            bl = false;
            while (true) {
                inputReaderTask = this;
                synchronized (inputReaderTask) {
                    if (Thread.currentThread().isInterrupted() || this.cancelled) {
                        bl = Thread.interrupted();
                        break;
                    }
                }
                this.inputReader.readInput(this.inputProcessor);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    break;
                }
            }
            inputReaderTask = this;
            synchronized (inputReaderTask) {
                if (Thread.currentThread().isInterrupted() || this.cancelled) {
                    bl = Thread.interrupted();
                }
            }
            Object var6_9 = null;
            if (!this.draining) break block39;
            try {
                while (this.inputReader.readInput(this.inputProcessor) > 0) {
                    LOGGER.log(Level.FINE, "Draining the rest of the reader");
                }
            }
            catch (IOException iOException22) {
                LOGGER.log(Level.FINE, null, iOException22);
            }
        }
        try {
            try {
                if (this.inputProcessor != null) {
                    this.inputProcessor.close();
                }
                this.inputReader.close();
                v0 = null;
            }
            catch (IOException iOException22) {
                LOGGER.log(Level.INFO, null, iOException22);
                v0 = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_18;
            v0 = var9_18 = null;
        }
        if (!bl) return;
        Thread.currentThread().interrupt();
        {
            return;
            catch (Exception exception) {
                Object v1;
                IOException iOException322;
                LOGGER.log(Level.FINE, null, exception);
                Object var6_10 = null;
                if (this.draining) {
                    try {
                        while (this.inputReader.readInput(this.inputProcessor) > 0) {
                            LOGGER.log(Level.FINE, "Draining the rest of the reader");
                        }
                    }
                    catch (IOException iOException322) {
                        LOGGER.log(Level.FINE, null, iOException322);
                    }
                }
                try {
                    try {
                        if (this.inputProcessor != null) {
                            this.inputProcessor.close();
                        }
                        this.inputReader.close();
                        v1 = null;
                    }
                    catch (IOException iOException322) {
                        LOGGER.log(Level.INFO, null, iOException322);
                        v1 = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_19;
                    v1 = var9_19 = null;
                }
                if (!bl) return;
                Thread.currentThread().interrupt();
                return;
            }
        }
        catch (Throwable throwable) {
            Object v2;
            IOException iOException422;
            Object var6_11 = null;
            if (this.draining) {
                try {
                    while (this.inputReader.readInput(this.inputProcessor) > 0) {
                        LOGGER.log(Level.FINE, "Draining the rest of the reader");
                    }
                }
                catch (IOException iOException422) {
                    LOGGER.log(Level.FINE, null, iOException422);
                }
            }
            try {
                try {
                    if (this.inputProcessor != null) {
                        this.inputProcessor.close();
                    }
                    this.inputReader.close();
                    v2 = null;
                }
                catch (IOException iOException422) {
                    LOGGER.log(Level.INFO, null, iOException422);
                    v2 = null;
                }
            }
            catch (Throwable throwable2) {
                Object var9_20;
                v2 = var9_20 = null;
            }
            if (!bl) throw throwable;
            Thread.currentThread().interrupt();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        InputReaderTask inputReaderTask = this;
        synchronized (inputReaderTask) {
            if (this.cancelled) {
                return false;
            }
            this.cancelled = true;
            return true;
        }
    }
}

