/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.selectors;

import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.RepositoriesSupport;
import org.netbeans.modules.bugtracking.jira.JiraUpdater;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.selectors.SelectorPanel;

public class RepositorySelector {
    private SelectorPanel selectorPanel = new SelectorPanel();

    public Repository create() {
        BugtrackingConnector[] bugtrackingConnectorArray = BugtrackingManager.getInstance().getConnectors();
        bugtrackingConnectorArray = this.addJiraProxyIfNeeded(bugtrackingConnectorArray);
        this.selectorPanel.setConnectors(bugtrackingConnectorArray);
        if (!this.selectorPanel.open()) {
            return null;
        }
        Repository repository = this.selectorPanel.getRepository();
        try {
            repository.getController().applyChanges();
        }
        catch (IOException iOException) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
            return null;
        }
        RepositoriesSupport.getInstance().fireRepositoriesChanged();
        return repository;
    }

    public boolean edit(Repository repository, String string) {
        if (!this.selectorPanel.edit(repository, string)) {
            return false;
        }
        Repository repository2 = this.selectorPanel.getRepository();
        try {
            repository2.getController().applyChanges();
        }
        catch (IOException iOException) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
            return false;
        }
        return true;
    }

    private BugtrackingConnector[] addJiraProxyIfNeeded(BugtrackingConnector[] bugtrackingConnectorArray) {
        if (!JiraUpdater.isJiraInstalled()) {
            BugtrackingConnector[] bugtrackingConnectorArray2 = new BugtrackingConnector[bugtrackingConnectorArray.length + 1];
            System.arraycopy(bugtrackingConnectorArray, 0, bugtrackingConnectorArray2, 0, bugtrackingConnectorArray.length);
            bugtrackingConnectorArray2[bugtrackingConnectorArray2.length - 1] = JiraUpdater.getInstance().getConnector();
            bugtrackingConnectorArray = bugtrackingConnectorArray2;
        }
        return bugtrackingConnectorArray;
    }
}

