/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue.cache;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueCache<T> {
    public static final int ISSUE_STATUS_UNKNOWN = 0;
    public static final int ISSUE_STATUS_SEEN = 2;
    public static final int ISSUE_STATUS_NEW = 4;
    public static final int ISSUE_STATUS_MODIFIED = 8;
    public static final int ISSUE_STATUS_ALL = 14;
    public static final int ISSUE_STATUS_NOT_SEEN = 12;
    public static final String EVENT_ISSUE_SEEN_CHANGED = "issue.seen_changed";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache");
    private Map<String, IssueEntry> cache;
    private final Map<String, PropertyChangeSupport> supports = new HashMap<String, PropertyChangeSupport>();
    private Map<String, Map<String, String>> lastSeenAttributes;
    private String nameSpace;
    private final Object CACHE_LOCK = new Object();
    private long referenceTime;
    private final IssueAccessor<T> issueAccessor;

    public IssueCache(String string, IssueAccessor<T> issueAccessor) {
        assert (issueAccessor != null);
        this.nameSpace = string;
        this.issueAccessor = issueAccessor;
        try {
            this.referenceTime = IssueStorage.getInstance().getReferenceTime(string);
        }
        catch (IOException iOException) {
            this.referenceTime = System.currentTimeMillis();
            LOG.log(Level.SEVERE, null, iOException);
        }
        BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = IssueCache.this.CACHE_LOCK;
                synchronized (object) {
                    IssueCache.this.cleanup();
                }
            }
        });
    }

    protected void cleanup() {
        IssueStorage.getInstance().cleanup(this.nameSpace);
    }

    IssueAccessor<T> getIssueAccessor() {
        return this.issueAccessor;
    }

    public Issue setIssueData(String string, T t) throws IOException {
        assert (t != null);
        assert (string != null && !string.equals(""));
        return this.setIssueData(string, null, t);
    }

    public void setIssueData(Issue issue, T t) throws IOException {
        assert (t != null);
        assert (issue != null);
        String string = issue.getID() == null ? this.issueAccessor.getID(t) : issue.getID();
        assert (string != null && !string.equals(""));
        this.setIssueData(string, issue, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Issue setIssueData(String string, Issue issue, T t) throws IOException {
        assert (t != null);
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry issueEntry = this.getCache().get(string);
            if (issueEntry == null) {
                issueEntry = this.createNewEntry(string);
            }
            if (issueEntry.issue == null) {
                if (issue != null) {
                    issueEntry.issue = issue;
                    LOG.log(Level.FINE, "setting task data for issue {0} ", new Object[]{string});
                    this.issueAccessor.setIssueData(issueEntry.issue, t);
                } else {
                    issueEntry.issue = this.issueAccessor.createIssue(t);
                    LOG.log(Level.FINE, "created issue {0} ", new Object[]{string});
                    this.readIssue(issueEntry);
                    Map<String, String> map = issueEntry.getSeenAttributes();
                    if (map == null || map.size() == 0) {
                        if (this.referenceTime >= this.issueAccessor.getLastModified(issueEntry.issue)) {
                            this.setSeen(string, true);
                        } else if (this.referenceTime >= this.issueAccessor.getCreated(issueEntry.issue)) {
                            issueEntry.seenAttributes = issueEntry.issue.getAttributes();
                            this.storeIssue(issueEntry);
                        }
                    }
                }
            } else {
                LOG.log(Level.FINE, "setting task data for issue {0} ", new Object[]{string});
                this.issueAccessor.setIssueData(issueEntry.issue, t);
            }
            if (issueEntry.seenAttributes != null) {
                if (issueEntry.wasSeen()) {
                    LOG.log(Level.FINE, " issue {0} was seen", new Object[]{string});
                    long l = this.issueAccessor.getLastModified(issueEntry.issue);
                    if (this.isChanged(issueEntry.seenAttributes, issueEntry.issue.getAttributes()) || issueEntry.lastSeenModified < l) {
                        LOG.log(Level.FINE, " issue {0} is changed", new Object[]{string});
                        if (issueEntry.lastSeenModified >= l) {
                            LOG.warning(" issue {0} changed, yet last known modify > last modify. [" + issueEntry.lastSeenModified + "," + l + "]");
                        }
                        this.storeIssue(issueEntry);
                        issueEntry.seen = false;
                        issueEntry.status = 8;
                    } else {
                        LOG.log(Level.FINE, " issue {0} isn't changed", new Object[]{string});
                    }
                } else {
                    LOG.log(Level.FINE, " issue {0} wasn't seen yet", new Object[]{string});
                    if (this.isChanged(issueEntry.seenAttributes, issueEntry.issue.getAttributes()) || this.referenceTime < this.issueAccessor.getLastModified(issueEntry.issue)) {
                        LOG.log(Level.FINE, " issue {0} is changed", new Object[]{string});
                        issueEntry.seen = false;
                        issueEntry.status = 8;
                    } else {
                        LOG.log(Level.FINE, " issue {0} isn't changed", new Object[]{string});
                        issueEntry.seenAttributes = null;
                        issueEntry.seen = false;
                        issueEntry.status = 4;
                    }
                }
            }
            return issueEntry.issue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeen(String string, boolean bl) throws IOException {
        IssueEntry issueEntry;
        boolean bl2;
        if (string == null) {
            return;
        }
        LOG.log(Level.FINE, "setting seen {0} for issue {1}", new Object[]{bl, string});
        assert (!SwingUtilities.isEventDispatchThread());
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            bl2 = this.wasSeen(string);
            issueEntry = this.getCache().get(string);
            assert (issueEntry != null && issueEntry.issue != null);
            if (bl) {
                this.getLastSeenAttributes().put(string, issueEntry.seenAttributes);
                issueEntry.seenAttributes = issueEntry.issue.getAttributes();
                issueEntry.lastSeenModified = this.issueAccessor.getLastModified(issueEntry.issue);
                issueEntry.lastUnseenStatus = issueEntry.status;
            } else {
                issueEntry.seenAttributes = this.getLastSeenAttributes().get(string);
                if (issueEntry.lastUnseenStatus != 0) {
                    issueEntry.status = issueEntry.lastUnseenStatus;
                    if (issueEntry.seenAttributes == null) {
                        issueEntry.seenAttributes = issueEntry.issue.getAttributes();
                    }
                }
            }
            issueEntry.seen = bl;
            this.storeIssue(issueEntry);
        }
        this.fireSeenChanged(issueEntry.issue, bl2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasSeen(String string) {
        IssueEntry issueEntry;
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            issueEntry = this.getCache().get(string);
            if (issueEntry == null) {
                issueEntry = this.createNewEntry(string);
                this.readIssue(issueEntry);
            }
        }
        boolean bl = issueEntry != null ? issueEntry.seen : false;
        LOG.log(Level.FINE, "returning seen {0} for issue {1}", new Object[]{bl, string});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSeenAttributes(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry issueEntry = this.getCache().get(string);
            if (issueEntry == null) {
                assert (!SwingUtilities.isEventDispatchThread());
                issueEntry = this.createNewEntry(string);
                this.readIssue(issueEntry);
            }
            return issueEntry.seenAttributes != null ? issueEntry.seenAttributes : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Issue getIssue(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry issueEntry = this.getCache().get(string);
            return issueEntry == null ? null : issueEntry.issue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry issueEntry = this.getCache().get(string);
            if (issueEntry == null) {
                LOG.log(Level.FINE, "returning UKNOWN status for issue {0}", new Object[]{string});
                return 0;
            }
            if (issueEntry.seen) {
                LOG.log(Level.FINE, "returning SEEN status for issue {0}", new Object[]{string});
                return 2;
            }
            LOG.log(Level.FINE, "returning status {0} for issue {1}", new Object[]{issueEntry.status, string});
            return issueEntry.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeQueryIssues(String string, String[] stringArray) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                IssueStorage.getInstance().storeQuery(this.nameSpace, string, stringArray);
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, null, iOException);
            }
        }
    }

    public long getQueryTimestamp(String string) {
        return IssueStorage.getInstance().getQueryTimestamp(this.nameSpace, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readQueryIssues(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                return IssueStorage.getInstance().readQuery(this.nameSpace, string);
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, null, iOException);
                return new ArrayList<String>(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeArchivedQueryIssues(String string, String[] stringArray) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                IssueStorage.getInstance().storeArchivedQueryIssues(this.nameSpace, string, stringArray);
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, null, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readArchivedQueryIssues(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                Map<String, Long> map = IssueStorage.getInstance().readArchivedQueryIssues(this.nameSpace, string);
                return new ArrayList<String>(map.keySet());
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, null, iOException);
                return new ArrayList<String>(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                IssueStorage.getInstance().removeQuery(this.nameSpace, string);
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, null, iOException);
            }
        }
    }

    private IssueEntry createNewEntry(String string) {
        IssueEntry issueEntry = new IssueEntry();
        issueEntry.id = string;
        issueEntry.status = 4;
        this.getCache().put(string, issueEntry);
        return issueEntry;
    }

    private Map<String, IssueEntry> getCache() {
        if (this.cache == null) {
            this.cache = new HashMap<String, IssueEntry>();
        }
        return this.cache;
    }

    private Map<String, Map<String, String>> getLastSeenAttributes() {
        if (this.lastSeenAttributes == null) {
            this.lastSeenAttributes = new HashMap<String, Map<String, String>>();
        }
        return this.lastSeenAttributes;
    }

    private synchronized void readIssue(IssueEntry issueEntry) {
        try {
            IssueStorage.getInstance().readIssue(this.nameSpace, issueEntry);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, null, iOException);
        }
    }

    private void storeIssue(IssueEntry issueEntry) throws IOException {
        IssueStorage.getInstance().storeIssue(this.nameSpace, issueEntry);
    }

    void addPropertyChangeListener(Issue issue, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.getChangeSupport(issue, true);
        propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    private PropertyChangeSupport getChangeSupport(Issue issue, boolean bl) {
        PropertyChangeSupport propertyChangeSupport = this.supports.get(issue.getID());
        if (propertyChangeSupport == null && bl) {
            propertyChangeSupport = new PropertyChangeSupport(issue);
            this.supports.put(issue.getID(), propertyChangeSupport);
        }
        return propertyChangeSupport;
    }

    void removePropertyChangeListener(Issue issue, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.getChangeSupport(issue, true);
        propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireSeenChanged(Issue issue, boolean bl, boolean bl2) {
        PropertyChangeSupport propertyChangeSupport = this.getChangeSupport(issue, false);
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(EVENT_ISSUE_SEEN_CHANGED, bl, bl2);
        }
    }

    private boolean isChanged(Map<String, String> map, Map<String, String> map2) {
        if (map == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = map2.get(entry.getKey());
            String string2 = entry.getValue();
            if (string == null && string2 != null) continue;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IssueAccessor<T> {
        public Issue createIssue(T var1);

        public void setIssueData(Issue var1, T var2);

        public String getRecentChanges(Issue var1);

        public long getLastModified(Issue var1);

        public long getCreated(Issue var1);

        public String getID(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IssueEntry {
        private Issue issue;
        private Map<String, String> seenAttributes;
        private int status;
        private boolean seen = false;
        private String id;
        private long lastSeenModified = -1L;
        private int lastUnseenStatus = 0;

        IssueEntry() {
        }

        IssueEntry(Issue issue, Map<String, String> map, int n, int n2, boolean bl, long l) {
            this.issue = issue;
            this.id = issue.getID();
            this.seenAttributes = map;
            this.status = n;
            this.seen = bl;
            this.lastSeenModified = l;
            this.lastUnseenStatus = n2;
        }

        public boolean wasSeen() {
            return this.seen;
        }

        public Map<String, String> getSeenAttributes() {
            return this.seenAttributes;
        }

        public int getStatus() {
            return this.status;
        }

        public void setSeen(boolean bl) {
            this.seen = bl;
        }

        public void setSeenAttributes(Map<String, String> map) {
            this.seenAttributes = map;
        }

        public String getId() {
            return this.id;
        }

        public long getLastSeenModified() {
            return this.lastSeenModified;
        }

        public void setLastSeenModified(long l) {
            this.lastSeenModified = l;
        }

        public int getLastUnseenStatus() {
            return this.lastUnseenStatus;
        }

        public void setLastUnseenStatus(int n) {
            this.lastUnseenStatus = n;
        }
    }
}

