/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.repository;

import java.awt.Image;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.commands.BugzillaCommand;
import org.netbeans.modules.bugzilla.commands.BugzillaExecutor;
import org.netbeans.modules.bugzilla.commands.GetMultiTaskDataCommand;
import org.netbeans.modules.bugzilla.commands.PerformQueryCommand;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueProvider;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.query.QueryController;
import org.netbeans.modules.bugzilla.query.QueryParameter;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.RepositoryController;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.kenai.ui.api.NbModuleOwnerSupport;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaRepository
extends Repository {
    private static final String ICON_PATH = "org/netbeans/modules/bugtracking/ui/resources/repository.png";
    private String name;
    private TaskRepository taskRepository;
    private RepositoryController controller;
    private Set<Query> queries = null;
    private IssueCache<TaskData> cache;
    private BugzillaExecutor executor;
    private Image icon;
    private BugzillaConfiguration bc;
    private RequestProcessor refreshProcessor;
    private final Set<String> issuesToRefresh = new HashSet<String>(5);
    private final Set<BugzillaQuery> queriesToRefresh = new HashSet<BugzillaQuery>(3);
    private RequestProcessor.Task refreshIssuesTask;
    private RequestProcessor.Task refreshQueryTask;
    private String id;
    public static final String ATTRIBUTE_URL = "bugzilla.repository.attribute.url";
    public static final String ATTRIBUTE_DISPLAY_NAME = "bugzilla.repository.attribute.displayName";
    private Lookup lookup;

    public BugzillaRepository() {
        this.icon = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
    }

    public BugzillaRepository(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this(string, string2, string3, string4, string5, string6, string7, false);
    }

    public BugzillaRepository(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        this();
        this.id = string;
        this.name = string2;
        if (string4 == null) {
            string4 = "";
        }
        if (string5 == null) {
            string5 = "";
        }
        this.taskRepository = BugzillaRepository.createTaskRepository(this.name, string3, string4, string5, string6, string7, bl);
    }

    public String getID() {
        if (this.id == null) {
            this.id = this.name + System.currentTimeMillis();
        }
        return this.id;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public Query createQuery() {
        BugzillaConfiguration bugzillaConfiguration = this.getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return null;
        }
        BugzillaQuery bugzillaQuery = new BugzillaQuery(this);
        return bugzillaQuery;
    }

    public Issue createIssue() {
        BugzillaConfiguration bugzillaConfiguration = this.getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return null;
        }
        TaskAttributeMapper taskAttributeMapper = Bugzilla.getInstance().getRepositoryConnector().getTaskDataHandler().getAttributeMapper(this.taskRepository);
        TaskData taskData = new TaskData(taskAttributeMapper, this.taskRepository.getConnectorKind(), this.taskRepository.getRepositoryUrl(), "");
        return new BugzillaIssue(taskData, this);
    }

    public void remove() {
        Query[] queryArray;
        for (Query query : queryArray = this.getQueries()) {
            this.removeQuery((BugzillaQuery)query);
        }
        this.resetRepository();
        Bugzilla.getInstance().removeRepository(this);
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = Lookups.fixed((Object[])this.getLookupObjects());
        }
        return this.lookup;
    }

    protected Object[] getLookupObjects() {
        return new Object[]{this.getIssueCache()};
    }

    synchronized void resetRepository() {
        this.bc = null;
        if (this.getTaskRepository() != null) {
            Bugzilla.getInstance().getRepositoryConnector().getClientManager().repositoryRemoved(this.getTaskRepository());
        }
    }

    void setName(String string) {
        this.name = string;
    }

    public void fireQueryListChanged() {
        super.fireQueryListChanged();
    }

    protected void fireAttributesChanged(Map<String, Object> map, Map<String, Object> map2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<String, Object> object : map2.entrySet()) {
            String string = object.getKey();
            Object object2 = object.getValue();
            Object object3 = map.get(string);
            if ((object2 != null || object3 != null) && (object2 == null || !object2.equals(object3))) continue;
            linkedList.add(string);
        }
        for (String string : linkedList) {
            if (map != null) {
                map.remove(string);
            }
            map2.remove(string);
        }
        if (!map2.isEmpty()) {
            super.fireAttributesChanged(map, map2);
        }
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getTooltip() {
        return this.name + " : " + this.taskRepository.getCredentials(AuthenticationType.REPOSITORY).getUserName() + "@" + this.taskRepository.getUrl();
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getUsername() {
        AuthenticationCredentials authenticationCredentials = this.getTaskRepository().getCredentials(AuthenticationType.REPOSITORY);
        return authenticationCredentials != null ? authenticationCredentials.getUserName() : "";
    }

    public String getPassword() {
        AuthenticationCredentials authenticationCredentials = this.getTaskRepository().getCredentials(AuthenticationType.REPOSITORY);
        return authenticationCredentials != null ? authenticationCredentials.getPassword() : "";
    }

    public String getHttpUsername() {
        AuthenticationCredentials authenticationCredentials = this.getTaskRepository().getCredentials(AuthenticationType.HTTP);
        return authenticationCredentials != null ? authenticationCredentials.getUserName() : "";
    }

    public String getHttpPassword() {
        AuthenticationCredentials authenticationCredentials = this.getTaskRepository().getCredentials(AuthenticationType.HTTP);
        return authenticationCredentials != null ? authenticationCredentials.getPassword() : "";
    }

    public Issue getIssue(String string) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        TaskData taskData = BugzillaUtil.getTaskData(this, string);
        if (taskData == null) {
            return null;
        }
        try {
            return this.getIssueCache().setIssueData(string, (Object)taskData);
        }
        catch (IOException iOException) {
            Bugzilla.LOG.log(Level.SEVERE, null, iOException);
            return null;
        }
    }

    public Issue[] simpleSearch(String string) {
        Object object;
        StringBuffer stringBuffer;
        assert (this.taskRepository != null);
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        String[] stringArray = string.split(" ");
        final ArrayList<BugzillaIssue> arrayList = new ArrayList<BugzillaIssue>();
        TaskDataCollector taskDataCollector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                BugzillaIssue bugzillaIssue = new BugzillaIssue(taskData, BugzillaRepository.this);
                arrayList.add(bugzillaIssue);
            }
        };
        if (stringArray.length == 1 && this.isInteger(stringArray[0]) && (stringBuffer = BugzillaUtil.getTaskData(this, stringArray[0], false)) != null) {
            BugzillaIssue bugzillaIssue = new BugzillaIssue((TaskData)stringBuffer, this);
            arrayList.add(bugzillaIssue);
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append("/buglist.cgi?query_format=advanced&short_desc_type=allwordssubstr&short_desc=");
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i].trim();
            if (((String)object).equals("")) continue;
            try {
                object = URLEncoder.encode((String)object, this.getTaskRepository().getCharacterEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Bugzilla.LOG.log(Level.INFO, null, unsupportedEncodingException);
                try {
                    object = URLEncoder.encode((String)object, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    // empty catch block
                }
            }
            stringBuffer.append((String)object);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append("+");
        }
        QueryParameter[] queryParameterArray = this.getSimpleSearchParameters();
        for (QueryParameter queryParameter : queryParameterArray) {
            stringBuffer.append(queryParameter.get());
        }
        object = new PerformQueryCommand(this, stringBuffer.toString(), taskDataCollector);
        this.getExecutor().execute((BugzillaCommand)object);
        if (((BugzillaCommand)object).hasFailed()) {
            return new Issue[0];
        }
        return arrayList.toArray(new BugzillaIssue[arrayList.size()]);
    }

    public BugtrackingController getController() {
        if (this.controller == null) {
            this.controller = new RepositoryController(this);
        }
        return this.controller;
    }

    public Query[] getQueries() {
        Set<Query> set = this.getQueriesIntern();
        return set.toArray(new Query[set.size()]);
    }

    public IssueCache<TaskData> getIssueCache() {
        if (this.cache == null) {
            this.cache = new Cache();
        }
        return this.cache;
    }

    public void removeQuery(BugzillaQuery bugzillaQuery) {
        BugzillaConfig.getInstance().removeQuery(this, bugzillaQuery);
        this.getIssueCache().removeQuery(bugzillaQuery.getStoredQueryName());
        this.getQueriesIntern().remove((Object)bugzillaQuery);
        this.stopRefreshing(bugzillaQuery);
    }

    public void saveQuery(BugzillaQuery bugzillaQuery) {
        assert (this.id != null);
        BugzillaConfig.getInstance().putQuery(this, bugzillaQuery);
        this.getQueriesIntern().add(bugzillaQuery);
    }

    private Set<Query> getQueriesIntern() {
        if (this.queries == null) {
            String[] stringArray;
            this.queries = new HashSet<Query>(10);
            for (String string : stringArray = BugzillaConfig.getInstance().getQueries(this.id)) {
                BugzillaQuery bugzillaQuery = BugzillaConfig.getInstance().getQuery(this, string);
                if (bugzillaQuery != null) {
                    this.queries.add(bugzillaQuery);
                    continue;
                }
                Bugzilla.LOG.warning("Couldn't find query with stored name " + string);
            }
        }
        return this.queries;
    }

    protected void setTaskRepository(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        HashMap<String, Object> hashMap = this.createAttributesMap();
        this.taskRepository = BugzillaRepository.createTaskRepository(string, string2, string3, string4, string5, string6, bl);
        Bugzilla.getInstance().addRepository(this);
        this.resetRepository();
        HashMap<String, Object> hashMap2 = this.createAttributesMap();
        this.fireAttributesChanged(hashMap, hashMap2);
    }

    static TaskRepository createTaskRepository(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        TaskRepository taskRepository = new TaskRepository(Bugzilla.getInstance().getRepositoryConnector().getConnectorKind(), string2);
        AuthenticationCredentials authenticationCredentials = new AuthenticationCredentials(string3, string4);
        taskRepository.setCredentials(AuthenticationType.REPOSITORY, authenticationCredentials, false);
        if (string5 != null || string6 != null) {
            string5 = string5 != null ? string5 : "";
            string6 = string6 != null ? string6 : "";
            authenticationCredentials = new AuthenticationCredentials(string5, string6);
            taskRepository.setCredentials(AuthenticationType.HTTP, authenticationCredentials, false);
        }
        taskRepository.setProperty("bugzilla.shortLoginEnabled", bl ? "true" : "false");
        return taskRepository;
    }

    public String getUrl() {
        return this.taskRepository != null ? this.taskRepository.getUrl() : null;
    }

    private boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public BugzillaExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new BugzillaExecutor(this);
        }
        return this.executor;
    }

    public boolean authenticate(String string) {
        return BugtrackingUtil.editRepository((Repository)this, (String)string);
    }

    public boolean isShortUsernamesEnabled() {
        return this.taskRepository != null && "true".equals(this.taskRepository.getProperty("bugzilla.shortLoginEnabled"));
    }

    public Collection<RepositoryUser> getUsers() {
        return Collections.emptyList();
    }

    public NbModuleOwnerSupport.OwnerInfo getOwnerInfo(Node[] nodeArray) {
        NbModuleOwnerSupport.OwnerInfo ownerInfo;
        if (nodeArray == null || nodeArray.length == 0) {
            return null;
        }
        if (BugzillaUtil.isNbRepository(this) && nodeArray != null && nodeArray.length > 0 && (ownerInfo = NbModuleOwnerSupport.getInstance().getOwnerInfo(nodeArray[0])) != null) {
            return ownerInfo;
        }
        return null;
    }

    public synchronized BugzillaConfiguration getConfiguration() {
        if (this.bc == null) {
            this.bc = this.createConfiguration(false);
        }
        return this.bc;
    }

    public synchronized void refreshConfiguration() {
        BugzillaConfiguration bugzillaConfiguration;
        this.bc = bugzillaConfiguration = this.createConfiguration(true);
    }

    protected BugzillaConfiguration createConfiguration(boolean bl) {
        BugzillaConfiguration bugzillaConfiguration = new BugzillaConfiguration();
        bugzillaConfiguration.initialize(this, bl);
        return bugzillaConfiguration;
    }

    private void setupIssueRefreshTask() {
        if (this.refreshIssuesTask == null) {
            this.refreshIssuesTask = this.getRefreshProcessor().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    HashSet<String> hashSet;
                    Object object = BugzillaRepository.this.issuesToRefresh;
                    synchronized (object) {
                        hashSet = new HashSet<String>(BugzillaRepository.this.issuesToRefresh);
                    }
                    if (hashSet.size() == 0) {
                        Bugzilla.LOG.log(Level.FINE, "no issues to refresh {0}", new Object[]{BugzillaRepository.this.name});
                        return;
                    }
                    Bugzilla.LOG.log(Level.FINER, "preparing to refresh issue {0} - {1}", new Object[]{BugzillaRepository.this.name, hashSet});
                    object = new GetMultiTaskDataCommand(BugzillaRepository.this, hashSet, new IssuesCollector());
                    BugzillaRepository.this.getExecutor().execute((BugzillaCommand)object, false);
                    BugzillaRepository.this.scheduleIssueRefresh();
                }
            });
            this.scheduleIssueRefresh();
        }
    }

    private void setupQueryRefreshTask() {
        if (this.refreshQueryTask == null) {
            this.refreshQueryTask = this.getRefreshProcessor().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    HashSet hashSet;
                    RequestProcessor.Task task = BugzillaRepository.this.refreshQueryTask;
                    synchronized (task) {
                        hashSet = new HashSet(BugzillaRepository.this.queriesToRefresh);
                    }
                    if (hashSet.size() == 0) {
                        Bugzilla.LOG.log(Level.FINE, "no queries to refresh {0}", new Object[]{BugzillaRepository.this.name});
                        return;
                    }
                    for (BugzillaQuery bugzillaQuery : hashSet) {
                        Bugzilla.LOG.log(Level.FINER, "preparing to refresh query {0} - {1}", new Object[]{bugzillaQuery.getDisplayName(), BugzillaRepository.this.name});
                        QueryController queryController = bugzillaQuery.getController();
                        queryController.autoRefresh();
                    }
                    BugzillaRepository.this.scheduleQueryRefresh();
                }
            });
            this.scheduleQueryRefresh();
        }
    }

    private void scheduleIssueRefresh() {
        int n = BugzillaConfig.getInstance().getIssueRefreshInterval();
        Bugzilla.LOG.log(Level.FINE, "scheduling issue refresh for repository {0} in {1} minute(s)", new Object[]{this.name, n});
        if (n < 5 && System.getProperty("netbeans.t9y.bugzilla.force.refresh.delay") == null) {
            Bugzilla.LOG.log(Level.WARNING, " wrong issue refresh delay {0}. Falling back to default {0}", new Object[]{n, 15});
            n = 15;
        }
        this.refreshIssuesTask.schedule(n * 60 * 1000);
    }

    private void scheduleQueryRefresh() {
        int n = BugzillaConfig.getInstance().getQueryRefreshInterval();
        Bugzilla.LOG.log(Level.FINE, "scheduling query refresh for repository {0} in {1} minute(s)", new Object[]{this.name, n});
        if (n < 5 && System.getProperty("netbeans.t9y.bugzilla.force.refresh.delay") == null) {
            Bugzilla.LOG.log(Level.WARNING, " wrong query refresh delay {0}. Falling back to default {0}", new Object[]{n, 30});
            n = 30;
        }
        this.refreshQueryTask.schedule(n * 60 * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleForRefresh(String string) {
        Bugzilla.LOG.log(Level.FINE, "scheduling issue {0} for refresh on repository {0}", new Object[]{string, this.name});
        Set<String> set = this.issuesToRefresh;
        synchronized (set) {
            this.issuesToRefresh.add(string);
        }
        this.setupIssueRefreshTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRefreshing(String string) {
        Bugzilla.LOG.log(Level.FINE, "removing issue {0} from refresh on repository {1}", new Object[]{string, this.name});
        Set<String> set = this.issuesToRefresh;
        synchronized (set) {
            this.issuesToRefresh.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleForRefresh(BugzillaQuery bugzillaQuery) {
        Bugzilla.LOG.log(Level.FINE, "scheduling query {0} for refresh on repository {1}", new Object[]{bugzillaQuery.getDisplayName(), this.name});
        Set<BugzillaQuery> set = this.queriesToRefresh;
        synchronized (set) {
            this.queriesToRefresh.add(bugzillaQuery);
        }
        this.setupQueryRefreshTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRefreshing(BugzillaQuery bugzillaQuery) {
        Bugzilla.LOG.log(Level.FINE, "removing query {0} from refresh on repository {1}", new Object[]{bugzillaQuery.getDisplayName(), this.name});
        Set<BugzillaQuery> set = this.queriesToRefresh;
        synchronized (set) {
            this.queriesToRefresh.remove((Object)bugzillaQuery);
        }
    }

    public void refreshAllQueries() {
        Query[] queryArray;
        for (Query query : queryArray = this.getQueries()) {
            Bugzilla.LOG.log(Level.FINER, "preparing to refresh query {0} - {1}", new Object[]{query.getDisplayName(), this.name});
            QueryController queryController = ((BugzillaQuery)query).getController();
            queryController.onRefresh();
        }
    }

    private RequestProcessor getRefreshProcessor() {
        if (this.refreshProcessor == null) {
            this.refreshProcessor = new RequestProcessor("Bugzilla refresh - " + this.name);
        }
        return this.refreshProcessor;
    }

    public String toString() {
        return super.toString() + " (" + this.getDisplayName() + ')';
    }

    protected QueryParameter[] getSimpleSearchParameters() {
        return new QueryParameter[0];
    }

    private HashMap<String, Object> createAttributesMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put(ATTRIBUTE_DISPLAY_NAME, this.getDisplayName());
        hashMap.put(ATTRIBUTE_URL, this.getUrl());
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Cache
    extends IssueCache<TaskData> {
        Cache() {
            super(BugzillaRepository.this.getUrl(), (IssueCache.IssueAccessor)new IssueAccessorImpl());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IssueAccessorImpl
    implements IssueCache.IssueAccessor<TaskData> {
        private IssueAccessorImpl() {
        }

        public Issue createIssue(TaskData taskData) {
            BugzillaIssue bugzillaIssue = new BugzillaIssue(taskData, BugzillaRepository.this);
            BugzillaIssueProvider.getInstance().notifyIssueCreated(bugzillaIssue);
            return bugzillaIssue;
        }

        public void setIssueData(Issue issue, TaskData taskData) {
            assert (issue != null && taskData != null);
            ((BugzillaIssue)issue).setTaskData(taskData);
        }

        public String getRecentChanges(Issue issue) {
            assert (issue != null);
            return ((BugzillaIssue)issue).getRecentChanges();
        }

        public long getLastModified(Issue issue) {
            assert (issue != null);
            return ((BugzillaIssue)issue).getLastModify();
        }

        public long getCreated(Issue issue) {
            assert (issue != null);
            return ((BugzillaIssue)issue).getCreated();
        }

        public String getID(TaskData taskData) {
            assert (taskData != null);
            return BugzillaIssue.getID(taskData);
        }
    }

    private class IssuesCollector
    extends TaskDataCollector {
        private IssuesCollector() {
        }

        public void accept(TaskData taskData) {
            String string = BugzillaIssue.getID(taskData);
            Bugzilla.LOG.log(Level.FINE, "refreshed issue {0} - {1}", new Object[]{BugzillaRepository.this.name, string});
            try {
                BugzillaRepository.this.getIssueCache().setIssueData(string, (Object)taskData);
            }
            catch (IOException iOException) {
                Bugzilla.LOG.log(Level.SEVERE, null, iOException);
                return;
            }
        }
    }
}

