/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.util.List;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaIssueNode
extends IssueNode {
    public BugzillaIssueNode(Issue issue) {
        super(issue);
    }

    BugzillaIssue getBugzillaIssue() {
        return (BugzillaIssue)super.getIssue();
    }

    protected Node.Property<?>[] getProperties() {
        return new Node.Property[]{new IDProperty(), BugzillaUtil.isNbRepository((BugzillaRepository)this.getIssue().getRepository()) ? new IssueTypeProperty() : new SeverityProperty(), new PriorityProperty(), new StatusProperty(), new AssignedProperty(), new ResolutionProperty(), new SummaryProperty(), new IssueNode.RecentChangesProperty((IssueNode)this), new IssueNode.SeenProperty((IssueNode)this)};
    }

    public void fireDataChanged() {
        super.fireDataChanged();
    }

    private Integer getIssueTypeSortKey(String string) {
        BugzillaConfiguration bugzillaConfiguration = this.getBugzillaIssue().getBugzillaRepository().getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return null;
        }
        List<String> list = bugzillaConfiguration.getIssueTypes();
        if (list == null) {
            return null;
        }
        return list.indexOf(string);
    }

    private Integer getSeveritySortKey(String string) {
        BugzillaConfiguration bugzillaConfiguration = this.getBugzillaIssue().getBugzillaRepository().getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return null;
        }
        List<String> list = bugzillaConfiguration.getSeverities();
        if (list == null) {
            return null;
        }
        return list.indexOf(string);
    }

    private Integer getPrioritySortKey(String string) {
        BugzillaConfiguration bugzillaConfiguration = this.getBugzillaIssue().getBugzillaRepository().getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return null;
        }
        List<String> list = bugzillaConfiguration.getPriorities();
        if (list == null) {
            return null;
        }
        return list.indexOf(string);
    }

    private Integer getResolutionSortKey(String string) {
        BugzillaConfiguration bugzillaConfiguration = this.getBugzillaIssue().getBugzillaRepository().getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return null;
        }
        List<String> list = bugzillaConfiguration.getResolutions();
        if (list == null) {
            return null;
        }
        return list.indexOf(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AssignedProperty
    extends IssueNode.IssueProperty<String> {
        public AssignedProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.assigned", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Assigned_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Assigned_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.ASSIGNED_TO);
        }

        public int compareTo(IssueNode.IssueProperty issueProperty) {
            if (issueProperty == null) {
                return 1;
            }
            String string = BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.ASSIGNED_TO);
            String string2 = ((BugzillaIssue)issueProperty.getIssue()).getFieldValue(BugzillaIssue.IssueField.ASSIGNED_TO);
            return string.compareTo(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IDProperty
    extends IssueNode.IssueProperty<String> {
        public IDProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.id", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_ID_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_ID_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getID();
        }

        public int compareTo(IssueNode.IssueProperty issueProperty) {
            if (issueProperty == null) {
                return 1;
            }
            Integer n = Integer.parseInt(this.getIssue().getID());
            Integer n2 = Integer.parseInt(issueProperty.getIssue().getID());
            return n.compareTo(n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IssueTypeProperty
    extends IssueNode.IssueProperty<String> {
        public IssueTypeProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.issue_type", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Issue_Type_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Issue_Type_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.ISSUE_TYPE);
        }

        public Object getValue(String string) {
            if ("sortkey".equals(string)) {
                return BugzillaIssueNode.this.getIssueTypeSortKey(BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.ISSUE_TYPE));
            }
            return super.getValue(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PriorityProperty
    extends IssueNode.IssueProperty<String> {
        public PriorityProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.priority", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Priority_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Priority_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.PRIORITY);
        }

        public Object getValue(String string) {
            if ("sortkey".equals(string)) {
                return BugzillaIssueNode.this.getPrioritySortKey(BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.PRIORITY));
            }
            return super.getValue(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolutionProperty
    extends IssueNode.IssueProperty<String> {
        public ResolutionProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.resolution", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Resolution_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_ID_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.RESOLUTION);
        }

        public Object getValue(String string) {
            if ("sortkey".equals(string)) {
                return BugzillaIssueNode.this.getResolutionSortKey(BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.RESOLUTION));
            }
            return super.getValue(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SeverityProperty
    extends IssueNode.IssueProperty<String> {
        public SeverityProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.severity", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Severity_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Severity_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.SEVERITY);
        }

        public Object getValue(String string) {
            if ("sortkey".equals(string)) {
                return BugzillaIssueNode.this.getSeveritySortKey(BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.SEVERITY));
            }
            return super.getValue(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatusProperty
    extends IssueNode.IssueProperty<String> {
        public StatusProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.status", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Status_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Status_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.STATUS);
        }

        public int compareTo(IssueNode.IssueProperty issueProperty) {
            if (issueProperty == null) {
                return 1;
            }
            String string = BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(BugzillaIssue.IssueField.STATUS);
            String string2 = ((BugzillaIssue)issueProperty.getIssue()).getFieldValue(BugzillaIssue.IssueField.STATUS);
            return string.compareTo(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SummaryProperty
    extends IssueNode.IssueProperty<String> {
        public SummaryProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.summary", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Summary_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Summary_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getSummary();
        }

        public int compareTo(IssueNode.IssueProperty issueProperty) {
            if (issueProperty == null) {
                return 1;
            }
            String string = this.getIssue().getSummary();
            String string2 = issueProperty.getIssue().getSummary();
            return string.compareTo(string2);
        }
    }
}

