/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.autoupdate.BugzillaAutoupdate;
import org.netbeans.modules.bugzilla.commands.BugzillaCommand;
import org.netbeans.modules.bugzilla.commands.HtmlPanel;
import org.netbeans.modules.bugzilla.commands.PerformQueryCommand;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BugzillaExecutor {
    private static final String HTTP_ERROR_NOT_FOUND = "http error: not found";
    private static final String INVALID_USERNAME_OR_PASSWORD = "invalid username or password";
    private static final String REPOSITORY_LOGIN_FAILURE = "unable to login to";
    private static final String COULD_NOT_BE_FOUND = "could not be found";
    private static final String REPOSITORY = "repository";
    private static final String MIDAIR_COLLISION = "mid-air collision occurred while submitting to";
    private final BugzillaRepository repository;

    public BugzillaExecutor(BugzillaRepository bugzillaRepository) {
        this.repository = bugzillaRepository;
    }

    public void execute(BugzillaCommand bugzillaCommand) {
        this.execute(bugzillaCommand, true);
    }

    public void execute(BugzillaCommand bugzillaCommand, boolean bl) {
        this.execute(bugzillaCommand, bl, true);
    }

    public void execute(BugzillaCommand bugzillaCommand, boolean bl, boolean bl2) {
        try {
            PerformQueryCommand performQueryCommand;
            bugzillaCommand.setFailed(true);
            if (bl2) {
                this.checkAutoupdate();
            }
            bugzillaCommand.execute();
            if (bugzillaCommand instanceof PerformQueryCommand && this.handleStatus(performQueryCommand = (PerformQueryCommand)bugzillaCommand, bl)) {
                return;
            }
            bugzillaCommand.setFailed(false);
            bugzillaCommand.setErrorMessage(null);
        }
        catch (CoreException coreException) {
            Bugzilla.LOG.log(Level.FINE, null, coreException);
            ExceptionHandler exceptionHandler = ExceptionHandler.createHandler(coreException, this, this.repository);
            assert (exceptionHandler != null);
            String string = exceptionHandler.getMessage();
            bugzillaCommand.setFailed(true);
            bugzillaCommand.setErrorMessage(string);
            if (bl && exceptionHandler.handle()) {
                this.execute(bugzillaCommand);
            }
            return;
        }
        catch (MalformedURLException malformedURLException) {
            bugzillaCommand.setErrorMessage(malformedURLException.getMessage());
            Bugzilla.LOG.log(Level.SEVERE, null, malformedURLException);
        }
        catch (IOException iOException) {
            bugzillaCommand.setErrorMessage(iOException.getMessage());
            if (!bl) {
                Bugzilla.LOG.log(Level.FINE, null, iOException);
                return;
            }
            this.handleIOException(iOException);
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            if (throwable instanceof InterruptedException || !bl) {
                Bugzilla.LOG.log(Level.FINE, null, throwable);
            }
            Bugzilla.LOG.log(Level.SEVERE, null, runtimeException);
        }
    }

    private boolean handleStatus(PerformQueryCommand performQueryCommand, boolean bl) throws CoreException {
        BugzillaVersion bugzillaVersion;
        BugzillaVersion bugzillaVersion2;
        Object object;
        IStatus iStatus = performQueryCommand.getStatus();
        if (iStatus == null || iStatus.isOK()) {
            return false;
        }
        Bugzilla.LOG.log(Level.FINE, "command {0} returned status : {1}", new Object[]{performQueryCommand, iStatus.getMessage()});
        if (iStatus.getException() instanceof CoreException) {
            throw (CoreException)iStatus.getException();
        }
        boolean bl2 = false;
        String string = null;
        if (iStatus instanceof RepositoryStatus) {
            object = (RepositoryStatus)iStatus;
            string = object.getHtmlMessage();
            boolean bl3 = bl2 = string != null;
        }
        if (string == null) {
            string = iStatus.getMessage();
        }
        performQueryCommand.setErrorMessage(string);
        performQueryCommand.setFailed(true);
        if (!bl) {
            return true;
        }
        object = this.repository.getConfiguration();
        if (((BugzillaConfiguration)object).isValid() && (bugzillaVersion2 = ((BugzillaConfiguration)object).getInstalledVersion()).compareTo(bugzillaVersion = new BugzillaVersion("3.4")) >= 0) {
            boolean bl4 = BugzillaAutoupdate.getInstance().isUpdateAvailable(this.repository);
            BugzillaExecutor.notifyErrorMessage(NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_BUGZILLA_VERSION_WARNING1", (Object)bugzillaVersion2) + "\n" + (bl4 ? NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_BUGZILLA_VERSION_WARNING2") + "\n\n" : "\n") + NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_BUGZILLA_ERROR_WARNING", (Object)iStatus.getMessage()));
            return true;
        }
        if (bl2) {
            BugzillaExecutor.notifyHtmlMessage(string, this.repository);
        } else {
            BugzillaExecutor.notifyErrorMessage(NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_BUGZILLA_ERROR_WARNING", (Object)string));
        }
        return true;
    }

    static void notifyErrorMessage(String string) {
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getMessage(BugzillaExecutor.class, (String)"LBLError"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    private static boolean notifyHtmlMessage(String string, BugzillaRepository bugzillaRepository) throws MissingResourceException {
        if (string != null && !string.trim().equals("")) {
            string = BugzillaExecutor.parseHtmlMessage(string);
            HtmlPanel htmlPanel = new HtmlPanel();
            String string2 = NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_ServerResponse", (Object[])new Object[]{bugzillaRepository.getDisplayName()});
            htmlPanel.setHtml(bugzillaRepository.getUrl(), string, string2);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)htmlPanel, NbBundle.getMessage(BugzillaExecutor.class, (String)"CTL_ServerResponse"), true, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION, 0, new HelpCtx(htmlPanel.getClass()), null);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            return true;
        }
        return false;
    }

    private static String parseHtmlMessage(String string) {
        int n = string.indexOf("<div id=\"bugzilla-body\">");
        if (n < 0) {
            return string;
        }
        int n2 = n;
        int n3 = string.indexOf("</div>", n2);
        int n4 = 1;
        while ((n2 = string.indexOf("<div", n2 + 1)) >= 0 && n2 <= n3) {
            ++n4;
        }
        n3 = n;
        for (int i = 0; i < n4; ++i) {
            n3 = string.indexOf("</div>", n3 + 1);
        }
        n3 = n3 > 6 ? n3 + 6 : string.length();
        string = string.substring(n, n3);
        string = string.replaceAll("Please press \\<b\\>Back\\</b\\> and try again.", "");
        return string;
    }

    public boolean handleIOException(IOException iOException) {
        Bugzilla.LOG.log(Level.SEVERE, null, iOException);
        return true;
    }

    private void checkAutoupdate() {
        try {
            BugzillaAutoupdate.getInstance().checkAndNotify(this.repository);
        }
        catch (Throwable throwable) {
            Bugzilla.LOG.log(Level.SEVERE, "Exception in Bugzilla autoupdate check.", throwable);
        }
    }

    private static abstract class ExceptionHandler {
        protected String errroMsg;
        protected CoreException ce;
        protected BugzillaExecutor executor;
        protected BugzillaRepository repository;

        protected ExceptionHandler(CoreException coreException, String string, BugzillaExecutor bugzillaExecutor, BugzillaRepository bugzillaRepository) {
            this.errroMsg = string;
            this.ce = coreException;
            this.executor = bugzillaExecutor;
            this.repository = bugzillaRepository;
        }

        static ExceptionHandler createHandler(CoreException coreException, BugzillaExecutor bugzillaExecutor, BugzillaRepository bugzillaRepository) {
            String string = ExceptionHandler.getLoginError(coreException);
            if (string != null) {
                return new LoginHandler(coreException, string, bugzillaExecutor, bugzillaRepository);
            }
            string = ExceptionHandler.getNotFoundError(coreException);
            if (string != null) {
                return new NotFoundHandler(coreException, string, bugzillaExecutor, bugzillaRepository);
            }
            string = ExceptionHandler.getMidAirColisionError(coreException);
            if (string != null) {
                string = MessageFormat.format(string, bugzillaRepository.getDisplayName());
                return new DefaultHandler(coreException, string, bugzillaExecutor, bugzillaRepository);
            }
            return new DefaultHandler(coreException, null, bugzillaExecutor, bugzillaRepository);
        }

        abstract boolean handle();

        private static String getLoginError(CoreException coreException) {
            String string = ExceptionHandler.getMessage(coreException);
            if (string != null) {
                if (BugzillaExecutor.INVALID_USERNAME_OR_PASSWORD.equals(string = string.trim().toLowerCase()) || string.contains(BugzillaExecutor.INVALID_USERNAME_OR_PASSWORD)) {
                    return NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_INVALID_USERNAME_OR_PASSWORD");
                }
                if (string.startsWith(BugzillaExecutor.REPOSITORY_LOGIN_FAILURE) || string.startsWith(BugzillaExecutor.REPOSITORY) && string.endsWith(BugzillaExecutor.COULD_NOT_BE_FOUND)) {
                    return NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_UNABLE_LOGIN_TO_REPOSITORY");
                }
            }
            return null;
        }

        private static String getMidAirColisionError(CoreException coreException) {
            String string = ExceptionHandler.getMessage(coreException);
            if (string != null && (string = string.trim().toLowerCase()).startsWith(BugzillaExecutor.MIDAIR_COLLISION)) {
                return NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_MID-AIR_COLLISION");
            }
            return null;
        }

        private static String getNotFoundError(CoreException coreException) {
            IStatus iStatus = coreException.getStatus();
            Throwable throwable = iStatus.getException();
            if (throwable instanceof UnknownHostException) {
                return NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_HOST_NOT_FOUND");
            }
            String string = ExceptionHandler.getMessage(coreException);
            if (string != null && BugzillaExecutor.HTTP_ERROR_NOT_FOUND.equals(string = string.trim().toLowerCase())) {
                return NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_HOST_NOT_FOUND");
            }
            return null;
        }

        static String getMessage(CoreException coreException) {
            String string = coreException.getMessage();
            if (string != null && !string.trim().equals("")) {
                return string;
            }
            IStatus iStatus = coreException.getStatus();
            string = iStatus != null ? iStatus.getMessage() : null;
            return string != null ? string.trim() : null;
        }

        String getMessage() {
            return this.errroMsg;
        }

        private static void notifyError(CoreException coreException, BugzillaRepository bugzillaRepository) {
            Object object;
            String string;
            IStatus iStatus = coreException.getStatus();
            if (iStatus instanceof RepositoryStatus && BugzillaExecutor.notifyHtmlMessage(string = (object = (RepositoryStatus)iStatus).getHtmlMessage(), bugzillaRepository)) {
                return;
            }
            object = ExceptionHandler.getMessage(coreException);
            BugzillaExecutor.notifyErrorMessage((String)object);
        }

        private static class DefaultHandler
        extends ExceptionHandler {
            public DefaultHandler(CoreException coreException, String string, BugzillaExecutor bugzillaExecutor, BugzillaRepository bugzillaRepository) {
                super(coreException, string, bugzillaExecutor, bugzillaRepository);
            }

            String getMessage() {
                return this.errroMsg;
            }

            protected boolean handle() {
                if (this.errroMsg != null) {
                    BugzillaExecutor.notifyErrorMessage(this.errroMsg);
                } else {
                    ExceptionHandler.notifyError(this.ce, this.repository);
                }
                return false;
            }
        }

        private static class LoginHandler
        extends ExceptionHandler {
            public LoginHandler(CoreException coreException, String string, BugzillaExecutor bugzillaExecutor, BugzillaRepository bugzillaRepository) {
                super(coreException, string, bugzillaExecutor, bugzillaRepository);
            }

            String getMessage() {
                return this.errroMsg;
            }

            protected boolean handle() {
                boolean bl = this.repository.authenticate(this.errroMsg);
                if (!bl) {
                    BugzillaExecutor.notifyErrorMessage(NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_ActionCanceledByUser"));
                }
                return bl;
            }
        }

        private static class NotFoundHandler
        extends ExceptionHandler {
            public NotFoundHandler(CoreException coreException, String string, BugzillaExecutor bugzillaExecutor, BugzillaRepository bugzillaRepository) {
                super(coreException, string, bugzillaExecutor, bugzillaRepository);
            }

            String getMessage() {
                return this.errroMsg;
            }

            protected boolean handle() {
                boolean bl = BugtrackingUtil.editRepository((Repository)this.executor.repository, (String)this.errroMsg);
                if (!bl) {
                    BugzillaExecutor.notifyErrorMessage(NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_ActionCanceledByUser"));
                }
                return bl;
            }
        }
    }
}

