/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui.support;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.netbeans.modules.project.uiapi.ProjectOpenedTrampoline;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UILookupMergerSupport {
    private UILookupMergerSupport() {
    }

    public static LookupMerger<RecommendedTemplates> createRecommendedTemplatesMerger() {
        return new RecommendedMerger();
    }

    public static LookupMerger<PrivilegedTemplates> createPrivilegedTemplatesMerger() {
        return new PrivilegedMerger();
    }

    public static LookupMerger<ProjectOpenedHook> createProjectOpenHookMerger(ProjectOpenedHook projectOpenedHook) {
        return new OpenMerger(projectOpenedHook);
    }

    private static class OpenHookImpl
    extends ProjectOpenedHook {
        private ProjectOpenedHook defaultInstance;
        private Lookup lkp;

        OpenHookImpl(ProjectOpenedHook projectOpenedHook, Lookup lookup) {
            this.defaultInstance = projectOpenedHook;
            this.lkp = lookup;
        }

        protected void projectOpened() {
            if (this.defaultInstance != null) {
                ProjectOpenedTrampoline.DEFAULT.projectOpened(this.defaultInstance);
            }
            for (ProjectOpenedHook projectOpenedHook : this.lkp.lookupAll(ProjectOpenedHook.class)) {
                if (projectOpenedHook == this.defaultInstance) continue;
                ProjectOpenedTrampoline.DEFAULT.projectOpened(projectOpenedHook);
            }
        }

        protected void projectClosed() {
            if (this.defaultInstance != null) {
                ProjectOpenedTrampoline.DEFAULT.projectClosed(this.defaultInstance);
            }
            for (ProjectOpenedHook projectOpenedHook : this.lkp.lookupAll(ProjectOpenedHook.class)) {
                if (projectOpenedHook == this.defaultInstance) continue;
                ProjectOpenedTrampoline.DEFAULT.projectClosed(projectOpenedHook);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OpenMerger
    implements LookupMerger<ProjectOpenedHook> {
        private ProjectOpenedHook defaultInstance;

        OpenMerger(ProjectOpenedHook projectOpenedHook) {
            this.defaultInstance = projectOpenedHook;
        }

        public Class<ProjectOpenedHook> getMergeableClass() {
            return ProjectOpenedHook.class;
        }

        public ProjectOpenedHook merge(Lookup lookup) {
            return new OpenHookImpl(this.defaultInstance, lookup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivilegedMerger
    implements LookupMerger<PrivilegedTemplates> {
        private PrivilegedMerger() {
        }

        public Class<PrivilegedTemplates> getMergeableClass() {
            return PrivilegedTemplates.class;
        }

        public PrivilegedTemplates merge(Lookup lookup) {
            return new PrivilegedTemplatesImpl(lookup);
        }
    }

    private static class PrivilegedTemplatesImpl
    implements PrivilegedTemplates {
        private Lookup lkp;

        public PrivilegedTemplatesImpl(Lookup lookup) {
            this.lkp = lookup;
        }

        public String[] getPrivilegedTemplates() {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (PrivilegedTemplates privilegedTemplates : this.lkp.lookupAll(PrivilegedTemplates.class)) {
                String[] stringArray = privilegedTemplates.getPrivilegedTemplates();
                if (stringArray == null) {
                    throw new IllegalStateException(privilegedTemplates.getClass().getName() + " returns null from getPrivilegedTemplates() method.");
                }
                linkedHashSet.addAll(Arrays.asList(stringArray));
            }
            return linkedHashSet.toArray(new String[linkedHashSet.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecommendedMerger
    implements LookupMerger<RecommendedTemplates> {
        private RecommendedMerger() {
        }

        public Class<RecommendedTemplates> getMergeableClass() {
            return RecommendedTemplates.class;
        }

        public RecommendedTemplates merge(Lookup lookup) {
            return new RecommendedTemplatesImpl(lookup);
        }
    }

    private static class RecommendedTemplatesImpl
    implements RecommendedTemplates {
        private Lookup lkp;

        public RecommendedTemplatesImpl(Lookup lookup) {
            this.lkp = lookup;
        }

        public String[] getRecommendedTypes() {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (RecommendedTemplates recommendedTemplates : this.lkp.lookupAll(RecommendedTemplates.class)) {
                String[] stringArray = recommendedTemplates.getRecommendedTypes();
                if (stringArray == null) {
                    throw new IllegalStateException(recommendedTemplates.getClass().getName() + " returns null from getRecommendedTemplates() method.");
                }
                linkedHashSet.addAll(Arrays.asList(stringArray));
            }
            return linkedHashSet.toArray(new String[linkedHashSet.size()]);
        }
    }
}

