/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.nb.javascript.BaseFunction;
import org.mozilla.nb.javascript.Callable;
import org.mozilla.nb.javascript.CompilerEnvirons;
import org.mozilla.nb.javascript.ConstProperties;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.EcmaError;
import org.mozilla.nb.javascript.Evaluator;
import org.mozilla.nb.javascript.EvaluatorException;
import org.mozilla.nb.javascript.Function;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.IdFunctionObject;
import org.mozilla.nb.javascript.InterpretedFunction;
import org.mozilla.nb.javascript.InterpreterData;
import org.mozilla.nb.javascript.JavaScriptException;
import org.mozilla.nb.javascript.Kit;
import org.mozilla.nb.javascript.NativeContinuation;
import org.mozilla.nb.javascript.NativeGenerator;
import org.mozilla.nb.javascript.NativeIterator;
import org.mozilla.nb.javascript.NativeWith;
import org.mozilla.nb.javascript.Node;
import org.mozilla.nb.javascript.NodeTransformer;
import org.mozilla.nb.javascript.ObjArray;
import org.mozilla.nb.javascript.ObjToIntMap;
import org.mozilla.nb.javascript.Ref;
import org.mozilla.nb.javascript.RegExpProxy;
import org.mozilla.nb.javascript.RhinoException;
import org.mozilla.nb.javascript.Script;
import org.mozilla.nb.javascript.ScriptOrFnNode;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.ScriptableObject;
import org.mozilla.nb.javascript.SecurityUtilities;
import org.mozilla.nb.javascript.UintMap;
import org.mozilla.nb.javascript.Undefined;
import org.mozilla.nb.javascript.UniqueTag;
import org.mozilla.nb.javascript.debug.DebugFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter
implements Evaluator {
    private static final int Icode_DUP = -1;
    private static final int Icode_DUP2 = -2;
    private static final int Icode_SWAP = -3;
    private static final int Icode_POP = -4;
    private static final int Icode_POP_RESULT = -5;
    private static final int Icode_IFEQ_POP = -6;
    private static final int Icode_VAR_INC_DEC = -7;
    private static final int Icode_NAME_INC_DEC = -8;
    private static final int Icode_PROP_INC_DEC = -9;
    private static final int Icode_ELEM_INC_DEC = -10;
    private static final int Icode_REF_INC_DEC = -11;
    private static final int Icode_SCOPE_LOAD = -12;
    private static final int Icode_SCOPE_SAVE = -13;
    private static final int Icode_TYPEOFNAME = -14;
    private static final int Icode_NAME_AND_THIS = -15;
    private static final int Icode_PROP_AND_THIS = -16;
    private static final int Icode_ELEM_AND_THIS = -17;
    private static final int Icode_VALUE_AND_THIS = -18;
    private static final int Icode_CLOSURE_EXPR = -19;
    private static final int Icode_CLOSURE_STMT = -20;
    private static final int Icode_CALLSPECIAL = -21;
    private static final int Icode_RETUNDEF = -22;
    private static final int Icode_GOSUB = -23;
    private static final int Icode_STARTSUB = -24;
    private static final int Icode_RETSUB = -25;
    private static final int Icode_LINE = -26;
    private static final int Icode_SHORTNUMBER = -27;
    private static final int Icode_INTNUMBER = -28;
    private static final int Icode_LITERAL_NEW = -29;
    private static final int Icode_LITERAL_SET = -30;
    private static final int Icode_SPARE_ARRAYLIT = -31;
    private static final int Icode_REG_IND_C0 = -32;
    private static final int Icode_REG_IND_C1 = -33;
    private static final int Icode_REG_IND_C2 = -34;
    private static final int Icode_REG_IND_C3 = -35;
    private static final int Icode_REG_IND_C4 = -36;
    private static final int Icode_REG_IND_C5 = -37;
    private static final int Icode_REG_IND1 = -38;
    private static final int Icode_REG_IND2 = -39;
    private static final int Icode_REG_IND4 = -40;
    private static final int Icode_REG_STR_C0 = -41;
    private static final int Icode_REG_STR_C1 = -42;
    private static final int Icode_REG_STR_C2 = -43;
    private static final int Icode_REG_STR_C3 = -44;
    private static final int Icode_REG_STR1 = -45;
    private static final int Icode_REG_STR2 = -46;
    private static final int Icode_REG_STR4 = -47;
    private static final int Icode_GETVAR1 = -48;
    private static final int Icode_SETVAR1 = -49;
    private static final int Icode_UNDEF = -50;
    private static final int Icode_ZERO = -51;
    private static final int Icode_ONE = -52;
    private static final int Icode_ENTERDQ = -53;
    private static final int Icode_LEAVEDQ = -54;
    private static final int Icode_TAIL_CALL = -55;
    private static final int Icode_LOCAL_CLEAR = -56;
    private static final int Icode_LITERAL_GETTER = -57;
    private static final int Icode_LITERAL_SETTER = -58;
    private static final int Icode_SETCONST = -59;
    private static final int Icode_SETCONSTVAR = -60;
    private static final int Icode_SETCONSTVAR1 = -61;
    private static final int Icode_GENERATOR = -62;
    private static final int Icode_GENERATOR_END = -63;
    private static final int Icode_DEBUGGER = -64;
    private static final int MIN_ICODE = -64;
    private CompilerEnvirons compilerEnv;
    private boolean itsInFunctionFlag;
    private boolean itsInTryFlag;
    private InterpreterData itsData;
    private ScriptOrFnNode scriptOrFn;
    private int itsICodeTop;
    private int itsStackDepth;
    private int itsLineNumber;
    private int itsDoubleTableTop;
    private ObjToIntMap itsStrings = new ObjToIntMap(20);
    private int itsLocalTop;
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private int[] itsLabelTable;
    private int itsLabelTableTop;
    private long[] itsFixupTable;
    private int itsFixupTableTop;
    private ObjArray itsLiteralIds = new ObjArray();
    private int itsExceptionTableTop;
    private static final int EXCEPTION_TRY_START_SLOT = 0;
    private static final int EXCEPTION_TRY_END_SLOT = 1;
    private static final int EXCEPTION_HANDLER_SLOT = 2;
    private static final int EXCEPTION_TYPE_SLOT = 3;
    private static final int EXCEPTION_LOCAL_SLOT = 4;
    private static final int EXCEPTION_SCOPE_SLOT = 5;
    private static final int EXCEPTION_SLOT_SIZE = 6;
    private static final int ECF_TAIL = 1;

    private static CallFrame captureFrameForGenerator(CallFrame callFrame) {
        callFrame.frozen = true;
        CallFrame callFrame2 = callFrame.cloneFrozen();
        callFrame.frozen = false;
        callFrame2.parentFrame = null;
        callFrame2.frameIndex = 0;
        return callFrame2;
    }

    private static String bytecodeName(int n) {
        if (!Interpreter.validBytecode(n)) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return String.valueOf(n);
    }

    private static boolean validIcode(int n) {
        return -64 <= n && n <= -1;
    }

    private static boolean validTokenCode(int n) {
        return 2 <= n && n <= 79;
    }

    private static boolean validBytecode(int n) {
        return Interpreter.validIcode(n) || Interpreter.validTokenCode(n);
    }

    @Override
    public Object compile(CompilerEnvirons compilerEnvirons, ScriptOrFnNode scriptOrFnNode, String string, boolean bl) {
        this.compilerEnv = compilerEnvirons;
        new NodeTransformer().transform(scriptOrFnNode);
        if (bl) {
            scriptOrFnNode = scriptOrFnNode.getFunctionNode(0);
        }
        this.scriptOrFn = scriptOrFnNode;
        this.itsData = new InterpreterData(compilerEnvirons.getLanguageVersion(), this.scriptOrFn.getSourceName(), string);
        this.itsData.topLevel = true;
        if (bl) {
            this.generateFunctionICode();
        } else {
            this.generateICodeFromTree(this.scriptOrFn);
        }
        return this.itsData;
    }

    @Override
    public Script createScriptObject(Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createScript(this.itsData, object2);
    }

    @Override
    public void setEvalScriptFlag(Script script) {
        ((InterpretedFunction)script).idata.evalScriptFlag = true;
    }

    @Override
    public Function createFunctionObject(Context context, Scriptable scriptable, Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createFunction(context, scriptable, this.itsData, object2);
    }

    private void generateFunctionICode() {
        this.itsInFunctionFlag = true;
        FunctionNode functionNode = (FunctionNode)this.scriptOrFn;
        this.itsData.itsFunctionType = functionNode.getFunctionType();
        this.itsData.itsNeedsActivation = functionNode.requiresActivation();
        this.itsData.itsName = functionNode.getFunctionName();
        if (!functionNode.getIgnoreDynamicScope() && this.compilerEnv.isUseDynamicScope()) {
            this.itsData.useDynamicScope = true;
        }
        if (functionNode.isGenerator()) {
            this.addIcode(-62);
            this.addUint16(functionNode.getBaseLineno() & 0xFFFF);
        }
        this.generateICodeFromTree(functionNode.getLastChild());
    }

    private void generateICodeFromTree(Node node) {
        Object object;
        this.generateNestedFunctions();
        this.generateRegExpLiterals();
        this.visitStatement(node, 0);
        this.fixLabelGotos();
        if (this.itsData.itsFunctionType == 0) {
            this.addToken(64);
        }
        if (this.itsData.itsICode.length != this.itsICodeTop) {
            object = new byte[this.itsICodeTop];
            System.arraycopy(this.itsData.itsICode, 0, object, 0, this.itsICodeTop);
            this.itsData.itsICode = object;
        }
        if (this.itsStrings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.itsStrings.size()];
            object = this.itsStrings.newIterator();
            ((ObjToIntMap.Iterator)object).start();
            while (!((ObjToIntMap.Iterator)object).done()) {
                String string = (String)((ObjToIntMap.Iterator)object).getKey();
                int n = ((ObjToIntMap.Iterator)object).getValue();
                if (this.itsData.itsStringTable[n] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsStringTable[n] = string;
                ((ObjToIntMap.Iterator)object).next();
            }
        }
        if (this.itsDoubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else if (this.itsData.itsDoubleTable.length != this.itsDoubleTableTop) {
            object = new double[this.itsDoubleTableTop];
            System.arraycopy(this.itsData.itsDoubleTable, 0, object, 0, this.itsDoubleTableTop);
            this.itsData.itsDoubleTable = (double[])object;
        }
        if (this.itsExceptionTableTop != 0 && this.itsData.itsExceptionTable.length != this.itsExceptionTableTop) {
            object = new int[this.itsExceptionTableTop];
            System.arraycopy(this.itsData.itsExceptionTable, 0, object, 0, this.itsExceptionTableTop);
            this.itsData.itsExceptionTable = (int[])object;
        }
        this.itsData.itsMaxVars = this.scriptOrFn.getParamAndVarCount();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxStack;
        this.itsData.argNames = this.scriptOrFn.getParamAndVarNames();
        this.itsData.argIsConst = this.scriptOrFn.getParamAndVarConst();
        this.itsData.argCount = this.scriptOrFn.getParamCount();
        this.itsData.encodedSourceStart = this.scriptOrFn.getEncodedSourceStart();
        this.itsData.encodedSourceEnd = this.scriptOrFn.getEncodedSourceEnd();
        if (this.itsLiteralIds.size() != 0) {
            this.itsData.literalIds = this.itsLiteralIds.toArray();
        }
    }

    private void generateNestedFunctions() {
        int n = this.scriptOrFn.getFunctionCount();
        if (n == 0) {
            return;
        }
        InterpreterData[] interpreterDataArray = new InterpreterData[n];
        for (int i = 0; i != n; ++i) {
            FunctionNode functionNode = this.scriptOrFn.getFunctionNode(i);
            Interpreter interpreter = new Interpreter();
            interpreter.compilerEnv = this.compilerEnv;
            interpreter.scriptOrFn = functionNode;
            interpreter.itsData = new InterpreterData(this.itsData);
            interpreter.generateFunctionICode();
            interpreterDataArray[i] = interpreter.itsData;
        }
        this.itsData.itsNestedFunctions = interpreterDataArray;
    }

    private void generateRegExpLiterals() {
        int n = this.scriptOrFn.getRegexpCount();
        if (n == 0) {
            return;
        }
        Context context = Context.getContext();
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(context);
        Object[] objectArray = new Object[n];
        for (int i = 0; i != n; ++i) {
            String string = this.scriptOrFn.getRegexpString(i);
            String string2 = this.scriptOrFn.getRegexpFlags(i);
            objectArray[i] = regExpProxy.compileRegExp(context, string, string2);
        }
        this.itsData.itsRegExpLiterals = objectArray;
    }

    private void updateLineNumber(Node node) {
        int n = node.getLineno();
        if (n != this.itsLineNumber && n >= 0) {
            if (this.itsData.firstLinePC < 0) {
                this.itsData.firstLinePC = n;
            }
            this.itsLineNumber = n;
            this.addIcode(-26);
            this.addUint16(n & 0xFFFF);
        }
    }

    private RuntimeException badTree(Node node) {
        throw new RuntimeException(node.toString());
    }

    private void visitStatement(Node node, int n) {
        int n2 = node.getType();
        switch (n2) {
            case 108: {
                int n3 = node.getExistingIntProp(1);
                int n4 = this.scriptOrFn.getFunctionNode(n3).getFunctionType();
                if (n4 == 3) {
                    this.addIndexOp(-20, n3);
                } else if (n4 != 1) {
                    throw Kit.codeBug();
                }
                if (this.itsInFunctionFlag) break;
                this.addIndexOp(-19, n3);
                this.stackChange(1);
                this.addIcode(-5);
                this.stackChange(-1);
                break;
            }
            case 122: 
            case 127: 
            case 128: 
            case 129: 
            case 131: {
                this.updateLineNumber(node);
            }
            case 135: {
                Node node2;
                while (node2 != null) {
                    this.visitStatement(node2, n);
                    node2 = node2.getNext();
                }
                break;
            }
            case 2: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(2);
                this.stackChange(-1);
                break;
            }
            case 3: {
                this.addToken(3);
                break;
            }
            case 140: {
                Node node2;
                int n5 = this.allocLocal();
                node.putIntProp(2, n5);
                this.updateLineNumber(node);
                for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    this.visitStatement(node2, n);
                }
                this.addIndexOp(-56, n5);
                this.releaseLocal(n5);
                break;
            }
            case 159: {
                this.addIcode(-64);
                break;
            }
            case 113: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                for (Node.Jump jump = (Node.Jump)node2.getNext(); jump != null; jump = (Node.Jump)jump.getNext()) {
                    if (jump.getType() != 114) {
                        throw this.badTree(jump);
                    }
                    Node node3 = jump.getFirstChild();
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.visitExpression(node3, 0);
                    this.addToken(46);
                    this.stackChange(-1);
                    this.addGoto(jump.target, -6);
                    this.stackChange(-1);
                }
                this.addIcode(-4);
                this.stackChange(-1);
                break;
            }
            case 130: {
                this.markTargetLabel(node);
                break;
            }
            case 6: 
            case 7: {
                Node node2;
                Node node4 = ((Node.Jump)node).target;
                this.visitExpression(node2, 0);
                this.addGoto(node4, n2);
                this.stackChange(-1);
                break;
            }
            case 5: {
                Node node5 = ((Node.Jump)node).target;
                this.addGoto(node5, n2);
                break;
            }
            case 134: {
                Node node6 = ((Node.Jump)node).target;
                this.addGoto(node6, -23);
                break;
            }
            case 124: {
                Node node2;
                this.stackChange(1);
                int n6 = this.getLocalBlockRef(node);
                this.addIndexOp(-24, n6);
                this.stackChange(-1);
                while (node2 != null) {
                    this.visitStatement(node2, n);
                    node2 = node2.getNext();
                }
                this.addIndexOp(-25, n6);
                break;
            }
            case 132: 
            case 133: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addIcode(n2 == 132 ? -4 : -5);
                this.stackChange(-1);
                break;
            }
            case 80: {
                Node node7;
                Node node2;
                Node.Jump jump = (Node.Jump)node;
                int n7 = this.getLocalBlockRef(jump);
                int n8 = this.allocLocal();
                this.addIndexOp(-13, n8);
                int n9 = this.itsICodeTop;
                boolean bl = this.itsInTryFlag;
                this.itsInTryFlag = true;
                while (node2 != null) {
                    this.visitStatement(node2, n);
                    node2 = node2.getNext();
                }
                this.itsInTryFlag = bl;
                Node node8 = jump.target;
                if (node8 != null) {
                    int n10 = this.itsLabelTable[this.getTargetLabel(node8)];
                    this.addExceptionHandler(n9, n10, n10, false, n7, n8);
                }
                if ((node7 = jump.getFinally()) != null) {
                    int n11 = this.itsLabelTable[this.getTargetLabel(node7)];
                    this.addExceptionHandler(n9, n11, n11, true, n7, n8);
                }
                this.addIndexOp(-56, n8);
                this.releaseLocal(n8);
                break;
            }
            case 57: {
                Node node2;
                int n12 = this.getLocalBlockRef(node);
                int n13 = node.getExistingIntProp(14);
                String string = node2.getString();
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringPrefix(string);
                this.addIndexPrefix(n12);
                this.addToken(57);
                this.addUint8(n13 != 0 ? 1 : 0);
                this.stackChange(-1);
                break;
            }
            case 50: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addToken(50);
                this.addUint16(this.itsLineNumber & 0xFFFF);
                this.stackChange(-1);
                break;
            }
            case 51: {
                this.updateLineNumber(node);
                this.addIndexOp(51, this.getLocalBlockRef(node));
                break;
            }
            case 4: {
                Node node2;
                this.updateLineNumber(node);
                if (node.getIntProp(20, 0) != 0) {
                    this.addIcode(-63);
                    this.addUint16(this.itsLineNumber & 0xFFFF);
                    break;
                }
                if (node2 != null) {
                    this.visitExpression(node2, 1);
                    this.addToken(4);
                    this.stackChange(-1);
                    break;
                }
                this.addIcode(-22);
                break;
            }
            case 64: {
                this.updateLineNumber(node);
                this.addToken(64);
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addIndexOp(n2, this.getLocalBlockRef(node));
                this.stackChange(-1);
                break;
            }
            case -62: {
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
        if (this.itsStackDepth != n) {
            throw Kit.codeBug();
        }
    }

    private void visitExpression(Node node, int n) {
        int n2 = node.getType();
        int n3 = this.itsStackDepth;
        switch (n2) {
            case 108: {
                int n4 = node.getExistingIntProp(1);
                FunctionNode functionNode = this.scriptOrFn.getFunctionNode(n4);
                if (functionNode.getFunctionType() != 2) {
                    throw Kit.codeBug();
                }
                this.addIndexOp(-19, n4);
                this.stackChange(1);
                break;
            }
            case 54: {
                int n5 = this.getLocalBlockRef(node);
                this.addIndexOp(54, n5);
                this.stackChange(1);
                break;
            }
            case 88: {
                Node node2;
                Node node3 = node.getLastChild();
                for (node2 = node.getFirstChild(); node2 != node3; node2 = node2.getNext()) {
                    this.visitExpression(node2, 0);
                    this.addIcode(-4);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, n & 1);
                break;
            }
            case 137: {
                this.stackChange(1);
                break;
            }
            case 30: 
            case 38: 
            case 70: {
                Node node2;
                if (n2 == 30) {
                    this.visitExpression(node2, 0);
                } else {
                    this.generateCallFunAndThis(node2);
                }
                int n6 = 0;
                while ((node2 = node2.getNext()) != null) {
                    this.visitExpression(node2, 0);
                    ++n6;
                }
                int n7 = node.getIntProp(10, 0);
                if (n7 != 0) {
                    this.addIndexOp(-21, n6);
                    this.addUint8(n7);
                    this.addUint8(n2 == 30 ? 1 : 0);
                    this.addUint16(this.itsLineNumber & 0xFFFF);
                } else {
                    if (n2 == 38 && (n & 1) != 0 && !this.compilerEnv.isGenerateDebugInfo() && !this.itsInTryFlag) {
                        n2 = -55;
                    }
                    this.addIndexOp(n2, n6);
                }
                if (n2 == 30) {
                    this.stackChange(-n6);
                } else {
                    this.stackChange(-1 - n6);
                }
                if (n6 <= this.itsData.itsMaxCalleeArgs) break;
                this.itsData.itsMaxCalleeArgs = n6;
                break;
            }
            case 103: 
            case 104: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addIcode(-1);
                this.stackChange(1);
                int n8 = this.itsICodeTop;
                int n9 = n2 == 104 ? 7 : 6;
                this.addGotoOp(n9);
                this.stackChange(-1);
                this.addIcode(-4);
                this.stackChange(-1);
                node2 = node2.getNext();
                this.visitExpression(node2, n & 1);
                this.resolveForwardGoto(n8);
                break;
            }
            case 101: {
                Node node2;
                Node node4 = node2.getNext();
                Node node5 = node4.getNext();
                this.visitExpression(node2, 0);
                int n10 = this.itsICodeTop;
                this.addGotoOp(7);
                this.stackChange(-1);
                this.visitExpression(node4, n & 1);
                int n11 = this.itsICodeTop;
                this.addGotoOp(5);
                this.resolveForwardGoto(n10);
                this.itsStackDepth = n3;
                this.visitExpression(node5, n & 1);
                this.resolveForwardGoto(n11);
                break;
            }
            case 33: 
            case 34: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.addStringOp(n2, node2.getString());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 36: 
            case 46: 
            case 47: 
            case 52: 
            case 53: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addToken(n2);
                this.stackChange(-1);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 125: {
                Node node2;
                this.visitExpression(node2, 0);
                if (n2 == 125) {
                    this.addIcode(-4);
                    this.addIcode(-50);
                    break;
                }
                this.addToken(n2);
                break;
            }
            case 67: 
            case 69: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(n2);
                break;
            }
            case 35: 
            case 138: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                String string = node2.getString();
                node2 = node2.getNext();
                if (n2 == 138) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addStringOp(33, string);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addStringOp(35, string);
                this.stackChange(-1);
                break;
            }
            case 37: 
            case 139: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                if (n2 == 139) {
                    this.addIcode(-2);
                    this.stackChange(2);
                    this.addToken(36);
                    this.stackChange(-1);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addToken(37);
                this.stackChange(-2);
                break;
            }
            case 68: 
            case 141: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                if (n2 == 141) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addToken(67);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addToken(68);
                this.stackChange(-1);
                break;
            }
            case 8: {
                Node node2;
                String string = node2.getString();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringOp(8, string);
                this.stackChange(-1);
                break;
            }
            case 154: {
                Node node2;
                String string = node2.getString();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringOp(-59, string);
                this.stackChange(-1);
                break;
            }
            case 136: {
                int n12 = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    n12 = this.scriptOrFn.getIndexForNameNode(node);
                }
                if (n12 == -1) {
                    this.addStringOp(-14, node.getString());
                    this.stackChange(1);
                    break;
                }
                this.addVarOp(55, n12);
                this.stackChange(1);
                this.addToken(32);
                break;
            }
            case 39: 
            case 41: 
            case 49: {
                this.addStringOp(n2, node.getString());
                this.stackChange(1);
                break;
            }
            case 105: 
            case 106: {
                Node node2;
                this.visitIncDec(node, node2);
                break;
            }
            case 40: {
                double d = node.getDouble();
                int n13 = (int)d;
                if ((double)n13 == d) {
                    if (n13 == 0) {
                        this.addIcode(-51);
                        if (1.0 / d < 0.0) {
                            this.addToken(29);
                        }
                    } else if (n13 == 1) {
                        this.addIcode(-52);
                    } else if ((short)n13 == n13) {
                        this.addIcode(-27);
                        this.addUint16(n13 & 0xFFFF);
                    } else {
                        this.addIcode(-28);
                        this.addInt(n13);
                    }
                } else {
                    int n14 = this.getDoubleIndex(d);
                    this.addIndexOp(40, n14);
                }
                this.stackChange(1);
                break;
            }
            case 55: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n15 = this.scriptOrFn.getIndexForNameNode(node);
                this.addVarOp(55, n15);
                this.stackChange(1);
                break;
            }
            case 56: {
                Node node2;
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n16 = this.scriptOrFn.getIndexForNameNode(node2);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addVarOp(56, n16);
                break;
            }
            case 155: {
                Node node2;
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n17 = this.scriptOrFn.getIndexForNameNode(node2);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addVarOp(155, n17);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 63: {
                this.addToken(n2);
                this.stackChange(1);
                break;
            }
            case 61: 
            case 62: {
                this.addIndexOp(n2, this.getLocalBlockRef(node));
                this.stackChange(1);
                break;
            }
            case 48: {
                int n18 = node.getExistingIntProp(4);
                this.addIndexOp(48, n18);
                this.stackChange(1);
                break;
            }
            case 65: 
            case 66: {
                Node node2;
                this.visitLiteral(node, node2);
                break;
            }
            case 156: {
                Node node2;
                this.visitArrayComprehension(node, node2, node2.getNext());
                break;
            }
            case 71: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addStringOp(n2, (String)node.getProp(17));
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                Node node2;
                int n19 = node.getIntProp(16, 0);
                int n20 = 0;
                do {
                    this.visitExpression(node2, 0);
                    ++n20;
                } while ((node2 = node2.getNext()) != null);
                this.addIndexOp(n2, n19);
                this.stackChange(1 - n20);
                break;
            }
            case 145: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addIcode(-53);
                this.stackChange(-1);
                int n21 = this.itsICodeTop;
                this.visitExpression(node2.getNext(), 0);
                this.addBackwardGoto(-54, n21);
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(n2);
                break;
            }
            case 72: {
                Node node2;
                if (node2 != null) {
                    this.visitExpression(node2, 0);
                } else {
                    this.addIcode(-50);
                    this.stackChange(1);
                }
                this.addToken(72);
                this.addUint16(node.getLineno() & 0xFFFF);
                break;
            }
            case 158: {
                Node node6 = node.getFirstChild();
                Node node7 = node6.getNext();
                this.visitExpression(node6.getFirstChild(), 0);
                this.addToken(2);
                this.stackChange(-1);
                this.visitExpression(node7.getFirstChild(), 0);
                this.addToken(3);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
        if (n3 + 1 != this.itsStackDepth) {
            Kit.codeBug();
        }
    }

    private void generateCallFunAndThis(Node node) {
        int n = node.getType();
        switch (n) {
            case 39: {
                String string = node.getString();
                this.addStringOp(-15, string);
                this.stackChange(2);
                break;
            }
            case 33: 
            case 36: {
                Node node2 = node.getFirstChild();
                this.visitExpression(node2, 0);
                Node node3 = node2.getNext();
                if (n == 33) {
                    String string = node3.getString();
                    this.addStringOp(-16, string);
                    this.stackChange(1);
                    break;
                }
                this.visitExpression(node3, 0);
                this.addIcode(-17);
                break;
            }
            default: {
                this.visitExpression(node, 0);
                this.addIcode(-18);
                this.stackChange(1);
            }
        }
    }

    private void visitIncDec(Node node, Node node2) {
        int n = node.getExistingIntProp(13);
        int n2 = node2.getType();
        switch (n2) {
            case 55: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n3 = this.scriptOrFn.getIndexForNameNode(node2);
                this.addVarOp(-7, n3);
                this.addUint8(n);
                this.stackChange(1);
                break;
            }
            case 39: {
                String string = node2.getString();
                this.addStringOp(-8, string);
                this.addUint8(n);
                this.stackChange(1);
                break;
            }
            case 33: {
                Node node3 = node2.getFirstChild();
                this.visitExpression(node3, 0);
                String string = node3.getNext().getString();
                this.addStringOp(-9, string);
                this.addUint8(n);
                break;
            }
            case 36: {
                Node node4 = node2.getFirstChild();
                this.visitExpression(node4, 0);
                Node node5 = node4.getNext();
                this.visitExpression(node5, 0);
                this.addIcode(-10);
                this.addUint8(n);
                this.stackChange(-1);
                break;
            }
            case 67: {
                Node node6 = node2.getFirstChild();
                this.visitExpression(node6, 0);
                this.addIcode(-11);
                this.addUint8(n);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
    }

    private void visitLiteral(Node node, Node node2) {
        Object object;
        int n;
        int n2 = node.getType();
        Object[] objectArray = null;
        if (n2 == 65) {
            n = 0;
            for (object = node2; object != null; object = ((Node)object).getNext()) {
                ++n;
            }
        } else if (n2 == 66) {
            objectArray = (Object[])node.getProp(12);
            n = objectArray.length;
        } else {
            throw this.badTree(node);
        }
        this.addIndexOp(-29, n);
        this.stackChange(2);
        while (node2 != null) {
            int n3 = node2.getType();
            if (n3 == 150) {
                this.visitExpression(node2.getFirstChild(), 0);
                this.addIcode(-57);
            } else if (n3 == 151) {
                this.visitExpression(node2.getFirstChild(), 0);
                this.addIcode(-58);
            } else {
                this.visitExpression(node2, 0);
                this.addIcode(-30);
            }
            this.stackChange(-1);
            node2 = node2.getNext();
        }
        if (n2 == 65) {
            object = (int[])node.getProp(11);
            if (object == null) {
                this.addToken(65);
            } else {
                int n4 = this.itsLiteralIds.size();
                this.itsLiteralIds.add(object);
                this.addIndexOp(-31, n4);
            }
        } else {
            int n5 = this.itsLiteralIds.size();
            this.itsLiteralIds.add(objectArray);
            this.addIndexOp(66, n5);
        }
        this.stackChange(-1);
    }

    private void visitArrayComprehension(Node node, Node node2, Node node3) {
        this.visitStatement(node2, this.itsStackDepth);
        this.visitExpression(node3, 0);
    }

    private int getLocalBlockRef(Node node) {
        Node node2 = (Node)node.getProp(3);
        return node2.getExistingIntProp(2);
    }

    private int getTargetLabel(Node node) {
        int n = node.labelId();
        if (n != -1) {
            return n;
        }
        n = this.itsLabelTableTop;
        if (this.itsLabelTable == null || n == this.itsLabelTable.length) {
            if (this.itsLabelTable == null) {
                this.itsLabelTable = new int[32];
            } else {
                int[] nArray = new int[this.itsLabelTable.length * 2];
                System.arraycopy(this.itsLabelTable, 0, nArray, 0, n);
                this.itsLabelTable = nArray;
            }
        }
        this.itsLabelTableTop = n + 1;
        this.itsLabelTable[n] = -1;
        node.labelId(n);
        return n;
    }

    private void markTargetLabel(Node node) {
        int n = this.getTargetLabel(node);
        if (this.itsLabelTable[n] != -1) {
            Kit.codeBug();
        }
        this.itsLabelTable[n] = this.itsICodeTop;
    }

    private void addGoto(Node node, int n) {
        int n2;
        int n3 = this.getTargetLabel(node);
        if (n3 >= this.itsLabelTableTop) {
            Kit.codeBug();
        }
        if ((n2 = this.itsLabelTable[n3]) != -1) {
            this.addBackwardGoto(n, n2);
        } else {
            int n4 = this.itsICodeTop;
            this.addGotoOp(n);
            int n5 = this.itsFixupTableTop;
            if (this.itsFixupTable == null || n5 == this.itsFixupTable.length) {
                if (this.itsFixupTable == null) {
                    this.itsFixupTable = new long[40];
                } else {
                    long[] lArray = new long[this.itsFixupTable.length * 2];
                    System.arraycopy(this.itsFixupTable, 0, lArray, 0, n5);
                    this.itsFixupTable = lArray;
                }
            }
            this.itsFixupTableTop = n5 + 1;
            this.itsFixupTable[n5] = (long)n3 << 32 | (long)n4;
        }
    }

    private void fixLabelGotos() {
        for (int i = 0; i < this.itsFixupTableTop; ++i) {
            long l = this.itsFixupTable[i];
            int n = (int)(l >> 32);
            int n2 = (int)l;
            int n3 = this.itsLabelTable[n];
            if (n3 == -1) {
                throw Kit.codeBug();
            }
            this.resolveGoto(n2, n3);
        }
        this.itsFixupTableTop = 0;
    }

    private void addBackwardGoto(int n, int n2) {
        int n3 = this.itsICodeTop;
        if (n3 <= n2) {
            throw Kit.codeBug();
        }
        this.addGotoOp(n);
        this.resolveGoto(n3, n2);
    }

    private void resolveForwardGoto(int n) {
        if (this.itsICodeTop < n + 3) {
            throw Kit.codeBug();
        }
        this.resolveGoto(n, this.itsICodeTop);
    }

    private void resolveGoto(int n, int n2) {
        int n3 = n2 - n;
        if (0 <= n3 && n3 <= 2) {
            throw Kit.codeBug();
        }
        int n4 = n + 1;
        if (n3 != (short)n3) {
            if (this.itsData.longJumps == null) {
                this.itsData.longJumps = new UintMap();
            }
            this.itsData.longJumps.put(n4, n2);
            n3 = 0;
        }
        byte[] byArray = this.itsData.itsICode;
        byArray[n4] = (byte)(n3 >> 8);
        byArray[n4 + 1] = (byte)n3;
    }

    private void addToken(int n) {
        if (!Interpreter.validTokenCode(n)) {
            throw Kit.codeBug();
        }
        this.addUint8(n);
    }

    private void addIcode(int n) {
        if (!Interpreter.validIcode(n)) {
            throw Kit.codeBug();
        }
        this.addUint8(n & 0xFF);
    }

    private void addUint8(int n) {
        if ((n & 0xFFFFFF00) != 0) {
            throw Kit.codeBug();
        }
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 == byArray.length) {
            byArray = this.increaseICodeCapacity(1);
        }
        byArray[n2] = (byte)n;
        this.itsICodeTop = n2 + 1;
    }

    private void addUint16(int n) {
        if ((n & 0xFFFF0000) != 0) {
            throw Kit.codeBug();
        }
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 2 > byArray.length) {
            byArray = this.increaseICodeCapacity(2);
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        this.itsICodeTop = n2 + 2;
    }

    private void addInt(int n) {
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 4 > byArray.length) {
            byArray = this.increaseICodeCapacity(4);
        }
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
        this.itsICodeTop = n2 + 4;
    }

    private int getDoubleIndex(double d) {
        int n = this.itsDoubleTableTop;
        if (n == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == n) {
            double[] dArray = new double[n * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, dArray, 0, n);
            this.itsData.itsDoubleTable = dArray;
        }
        this.itsData.itsDoubleTable[n] = d;
        this.itsDoubleTableTop = n + 1;
        return n;
    }

    private void addGotoOp(int n) {
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 3 > byArray.length) {
            byArray = this.increaseICodeCapacity(3);
        }
        byArray[n2] = (byte)n;
        this.itsICodeTop = n2 + 1 + 2;
    }

    private void addVarOp(int n, int n2) {
        switch (n) {
            case 155: {
                if (n2 < 128) {
                    this.addIcode(-61);
                    this.addUint8(n2);
                    return;
                }
                this.addIndexOp(-60, n2);
                return;
            }
            case 55: 
            case 56: {
                if (n2 < 128) {
                    this.addIcode(n == 55 ? -48 : -49);
                    this.addUint8(n2);
                    return;
                }
            }
            case -7: {
                this.addIndexOp(n, n2);
                return;
            }
        }
        throw Kit.codeBug();
    }

    private void addStringOp(int n, String string) {
        this.addStringPrefix(string);
        if (Interpreter.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addIndexOp(int n, int n2) {
        this.addIndexPrefix(n2);
        if (Interpreter.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addStringPrefix(String string) {
        int n = this.itsStrings.get(string, -1);
        if (n == -1) {
            n = this.itsStrings.size();
            this.itsStrings.put(string, n);
        }
        if (n < 4) {
            this.addIcode(-41 - n);
        } else if (n <= 255) {
            this.addIcode(-45);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-46);
            this.addUint16(n);
        } else {
            this.addIcode(-47);
            this.addInt(n);
        }
    }

    private void addIndexPrefix(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        if (n < 6) {
            this.addIcode(-32 - n);
        } else if (n <= 255) {
            this.addIcode(-38);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-39);
            this.addUint16(n);
        } else {
            this.addIcode(-40);
            this.addInt(n);
        }
    }

    private void addExceptionHandler(int n, int n2, int n3, boolean bl, int n4, int n5) {
        int n6 = this.itsExceptionTableTop;
        int[] nArray = this.itsData.itsExceptionTable;
        if (nArray == null) {
            if (n6 != 0) {
                Kit.codeBug();
            }
            this.itsData.itsExceptionTable = nArray = new int[12];
        } else if (nArray.length == n6) {
            nArray = new int[nArray.length * 2];
            System.arraycopy(this.itsData.itsExceptionTable, 0, nArray, 0, n6);
            this.itsData.itsExceptionTable = nArray;
        }
        nArray[n6 + 0] = n;
        nArray[n6 + 1] = n2;
        nArray[n6 + 2] = n3;
        nArray[n6 + 3] = bl ? 1 : 0;
        nArray[n6 + 4] = n4;
        nArray[n6 + 5] = n5;
        this.itsExceptionTableTop = n6 + 6;
    }

    private byte[] increaseICodeCapacity(int n) {
        int n2 = this.itsICodeTop;
        int n3 = this.itsData.itsICode.length;
        if (n2 + n <= n3) {
            throw Kit.codeBug();
        }
        if (n2 + n > (n3 *= 2)) {
            n3 = n2 + n;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.itsData.itsICode, 0, byArray, 0, n2);
        this.itsData.itsICode = byArray;
        return byArray;
    }

    private void stackChange(int n) {
        if (n <= 0) {
            this.itsStackDepth += n;
        } else {
            int n2 = this.itsStackDepth + n;
            if (n2 > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = n2;
            }
            this.itsStackDepth = n2;
        }
    }

    private int allocLocal() {
        int n = this.itsLocalTop++;
        if (this.itsLocalTop > this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = this.itsLocalTop;
        }
        return n;
    }

    private void releaseLocal(int n) {
        --this.itsLocalTop;
        if (n != this.itsLocalTop) {
            Kit.codeBug();
        }
    }

    private static int getShort(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getIndex(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int getExceptionHandler(CallFrame callFrame, boolean bl) {
        int[] nArray = callFrame.idata.itsExceptionTable;
        if (nArray == null) {
            return -1;
        }
        int n = callFrame.pc - 1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i != nArray.length; i += 6) {
            int n5 = nArray[i + 0];
            int n6 = nArray[i + 1];
            if (n5 > n || n >= n6 || bl && nArray[i + 3] != 1) continue;
            if (n2 >= 0) {
                if (n4 < n6) continue;
                if (n3 > n5) {
                    Kit.codeBug();
                }
                if (n4 == n6) {
                    Kit.codeBug();
                }
            }
            n2 = i;
            n3 = n5;
            n4 = n6;
        }
        return n2;
    }

    private static void dumpICode(InterpreterData interpreterData) {
    }

    private static int bytecodeSpan(int n) {
        switch (n) {
            case -63: 
            case -62: 
            case 50: 
            case 72: {
                return 3;
            }
            case -54: 
            case -23: 
            case -6: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case -21: {
                return 5;
            }
            case 57: {
                return 2;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: {
                return 2;
            }
            case -27: {
                return 3;
            }
            case -28: {
                return 5;
            }
            case -38: {
                return 2;
            }
            case -39: {
                return 3;
            }
            case -40: {
                return 5;
            }
            case -45: {
                return 2;
            }
            case -46: {
                return 3;
            }
            case -47: {
                return 5;
            }
            case -61: 
            case -49: 
            case -48: {
                return 2;
            }
            case -26: {
                return 3;
            }
        }
        if (!Interpreter.validBytecode(n)) {
            throw Kit.codeBug();
        }
        return 1;
    }

    static int[] getLineNumbers(InterpreterData interpreterData) {
        int n;
        UintMap uintMap = new UintMap();
        byte[] byArray = interpreterData.itsICode;
        int n2 = byArray.length;
        for (int i = 0; i != n2; i += n) {
            byte by = byArray[i];
            n = Interpreter.bytecodeSpan(by);
            if (by != -26) continue;
            if (n != 3) {
                Kit.codeBug();
            }
            int n3 = Interpreter.getIndex(byArray, i + 1);
            uintMap.put(n3, 0);
        }
        return uintMap.getKeys();
    }

    @Override
    public void captureStackInfo(RhinoException rhinoException) {
        int n;
        Object[] objectArray;
        Context context = Context.getCurrentContext();
        if (context == null || context.lastInterpreterFrame == null) {
            rhinoException.interpreterStackInfo = null;
            rhinoException.interpreterLineData = null;
            return;
        }
        if (context.previousInterpreterInvocations == null || context.previousInterpreterInvocations.size() == 0) {
            objectArray = new CallFrame[1];
        } else {
            n = context.previousInterpreterInvocations.size();
            if (context.previousInterpreterInvocations.peek() == context.lastInterpreterFrame) {
                --n;
            }
            objectArray = new CallFrame[n + 1];
            context.previousInterpreterInvocations.toArray(objectArray);
        }
        objectArray[objectArray.length - 1] = (CallFrame)context.lastInterpreterFrame;
        n = 0;
        for (int i = 0; i != objectArray.length; ++i) {
            n += 1 + ((CallFrame)objectArray[i]).frameIndex;
        }
        int[] nArray = new int[n];
        int n2 = n;
        int n3 = objectArray.length;
        while (n3 != 0) {
            Object object = objectArray[--n3];
            while (object != null) {
                nArray[--n2] = ((CallFrame)object).pcSourceLineStart;
                object = ((CallFrame)object).parentFrame;
            }
        }
        if (n2 != 0) {
            Kit.codeBug();
        }
        rhinoException.interpreterStackInfo = objectArray;
        rhinoException.interpreterLineData = nArray;
    }

    @Override
    public String getSourcePositionFromStack(Context context, int[] nArray) {
        CallFrame callFrame = (CallFrame)context.lastInterpreterFrame;
        InterpreterData interpreterData = callFrame.idata;
        nArray[0] = callFrame.pcSourceLineStart >= 0 ? Interpreter.getIndex(interpreterData.itsICode, callFrame.pcSourceLineStart) : 0;
        return interpreterData.itsSourceFile;
    }

    @Override
    public String getPatchedStack(RhinoException rhinoException, String string) {
        String string2 = "org.mozilla.nb.javascript.Interpreter.interpretLoop";
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1000);
        String string3 = SecurityUtilities.getSystemProperty("line.separator");
        CallFrame[] callFrameArray = (CallFrame[])rhinoException.interpreterStackInfo;
        int[] nArray = rhinoException.interpreterLineData;
        int n = callFrameArray.length;
        int n2 = nArray.length;
        int n3 = 0;
        while (n != 0) {
            char c;
            --n;
            int n4 = string.indexOf(string2, n3);
            if (n4 < 0) break;
            n4 += string2.length();
            while (n4 != string.length() && (c = string.charAt(n4)) != '\n' && c != '\r') {
                ++n4;
            }
            stringBuffer.append(string.substring(n3, n4));
            n3 = n4;
            CallFrame callFrame = callFrameArray[n];
            while (callFrame != null) {
                if (n2 == 0) {
                    Kit.codeBug();
                }
                --n2;
                InterpreterData interpreterData = callFrame.idata;
                stringBuffer.append(string3);
                stringBuffer.append("\tat script");
                if (interpreterData.itsName != null && interpreterData.itsName.length() != 0) {
                    stringBuffer.append('.');
                    stringBuffer.append(interpreterData.itsName);
                }
                stringBuffer.append('(');
                stringBuffer.append(interpreterData.itsSourceFile);
                int n5 = nArray[n2];
                if (n5 >= 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(Interpreter.getIndex(interpreterData.itsICode, n5));
                }
                stringBuffer.append(')');
                callFrame = callFrame.parentFrame;
            }
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    @Override
    public List<String> getScriptStack(RhinoException rhinoException) {
        if (rhinoException.interpreterStackInfo == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = SecurityUtilities.getSystemProperty("line.separator");
        CallFrame[] callFrameArray = (CallFrame[])rhinoException.interpreterStackInfo;
        int[] nArray = rhinoException.interpreterLineData;
        int n = callFrameArray.length;
        int n2 = nArray.length;
        while (n != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            CallFrame callFrame = callFrameArray[--n];
            while (callFrame != null) {
                if (n2 == 0) {
                    Kit.codeBug();
                }
                --n2;
                InterpreterData interpreterData = callFrame.idata;
                stringBuilder.append("\tat ");
                stringBuilder.append(interpreterData.itsSourceFile);
                int n3 = nArray[n2];
                if (n3 >= 0) {
                    stringBuilder.append(':');
                    stringBuilder.append(Interpreter.getIndex(interpreterData.itsICode, n3));
                }
                if (interpreterData.itsName != null && interpreterData.itsName.length() != 0) {
                    stringBuilder.append(" (");
                    stringBuilder.append(interpreterData.itsName);
                    stringBuilder.append(')');
                }
                stringBuilder.append(string);
                callFrame = callFrame.parentFrame;
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    static String getEncodedSource(InterpreterData interpreterData) {
        if (interpreterData.encodedSource == null) {
            return null;
        }
        return interpreterData.encodedSource.substring(interpreterData.encodedSourceStart, interpreterData.encodedSourceEnd);
    }

    private static void initFunction(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, int n) {
        InterpretedFunction interpretedFunction2 = InterpretedFunction.createFunction(context, scriptable, interpretedFunction, n);
        ScriptRuntime.initFunction(context, scriptable, interpretedFunction2, interpretedFunction2.idata.itsFunctionType, interpretedFunction.idata.evalScriptFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object interpret(InterpretedFunction interpretedFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            Kit.codeBug();
        }
        if (context.interpreterSecurityDomain != interpretedFunction.securityDomain) {
            Object object = context.interpreterSecurityDomain;
            context.interpreterSecurityDomain = interpretedFunction.securityDomain;
            try {
                Object object2 = interpretedFunction.securityController.callWithDomain(interpretedFunction.securityDomain, context, interpretedFunction, scriptable, scriptable2, objectArray);
                return object2;
            }
            finally {
                context.interpreterSecurityDomain = object;
            }
        }
        CallFrame callFrame = new CallFrame();
        Interpreter.initFrame(context, scriptable, scriptable2, objectArray, null, 0, objectArray.length, interpretedFunction, null, callFrame);
        callFrame.isContinuationsTopFrame = context.isContinuationsTopCall;
        context.isContinuationsTopCall = false;
        return Interpreter.interpretLoop(context, callFrame, null);
    }

    public static Object resumeGenerator(Context context, Scriptable scriptable, int n, Object object, Object object2) {
        CallFrame callFrame = (CallFrame)object;
        GeneratorState generatorState = new GeneratorState(n, object2);
        if (n == 2) {
            try {
                return Interpreter.interpretLoop(context, callFrame, generatorState);
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException != object2) {
                    throw runtimeException;
                }
                return Undefined.instance;
            }
        }
        Object object3 = Interpreter.interpretLoop(context, callFrame, generatorState);
        if (generatorState.returnedException != null) {
            throw generatorState.returnedException;
        }
        return object3;
    }

    public static Object restartContinuation(NativeContinuation nativeContinuation, Context context, Scriptable scriptable, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(nativeContinuation, context, scriptable, null, objectArray);
        }
        Object object = objectArray.length == 0 ? Undefined.instance : objectArray[0];
        CallFrame callFrame = (CallFrame)nativeContinuation.getImplementation();
        if (callFrame == null) {
            return object;
        }
        ContinuationJump continuationJump = new ContinuationJump(nativeContinuation, null);
        continuationJump.result = object;
        return Interpreter.interpretLoop(context, null, continuationJump);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Object interpretLoop(Context var0, CallFrame var1_1, Object var2_2) {
        block286: {
            var3_3 = UniqueTag.DOUBLE_MARK;
            var4_4 = Undefined.instance;
            var5_5 = var0.instructionThreshold != 0;
            var8_6 = null;
            var9_7 = -1;
            if (var0.lastInterpreterFrame != null) {
                if (var0.previousInterpreterInvocations == null) {
                    var0.previousInterpreterInvocations = new ObjArray();
                }
                var0.previousInterpreterInvocations.push(var0.lastInterpreterFrame);
            }
            var10_8 = null;
            if (var2_2 != null) {
                if (var2_2 instanceof GeneratorState) {
                    var10_8 = (GeneratorState)var2_2;
                    Interpreter.enterFrame(var0, var1_1, ScriptRuntime.emptyArgs, true);
                    var2_2 = null;
                } else if (!(var2_2 instanceof ContinuationJump)) {
                    Kit.codeBug();
                }
            }
            var11_9 = null;
            var12_10 = 0.0;
            block155: while (true) {
                block287: {
                    block285: {
                        try {
                            block156: while (true) {
                                if (var2_2 != null) {
                                    var1_1 = Interpreter.processThrowable(var0, var2_2, var1_1, var9_7, var5_5);
                                    var2_2 = var1_1.throwable;
                                    var1_1.throwable = null;
                                } else if (var10_8 == null && var1_1.frozen) {
                                    Kit.codeBug();
                                }
                                var14_11 = var1_1.stack;
                                var15_13 = var1_1.sDbl;
                                var16_14 = var1_1.varSource.stack;
                                var17_15 = var1_1.varSource.sDbl;
                                var18_17 /* !! */  = var1_1.varSource.stackAttributes;
                                var19_18 /* !! */  = var1_1.idata.itsICode;
                                var20_22 = var1_1.idata.itsStringTable;
                                var21_24 = var1_1.savedStackTop;
                                var0.lastInterpreterFrame = var1_1;
                                block157: while (true) {
                                    var22_25 = var19_18 /* !! */ [var1_1.pc++];
                                    switch (var22_25) {
                                        case -62: {
                                            if (!var1_1.frozen) {
                                                --var1_1.pc;
                                                var23_26 = Interpreter.captureFrameForGenerator(var1_1);
                                                var23_26.frozen = true;
                                                var24_85 = new NativeGenerator(var1_1.scope, var23_26.fnOrScript, var23_26);
                                                var1_1.result = var24_85;
                                                break block157;
                                            }
                                        }
                                        case 72: {
                                            if (!var1_1.frozen) {
                                                return Interpreter.freezeGenerator(var0, var1_1, var21_24, var10_8);
                                            }
                                            var23_27 = Interpreter.thawGenerator(var1_1, var21_24, var10_8, var22_25);
                                            if (var23_27 == Scriptable.NOT_FOUND) continue block157;
                                            var2_2 = var23_27;
                                            break block285;
                                        }
                                        case -63: {
                                            var1_1.frozen = true;
                                            var23_28 = Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc);
                                            var10_8.returnedException = new JavaScriptException(NativeIterator.getStopIterationObject(var1_1.scope), var1_1.idata.itsSourceFile, var23_28);
                                            break block157;
                                        }
                                        case 50: {
                                            var23_29 = var14_11[var21_24];
                                            if (var23_29 == var3_3) {
                                                var23_29 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            --var21_24;
                                            var24_86 = Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc);
                                            var2_2 = new JavaScriptException(var23_29, var1_1.idata.itsSourceFile, var24_86);
                                            break block285;
                                        }
                                        case 51: {
                                            var2_2 = var14_11[var9_7 += var1_1.localShift];
                                            break block285;
                                        }
                                        case 14: 
                                        case 15: 
                                        case 16: 
                                        case 17: {
                                            var23_30 = var14_11[--var21_24 + 1];
                                            var24_87 = var14_11[var21_24];
                                            if (var23_30 != var3_3) ** GOTO lbl83
                                            var26_134 = var15_13[var21_24 + 1];
                                            var28_149 = Interpreter.stack_double(var1_1, var21_24);
                                            ** GOTO lbl86
lbl83:
                                            // 1 sources

                                            if (var24_87 != var3_3) ** GOTO lbl101
                                            var26_134 = ScriptRuntime.toNumber(var23_30);
                                            var28_149 = var15_13[var21_24];
lbl86:
                                            // 2 sources

                                            switch (var22_25) {
                                                case 17: {
                                                    var25_117 = var28_149 >= var26_134;
                                                    ** GOTO lbl116
                                                }
                                                case 15: {
                                                    var25_117 = var28_149 <= var26_134;
                                                    ** GOTO lbl116
                                                }
                                                case 16: {
                                                    var25_117 = var28_149 > var26_134;
                                                    ** GOTO lbl116
                                                }
                                                case 14: {
                                                    var25_117 = var28_149 < var26_134;
                                                    ** GOTO lbl116
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl101:
                                            // 1 sources

                                            switch (var22_25) {
                                                case 17: {
                                                    var25_117 = ScriptRuntime.cmp_LE(var23_30, var24_87);
                                                    break;
                                                }
                                                case 15: {
                                                    var25_117 = ScriptRuntime.cmp_LE(var24_87, var23_30);
                                                    break;
                                                }
                                                case 16: {
                                                    var25_117 = ScriptRuntime.cmp_LT(var23_30, var24_87);
                                                    break;
                                                }
                                                case 14: {
                                                    var25_117 = ScriptRuntime.cmp_LT(var24_87, var23_30);
                                                    break;
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl116:
                                            // 8 sources

                                            var14_11[var21_24] = ScriptRuntime.wrapBoolean(var25_117);
                                            continue block157;
                                        }
                                        case 52: 
                                        case 53: {
                                            var23_31 = var14_11[var21_24];
                                            if (var23_31 == var3_3) {
                                                var23_31 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_88 = var14_11[--var21_24]) == var3_3) {
                                                var24_88 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var25_118 = var22_25 == 52 ? ScriptRuntime.in(var24_88, var23_31, var0) : ScriptRuntime.instanceOf(var24_88, var23_31, var0);
                                            var14_11[var21_24] = ScriptRuntime.wrapBoolean(var25_118);
                                            continue block157;
                                        }
                                        case 12: 
                                        case 13: {
                                            var24_89 = var14_11[--var21_24 + 1];
                                            var25_119 = var14_11[var21_24];
                                            var23_32 = var24_89 == var3_3 ? (var25_119 == var3_3 ? var15_13[var21_24] == var15_13[var21_24 + 1] : ScriptRuntime.eqNumber(var15_13[var21_24 + 1], var25_119)) : (var25_119 == var3_3 ? ScriptRuntime.eqNumber(var15_13[var21_24], var24_89) : ScriptRuntime.eq(var25_119, var24_89));
                                            var14_11[var21_24] = ScriptRuntime.wrapBoolean(var23_32 ^= var22_25 == 13);
                                            continue block157;
                                        }
                                        case 46: 
                                        case 47: {
                                            var23_33 = Interpreter.shallowEquals(var14_11, var15_13, --var21_24);
                                            var14_11[var21_24] = ScriptRuntime.wrapBoolean(var23_33 ^= var22_25 == 47);
                                            continue block157;
                                        }
                                        case 7: {
                                            if (!Interpreter.stack_boolean(var1_1, var21_24--)) break;
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case 6: {
                                            if (Interpreter.stack_boolean(var1_1, var21_24--)) break;
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case -6: {
                                            if (!Interpreter.stack_boolean(var1_1, var21_24--)) {
                                                var1_1.pc += 2;
                                                continue block157;
                                            }
                                            var14_11[var21_24--] = null;
                                            break;
                                        }
                                        case 5: {
                                            break;
                                        }
                                        case -23: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = var1_1.pc + 2;
                                            break;
                                        }
                                        case -24: {
                                            if (var21_24 == var1_1.emptyStackTop + 1) {
                                                var14_11[var9_7 += var1_1.localShift] = var14_11[var21_24];
                                                var15_13[var9_7] = var15_13[var21_24];
                                                --var21_24;
                                                continue block157;
                                            }
                                            if (var21_24 == var1_1.emptyStackTop) continue block157;
                                            Kit.codeBug();
                                            continue block157;
                                        }
                                        case -25: {
                                            if (var5_5) {
                                                Interpreter.addInstructionCount(var0, var1_1, 0);
                                            }
                                            if ((var23_34 = var14_11[var9_7 += var1_1.localShift]) != var3_3) {
                                                var2_2 = var23_34;
                                                break block285;
                                            }
                                            var1_1.pc = (int)var15_13[var9_7];
                                            if (!var5_5) continue block157;
                                            var1_1.pcPrevBranch = var1_1.pc;
                                            continue block157;
                                        }
                                        case -4: {
                                            var14_11[var21_24] = null;
                                            --var21_24;
                                            continue block157;
                                        }
                                        case -5: {
                                            var1_1.result = var14_11[var21_24];
                                            var1_1.resultDbl = var15_13[var21_24];
                                            var14_11[var21_24] = null;
                                            --var21_24;
                                            continue block157;
                                        }
                                        case -1: {
                                            var14_11[var21_24 + 1] = var14_11[var21_24];
                                            var15_13[var21_24 + 1] = var15_13[var21_24];
                                            ++var21_24;
                                            continue block157;
                                        }
                                        case -2: {
                                            var14_11[var21_24 + 1] = var14_11[var21_24 - 1];
                                            var15_13[var21_24 + 1] = var15_13[var21_24 - 1];
                                            var14_11[var21_24 + 2] = var14_11[var21_24];
                                            var15_13[var21_24 + 2] = var15_13[var21_24];
                                            var21_24 += 2;
                                            continue block157;
                                        }
                                        case -3: {
                                            var23_35 = var14_11[var21_24];
                                            var14_11[var21_24] = var14_11[var21_24 - 1];
                                            var14_11[var21_24 - 1] = var23_35;
                                            var24_90 = var15_13[var21_24];
                                            var15_13[var21_24] = var15_13[var21_24 - 1];
                                            var15_13[var21_24 - 1] = var24_90;
                                            continue block157;
                                        }
                                        case 4: {
                                            var1_1.result = var14_11[var21_24];
                                            var1_1.resultDbl = var15_13[var21_24];
                                            --var21_24;
                                            break block157;
                                        }
                                        case 64: {
                                            break block157;
                                        }
                                        case -22: {
                                            var1_1.result = var4_4;
                                            break block157;
                                        }
                                        case 27: {
                                            var23_36 = Interpreter.stack_int32(var1_1, var21_24);
                                            var14_11[var21_24] = var3_3;
                                            var15_13[var21_24] = ~var23_36;
                                            continue block157;
                                        }
                                        case 9: 
                                        case 10: 
                                        case 11: 
                                        case 18: 
                                        case 19: {
                                            var23_37 = Interpreter.stack_int32(var1_1, var21_24 - 1);
                                            var24_91 = Interpreter.stack_int32(var1_1, var21_24);
                                            var14_11[--var21_24] = var3_3;
                                            switch (var22_25) {
                                                case 11: {
                                                    var23_37 &= var24_91;
                                                    break;
                                                }
                                                case 9: {
                                                    var23_37 |= var24_91;
                                                    break;
                                                }
                                                case 10: {
                                                    var23_37 ^= var24_91;
                                                    break;
                                                }
                                                case 18: {
                                                    var23_37 <<= var24_91;
                                                    break;
                                                }
                                                case 19: {
                                                    var23_37 >>= var24_91;
                                                }
                                            }
                                            var15_13[var21_24] = var23_37;
                                            continue block157;
                                        }
                                        case 20: {
                                            var23_38 = Interpreter.stack_double(var1_1, var21_24 - 1);
                                            var25_120 = Interpreter.stack_int32(var1_1, var21_24) & 31;
                                            var14_11[--var21_24] = var3_3;
                                            var15_13[var21_24] = ScriptRuntime.toUint32(var23_38) >>> var25_120;
                                            continue block157;
                                        }
                                        case 28: 
                                        case 29: {
                                            var23_39 = Interpreter.stack_double(var1_1, var21_24);
                                            var14_11[var21_24] = var3_3;
                                            if (var22_25 == 29) {
                                                var23_39 = -var23_39;
                                            }
                                            var15_13[var21_24] = var23_39;
                                            continue block157;
                                        }
                                        case 21: {
                                            Interpreter.do_add(var14_11, var15_13, --var21_24, var0);
                                            continue block157;
                                        }
                                        case 22: 
                                        case 23: 
                                        case 24: 
                                        case 25: {
                                            var23_40 = Interpreter.stack_double(var1_1, var21_24);
                                            var25_121 = Interpreter.stack_double(var1_1, --var21_24);
                                            var14_11[var21_24] = var3_3;
                                            switch (var22_25) {
                                                case 22: {
                                                    var25_121 -= var23_40;
                                                    break;
                                                }
                                                case 23: {
                                                    var25_121 *= var23_40;
                                                    break;
                                                }
                                                case 24: {
                                                    var25_121 /= var23_40;
                                                    break;
                                                }
                                                case 25: {
                                                    var25_121 %= var23_40;
                                                }
                                            }
                                            var15_13[var21_24] = var25_121;
                                            continue block157;
                                        }
                                        case 26: {
                                            var14_11[var21_24] = ScriptRuntime.wrapBoolean(Interpreter.stack_boolean(var1_1, var21_24) == false);
                                            continue block157;
                                        }
                                        case 49: {
                                            var14_11[++var21_24] = ScriptRuntime.bind(var0, var1_1.scope, var8_6);
                                            continue block157;
                                        }
                                        case 8: {
                                            var23_41 = var14_11[var21_24];
                                            if (var23_41 == var3_3) {
                                                var23_41 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var24_92 = (Scriptable)var14_11[--var21_24];
                                            var14_11[var21_24] = ScriptRuntime.setName(var24_92, var23_41, var0, var1_1.scope, var8_6);
                                            continue block157;
                                        }
                                        case -59: {
                                            var23_42 = var14_11[var21_24];
                                            if (var23_42 == var3_3) {
                                                var23_42 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var24_93 = (Scriptable)var14_11[--var21_24];
                                            var14_11[var21_24] = ScriptRuntime.setConst(var24_93, var23_42, var0, var8_6);
                                            continue block157;
                                        }
                                        case 31: {
                                            var23_43 = var14_11[var21_24];
                                            if (var23_43 == var3_3) {
                                                var23_43 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_94 = var14_11[--var21_24]) == var3_3) {
                                                var24_94 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.delete(var24_94, var23_43, var0);
                                            continue block157;
                                        }
                                        case 34: {
                                            var23_44 = var14_11[var21_24];
                                            if (var23_44 == var3_3) {
                                                var23_44 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.getObjectPropNoWarn(var23_44, var8_6, var0);
                                            continue block157;
                                        }
                                        case 33: {
                                            var23_45 = var14_11[var21_24];
                                            if (var23_45 == var3_3) {
                                                var23_45 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.getObjectProp(var23_45, var8_6, var0);
                                            continue block157;
                                        }
                                        case 35: {
                                            var23_46 = var14_11[var21_24];
                                            if (var23_46 == var3_3) {
                                                var23_46 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_95 = var14_11[--var21_24]) == var3_3) {
                                                var24_95 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.setObjectProp(var24_95, var8_6, var23_46, var0);
                                            continue block157;
                                        }
                                        case -9: {
                                            var23_47 = var14_11[var21_24];
                                            if (var23_47 == var3_3) {
                                                var23_47 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.propIncrDecr(var23_47, var8_6, var0, var19_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case 36: {
                                            var23_48 = var14_11[--var21_24];
                                            if (var23_48 == var3_3) {
                                                var23_48 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var25_122 = var14_11[var21_24 + 1]) != var3_3) {
                                                var24_96 = ScriptRuntime.getObjectElem(var23_48, var25_122, var0);
                                            } else {
                                                var26_135 = var15_13[var21_24 + 1];
                                                var24_96 = ScriptRuntime.getObjectIndex(var23_48, var26_135, var0);
                                            }
                                            var14_11[var21_24] = var24_96;
                                            continue block157;
                                        }
                                        case 37: {
                                            var23_49 = var14_11[(var21_24 -= 2) + 2];
                                            if (var23_49 == var3_3) {
                                                var23_49 = ScriptRuntime.wrapNumber(var15_13[var21_24 + 2]);
                                            }
                                            if ((var24_97 = var14_11[var21_24]) == var3_3) {
                                                var24_97 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var26_136 = var14_11[var21_24 + 1]) != var3_3) {
                                                var25_123 = ScriptRuntime.setObjectElem(var24_97, var26_136, var23_49, var0);
                                            } else {
                                                var27_144 = var15_13[var21_24 + 1];
                                                var25_123 = ScriptRuntime.setObjectIndex(var24_97, var27_144, var23_49, var0);
                                            }
                                            var14_11[var21_24] = var25_123;
                                            continue block157;
                                        }
                                        case -10: {
                                            var23_50 = var14_11[var21_24];
                                            if (var23_50 == var3_3) {
                                                var23_50 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_98 = var14_11[--var21_24]) == var3_3) {
                                                var24_98 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.elemIncrDecr(var24_98, var23_50, var0, var19_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case 67: {
                                            var23_51 = (Ref)var14_11[var21_24];
                                            var14_11[var21_24] = ScriptRuntime.refGet(var23_51, var0);
                                            continue block157;
                                        }
                                        case 68: {
                                            var23_52 = var14_11[var21_24];
                                            if (var23_52 == var3_3) {
                                                var23_52 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var24_99 = (Ref)var14_11[--var21_24];
                                            var14_11[var21_24] = ScriptRuntime.refSet(var24_99, var23_52, var0);
                                            continue block157;
                                        }
                                        case 69: {
                                            var23_53 = (Ref)var14_11[var21_24];
                                            var14_11[var21_24] = ScriptRuntime.refDel(var23_53, var0);
                                            continue block157;
                                        }
                                        case -11: {
                                            var23_54 = (Ref)var14_11[var21_24];
                                            var14_11[var21_24] = ScriptRuntime.refIncrDecr(var23_54, var0, var19_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case 54: {
                                            var14_11[++var21_24] = var14_11[var9_7 += var1_1.localShift];
                                            var15_13[var21_24] = var15_13[var9_7];
                                            continue block157;
                                        }
                                        case -56: {
                                            var14_11[var9_7 += var1_1.localShift] = null;
                                            continue block157;
                                        }
                                        case -15: {
                                            var14_11[++var21_24] = ScriptRuntime.getNameFunctionAndThis(var8_6, var0, var1_1.scope);
                                            var14_11[++var21_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block157;
                                        }
                                        case -16: {
                                            var23_55 = var14_11[var21_24];
                                            if (var23_55 == var3_3) {
                                                var23_55 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.getPropFunctionAndThis(var23_55, var8_6, var0);
                                            var14_11[++var21_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block157;
                                        }
                                        case -17: {
                                            var23_56 = var14_11[var21_24 - 1];
                                            if (var23_56 == var3_3) {
                                                var23_56 = ScriptRuntime.wrapNumber(var15_13[var21_24 - 1]);
                                            }
                                            if ((var24_100 = var14_11[var21_24]) == var3_3) {
                                                var24_100 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24 - 1] = ScriptRuntime.getElemFunctionAndThis(var23_56, var24_100, var0);
                                            var14_11[var21_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block157;
                                        }
                                        case -18: {
                                            var23_57 = var14_11[var21_24];
                                            if (var23_57 == var3_3) {
                                                var23_57 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.getValueFunctionAndThis(var23_57, var0);
                                            var14_11[++var21_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block157;
                                        }
                                        case -21: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            var23_58 = var19_18 /* !! */ [var1_1.pc] & 255;
                                            var24_101 = var19_18 /* !! */ [var1_1.pc + 1] != 0;
                                            var25_124 = Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc + 2);
                                            if (var24_101) {
                                                var26_137 = var14_11[var21_24 -= var9_7];
                                                if (var26_137 == var3_3) {
                                                    var26_137 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                                }
                                                var27_145 = Interpreter.getArgsArray(var14_11, var15_13, var21_24 + 1, var9_7);
                                                var14_11[var21_24] = ScriptRuntime.newSpecial(var0, var26_137, var27_145, var1_1.scope, var23_58);
                                            } else {
                                                var26_137 = (Scriptable)var14_11[(var21_24 -= 1 + var9_7) + 1];
                                                var27_145 = (Object[])var14_11[var21_24];
                                                var28_150 = Interpreter.getArgsArray(var14_11, var15_13, var21_24 + 2, var9_7);
                                                var14_11[var21_24] = ScriptRuntime.callSpecial(var0, (Callable)var27_145, (Scriptable)var26_137, var28_150, var1_1.scope, var1_1.thisObj, var23_58, var1_1.idata.itsSourceFile, var25_124);
                                            }
                                            var1_1.pc += 4;
                                            continue block157;
                                        }
                                        case -55: 
                                        case 38: 
                                        case 70: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            var23_59 = (Callable)var14_11[var21_24 -= 1 + var9_7];
                                            var24_102 = (Scriptable)var14_11[var21_24 + 1];
                                            if (var22_25 == 70) {
                                                var25_125 = Interpreter.getArgsArray(var14_11, var15_13, var21_24 + 2, var9_7);
                                                var14_11[var21_24] = ScriptRuntime.callRef(var23_59, var24_102, var25_125, var0);
                                                continue block157;
                                            }
                                            var25_126 = var1_1.scope;
                                            if (var1_1.useActivation) {
                                                var25_126 = ScriptableObject.getTopLevelScope(var1_1.scope);
                                            }
                                            if (var23_59 instanceof InterpretedFunction) {
                                                var26_138 = (InterpretedFunction)var23_59;
                                                if (var1_1.fnOrScript.securityDomain == var26_138.securityDomain) {
                                                    var27_146 = var1_1;
                                                    var28_151 = new CallFrame();
                                                    if (var22_25 == -55) {
                                                        var27_146 = var1_1.parentFrame;
                                                        Interpreter.exitFrame(var0, var1_1, null);
                                                    }
                                                    Interpreter.initFrame(var0, var25_126, var24_102, var14_11, var15_13, var21_24 + 2, var9_7, var26_138, var27_146, var28_151);
                                                    if (var22_25 != -55) {
                                                        var1_1.savedStackTop = var21_24;
                                                        var1_1.savedCallOp = var22_25;
                                                    }
                                                    var1_1 = var28_151;
                                                    continue block156;
                                                }
                                            }
                                            if (var23_59 instanceof NativeContinuation) {
                                                var26_139 = new ContinuationJump((NativeContinuation)var23_59, var1_1);
                                                if (var9_7 == 0) {
                                                    var26_139.result = var4_4;
                                                } else {
                                                    var26_139.result = var14_11[var21_24 + 2];
                                                    var26_139.resultDbl = var15_13[var21_24 + 2];
                                                }
                                                var2_2 = var26_139;
                                                break block285;
                                            }
                                            if (var23_59 instanceof IdFunctionObject) {
                                                var26_140 = (IdFunctionObject)var23_59;
                                                if (NativeContinuation.isContinuationConstructor(var26_140)) {
                                                    var1_1.stack[var21_24] = Interpreter.captureContinuation(var0, var1_1.parentFrame, false);
                                                    continue block157;
                                                }
                                                if (BaseFunction.isApplyOrCall(var26_140) && (var27_147 = ScriptRuntime.getCallable(var24_102)) instanceof InterpretedFunction) {
                                                    var28_152 = (InterpretedFunction)var27_147;
                                                    if (var1_1.fnOrScript.securityDomain == var28_152.securityDomain) {
                                                        var1_1 = Interpreter.initFrameForApplyOrCall(var0, var1_1, var9_7, var14_11, var15_13, var21_24, var22_25, var25_126, var26_140, var28_152);
                                                        continue block156;
                                                    }
                                                }
                                            }
                                            if (var23_59 instanceof ScriptRuntime.NoSuchMethodShim) {
                                                var26_141 = (ScriptRuntime.NoSuchMethodShim)var23_59;
                                                var27_148 = var26_141.noSuchMethodMethod;
                                                if (var27_148 instanceof InterpretedFunction) {
                                                    var28_153 = (InterpretedFunction)var27_148;
                                                    if (var1_1.fnOrScript.securityDomain == var28_153.securityDomain) {
                                                        var1_1 = Interpreter.initFrameForNoSuchMethod(var0, var1_1, var9_7, var14_11, var15_13, var21_24, var22_25, var24_102, var25_126, var26_141, var28_153);
                                                        continue block156;
                                                    }
                                                }
                                            }
                                            var0.lastInterpreterFrame = var1_1;
                                            var1_1.savedCallOp = var22_25;
                                            var1_1.savedStackTop = var21_24;
                                            var14_11[var21_24] = var23_59.call(var0, var25_126, var24_102, Interpreter.getArgsArray(var14_11, var15_13, var21_24 + 2, var9_7));
                                            var0.lastInterpreterFrame = null;
                                            continue block157;
                                        }
                                        case 30: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            if ((var23_60 = var14_11[var21_24 -= var9_7]) instanceof InterpretedFunction) {
                                                var24_103 = (InterpretedFunction)var23_60;
                                                if (var1_1.fnOrScript.securityDomain == var24_103.securityDomain) {
                                                    var25_127 = var24_103.createObject(var0, var1_1.scope);
                                                    var26_142 = new CallFrame();
                                                    Interpreter.initFrame(var0, var1_1.scope, var25_127, var14_11, var15_13, var21_24 + 1, var9_7, var24_103, var1_1, var26_142);
                                                    var14_11[var21_24] = var25_127;
                                                    var1_1.savedStackTop = var21_24;
                                                    var1_1.savedCallOp = var22_25;
                                                    var1_1 = var26_142;
                                                    continue block156;
                                                }
                                            }
                                            if (!(var23_60 instanceof Function)) {
                                                if (var23_60 == var3_3) {
                                                    var23_60 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                                }
                                                throw ScriptRuntime.notFunctionError(var23_60);
                                            }
                                            var24_104 = (Function)var23_60;
                                            if (var24_104 instanceof IdFunctionObject && NativeContinuation.isContinuationConstructor(var25_128 = (IdFunctionObject)var24_104)) {
                                                var1_1.stack[var21_24] = Interpreter.captureContinuation(var0, var1_1.parentFrame, false);
                                                continue block157;
                                            }
                                            var25_129 = Interpreter.getArgsArray(var14_11, var15_13, var21_24 + 1, var9_7);
                                            var14_11[var21_24] = var24_104.construct(var0, var1_1.scope, var25_129);
                                            continue block157;
                                        }
                                        case 32: {
                                            var23_61 = var14_11[var21_24];
                                            if (var23_61 == var3_3) {
                                                var23_61 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.typeof(var23_61);
                                            continue block157;
                                        }
                                        case -14: {
                                            var14_11[++var21_24] = ScriptRuntime.typeofName(var1_1.scope, var8_6);
                                            continue block157;
                                        }
                                        case 41: {
                                            var14_11[++var21_24] = var8_6;
                                            continue block157;
                                        }
                                        case -27: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = Interpreter.getShort(var19_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case -28: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = Interpreter.getInt(var19_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 4;
                                            continue block157;
                                        }
                                        case 40: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = var1_1.idata.itsDoubleTable[var9_7];
                                            continue block157;
                                        }
                                        case 39: {
                                            var14_11[++var21_24] = ScriptRuntime.name(var0, var1_1.scope, var8_6);
                                            continue block157;
                                        }
                                        case -8: {
                                            var14_11[++var21_24] = ScriptRuntime.nameIncrDecr(var1_1.scope, var8_6, var0, var19_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case -61: {
                                            var9_7 = var19_18 /* !! */ [var1_1.pc++];
                                        }
                                        case 155: {
                                            if (!var1_1.useActivation) {
                                                if ((var18_17 /* !! */ [var9_7] & 1) == 0) {
                                                    throw Context.reportRuntimeError1("msg.var.redecl", var1_1.idata.argNames[var9_7]);
                                                }
                                                if ((var18_17 /* !! */ [var9_7] & 8) == 0) continue block157;
                                                var16_14[var9_7] = var14_11[var21_24];
                                                v0 = var9_7;
                                                var18_17 /* !! */ [v0] = var18_17 /* !! */ [v0] & -9;
                                                var17_15[var9_7] = var15_13[var21_24];
                                                continue block157;
                                            }
                                            var23_62 = var14_11[var21_24];
                                            if (var23_62 == var3_3) {
                                                var23_62 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var8_6 = var1_1.idata.argNames[var9_7];
                                            if (var1_1.scope instanceof ConstProperties) {
                                                var24_105 = (ConstProperties)var1_1.scope;
                                                var24_105.putConst(var8_6, var1_1.scope, var23_62);
                                                continue block157;
                                            }
                                            throw Kit.codeBug();
                                        }
                                        case -49: {
                                            var9_7 = var19_18 /* !! */ [var1_1.pc++];
                                        }
                                        case 56: {
                                            if (!var1_1.useActivation) {
                                                if ((var18_17 /* !! */ [var9_7] & 1) != 0) continue block157;
                                                var16_14[var9_7] = var14_11[var21_24];
                                                var17_15[var9_7] = var15_13[var21_24];
                                                continue block157;
                                            }
                                            var23_63 = var14_11[var21_24];
                                            if (var23_63 == var3_3) {
                                                var23_63 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var8_6 = var1_1.idata.argNames[var9_7];
                                            var1_1.scope.put(var8_6, var1_1.scope, var23_63);
                                            continue block157;
                                        }
                                        case -48: {
                                            var9_7 = var19_18 /* !! */ [var1_1.pc++];
                                        }
                                        case 55: {
                                            ++var21_24;
                                            if (!var1_1.useActivation) {
                                                var14_11[var21_24] = var16_14[var9_7];
                                                var15_13[var21_24] = var17_15[var9_7];
                                                continue block157;
                                            }
                                            var8_6 = var1_1.idata.argNames[var9_7];
                                            var14_11[var21_24] = var1_1.scope.get(var8_6, var1_1.scope);
                                            continue block157;
                                        }
                                        case -7: {
                                            ++var21_24;
                                            var23_64 = var19_18 /* !! */ [var1_1.pc];
                                            if (!var1_1.useActivation) {
                                                var14_11[var21_24] = var3_3;
                                                var24_106 = var16_14[var9_7];
                                                if (var24_106 == var3_3) {
                                                    var25_130 = var17_15[var9_7];
                                                } else {
                                                    var25_130 = ScriptRuntime.toNumber(var24_106);
                                                    var16_14[var9_7] = var3_3;
                                                }
                                                var17_15[var9_7] = var27_144 = (var23_64 & 1) == 0 ? var25_130 + 1.0 : var25_130 - 1.0;
                                                var15_13[var21_24] = (var23_64 & 2) == 0 ? var27_144 : var25_130;
                                            } else {
                                                var24_106 = var1_1.idata.argNames[var9_7];
                                                var14_11[var21_24] = ScriptRuntime.nameIncrDecr(var1_1.scope, (String)var24_106, var0, var23_64);
                                            }
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case -51: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = 0.0;
                                            continue block157;
                                        }
                                        case -52: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = 1.0;
                                            continue block157;
                                        }
                                        case 42: {
                                            var14_11[++var21_24] = null;
                                            continue block157;
                                        }
                                        case 43: {
                                            var14_11[++var21_24] = var1_1.thisObj;
                                            continue block157;
                                        }
                                        case 63: {
                                            var14_11[++var21_24] = var1_1.fnOrScript;
                                            continue block157;
                                        }
                                        case 44: {
                                            var14_11[++var21_24] = Boolean.FALSE;
                                            continue block157;
                                        }
                                        case 45: {
                                            var14_11[++var21_24] = Boolean.TRUE;
                                            continue block157;
                                        }
                                        case -50: {
                                            var14_11[++var21_24] = var4_4;
                                            continue block157;
                                        }
                                        case 2: {
                                            var23_65 = var14_11[var21_24];
                                            if (var23_65 == var3_3) {
                                                var23_65 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            --var21_24;
                                            var1_1.scope = ScriptRuntime.enterWith(var23_65, var0, var1_1.scope);
                                            continue block157;
                                        }
                                        case 3: {
                                            var1_1.scope = ScriptRuntime.leaveWith(var1_1.scope);
                                            continue block157;
                                        }
                                        case 57: {
                                            var23_66 = var1_1.idata.itsICode[var1_1.pc] != 0;
                                            var24_107 = (Throwable)var14_11[--var21_24 + 1];
                                            var25_131 = var23_66 == false ? null : (Scriptable)var14_11[var9_7 += var1_1.localShift];
                                            var14_11[var9_7] = ScriptRuntime.newCatchScope(var24_107, var25_131, var8_6, var0, var1_1.scope);
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case 58: 
                                        case 59: 
                                        case 60: {
                                            var23_67 = var14_11[var21_24];
                                            if (var23_67 == var3_3) {
                                                var23_67 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            --var21_24;
                                            var24_108 = var22_25 == 58 ? 0 : (var22_25 == 59 ? 1 : 2);
                                            var14_11[var9_7 += var1_1.localShift] = ScriptRuntime.enumInit(var23_67, var0, var24_108);
                                            continue block157;
                                        }
                                        case 61: 
                                        case 62: {
                                            var23_68 = var14_11[var9_7 += var1_1.localShift];
                                            var14_11[++var21_24] = var22_25 == 61 ? ScriptRuntime.enumNext(var23_68) : ScriptRuntime.enumId(var23_68, var0);
                                            continue block157;
                                        }
                                        case 71: {
                                            var23_69 = var14_11[var21_24];
                                            if (var23_69 == var3_3) {
                                                var23_69 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.specialRef(var23_69, var8_6, var0);
                                            continue block157;
                                        }
                                        case 76: {
                                            var23_70 = var14_11[var21_24];
                                            if (var23_70 == var3_3) {
                                                var23_70 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_109 = var14_11[--var21_24]) == var3_3) {
                                                var24_109 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.memberRef(var24_109, var23_70, var0, var9_7);
                                            continue block157;
                                        }
                                        case 77: {
                                            var23_71 = var14_11[var21_24];
                                            if (var23_71 == var3_3) {
                                                var23_71 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_110 = var14_11[--var21_24]) == var3_3) {
                                                var24_110 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var25_132 = var14_11[--var21_24]) == var3_3) {
                                                var25_132 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.memberRef(var25_132, var24_110, var23_71, var0, var9_7);
                                            continue block157;
                                        }
                                        case 78: {
                                            var23_72 = var14_11[var21_24];
                                            if (var23_72 == var3_3) {
                                                var23_72 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.nameRef(var23_72, var0, var1_1.scope, var9_7);
                                            continue block157;
                                        }
                                        case 79: {
                                            var23_73 = var14_11[var21_24];
                                            if (var23_73 == var3_3) {
                                                var23_73 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_111 = var14_11[--var21_24]) == var3_3) {
                                                var24_111 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.nameRef(var24_111, var23_73, var0, var1_1.scope, var9_7);
                                            continue block157;
                                        }
                                        case -12: {
                                            var1_1.scope = (Scriptable)var14_11[var9_7 += var1_1.localShift];
                                            continue block157;
                                        }
                                        case -13: {
                                            var14_11[var9_7 += var1_1.localShift] = var1_1.scope;
                                            continue block157;
                                        }
                                        case -19: {
                                            var14_11[++var21_24] = InterpretedFunction.createFunction(var0, var1_1.scope, var1_1.fnOrScript, var9_7);
                                            continue block157;
                                        }
                                        case -20: {
                                            Interpreter.initFunction(var0, var1_1.scope, var1_1.fnOrScript, var9_7);
                                            continue block157;
                                        }
                                        case 48: {
                                            var14_11[++var21_24] = var1_1.scriptRegExps[var9_7];
                                            continue block157;
                                        }
                                        case -29: {
                                            var14_11[++var21_24] = new int[var9_7];
                                            var14_11[++var21_24] = new Object[var9_7];
                                            var15_13[var21_24] = 0.0;
                                            continue block157;
                                        }
                                        case -30: {
                                            var23_74 = var14_11[var21_24];
                                            if (var23_74 == var3_3) {
                                                var23_74 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var24_112 = (int)var15_13[--var21_24];
                                            ((Object[])var14_11[var21_24])[var24_112] = var23_74;
                                            var15_13[var21_24] = var24_112 + 1;
                                            continue block157;
                                        }
                                        case -57: {
                                            var23_75 = var14_11[var21_24];
                                            var24_113 = (int)var15_13[--var21_24];
                                            ((Object[])var14_11[var21_24])[var24_113] = var23_75;
                                            ((int[])var14_11[var21_24 - 1])[var24_113] = -1;
                                            var15_13[var21_24] = var24_113 + 1;
                                            continue block157;
                                        }
                                        case -58: {
                                            var23_76 = var14_11[var21_24];
                                            var24_114 = (int)var15_13[--var21_24];
                                            ((Object[])var14_11[var21_24])[var24_114] = var23_76;
                                            ((int[])var14_11[var21_24 - 1])[var24_114] = 1;
                                            var15_13[var21_24] = var24_114 + 1;
                                            continue block157;
                                        }
                                        case -31: 
                                        case 65: 
                                        case 66: {
                                            var23_77 = (Object[])var14_11[var21_24];
                                            var24_115 = (int[])var14_11[--var21_24];
                                            if (var22_25 == 66) {
                                                var26_143 /* !! */  = (Object[])var1_1.idata.literalIds[var9_7];
                                                var25_133 = ScriptRuntime.newObjectLiteral(var26_143 /* !! */ , var23_77, var24_115, var0, var1_1.scope);
                                            } else {
                                                var26_143 /* !! */  = null;
                                                if (var22_25 == -31) {
                                                    var26_143 /* !! */  = (int[])var1_1.idata.literalIds[var9_7];
                                                }
                                                var25_133 = ScriptRuntime.newArrayLiteral(var23_77, (int[])var26_143 /* !! */ , var0, var1_1.scope);
                                            }
                                            var14_11[var21_24] = var25_133;
                                            continue block157;
                                        }
                                        case -53: {
                                            var23_78 = var14_11[var21_24];
                                            if (var23_78 == var3_3) {
                                                var23_78 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            --var21_24;
                                            var1_1.scope = ScriptRuntime.enterDotQuery(var23_78, var1_1.scope);
                                            continue block157;
                                        }
                                        case -54: {
                                            var23_79 = Interpreter.stack_boolean(var1_1, var21_24);
                                            var24_116 = ScriptRuntime.updateDotQuery(var23_79, var1_1.scope);
                                            if (var24_116 != null) {
                                                var14_11[var21_24] = var24_116;
                                                var1_1.scope = ScriptRuntime.leaveDotQuery(var1_1.scope);
                                                var1_1.pc += 2;
                                                continue block157;
                                            }
                                            --var21_24;
                                            break;
                                        }
                                        case 73: {
                                            var23_80 = var14_11[var21_24];
                                            if (var23_80 == var3_3) {
                                                var23_80 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.setDefaultNamespace(var23_80, var0);
                                            continue block157;
                                        }
                                        case 74: {
                                            var23_81 = var14_11[var21_24];
                                            if (var23_81 == var3_3) continue block157;
                                            var14_11[var21_24] = ScriptRuntime.escapeAttributeValue(var23_81, var0);
                                            continue block157;
                                        }
                                        case 75: {
                                            var23_82 = var14_11[var21_24];
                                            if (var23_82 == var3_3) continue block157;
                                            var14_11[var21_24] = ScriptRuntime.escapeTextValue(var23_82, var0);
                                            continue block157;
                                        }
                                        case -64: {
                                            if (var1_1.debuggerFrame == null) continue block157;
                                            var1_1.debuggerFrame.onDebuggerStatement(var0);
                                            continue block157;
                                        }
                                        case -26: {
                                            var1_1.pcSourceLineStart = var1_1.pc;
                                            if (var1_1.debuggerFrame != null) {
                                                var23_83 = Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc);
                                                var1_1.debuggerFrame.onLineChange(var0, var23_83);
                                            }
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case -32: {
                                            var9_7 = 0;
                                            continue block157;
                                        }
                                        case -33: {
                                            var9_7 = 1;
                                            continue block157;
                                        }
                                        case -34: {
                                            var9_7 = 2;
                                            continue block157;
                                        }
                                        case -35: {
                                            var9_7 = 3;
                                            continue block157;
                                        }
                                        case -36: {
                                            var9_7 = 4;
                                            continue block157;
                                        }
                                        case -37: {
                                            var9_7 = 5;
                                            continue block157;
                                        }
                                        case -38: {
                                            var9_7 = 255 & var19_18 /* !! */ [var1_1.pc];
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case -39: {
                                            var9_7 = Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case -40: {
                                            var9_7 = Interpreter.getInt(var19_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 4;
                                            continue block157;
                                        }
                                        case -41: {
                                            var8_6 = var20_22[0];
                                            continue block157;
                                        }
                                        case -42: {
                                            var8_6 = var20_22[1];
                                            continue block157;
                                        }
                                        case -43: {
                                            var8_6 = var20_22[2];
                                            continue block157;
                                        }
                                        case -44: {
                                            var8_6 = var20_22[3];
                                            continue block157;
                                        }
                                        case -45: {
                                            var8_6 = var20_22[255 & var19_18 /* !! */ [var1_1.pc]];
                                            ++var1_1.pc;
                                            continue block157;
                                        }
                                        case -46: {
                                            var8_6 = var20_22[Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc)];
                                            var1_1.pc += 2;
                                            continue block157;
                                        }
                                        case -47: {
                                            var8_6 = var20_22[Interpreter.getInt(var19_18 /* !! */ , var1_1.pc)];
                                            var1_1.pc += 4;
                                            continue block157;
                                        }
                                        default: {
                                            Interpreter.dumpICode(var1_1.idata);
                                            throw new RuntimeException("Unknown icode : " + var22_25 + " @ pc : " + (var1_1.pc - 1));
                                        }
                                    }
                                    if (var5_5) {
                                        Interpreter.addInstructionCount(var0, var1_1, 2);
                                    }
                                    var1_1.pc = (var23_84 = Interpreter.getShort(var19_18 /* !! */ , var1_1.pc)) != 0 ? (var1_1.pc += var23_84 - 1) : var1_1.idata.longJumps.getExistingInt(var1_1.pc);
                                    if (!var5_5) continue;
                                    var1_1.pcPrevBranch = var1_1.pc;
                                }
                                Interpreter.exitFrame(var0, var1_1, null);
                                var11_9 = var1_1.result;
                                var12_10 = var1_1.resultDbl;
                                if (var1_1.parentFrame != null) {
                                    var1_1 = var1_1.parentFrame;
                                    if (var1_1.frozen) {
                                        var1_1 = var1_1.cloneFrozen();
                                    }
                                    Interpreter.setCallResult(var1_1, var11_9, var12_10);
                                    var11_9 = null;
                                    continue;
                                }
                                break block286;
                                break;
                            }
                        }
                        catch (Throwable var14_12) {
                            if (var2_2 != null) {
                                var14_12.printStackTrace(System.err);
                                throw new IllegalStateException();
                            }
                            var2_2 = var14_12;
                        }
                    }
                    if (var2_2 == null) {
                        Kit.codeBug();
                    }
                    var18_17 /* !! */  = null;
                    if (var10_8 != null && var10_8.operation == 2 && var2_2 == var10_8.value) {
                        var17_16 = 1;
                    } else if (var2_2 instanceof JavaScriptException) {
                        var17_16 = 2;
                    } else if (var2_2 instanceof EcmaError) {
                        var17_16 = 2;
                    } else if (var2_2 instanceof EvaluatorException) {
                        var17_16 = 2;
                    } else if (var2_2 instanceof RuntimeException) {
                        var17_16 = var0.hasFeature(13) != false ? 2 : 1;
                    } else if (var2_2 instanceof Error) {
                        var17_16 = var0.hasFeature(13) != false ? 2 : 0;
                    } else if (var2_2 instanceof ContinuationJump) {
                        var17_16 = 1;
                        var18_17 /* !! */  = (int[])((ContinuationJump)var2_2);
                    } else {
                        v1 = var17_16 = var0.hasFeature(13) != false ? 2 : 1;
                    }
                    if (var5_5) {
                        try {
                            Interpreter.addInstructionCount(var0, var1_1, 100);
                        }
                        catch (RuntimeException var19_19) {
                            var2_2 = var19_19;
                            var17_16 = 1;
                        }
                        catch (Error var19_20) {
                            var2_2 = var19_20;
                            var18_17 /* !! */  = null;
                            var17_16 = 0;
                        }
                    }
                    if (var1_1.debuggerFrame != null && var2_2 instanceof RuntimeException) {
                        var19_18 /* !! */  = (byte[])((RuntimeException)var2_2);
                        try {
                            var1_1.debuggerFrame.onExceptionThrown(var0, (Throwable)var19_18 /* !! */ );
                        }
                        catch (Throwable var20_23) {
                            var2_2 = var20_23;
                            var18_17 /* !! */  = null;
                            var17_16 = 0;
                        }
                    }
                    do {
                        if (var17_16 != 0 && (var9_7 = Interpreter.getExceptionHandler(var1_1, var19_21 = var17_16 != 2)) >= 0) continue block155;
                        Interpreter.exitFrame(var0, var1_1, var2_2);
                        var1_1 = var1_1.parentFrame;
                        if (var1_1 == null) break block287;
                    } while (var18_17 /* !! */  == null || var18_17 /* !! */ .branchFrame != var1_1);
                    var9_7 = -1;
                    continue;
                }
                if (var18_17 /* !! */  == null) break block286;
                if (var18_17 /* !! */ .branchFrame != null) {
                    Kit.codeBug();
                }
                if (var18_17 /* !! */ .capturedFrame == null) break;
                var9_7 = -1;
            }
            var11_9 = var18_17 /* !! */ .result;
            var12_10 = var18_17 /* !! */ .resultDbl;
            var2_2 = null;
        }
        if (var0.previousInterpreterInvocations != null && var0.previousInterpreterInvocations.size() != 0) {
            var0.lastInterpreterFrame = var0.previousInterpreterInvocations.pop();
        } else {
            var0.lastInterpreterFrame = null;
            var0.previousInterpreterInvocations = null;
        }
        if (var2_2 != null) {
            if (var2_2 instanceof RuntimeException) {
                throw (RuntimeException)var2_2;
            }
            throw (Error)var2_2;
        }
        return var11_9 != var3_3 ? var11_9 : ScriptRuntime.wrapNumber(var12_10);
    }

    private static CallFrame initFrameForNoSuchMethod(Context context, CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2, int n3, Scriptable scriptable, Scriptable scriptable2, ScriptRuntime.NoSuchMethodShim noSuchMethodShim, InterpretedFunction interpretedFunction) {
        Object object;
        Object[] objectArray2 = null;
        int n4 = n2 + 2;
        Object[] objectArray3 = new Object[n];
        int n5 = 0;
        while (n5 < n) {
            object = objectArray[n4];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n4]);
            }
            objectArray3[n5] = object;
            ++n5;
            ++n4;
        }
        objectArray2 = new Object[]{noSuchMethodShim.methodName, context.newArray(scriptable2, objectArray3)};
        CallFrame callFrame2 = callFrame;
        object = new CallFrame();
        if (n3 == -55) {
            callFrame2 = callFrame.parentFrame;
            Interpreter.exitFrame(context, callFrame, null);
        }
        Interpreter.initFrame(context, scriptable2, scriptable, objectArray2, null, 0, 2, interpretedFunction, callFrame2, (CallFrame)object);
        if (n3 != -55) {
            callFrame.savedStackTop = n2;
            callFrame.savedCallOp = n3;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shallowEquals(Object[] objectArray, double[] dArray, int n) {
        double d;
        double d2;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        UniqueTag uniqueTag = UniqueTag.DOUBLE_MARK;
        if (object == uniqueTag) {
            d2 = dArray[n + 1];
            if (object2 == uniqueTag) {
                d = dArray[n];
            } else {
                if (!(object2 instanceof Number)) return false;
                d = ((Number)object2).doubleValue();
            }
        } else {
            if (object2 != uniqueTag) return ScriptRuntime.shallowEq(object2, object);
            d = dArray[n];
            if (object == uniqueTag) {
                d2 = dArray[n + 1];
            } else {
                if (!(object instanceof Number)) return false;
                d2 = ((Number)object).doubleValue();
            }
        }
        if (d != d2) return false;
        return true;
    }

    private static CallFrame processThrowable(Context context, Object object, CallFrame callFrame, int n, boolean bl) {
        if (n >= 0) {
            if (callFrame.frozen) {
                callFrame = callFrame.cloneFrozen();
            }
            int[] nArray = callFrame.idata.itsExceptionTable;
            callFrame.pc = nArray[n + 2];
            if (bl) {
                callFrame.pcPrevBranch = callFrame.pc;
            }
            callFrame.savedStackTop = callFrame.emptyStackTop;
            int n2 = callFrame.localShift + nArray[n + 5];
            int n3 = callFrame.localShift + nArray[n + 4];
            callFrame.scope = (Scriptable)callFrame.stack[n2];
            callFrame.stack[n3] = object;
            object = null;
        } else {
            ContinuationJump continuationJump = (ContinuationJump)object;
            object = null;
            if (continuationJump.branchFrame != callFrame) {
                Kit.codeBug();
            }
            if (continuationJump.capturedFrame == null) {
                Kit.codeBug();
            }
            int n4 = continuationJump.capturedFrame.frameIndex + 1;
            if (continuationJump.branchFrame != null) {
                n4 -= continuationJump.branchFrame.frameIndex;
            }
            int n5 = 0;
            CallFrame[] callFrameArray = null;
            CallFrame callFrame2 = continuationJump.capturedFrame;
            for (int i = 0; i != n4; ++i) {
                if (!callFrame2.frozen) {
                    Kit.codeBug();
                }
                if (Interpreter.isFrameEnterExitRequired(callFrame2)) {
                    if (callFrameArray == null) {
                        callFrameArray = new CallFrame[n4 - i];
                    }
                    callFrameArray[n5] = callFrame2;
                    ++n5;
                }
                callFrame2 = callFrame2.parentFrame;
            }
            while (n5 != 0) {
                callFrame2 = callFrameArray[--n5];
                Interpreter.enterFrame(context, callFrame2, ScriptRuntime.emptyArgs, true);
            }
            callFrame = continuationJump.capturedFrame.cloneFrozen();
            Interpreter.setCallResult(callFrame, continuationJump.result, continuationJump.resultDbl);
        }
        callFrame.throwable = object;
        return callFrame;
    }

    private static Object freezeGenerator(Context context, CallFrame callFrame, int n, GeneratorState generatorState) {
        if (generatorState.operation == 2) {
            throw ScriptRuntime.typeError0("msg.yield.closing");
        }
        callFrame.frozen = true;
        callFrame.result = callFrame.stack[n];
        callFrame.resultDbl = callFrame.sDbl[n];
        callFrame.savedStackTop = n;
        --callFrame.pc;
        ScriptRuntime.exitActivationFunction(context);
        return callFrame.result != UniqueTag.DOUBLE_MARK ? callFrame.result : ScriptRuntime.wrapNumber(callFrame.resultDbl);
    }

    private static Object thawGenerator(CallFrame callFrame, int n, GeneratorState generatorState, int n2) {
        callFrame.frozen = false;
        int n3 = Interpreter.getIndex(callFrame.idata.itsICode, callFrame.pc);
        callFrame.pc += 2;
        if (generatorState.operation == 1) {
            return new JavaScriptException(generatorState.value, callFrame.idata.itsSourceFile, n3);
        }
        if (generatorState.operation == 2) {
            return generatorState.value;
        }
        if (generatorState.operation != 0) {
            throw Kit.codeBug();
        }
        if (n2 == 72) {
            callFrame.stack[n] = generatorState.value;
        }
        return Scriptable.NOT_FOUND;
    }

    private static CallFrame initFrameForApplyOrCall(Context context, CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2, int n3, Scriptable scriptable, IdFunctionObject idFunctionObject, InterpretedFunction interpretedFunction) {
        Scriptable scriptable2 = n != 0 ? ScriptRuntime.toObjectOrNull(context, objectArray[n2 + 2]) : null;
        if (scriptable2 == null) {
            scriptable2 = ScriptRuntime.getTopCallScope(context);
        }
        if (n3 == -55) {
            Interpreter.exitFrame(context, callFrame, null);
            callFrame = callFrame.parentFrame;
        } else {
            callFrame.savedStackTop = n2;
            callFrame.savedCallOp = n3;
        }
        CallFrame callFrame2 = new CallFrame();
        if (BaseFunction.isApply(idFunctionObject)) {
            Object[] objectArray2 = n < 2 ? ScriptRuntime.emptyArgs : ScriptRuntime.getApplyArguments(context, objectArray[n2 + 3]);
            Interpreter.initFrame(context, scriptable, scriptable2, objectArray2, null, 0, objectArray2.length, interpretedFunction, callFrame, callFrame2);
        } else {
            int n4;
            for (n4 = 1; n4 < n; ++n4) {
                objectArray[n2 + 1 + n4] = objectArray[n2 + 2 + n4];
                dArray[n2 + 1 + n4] = dArray[n2 + 2 + n4];
            }
            n4 = n < 2 ? 0 : n - 1;
            Interpreter.initFrame(context, scriptable, scriptable2, objectArray, dArray, n2 + 2, n4, interpretedFunction, callFrame, callFrame2);
        }
        callFrame = callFrame2;
        return callFrame;
    }

    private static void initFrame(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, double[] dArray, int n, int n2, InterpretedFunction interpretedFunction, CallFrame callFrame, CallFrame callFrame2) {
        int n3;
        int n4;
        double[] dArray2;
        int[] nArray;
        Object[] objectArray2;
        boolean bl;
        int n5;
        int n6;
        Scriptable scriptable3;
        InterpreterData interpreterData = interpretedFunction.idata;
        boolean bl2 = interpreterData.itsNeedsActivation;
        DebugFrame debugFrame = null;
        if (context.debugger != null && (debugFrame = context.debugger.getFrame(context, interpreterData)) != null) {
            bl2 = true;
        }
        if (bl2) {
            if (dArray != null) {
                objectArray = Interpreter.getArgsArray(objectArray, dArray, n, n2);
            }
            n = 0;
            dArray = null;
        }
        if (interpreterData.itsFunctionType != 0) {
            scriptable3 = !interpreterData.useDynamicScope ? interpretedFunction.getParentScope() : scriptable;
            if (bl2) {
                scriptable3 = ScriptRuntime.createFunctionActivation(interpretedFunction, scriptable3, objectArray);
            }
        } else {
            scriptable3 = scriptable;
            ScriptRuntime.initScript(interpretedFunction, scriptable2, context, scriptable3, interpretedFunction.idata.evalScriptFlag);
        }
        if (interpreterData.itsNestedFunctions != null) {
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                Kit.codeBug();
            }
            for (int i = 0; i < interpreterData.itsNestedFunctions.length; ++i) {
                InterpreterData interpreterData2 = interpreterData.itsNestedFunctions[i];
                if (interpreterData2.itsFunctionType != 1) continue;
                Interpreter.initFunction(context, scriptable3, interpretedFunction, i);
            }
        }
        Scriptable[] scriptableArray = null;
        if (interpreterData.itsRegExpLiterals != null) {
            scriptableArray = interpreterData.itsFunctionType != 0 ? interpretedFunction.functionRegExps : interpretedFunction.createRegExpWraps(context, scriptable3);
        }
        if ((n6 = interpreterData.itsMaxFrameArray) != (n5 = interpreterData.itsMaxVars + interpreterData.itsMaxLocals - 1) + interpreterData.itsMaxStack + 1) {
            Kit.codeBug();
        }
        if (callFrame2.stack != null && n6 <= callFrame2.stack.length) {
            bl = true;
            objectArray2 = callFrame2.stack;
            nArray = callFrame2.stackAttributes;
            dArray2 = callFrame2.sDbl;
        } else {
            bl = false;
            objectArray2 = new Object[n6];
            nArray = new int[n6];
            dArray2 = new double[n6];
        }
        int n7 = interpreterData.getParamAndVarCount();
        for (n4 = 0; n4 < n7; ++n4) {
            if (!interpreterData.getParamOrVarConst(n4)) continue;
            nArray[n4] = 13;
        }
        n4 = interpreterData.argCount;
        if (n4 > n2) {
            n4 = n2;
        }
        callFrame2.parentFrame = callFrame;
        int n8 = callFrame2.frameIndex = callFrame == null ? 0 : callFrame.frameIndex + 1;
        if (callFrame2.frameIndex > context.getMaximumInterpreterStackDepth()) {
            throw Context.reportRuntimeError("Exceeded maximum stack depth");
        }
        callFrame2.frozen = false;
        callFrame2.fnOrScript = interpretedFunction;
        callFrame2.idata = interpreterData;
        callFrame2.stack = objectArray2;
        callFrame2.stackAttributes = nArray;
        callFrame2.sDbl = dArray2;
        callFrame2.varSource = callFrame2;
        callFrame2.localShift = interpreterData.itsMaxVars;
        callFrame2.emptyStackTop = n5;
        callFrame2.debuggerFrame = debugFrame;
        callFrame2.useActivation = bl2;
        callFrame2.thisObj = scriptable2;
        callFrame2.scriptRegExps = scriptableArray;
        callFrame2.result = Undefined.instance;
        callFrame2.pc = 0;
        callFrame2.pcPrevBranch = 0;
        callFrame2.pcSourceLineStart = interpreterData.firstLinePC;
        callFrame2.scope = scriptable3;
        callFrame2.savedStackTop = n5;
        callFrame2.savedCallOp = 0;
        System.arraycopy(objectArray, n, objectArray2, 0, n4);
        if (dArray != null) {
            System.arraycopy(dArray, n, dArray2, 0, n4);
        }
        for (n3 = n4; n3 != interpreterData.itsMaxVars; ++n3) {
            objectArray2[n3] = Undefined.instance;
        }
        if (bl) {
            for (n3 = n5 + 1; n3 != objectArray2.length; ++n3) {
                objectArray2[n3] = null;
            }
        }
        Interpreter.enterFrame(context, callFrame2, objectArray, false);
    }

    private static boolean isFrameEnterExitRequired(CallFrame callFrame) {
        return callFrame.debuggerFrame != null || callFrame.idata.itsNeedsActivation;
    }

    private static void enterFrame(Context context, CallFrame callFrame, Object[] objectArray, boolean bl) {
        boolean bl2;
        boolean bl3 = callFrame.idata.itsNeedsActivation;
        boolean bl4 = bl2 = callFrame.debuggerFrame != null;
        if (bl3 || bl2) {
            Scriptable scriptable = callFrame.scope;
            if (scriptable == null) {
                Kit.codeBug();
            } else if (bl) {
                while (scriptable instanceof NativeWith) {
                    if ((scriptable = scriptable.getParentScope()) != null && (callFrame.parentFrame == null || callFrame.parentFrame.scope != scriptable)) continue;
                    Kit.codeBug();
                    break;
                }
            }
            if (bl2) {
                callFrame.debuggerFrame.onEnter(context, scriptable, callFrame.thisObj, objectArray);
            }
            if (bl3) {
                ScriptRuntime.enterActivationFunction(context, scriptable);
            }
        }
    }

    private static void exitFrame(Context context, CallFrame callFrame, Object object) {
        if (callFrame.idata.itsNeedsActivation) {
            ScriptRuntime.exitActivationFunction(context);
        }
        if (callFrame.debuggerFrame != null) {
            try {
                if (object instanceof Throwable) {
                    callFrame.debuggerFrame.onExit(context, true, object);
                } else {
                    ContinuationJump continuationJump = (ContinuationJump)object;
                    Object object2 = continuationJump == null ? callFrame.result : continuationJump.result;
                    if (object2 == UniqueTag.DOUBLE_MARK) {
                        double d = continuationJump == null ? callFrame.resultDbl : continuationJump.resultDbl;
                        object2 = ScriptRuntime.wrapNumber(d);
                    }
                    callFrame.debuggerFrame.onExit(context, false, object2);
                }
            }
            catch (Throwable throwable) {
                System.err.println("RHINO USAGE WARNING: onExit terminated with exception");
                throwable.printStackTrace(System.err);
            }
        }
    }

    private static void setCallResult(CallFrame callFrame, Object object, double d) {
        if (callFrame.savedCallOp == 38) {
            callFrame.stack[callFrame.savedStackTop] = object;
            callFrame.sDbl[callFrame.savedStackTop] = d;
        } else if (callFrame.savedCallOp == 30) {
            if (object instanceof Scriptable) {
                callFrame.stack[callFrame.savedStackTop] = object;
            }
        } else {
            Kit.codeBug();
        }
        callFrame.savedCallOp = 0;
    }

    public static NativeContinuation captureContinuation(Context context) {
        if (context.lastInterpreterFrame == null || !(context.lastInterpreterFrame instanceof CallFrame)) {
            throw new IllegalStateException("Interpreter frames not found");
        }
        return Interpreter.captureContinuation(context, (CallFrame)context.lastInterpreterFrame, true);
    }

    private static NativeContinuation captureContinuation(Context context, CallFrame callFrame, boolean bl) {
        NativeContinuation nativeContinuation = new NativeContinuation();
        ScriptRuntime.setObjectProtoAndParent(nativeContinuation, ScriptRuntime.getTopCallScope(context));
        CallFrame callFrame2 = callFrame;
        CallFrame callFrame3 = callFrame;
        while (callFrame2 != null && !callFrame2.frozen) {
            callFrame2.frozen = true;
            for (int i = callFrame2.savedStackTop + 1; i != callFrame2.stack.length; ++i) {
                callFrame2.stack[i] = null;
                callFrame2.stackAttributes[i] = 0;
            }
            if (callFrame2.savedCallOp == 38) {
                callFrame2.stack[callFrame2.savedStackTop] = null;
            } else if (callFrame2.savedCallOp != 30) {
                Kit.codeBug();
            }
            callFrame3 = callFrame2;
            callFrame2 = callFrame2.parentFrame;
        }
        while (callFrame3.parentFrame != null) {
            callFrame3 = callFrame3.parentFrame;
        }
        if (bl && !callFrame3.isContinuationsTopFrame) {
            throw new IllegalStateException("Cannot capture continuation from JavaScript code not called directly by executeScriptWithContinuations or callFunctionWithContinuations");
        }
        nativeContinuation.initImplementation(callFrame);
        return nativeContinuation;
    }

    private static int stack_int32(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        double d = object == UniqueTag.DOUBLE_MARK ? callFrame.sDbl[n] : ScriptRuntime.toNumber(object);
        return ScriptRuntime.toInt32(d);
    }

    private static double stack_double(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object != UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toNumber(object);
        }
        return callFrame.sDbl[n];
    }

    private static boolean stack_boolean(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object == Boolean.TRUE) {
            return true;
        }
        if (object == Boolean.FALSE) {
            return false;
        }
        if (object == UniqueTag.DOUBLE_MARK) {
            double d = callFrame.sDbl[n];
            return d == d && d != 0.0;
        }
        if (object == null || object == Undefined.instance) {
            return false;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return d == d && d != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return ScriptRuntime.toBoolean(object);
    }

    private static void do_add(Object[] objectArray, double[] dArray, int n, Context context) {
        boolean bl;
        double d;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == UniqueTag.DOUBLE_MARK) {
            d = dArray[n + 1];
            if (object2 == UniqueTag.DOUBLE_MARK) {
                int n2 = n;
                dArray[n2] = dArray[n2] + d;
                return;
            }
            bl = true;
        } else if (object2 == UniqueTag.DOUBLE_MARK) {
            d = dArray[n];
            object2 = object;
            bl = false;
        } else {
            if (object2 instanceof Scriptable || object instanceof Scriptable) {
                objectArray[n] = ScriptRuntime.add(object2, object, context);
            } else if (object2 instanceof String) {
                String string = (String)object2;
                String string2 = ScriptRuntime.toString(object);
                objectArray[n] = string.concat(string2);
            } else if (object instanceof String) {
                String string = ScriptRuntime.toString(object2);
                String string3 = (String)object;
                objectArray[n] = string.concat(string3);
            } else {
                double d2 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
                double d3 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
                objectArray[n] = UniqueTag.DOUBLE_MARK;
                dArray[n] = d2 + d3;
            }
            return;
        }
        if (object2 instanceof Scriptable) {
            object = ScriptRuntime.wrapNumber(d);
            if (!bl) {
                Object object3 = object2;
                object2 = object;
                object = object3;
            }
            objectArray[n] = ScriptRuntime.add(object2, object, context);
        } else if (object2 instanceof String) {
            String string = (String)object2;
            String string4 = ScriptRuntime.toString(d);
            objectArray[n] = bl ? string.concat(string4) : string4.concat(string);
        } else {
            double d4 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
            objectArray[n] = UniqueTag.DOUBLE_MARK;
            dArray[n] = d4 + d;
        }
    }

    private static Object[] getArgsArray(Object[] objectArray, double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        while (n3 != n2) {
            Object object = objectArray[n];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n]);
            }
            objectArray2[n3] = object;
            ++n3;
            ++n;
        }
        return objectArray2;
    }

    private static void addInstructionCount(Context context, CallFrame callFrame, int n) {
        context.instructionCount += callFrame.pc - callFrame.pcPrevBranch + n;
        if (context.instructionCount > context.instructionThreshold) {
            context.observeInstructionCount(context.instructionCount);
            context.instructionCount = 0;
        }
    }

    private static class CallFrame
    implements Cloneable,
    Serializable {
        static final long serialVersionUID = -2843792508994958978L;
        CallFrame parentFrame;
        int frameIndex;
        boolean frozen;
        InterpretedFunction fnOrScript;
        InterpreterData idata;
        Object[] stack;
        int[] stackAttributes;
        double[] sDbl;
        CallFrame varSource;
        int localShift;
        int emptyStackTop;
        DebugFrame debuggerFrame;
        boolean useActivation;
        boolean isContinuationsTopFrame;
        Scriptable thisObj;
        Scriptable[] scriptRegExps;
        Object result;
        double resultDbl;
        int pc;
        int pcPrevBranch;
        int pcSourceLineStart;
        Scriptable scope;
        int savedStackTop;
        int savedCallOp;
        Object throwable;

        private CallFrame() {
        }

        CallFrame cloneFrozen() {
            CallFrame callFrame;
            if (!this.frozen) {
                Kit.codeBug();
            }
            try {
                callFrame = (CallFrame)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException();
            }
            callFrame.stack = (Object[])this.stack.clone();
            callFrame.stackAttributes = (int[])this.stackAttributes.clone();
            callFrame.sDbl = (double[])this.sDbl.clone();
            callFrame.frozen = false;
            return callFrame;
        }
    }

    private static final class ContinuationJump
    implements Serializable {
        static final long serialVersionUID = 7687739156004308247L;
        CallFrame capturedFrame;
        CallFrame branchFrame;
        Object result;
        double resultDbl;

        ContinuationJump(NativeContinuation nativeContinuation, CallFrame callFrame) {
            this.capturedFrame = (CallFrame)nativeContinuation.getImplementation();
            if (this.capturedFrame == null || callFrame == null) {
                this.branchFrame = null;
            } else {
                CallFrame callFrame2 = this.capturedFrame;
                CallFrame callFrame3 = callFrame;
                int n = callFrame2.frameIndex - callFrame3.frameIndex;
                if (n != 0) {
                    if (n < 0) {
                        callFrame2 = callFrame;
                        callFrame3 = this.capturedFrame;
                        n = -n;
                    }
                    do {
                        callFrame2 = callFrame2.parentFrame;
                    } while (--n != 0);
                    if (callFrame2.frameIndex != callFrame3.frameIndex) {
                        Kit.codeBug();
                    }
                }
                while (callFrame2 != callFrame3 && callFrame2 != null) {
                    callFrame2 = callFrame2.parentFrame;
                    callFrame3 = callFrame3.parentFrame;
                }
                this.branchFrame = callFrame2;
                if (this.branchFrame != null && !this.branchFrame.frozen) {
                    Kit.codeBug();
                }
            }
        }
    }

    static class GeneratorState {
        int operation;
        Object value;
        RuntimeException returnedException;

        GeneratorState(int n, Object object) {
            this.operation = n;
            this.value = object;
        }
    }
}

