/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.nb.javascript.JavaAdapter;
import org.mozilla.nb.javascript.JavaMembers;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCache
implements Serializable {
    private static final long serialVersionUID = -8866246036237312215L;
    private static final Object AKEY = "ClassCache";
    private volatile boolean cachingIsEnabled = true;
    private transient HashMap<Class<?>, JavaMembers> classTable;
    private transient HashMap<JavaAdapter.JavaAdapterSignature, Class<?>> classAdapterCache;
    private transient HashMap<Class<?>, Object> interfaceAdapterCache;
    private int generatedClassSerial;

    public static ClassCache get(Scriptable scriptable) {
        ClassCache classCache = (ClassCache)ScriptableObject.getTopScopeValue(scriptable, AKEY);
        if (classCache == null) {
            throw new RuntimeException("Can't find top level scope for ClassCache.get");
        }
        return classCache;
    }

    public boolean associate(ScriptableObject scriptableObject) {
        if (scriptableObject.getParentScope() != null) {
            throw new IllegalArgumentException();
        }
        return this == scriptableObject.associateValue(AKEY, this);
    }

    public synchronized void clearCaches() {
        this.classTable = null;
        this.classAdapterCache = null;
        this.interfaceAdapterCache = null;
    }

    public final boolean isCachingEnabled() {
        return this.cachingIsEnabled;
    }

    public synchronized void setCachingEnabled(boolean bl) {
        if (bl == this.cachingIsEnabled) {
            return;
        }
        if (!bl) {
            this.clearCaches();
        }
        this.cachingIsEnabled = bl;
    }

    Map<Class<?>, JavaMembers> getClassCacheMap() {
        if (this.classTable == null) {
            this.classTable = new HashMap();
        }
        return this.classTable;
    }

    Map<JavaAdapter.JavaAdapterSignature, Class<?>> getInterfaceAdapterCacheMap() {
        if (this.classAdapterCache == null) {
            this.classAdapterCache = new HashMap();
        }
        return this.classAdapterCache;
    }

    public boolean isInvokerOptimizationEnabled() {
        return false;
    }

    public synchronized void setInvokerOptimizationEnabled(boolean bl) {
    }

    public final synchronized int newClassSerialNumber() {
        return ++this.generatedClassSerial;
    }

    Object getInterfaceAdapter(Class<?> clazz) {
        return this.interfaceAdapterCache == null ? null : this.interfaceAdapterCache.get(clazz);
    }

    synchronized void cacheInterfaceAdapter(Class<?> clazz, Object object) {
        if (this.cachingIsEnabled) {
            if (this.interfaceAdapterCache == null) {
                this.interfaceAdapterCache = new HashMap();
            }
            this.interfaceAdapterCache.put(clazz, object);
        }
    }
}

