/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.EmbeddingModel;
import org.netbeans.modules.gsf.api.IncrementalEmbeddingModel;
import org.netbeans.modules.gsf.api.IncrementalParser;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.spi.DefaultParserFile;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.util.LowMemoryEvent;
import org.netbeans.modules.gsfret.source.util.LowMemoryListener;
import org.netbeans.modules.gsfret.source.util.LowMemoryNotifier;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.ModificationResult;
import org.netbeans.napi.gsfret.source.ParserTaskImpl;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.StringSourceFileReader;
import org.netbeans.napi.gsfret.source.WorkingCopy;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Source {
    private static final int INVALID = 1;
    private static final int CHANGE_EXPECTED = 2;
    private static final int RESCHEDULE_FINISHED_TASKS = 4;
    private static final int UPDATE_INDEX = 8;
    private static final boolean reportSlowTasks = Boolean.getBoolean("org.netbeans.napi.gsfret.source.Source.reportSlowTasks");
    private static final int SLOW_TASK_LIMIT = 250;
    private static final int SLOW_CANCEL_LIMIT = 50;
    static int REPARSE_DELAY = 500;
    private static Map<Phase, String> phase2Key = new HashMap<Phase, String>();
    private static Map<Phase, String> phase2Message = new HashMap<Phase, String>();
    private static final PriorityBlockingQueue<Request> requests;
    private static final Map<Source, Collection<Request>> finishedRequests;
    private static final Map<Source, Collection<Request>> waitingRequests;
    private static final Collection<CancellableTask> toRemove;
    private static final SingleThreadFactory factory;
    private static final CurrentRequestReference currentRequest;
    private static final EditorRegistryListener editorRegistryListener;
    private static final ReentrantLock javacLock;
    private final Collection<FileObject> files;
    private final FileObject rootFo;
    private final FileChangeListener fileChangeListener;
    private DocListener listener;
    private PropertyChangeListener dataObjectListener;
    private final ClasspathInfo classpathInfo;
    private CompilationInfo currentInfo;
    private Map<String, ParserResult> recentParseResult = new HashMap<String, ParserResult>();
    private Map<EmbeddingModel, Collection<? extends TranslatedSource>> recentEmbeddingTranslations = new IdentityHashMap<EmbeddingModel, Collection<? extends TranslatedSource>>();
    private EditHistory editHistory = new EditHistory();
    private Stack<CompilationInfo> infoStack = new Stack();
    private int flags = 0;
    private Object filterListener;
    private boolean possiblyIncremental;
    private static Map<FileObject, Reference<Source>> file2JavaSource;
    private final RequestProcessor.Task resetTask = RequestProcessor.getDefault().create(new Runnable(){

        public void run() {
            Source.this.resetStateImpl();
        }
    });
    private static final int MAX_DUMPS = 255;

    public static Source create(ClasspathInfo classpathInfo, Collection<? extends FileObject> collection) throws IllegalArgumentException {
        if (collection == null || classpathInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            return new Source(classpathInfo, collection);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger("global").warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)dataObjectNotFoundException.getFileObject()));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    public static Source create(ClasspathInfo classpathInfo, FileObject ... fileObjectArray) throws IllegalArgumentException {
        if (fileObjectArray == null || classpathInfo == null) {
            throw new IllegalArgumentException();
        }
        return Source.create(classpathInfo, Arrays.asList(fileObjectArray));
    }

    public static void clearSourceCache() {
        file2JavaSource.clear();
    }

    public static Source forFileObject(FileObject fileObject) throws IllegalArgumentException {
        Source source;
        if (fileObject == null) {
            throw new IllegalArgumentException("fileObject == null");
        }
        if (!fileObject.isValid() || fileObject.isFolder()) {
            return null;
        }
        if (!LanguageRegistry.getInstance().isSupported(fileObject.getMIMEType())) {
            return null;
        }
        Reference<Source> reference = file2JavaSource.get(fileObject);
        Source source2 = source = reference != null ? reference.get() : null;
        if (source == null) {
            source = Source.create(ClasspathInfo.create(fileObject), fileObject);
            file2JavaSource.put(fileObject, new WeakReference<Source>(source));
        }
        return source;
    }

    public static Source forDocument(Document document) throws IllegalArgumentException {
        FileObject fileObject;
        Source source;
        if (document == null) {
            throw new IllegalArgumentException("doc == null");
        }
        Reference reference = (Reference)document.getProperty(Source.class);
        Source source2 = source = reference != null ? (Source)reference.get() : null;
        if (source == null && (fileObject = DataLoadersBridge.getDefault().getFileObject(document)) != null) {
            source = Source.forFileObject(fileObject);
        }
        return source;
    }

    private Source(ClasspathInfo classpathInfo, Collection<? extends FileObject> collection) throws IOException {
        this.files = Collections.unmodifiableList(new ArrayList<FileObject>(collection));
        this.fileChangeListener = new FileChangeListenerImpl();
        boolean bl = this.files.size() > 1;
        boolean bl2 = false;
        Iterator<FileObject> iterator = this.files.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = iterator.next();
            try {
                if (bl) continue;
                this.possiblyIncremental = LanguageRegistry.getInstance().isIncremental(fileObject.getMIMEType());
                fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeListener, (Object)fileObject));
                this.assignDocumentListener(fileObject);
                this.dataObjectListener = DataLoadersBridge.getDefault().getDataObjectListener(fileObject, (FileChangeListener)new FileChangeAdapter(){

                    public void fileChanged(FileEvent fileEvent) {
                        try {
                            Source.this.assignDocumentListener(fileEvent.getFile());
                            Source.this.resetState(true, true);
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(Source.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
                        }
                    }
                });
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                if (bl) {
                    Logger.getLogger("global").warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                    iterator.remove();
                    continue;
                }
                throw dataObjectNotFoundException;
            }
        }
        this.classpathInfo = classpathInfo;
        this.rootFo = collection.size() == 1 ? this.classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).findOwnerRoot(collection.iterator().next()) : null;
        this.classpathInfo.addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)this.classpathInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUserActionTask(CancellableTask<CompilationController> cancellableTask, boolean bl) throws IOException {
        Object object;
        if (cancellableTask == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        boolean bl2 = false;
        if (!$assertionsDisabled) {
            bl2 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl2 && !javacLock.isHeldByCurrentThread() && Source.holdsDocumentWriteLock(this.files)) {
            object = "Source.runCompileControlTask called under Document write lock.";
            Logger.getLogger(Source.class.getName()).log(Level.INFO, (String)object, new IllegalStateException((String)object));
        }
        if (this.files.size() <= 1) {
            object = currentRequest.getTaskToCancel();
            try {
                if (object != null) {
                    ((Request)object).task.cancel();
                }
                javacLock.lock();
                try {
                    try {
                        block44: {
                            CompilationInfo compilationInfo = null;
                            Source source = this;
                            synchronized (source) {
                                if (this.currentInfo != null && (this.flags & 1) == 0) {
                                    compilationInfo = this.currentInfo;
                                }
                                if (!bl) {
                                    this.flags |= 1;
                                }
                            }
                            if (compilationInfo == null) {
                                compilationInfo = Source.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
                                if (bl) {
                                    source = this;
                                    synchronized (source) {
                                        if (this.currentInfo == null || (this.flags & 1) != 0) {
                                            this.currentInfo = compilationInfo;
                                            this.flags &= 0xFFFFFFFE;
                                        } else {
                                            compilationInfo = this.currentInfo;
                                        }
                                    }
                                }
                            }
                            assert (compilationInfo != null);
                            if (bl) {
                                if (!this.infoStack.isEmpty()) {
                                    compilationInfo = this.infoStack.peek();
                                }
                            } else {
                                this.infoStack.push(compilationInfo);
                            }
                            try {
                                cancellableTask.run((Object)new CompilationController(compilationInfo));
                                Object var10_19 = null;
                                if (bl) break block44;
                                this.infoStack.pop();
                            }
                            catch (Throwable throwable) {
                                Object var10_20 = null;
                                if (!bl) {
                                    this.infoStack.pop();
                                }
                                throw throwable;
                            }
                            {
                            }
                        }
                        Object var12_23 = null;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        IOException iOException = new IOException();
                        iOException.initCause(exception);
                        throw iOException;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_24 = null;
                    javacLock.unlock();
                    throw throwable;
                }
                javacLock.unlock();
                Object var14_26 = null;
                currentRequest.cancelCompleted((Request)object);
            }
            catch (Throwable throwable) {
                Object var14_27 = null;
                currentRequest.cancelCompleted((Request)object);
                throw throwable;
            }
        }
        object = currentRequest.getTaskToCancel();
        try {
            if (object != null) {
                ((Request)object).task.cancel();
            }
            javacLock.lock();
            try {
                try {
                    ParserTaskImpl parserTaskImpl = null;
                    FileObject fileObject = null;
                    Iterator<FileObject> iterator = this.files.iterator();
                    while (iterator.hasNext() || fileObject != null) {
                        boolean bl3;
                        if (fileObject == null) {
                            fileObject = iterator.next();
                            bl3 = false;
                        } else {
                            bl3 = true;
                        }
                        CompilationInfo compilationInfo = Source.createCurrentInfo(this, fileObject, this.filterListener, parserTaskImpl);
                        cancellableTask.run((Object)new CompilationController(compilationInfo));
                        if (!compilationInfo.needsRestart) {
                            parserTaskImpl = compilationInfo.getParserTask();
                            fileObject = null;
                            continue;
                        }
                        parserTaskImpl = null;
                        compilationInfo = null;
                        System.gc();
                        if (!bl3) continue;
                        throw new InsufficientMemoryException(fileObject);
                    }
                    Object var16_29 = null;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    IOException iOException = new IOException();
                    iOException.initCause(exception);
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var16_30 = null;
                javacLock.unlock();
                throw throwable;
            }
            javacLock.unlock();
            Object var18_32 = null;
            currentRequest.cancelCompleted((Request)object);
        }
        catch (Throwable throwable) {
            Object var18_33 = null;
            currentRequest.cancelCompleted((Request)object);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationResult runModificationTask(CancellableTask<WorkingCopy> cancellableTask) throws IOException {
        Object object;
        if (cancellableTask == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        assert (javacLock.isHeldByCurrentThread() || !Source.holdsDocumentWriteLock(this.files)) : "Source.runCompileControlTask called under Document write lock.";
        ModificationResult modificationResult = new ModificationResult(this);
        if (this.files.size() <= 1) {
            object = currentRequest.getTaskToCancel();
            try {
                if (object != null) {
                    ((Request)object).task.cancel();
                }
                javacLock.lock();
                try {
                    block38: {
                        try {
                            CompilationInfo compilationInfo = null;
                            Object object2 = this;
                            synchronized (object2) {
                                if (this.currentInfo != null && (this.flags & 1) == 0) {
                                    compilationInfo = this.currentInfo;
                                }
                            }
                            if (compilationInfo == null) {
                                compilationInfo = Source.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
                                object2 = this;
                                synchronized (object2) {
                                    if (this.currentInfo == null || (this.flags & 1) != 0) {
                                        this.currentInfo = compilationInfo;
                                        this.flags &= 0xFFFFFFFE;
                                    } else {
                                        compilationInfo = this.currentInfo;
                                    }
                                }
                            }
                            assert (compilationInfo != null);
                            object2 = new WorkingCopy(compilationInfo);
                            cancellableTask.run(object2);
                            List<ModificationResult.Difference> list = ((WorkingCopy)((Object)object2)).getChanges();
                            if (list == null || list.size() <= 0) break block38;
                            modificationResult.diffs.put(compilationInfo.getFileObject(), list);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            IOException iOException = new IOException();
                            iOException.initCause(exception);
                            throw iOException;
                        }
                    }
                    Object var9_19 = null;
                }
                catch (Throwable throwable) {
                    Object var9_20 = null;
                    javacLock.unlock();
                    throw throwable;
                }
                javacLock.unlock();
                Object var11_24 = null;
                currentRequest.cancelCompleted((Request)object);
            }
            catch (Throwable throwable) {
                Object var11_25 = null;
                currentRequest.cancelCompleted((Request)object);
                throw throwable;
            }
        }
        object = currentRequest.getTaskToCancel();
        try {
            if (object != null) {
                ((Request)object).task.cancel();
            }
            javacLock.lock();
            try {
                try {
                    ParserTaskImpl parserTaskImpl = null;
                    FileObject fileObject = null;
                    Iterator<FileObject> iterator = this.files.iterator();
                    while (iterator.hasNext() || fileObject != null) {
                        boolean bl;
                        if (fileObject == null) {
                            fileObject = iterator.next();
                            bl = false;
                        } else {
                            bl = true;
                        }
                        CompilationInfo compilationInfo = Source.createCurrentInfo(this, fileObject, this.filterListener, parserTaskImpl);
                        WorkingCopy workingCopy = new WorkingCopy(compilationInfo);
                        cancellableTask.run((Object)workingCopy);
                        if (!compilationInfo.needsRestart) {
                            parserTaskImpl = compilationInfo.getParserTask();
                            List<ModificationResult.Difference> list = workingCopy.getChanges();
                            if (list != null && list.size() > 0) {
                                modificationResult.diffs.put(compilationInfo.getFileObject(), list);
                            }
                            fileObject = null;
                            continue;
                        }
                        parserTaskImpl = null;
                        compilationInfo = null;
                        System.gc();
                        if (!bl) continue;
                        throw new InsufficientMemoryException(fileObject);
                    }
                    Object var13_28 = null;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    IOException iOException = new IOException();
                    iOException.initCause(exception);
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var13_29 = null;
                javacLock.unlock();
                throw throwable;
            }
            javacLock.unlock();
            Object var15_31 = null;
            currentRequest.cancelCompleted((Request)object);
        }
        catch (Throwable throwable) {
            Object var15_32 = null;
            currentRequest.cancelCompleted((Request)object);
            throw throwable;
        }
        object = this;
        synchronized (object) {
            this.flags |= 1;
        }
        return modificationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPhaseCompletionTask(CancellableTask<CompilationInfo> cancellableTask, Phase phase, Priority priority) throws IOException {
        CompilationInfo compilationInfo;
        if (cancellableTask == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (phase == null || phase == Phase.MODIFIED) {
            throw new IllegalArgumentException(String.format("The %s is not a legal value of phase", new Object[]{phase}));
        }
        if (priority == null) {
            throw new IllegalArgumentException("The priority cannot be null");
        }
        Source source = this;
        synchronized (source) {
            compilationInfo = this.currentInfo;
        }
        if (compilationInfo == null) {
            compilationInfo = Source.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
        }
        source = this;
        synchronized (source) {
            if (this.currentInfo == null) {
                this.currentInfo = compilationInfo;
            }
        }
        Source.handleAddRequest(new Request(cancellableTask, this, phase, priority, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePhaseCompletionTask(CancellableTask<CompilationInfo> cancellableTask) {
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            toRemove.add(cancellableTask);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescheduleTask(CancellableTask<CompilationInfo> cancellableTask) {
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            block8: {
                Request request = currentRequest.getTaskToCancel(cancellableTask);
                if (request == null) {
                    Iterator<Collection<Request>> iterator = finishedRequests.values().iterator();
                    while (iterator.hasNext()) {
                        Collection<Request> collection = iterator.next();
                        Iterator<Request> iterator2 = collection.iterator();
                        while (iterator2.hasNext()) {
                            Request request2 = iterator2.next();
                            if (cancellableTask != request2.task) continue;
                            iterator2.remove();
                            requests.add(request2);
                            if (collection.size() == 0) {
                                iterator.remove();
                            }
                            break block8;
                        }
                    }
                } else {
                    currentRequest.cancelCompleted(request);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void revalidate() {
        this.resetState(true, false);
    }

    public ClasspathInfo getClasspathInfo() {
        return this.classpathInfo;
    }

    public Collection<FileObject> getFileObjects() {
        return this.files;
    }

    ParserTaskImpl createParserTask(CompilationInfo compilationInfo) {
        Language language = compilationInfo.getLanguage();
        assert (language != null);
        ParserTaskImpl parserTaskImpl = Source.createParserTask(language, compilationInfo, this.getClasspathInfo(), false);
        return parserTaskImpl;
    }

    private static ParserTaskImpl createParserTask(Language language, CompilationInfo compilationInfo, ClasspathInfo classpathInfo, boolean bl) {
        ParserTaskImpl parserTaskImpl = new ParserTaskImpl(language);
        return parserTaskImpl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Phase moveToPhase(Phase phase, CompilationInfo compilationInfo, boolean bl) throws IOException {
        LMListener lMListener;
        LowMemoryNotifier lowMemoryNotifier;
        boolean bl2;
        Phase phase2;
        block103: {
            Phase phase3;
            block102: {
                Phase phase4;
                block101: {
                    Phase phase5;
                    block100: {
                        Phase phase6;
                        block99: {
                            Phase phase7;
                            block98: {
                                Phase phase8;
                                block96: {
                                    Phase phase9;
                                    block94: {
                                        block95: {
                                            phase2 = compilationInfo.getPhase();
                                            bl2 = compilationInfo.getSource().files.size() > 1;
                                            lowMemoryNotifier = null;
                                            lMListener = null;
                                            if (bl2) {
                                                lowMemoryNotifier = LowMemoryNotifier.getDefault();
                                                assert (lowMemoryNotifier != null);
                                                lMListener = new LMListener();
                                                lowMemoryNotifier.addLowMemoryListener(lMListener);
                                            }
                                            try {
                                                try {
                                                    long l;
                                                    block104: {
                                                        if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                                                            compilationInfo.needsRestart = true;
                                                            phase9 = phase2;
                                                            Object var44_17 = null;
                                                            if (!bl2) break block94;
                                                            if ($assertionsDisabled || lowMemoryNotifier != null) break block95;
                                                            throw new AssertionError();
                                                        }
                                                        if (phase2.compareTo(Phase.PARSED) >= 0 || phase.compareTo(Phase.PARSED) < 0) break block104;
                                                        if (bl && currentRequest.isCanceled()) {
                                                            phase8 = Phase.MODIFIED;
                                                            break block96;
                                                        }
                                                        l = System.currentTimeMillis();
                                                        DefaultParserFile defaultParserFile = new DefaultParserFile(compilationInfo.getFileObject(), null, false);
                                                        List<DefaultParserFile> list = Collections.singletonList(defaultParserFile);
                                                        FileObject fileObject = compilationInfo.getFileObject();
                                                        final ParserResult[] parserResultArray = new ParserResult[1];
                                                        ParseListener parseListener = new ParseListener(){
                                                            final List<org.netbeans.modules.gsf.api.Error> errors = new ArrayList<org.netbeans.modules.gsf.api.Error>();

                                                            public void started(ParseEvent parseEvent) {
                                                                this.errors.clear();
                                                            }

                                                            public void error(org.netbeans.modules.gsf.api.Error error) {
                                                                this.errors.add(error);
                                                            }

                                                            public void exception(Exception exception) {
                                                                Exceptions.printStackTrace((Throwable)exception);
                                                            }

                                                            public void finished(ParseEvent parseEvent) {
                                                                if (parseEvent.getKind() == ParseEvent.Kind.PARSE) {
                                                                    ParserResult parserResult = parseEvent.getResult();
                                                                    for (org.netbeans.modules.gsf.api.Error error : this.errors) {
                                                                        parserResult.addError(error);
                                                                    }
                                                                    parserResultArray[0] = parserResult;
                                                                }
                                                            }
                                                        };
                                                        LanguageRegistry languageRegistry = LanguageRegistry.getInstance();
                                                        String string = compilationInfo.getFileObject().getMIMEType();
                                                        List<Language> list2 = languageRegistry.getApplicableLanguages(string);
                                                        Source source = compilationInfo.getSource();
                                                        compilationInfo.setHistory(source.editHistory);
                                                        for (Language language : list2) {
                                                            long l2;
                                                            long l3;
                                                            block105: {
                                                                EditHistory editHistory;
                                                                String string2;
                                                                Object object;
                                                                Collection<? extends TranslatedSource> collection;
                                                                IncrementalParser incrementalParser;
                                                                Parser parser;
                                                                block106: {
                                                                    boolean bl3;
                                                                    long l4;
                                                                    Document document;
                                                                    EmbeddingModel embeddingModel;
                                                                    block97: {
                                                                        block107: {
                                                                            void var33_64;
                                                                            embeddingModel = languageRegistry.getEmbedding(language.getMimeType(), string);
                                                                            assert (language != null);
                                                                            parser = language.getParser();
                                                                            IncrementalParser incrementalParser2 = incrementalParser = parser instanceof IncrementalParser ? (IncrementalParser)parser : null;
                                                                            if (bl && currentRequest.isCanceled()) {
                                                                                Phase phase10 = Phase.MODIFIED;
                                                                                Object var44_19 = null;
                                                                                if (bl2) {
                                                                                    assert (lowMemoryNotifier != null);
                                                                                    assert (lMListener != null);
                                                                                    lowMemoryNotifier.removeLowMemoryListener(lMListener);
                                                                                }
                                                                                compilationInfo.setPhase(phase2);
                                                                                return phase10;
                                                                            }
                                                                            l3 = -1L;
                                                                            l2 = -1L;
                                                                            if (parser == null) break block105;
                                                                            if (embeddingModel == null) break block106;
                                                                            document = compilationInfo.getDocument();
                                                                            if (document == null) {
                                                                                GsfUtilities.getDocument((FileObject)compilationInfo.getFileObject(), (boolean)true);
                                                                                document = compilationInfo.getDocument();
                                                                            } else if ("text/plain".equals(document.getProperty("mimeType"))) {
                                                                                Phase phase11 = Phase.MODIFIED;
                                                                                Object var44_20 = null;
                                                                                if (bl2) {
                                                                                    assert (lowMemoryNotifier != null);
                                                                                    assert (lMListener != null);
                                                                                    lowMemoryNotifier.removeLowMemoryListener(lMListener);
                                                                                }
                                                                                compilationInfo.setPhase(phase2);
                                                                                return phase11;
                                                                            }
                                                                            if (document == null) continue;
                                                                            if (bl && currentRequest.isCanceled()) {
                                                                                Phase phase12 = Phase.MODIFIED;
                                                                                Object var44_21 = null;
                                                                                if (bl2) {
                                                                                    assert (lowMemoryNotifier != null);
                                                                                    assert (lMListener != null);
                                                                                    lowMemoryNotifier.removeLowMemoryListener(lMListener);
                                                                                }
                                                                                compilationInfo.setPhase(phase2);
                                                                                return phase12;
                                                                            }
                                                                            l4 = System.currentTimeMillis();
                                                                            collection = null;
                                                                            bl3 = false;
                                                                            if (!(embeddingModel instanceof IncrementalEmbeddingModel) || source.files != null && source.files.size() > 1) break block97;
                                                                            bl3 = true;
                                                                            object = (IncrementalEmbeddingModel)embeddingModel;
                                                                            collection = source.recentEmbeddingTranslations.get(embeddingModel);
                                                                            if (collection == null) break block97;
                                                                            EditHistory editHistory2 = source.editHistory;
                                                                            if (collection.size() > 0) {
                                                                                EditHistory editHistory3 = EditHistory.getCombinedEdits((int)collection.iterator().next().getEditVersion(), (EditHistory)source.editHistory);
                                                                            }
                                                                            if (var33_64 == null || !var33_64.isValid()) break block107;
                                                                            string2 = object.update((EditHistory)var33_64, collection);
                                                                            if (string2 == IncrementalEmbeddingModel.UpdateState.COMPLETED) {
                                                                                ParserResult parserResult = source.recentParseResult.get(language.getMimeType());
                                                                                for (TranslatedSource translatedSource : collection) {
                                                                                    translatedSource.setEditVersion(source.editHistory.getVersion());
                                                                                }
                                                                                if (parserResult != null) {
                                                                                    compilationInfo.addEmbeddingResult(language.getMimeType(), parserResult);
                                                                                    parserResult.setUpdateState(ParserResult.UpdateState.NO_CHANGE);
                                                                                    continue;
                                                                                }
                                                                                break block97;
                                                                            } else if (string2 == IncrementalEmbeddingModel.UpdateState.FAILED) {
                                                                                collection = null;
                                                                                break block97;
                                                                            } else {
                                                                                assert (string2 == IncrementalEmbeddingModel.UpdateState.UPDATED);
                                                                                for (TranslatedSource translatedSource : collection) {
                                                                                    translatedSource.setEditVersion(source.editHistory.getVersion());
                                                                                }
                                                                            }
                                                                            break block97;
                                                                        }
                                                                        collection = null;
                                                                    }
                                                                    if (collection == null) {
                                                                        collection = embeddingModel.translate(document);
                                                                        if (bl3) {
                                                                            source.recentEmbeddingTranslations.put(embeddingModel, collection);
                                                                            for (TranslatedSource translatedSource : collection) {
                                                                                translatedSource.setEditVersion(source.editHistory.getVersion());
                                                                            }
                                                                        }
                                                                    }
                                                                    if (bl && currentRequest.isCanceled()) {
                                                                        object = Phase.MODIFIED;
                                                                        Object var44_22 = null;
                                                                        if (bl2) {
                                                                            assert (lowMemoryNotifier != null);
                                                                            assert (lMListener != null);
                                                                            lowMemoryNotifier.removeLowMemoryListener(lMListener);
                                                                        }
                                                                        compilationInfo.setPhase(phase2);
                                                                        return object;
                                                                    }
                                                                    l3 = System.currentTimeMillis() - l4;
                                                                    l2 = 0L;
                                                                    object = collection.iterator();
                                                                    while (object.hasNext()) {
                                                                        ParserResult.UpdateState updateState;
                                                                        ParserResult parserResult;
                                                                        EditHistory editHistory4;
                                                                        Object object2;
                                                                        TranslatedSource translatedSource = (TranslatedSource)object.next();
                                                                        l4 = System.currentTimeMillis();
                                                                        string2 = translatedSource.getSource();
                                                                        l3 += System.currentTimeMillis() - l4;
                                                                        long l5 = System.currentTimeMillis();
                                                                        StringSourceFileReader stringSourceFileReader = new StringSourceFileReader(string2, fileObject);
                                                                        ParserResult parserResult2 = null;
                                                                        if (incrementalParser != null && (source.files == null || source.files.size() <= 1) && (object2 = source.recentParseResult.get(language.getMimeType())) != null && (editHistory4 = EditHistory.getCombinedEdits((int)object2.getEditVersion(), (EditHistory)source.editHistory)) != null && editHistory4.isValid() && (parserResult = incrementalParser.parse((ParserFile)defaultParserFile, (SourceFileReader)stringSourceFileReader, translatedSource, editHistory4, object2)) != null && (updateState = parserResult.getUpdateState()) != ParserResult.UpdateState.FAILED) {
                                                                            parserResult2 = parserResult;
                                                                        }
                                                                        if (parserResult2 == null) {
                                                                            object2 = new Parser.Job(list, parseListener, (SourceFileReader)stringSourceFileReader, translatedSource);
                                                                            parser.parseFiles((Parser.Job)object2);
                                                                            parserResult2 = parserResultArray[0];
                                                                        }
                                                                        if (incrementalParser != null || bl3 && collection != null) {
                                                                            source.recentParseResult.put(language.getMimeType(), parserResult2);
                                                                            parserResult2.setEditVersion(source.editHistory.getVersion());
                                                                        }
                                                                        l2 += System.currentTimeMillis() - l5;
                                                                        if (bl && currentRequest.isCanceled()) {
                                                                            object2 = Phase.MODIFIED;
                                                                            Object var44_23 = null;
                                                                            if (bl2) {
                                                                                assert (lowMemoryNotifier != null);
                                                                                assert (lMListener != null);
                                                                                lowMemoryNotifier.removeLowMemoryListener(lMListener);
                                                                            }
                                                                            compilationInfo.setPhase(phase2);
                                                                            return object2;
                                                                        }
                                                                        parserResult2.setTranslatedSource(translatedSource);
                                                                        assert (parserResult2 != null);
                                                                        compilationInfo.addEmbeddingResult(language.getMimeType(), parserResult2);
                                                                    }
                                                                    break block105;
                                                                }
                                                                long l6 = System.currentTimeMillis();
                                                                String string3 = compilationInfo.getText();
                                                                collection = new StringSourceFileReader(string3, fileObject);
                                                                ParserResult parserResult = null;
                                                                if (incrementalParser != null && (source.files == null || source.files.size() <= 1) && (object = source.recentParseResult.get(language.getMimeType())) != null && (editHistory = EditHistory.getCombinedEdits((int)object.getEditVersion(), (EditHistory)source.editHistory)) != null && editHistory.isValid() && (parserResult = incrementalParser.parse((ParserFile)defaultParserFile, collection, null, editHistory, (ParserResult)object)) != null && (string2 = parserResult.getUpdateState()) == ParserResult.UpdateState.FAILED) {
                                                                    parserResult = null;
                                                                }
                                                                if (parserResult == null) {
                                                                    object = new Parser.Job(list, parseListener, (SourceFileReader)collection, null);
                                                                    parser.parseFiles((Parser.Job)object);
                                                                    parserResult = parserResultArray[0];
                                                                }
                                                                if (incrementalParser != null) {
                                                                    source.recentParseResult.put(language.getMimeType(), parserResult);
                                                                    parserResult.setEditVersion(source.editHistory.getVersion());
                                                                }
                                                                l2 = System.currentTimeMillis() - l6;
                                                                if (bl && currentRequest.isCanceled()) {
                                                                    object = Phase.MODIFIED;
                                                                    Object var44_24 = null;
                                                                    if (bl2) {
                                                                        assert (lowMemoryNotifier != null);
                                                                        assert (lMListener != null);
                                                                        lowMemoryNotifier.removeLowMemoryListener(lMListener);
                                                                    }
                                                                    compilationInfo.setPhase(phase2);
                                                                    return object;
                                                                }
                                                                assert (parserResult != null);
                                                                compilationInfo.addEmbeddingResult(language.getMimeType(), parserResult);
                                                            }
                                                            if (l3 > 0L) {
                                                                Logger.getLogger("TIMER").log(Level.FINE, "Virtual Source (" + language.getMimeType() + ")", new Object[]{compilationInfo.getFileObject(), l3});
                                                            }
                                                            if (l2 <= 0L) continue;
                                                            Logger.getLogger("TIMER").log(Level.FINE, "Parsing (" + language.getMimeType() + ")", new Object[]{compilationInfo.getFileObject(), l2});
                                                        }
                                                        phase2 = Phase.PARSED;
                                                        if (source.possiblyIncremental) {
                                                            EditHistory editHistory = source.editHistory;
                                                            source.editHistory = new EditHistory();
                                                            editHistory.add(source.editHistory);
                                                        }
                                                    }
                                                    if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                                                        compilationInfo.needsRestart = true;
                                                        phase7 = phase2;
                                                        break block98;
                                                    }
                                                    if (phase2 == Phase.PARSED && phase.compareTo(Phase.ELEMENTS_RESOLVED) >= 0) {
                                                        if (bl && currentRequest.isCanceled()) {
                                                            phase6 = Phase.MODIFIED;
                                                            break block99;
                                                        }
                                                        l = System.currentTimeMillis();
                                                        phase2 = Phase.ELEMENTS_RESOLVED;
                                                        long l7 = System.currentTimeMillis();
                                                        Source.logTime(compilationInfo.getFileObject(), phase2, l7 - l);
                                                    }
                                                    if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                                                        compilationInfo.needsRestart = true;
                                                        phase5 = phase2;
                                                        break block100;
                                                    }
                                                    if (phase2 == Phase.ELEMENTS_RESOLVED && phase.compareTo(Phase.RESOLVED) >= 0) {
                                                        if (bl && currentRequest.isCanceled()) {
                                                            phase4 = Phase.MODIFIED;
                                                            break block101;
                                                        }
                                                        l = System.currentTimeMillis();
                                                        phase2 = Phase.RESOLVED;
                                                        long l8 = System.currentTimeMillis();
                                                        Source.logTime(compilationInfo.getFileObject(), phase2, l8 - l);
                                                    }
                                                    if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                                                        compilationInfo.needsRestart = true;
                                                        phase3 = phase2;
                                                        break block102;
                                                    }
                                                    if (phase2 == Phase.RESOLVED && phase.compareTo(Phase.UP_TO_DATE) >= 0) {
                                                        phase2 = Phase.UP_TO_DATE;
                                                    }
                                                    break block103;
                                                }
                                                catch (RuntimeException runtimeException) {
                                                    Source.dumpSource(compilationInfo, runtimeException);
                                                    throw runtimeException;
                                                }
                                                catch (Error error) {
                                                    Source.dumpSource(compilationInfo, error);
                                                    throw error;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Object var44_31 = null;
                                                if (bl2) {
                                                    assert (lowMemoryNotifier != null);
                                                    assert (lMListener != null);
                                                    lowMemoryNotifier.removeLowMemoryListener(lMListener);
                                                }
                                                compilationInfo.setPhase(phase2);
                                                throw throwable;
                                            }
                                        }
                                        assert (lMListener != null);
                                        lowMemoryNotifier.removeLowMemoryListener(lMListener);
                                    }
                                    compilationInfo.setPhase(phase2);
                                    return phase9;
                                }
                                Object var44_18 = null;
                                if (bl2) {
                                    assert (lowMemoryNotifier != null);
                                    assert (lMListener != null);
                                    lowMemoryNotifier.removeLowMemoryListener(lMListener);
                                }
                                compilationInfo.setPhase(phase2);
                                return phase8;
                            }
                            Object var44_25 = null;
                            if (bl2) {
                                assert (lowMemoryNotifier != null);
                                assert (lMListener != null);
                                lowMemoryNotifier.removeLowMemoryListener(lMListener);
                            }
                            compilationInfo.setPhase(phase2);
                            return phase7;
                        }
                        Object var44_26 = null;
                        if (bl2) {
                            assert (lowMemoryNotifier != null);
                            assert (lMListener != null);
                            lowMemoryNotifier.removeLowMemoryListener(lMListener);
                        }
                        compilationInfo.setPhase(phase2);
                        return phase6;
                    }
                    Object var44_27 = null;
                    if (bl2) {
                        assert (lowMemoryNotifier != null);
                        assert (lMListener != null);
                        lowMemoryNotifier.removeLowMemoryListener(lMListener);
                    }
                    compilationInfo.setPhase(phase2);
                    return phase5;
                }
                Object var44_28 = null;
                if (bl2) {
                    assert (lowMemoryNotifier != null);
                    assert (lMListener != null);
                    lowMemoryNotifier.removeLowMemoryListener(lMListener);
                }
                compilationInfo.setPhase(phase2);
                return phase4;
            }
            Object var44_29 = null;
            if (bl2) {
                assert (lowMemoryNotifier != null);
                assert (lMListener != null);
                lowMemoryNotifier.removeLowMemoryListener(lMListener);
            }
            compilationInfo.setPhase(phase2);
            return phase3;
        }
        Object var44_30 = null;
        if (bl2) {
            assert (lowMemoryNotifier != null);
            assert (lMListener != null);
            lowMemoryNotifier.removeLowMemoryListener(lMListener);
        }
        compilationInfo.setPhase(phase2);
        return phase2;
    }

    static void logTime(FileObject fileObject, Phase phase, long l) {
        assert (fileObject != null && phase != null);
        String string = phase2Key.get((Object)phase);
        String string2 = phase2Message.get((Object)phase);
        assert (string != null && string2 != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetState(boolean bl, boolean bl2) {
        boolean bl3;
        Object object = this;
        synchronized (object) {
            bl3 = (this.flags & 1) != 0;
            this.flags |= 2;
            if (bl) {
                this.flags |= 5;
            }
            if (bl2) {
                this.flags |= 8;
            }
        }
        if (bl2 && !bl3) {
            this.updateIndex();
        }
        object = currentRequest.getTaskToCancel(this);
        try {
            if (object != null) {
                ((Request)object).task.cancel();
            }
            Object var7_6 = null;
            currentRequest.cancelCompleted((Request)object);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            currentRequest.cancelCompleted((Request)object);
            throw throwable;
        }
        this.resetTask.schedule(REPARSE_DELAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStateImpl() {
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            boolean bl;
            boolean bl2;
            Collection<Request> collection = this;
            synchronized (collection) {
                bl2 = (this.flags & 4) != 0;
                bl = (this.flags & 8) != 0;
                this.flags &= 0xFFFFFFF1;
            }
            if (bl) {
                this.updateIndex();
            }
            if (bl2 && (collection = finishedRequests.remove(this)) != null && collection.size() > 0) {
                requests.addAll(collection);
            }
            if ((collection = waitingRequests.remove(this)) != null && collection.size() > 0) {
                requests.addAll(collection);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void updateIndex() {
        if (this.rootFo != null) {
            try {
                for (Language language : LanguageRegistry.getInstance()) {
                    ClassIndexImpl classIndexImpl;
                    if (language.getIndexer() == null || (classIndexImpl = ClassIndexManager.get(language).getUsagesQuery(this.rootFo.getURL())) == null) continue;
                    classIndexImpl.setDirty(this);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public void testUpdateIndex() {
        this.updateIndex();
    }

    private void assignDocumentListener(FileObject fileObject) throws IOException {
        EditorCookie.Observable observable = (EditorCookie.Observable)DataLoadersBridge.getDefault().getCookie(fileObject, EditorCookie.Observable.class);
        if (observable != null) {
            this.listener = new DocListener(observable);
        } else {
            Logger.getLogger("global").log(Level.WARNING, String.format("File: %s has no EditorCookie.Observable", FileUtil.getFileDisplayName((FileObject)fileObject)));
        }
    }

    private static CompilationInfo createCurrentInfo(Source source, FileObject fileObject, Object object, ParserTaskImpl parserTaskImpl) throws IOException {
        CompilationInfo compilationInfo = new CompilationInfo(source, fileObject, parserTaskImpl);
        return compilationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAddRequest(Request request) {
        assert (request != null);
        requests.add(request);
        Request request2 = currentRequest.getTaskToCancel(request.priority);
        try {
            if (request2 != null) {
                request2.task.cancel();
            }
            Object var3_2 = null;
            currentRequest.cancelCompleted(request2);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            currentRequest.cancelCompleted(request2);
            throw throwable;
        }
    }

    private static boolean holdsDocumentWriteLock(Iterable<FileObject> iterable) {
        Class<AbstractDocument> clazz = AbstractDocument.class;
        try {
            Method method = clazz.getDeclaredMethod("getCurrentWriter", new Class[0]);
            method.setAccessible(true);
            Thread thread = Thread.currentThread();
            for (FileObject fileObject : iterable) {
                try {
                    Object object;
                    StyledDocument styledDocument = DataLoadersBridge.getDefault().getDocument(fileObject);
                    if (!(styledDocument instanceof AbstractDocument) || (object = method.invoke((Object)styledDocument, new Object[0])) != thread) continue;
                    return true;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpSource(CompilationInfo compilationInfo, Throwable throwable) {
        Object object;
        Object object2;
        Object object3;
        String string;
        String string2;
        block15: {
            string2 = System.getProperty("netbeans.user") + "/var/log/";
            string = null;
            try {
                string = compilationInfo.getText();
            }
            catch (IllegalStateException illegalStateException) {
                object3 = compilationInfo.getDocument();
                if (object3 == null) break block15;
                try {
                    string = object3.getText(0, object3.getLength());
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        }
        if (string == null) {
            string = "";
        }
        FileObject fileObject = compilationInfo.getFileObject();
        Object object4 = object3 = "unknown";
        if (fileObject != null) {
            object4 = FileUtil.getFileDisplayName((FileObject)fileObject);
            object3 = fileObject.getNameExt();
        }
        File file = new File(string2 + (String)object3 + ".dump");
        boolean bl = false;
        for (int i = 1; i < 255 && file.exists(); ++i) {
            file = new File(string2 + (String)object3 + '_' + i + ".dump");
        }
        if (!file.exists()) {
            try {
                object2 = new FileOutputStream(file);
                object = new PrintWriter(new OutputStreamWriter((OutputStream)object2, "UTF-8"));
                try {
                    ((PrintWriter)object).println(string);
                    ((PrintWriter)object).println("----- Classpath: ---------------------------------------------");
                    ClassPath classPath = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                    ClassPath classPath2 = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                    ClassPath classPath3 = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    ((PrintWriter)object).println("bootPath: " + (classPath != null ? classPath.toString() : "null"));
                    ((PrintWriter)object).println("classPath: " + (classPath2 != null ? classPath2.toString() : "null"));
                    ((PrintWriter)object).println("sourcePath: " + (classPath3 != null ? classPath3.toString() : "null"));
                    ((PrintWriter)object).println("----- Original exception ---------------------------------------------");
                    throwable.printStackTrace((PrintWriter)object);
                    Object var16_18 = null;
                    ((PrintWriter)object).close();
                    bl = true;
                }
                catch (Throwable throwable2) {
                    Object var16_19 = null;
                    ((PrintWriter)object).close();
                    bl = true;
                    throw throwable2;
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, "Error when writing parser dump file!", iOException);
            }
        }
        object2 = "ruby";
        if (compilationInfo.getLanguage() != null) {
            object2 = compilationInfo.getLanguage().getDisplayName();
        }
        if (bl) {
            object = Exceptions.attachMessage((Throwable)throwable, (String)("An error occurred during parsing of '" + (String)object4 + "'. Please report a bug against " + (String)object2 + " and attach dump file '" + file.getAbsolutePath() + "'."));
            Exceptions.printStackTrace((Throwable)object);
        } else {
            Logger.getLogger("global").log(Level.WARNING, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + string2 + "' and " + "clean all *.dump files in that directory.");
        }
    }

    static /* synthetic */ Collection access$1300() {
        return toRemove;
    }

    static /* synthetic */ Map access$1400() {
        return finishedRequests;
    }

    static /* synthetic */ PriorityBlockingQueue access$1500() {
        return requests;
    }

    static /* synthetic */ CurrentRequestReference access$1600() {
        return currentRequest;
    }

    static /* synthetic */ Collection access$2100(Source source) {
        return source.files;
    }

    static /* synthetic */ Map access$2300() {
        return waitingRequests;
    }

    static /* synthetic */ Object access$2500(Source source) {
        return source.filterListener;
    }

    static /* synthetic */ CompilationInfo access$2600(Source source, FileObject fileObject, Object object, ParserTaskImpl parserTaskImpl) throws IOException {
        return Source.createCurrentInfo(source, fileObject, object, parserTaskImpl);
    }

    static /* synthetic */ CompilationInfo access$2402(Source source, CompilationInfo compilationInfo) {
        source.currentInfo = compilationInfo;
        return source.currentInfo;
    }

    static /* synthetic */ int access$2272(Source source, int n) {
        return source.flags &= n;
    }

    static {
        SourceAccessor.setINSTANCE(new JavaSourceAccessorImpl());
        phase2Key.put(Phase.PARSED, "parsed");
        phase2Message.put(Phase.PARSED, "Parsed");
        phase2Key.put(Phase.ELEMENTS_RESOLVED, "sig-attributed");
        phase2Message.put(Phase.ELEMENTS_RESOLVED, "Signatures Attributed");
        phase2Key.put(Phase.RESOLVED, "attributed");
        phase2Message.put(Phase.RESOLVED, "Attributed");
        requests = new PriorityBlockingQueue<Request>(10, new RequestComparator());
        finishedRequests = new WeakHashMap<Source, Collection<Request>>();
        waitingRequests = new WeakHashMap<Source, Collection<Request>>();
        toRemove = new LinkedList<CancellableTask>();
        factory = new SingleThreadFactory();
        currentRequest = new CurrentRequestReference();
        editorRegistryListener = new EditorRegistryListener();
        javacLock = new ReentrantLock(true);
        Executors.newSingleThreadExecutor(factory).submit(new CompilationJob());
        file2JavaSource = new WeakHashMap<FileObject, Reference<Source>>();
    }

    private static class CompilationJob
    implements Runnable {
        private CompilationJob() {
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class CurrentRequestReference {
        private Request reference;
        private Request canceledReference;
        private long cancelTime;
        private boolean canceled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setCurrentTask(Request request) throws InterruptedException {
            boolean bl = false;
            CurrentRequestReference currentRequestReference = this;
            synchronized (currentRequestReference) {
                while (this.canceledReference != null) {
                    this.wait();
                }
                bl = this.canceled;
                this.canceled = false;
                this.cancelTime = 0L;
                this.reference = request;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(Priority priority) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && priority.compareTo(this.reference.priority) < 0) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(Source source) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && source.equals(this.reference.javaSource)) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(CancellableTask cancellableTask) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && cancellableTask == this.reference.task) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel() {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    request = this.reference;
                    if (request != null) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        public synchronized boolean isCanceled() {
            return this.canceled;
        }

        public synchronized long getCancelTime() {
            return this.cancelTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelCompleted(Request request) {
            if (request != null) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    assert (request == this.canceledReference);
                    this.canceledReference = null;
                    this.notify();
                }
            }
        }
    }

    private class DocListener
    implements DocumentListener,
    PropertyChangeListener,
    ChangeListener,
    TokenHierarchyListener {
        private EditorCookie.Observable ec;
        private DocumentListener docListener;
        private TokenHierarchyListener lexListener;

        public DocListener(EditorCookie.Observable observable) {
            assert (observable != null);
            this.ec = observable;
            this.ec.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.ec));
            StyledDocument styledDocument = observable.getDocument();
            if (styledDocument != null) {
                this.docListener = (DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)styledDocument);
                styledDocument.addDocumentListener(this.docListener);
                if (Source.this.possiblyIncremental) {
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)styledDocument);
                    this.lexListener = (TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)this, (Object)tokenHierarchy);
                    tokenHierarchy.addTokenHierarchyListener(this.lexListener);
                }
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Source.this.resetState(true, true);
            if (Source.this.possiblyIncremental) {
                Source.this.editHistory.insertUpdate(documentEvent);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Source.this.resetState(true, true);
            if (Source.this.possiblyIncremental) {
                Source.this.editHistory.removeUpdate(documentEvent);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("document".equals(propertyChangeEvent.getPropertyName())) {
                StyledDocument styledDocument;
                Object object = propertyChangeEvent.getOldValue();
                if (object instanceof Document) {
                    if (this.lexListener != null) {
                        styledDocument = TokenHierarchy.get((Document)((Document)object));
                        styledDocument.removeTokenHierarchyListener(this.lexListener);
                        this.lexListener = null;
                    }
                    if (this.docListener != null) {
                        ((Document)object).removeDocumentListener(this.docListener);
                        this.docListener = null;
                        Source.this.recentParseResult.clear();
                        Source.this.recentEmbeddingTranslations.clear();
                    }
                }
                if ((styledDocument = this.ec.getDocument()) != null) {
                    this.docListener = (DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)styledDocument);
                    styledDocument.addDocumentListener(this.docListener);
                    if (Source.this.possiblyIncremental) {
                        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)styledDocument);
                        this.lexListener = (TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)this, (Object)tokenHierarchy);
                        tokenHierarchy.addTokenHierarchyListener(this.lexListener);
                    }
                    Source.this.resetState(true, false);
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Source.this.resetState(true, false);
        }

        public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
            assert (Source.this.possiblyIncremental);
            Source.this.editHistory.tokenHierarchyChanged(tokenHierarchyEvent);
            if (tokenHierarchyEvent.type() == TokenHierarchyEventType.REBUILD) {
                Source.this.resetState(true, true);
            }
        }
    }

    private static class EditorRegistryListener
    implements CaretListener {
        private Reference<JTextComponent> lastEditorRef;

        public EditorRegistryListener() {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    EditorRegistryListener.this.editorRegistryChanged();
                }
            });
            this.editorRegistryChanged();
        }

        public void editorRegistryChanged() {
            JTextComponent jTextComponent;
            JTextComponent jTextComponent2 = EditorRegistry.lastFocusedComponent();
            JTextComponent jTextComponent3 = jTextComponent = this.lastEditorRef == null ? null : this.lastEditorRef.get();
            if (jTextComponent != jTextComponent2) {
                if (jTextComponent != null) {
                    jTextComponent.removeCaretListener(this);
                    Document document = jTextComponent.getDocument();
                    Source source = null;
                    if (document != null) {
                        source = Source.forDocument(document);
                    }
                }
                this.lastEditorRef = new WeakReference<JTextComponent>(jTextComponent2);
                if (jTextComponent2 != null) {
                    jTextComponent2.addCaretListener(this);
                }
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            Source source;
            Document document;
            JTextComponent jTextComponent;
            JTextComponent jTextComponent2 = jTextComponent = this.lastEditorRef == null ? null : this.lastEditorRef.get();
            if (jTextComponent != null && (document = jTextComponent.getDocument()) != null && (source = Source.forDocument(document)) != null) {
                source.resetState(false, false);
            }
        }
    }

    private class FileChangeListenerImpl
    extends FileChangeAdapter {
        private FileChangeListenerImpl() {
        }

        public void fileChanged(FileEvent fileEvent) {
            Source.this.resetState(true, false);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            Source.this.resetState(true, false);
        }
    }

    public static final class InsufficientMemoryException
    extends IOException {
        private FileObject fo;

        private InsufficientMemoryException(String string, FileObject fileObject) {
            super(string);
            this.fo = fileObject;
        }

        private InsufficientMemoryException(FileObject fileObject) {
            this(NbBundle.getMessage(Source.class, (String)"MSG_UnsufficientMemoryException", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)), fileObject);
        }

        public FileObject getFile() {
            return this.fo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaSourceAccessorImpl
    extends SourceAccessor {
        private StackTraceElement[] javacLockedStackTrace;

        private JavaSourceAccessorImpl() {
        }

        @Override
        protected void runSpecialTaskImpl(CancellableTask<CompilationInfo> cancellableTask, Priority priority) {
            Source.handleAddRequest(new Request(cancellableTask, null, null, priority, false));
        }

        @Override
        public ParserTaskImpl createParserTask(Language language, ClasspathInfo classpathInfo) {
            boolean bl = true;
            return Source.createParserTask(language, null, classpathInfo, bl);
        }

        @Override
        public ParserTaskImpl getParserTask(CompilationInfo compilationInfo) {
            assert (compilationInfo != null);
            return compilationInfo.getParserTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompilationInfo getCurrentCompilationInfo(Source source, Phase phase) throws IOException {
            assert (source != null);
            assert (this.isDispatchThread());
            CompilationInfo compilationInfo = null;
            Object object = source;
            synchronized (object) {
                if ((source.flags & 1) == 0) {
                    compilationInfo = source.currentInfo;
                }
            }
            if (compilationInfo == null) {
                return null;
            }
            object = Source.moveToPhase(phase, compilationInfo, true);
            return ((Enum)object).compareTo(phase) < 0 ? null : compilationInfo;
        }

        @Override
        public void revalidate(Source source) {
            source.revalidate();
        }

        @Override
        public boolean isDispatchThread() {
            return factory.isDispatchThread(Thread.currentThread());
        }

        @Override
        public void lockParser() {
            javacLock.lock();
            try {
                this.javacLockedStackTrace = Thread.currentThread().getStackTrace();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlockParser() {
            try {
                this.javacLockedStackTrace = null;
                Object var2_1 = null;
                javacLock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                javacLock.unlock();
                throw throwable;
            }
        }

        @Override
        public boolean isParserLocked() {
            return javacLock.isLocked();
        }
    }

    private static class LMListener
    implements LowMemoryListener {
        private AtomicBoolean lowMemory = new AtomicBoolean(false);

        private LMListener() {
        }

        public void lowMemory(LowMemoryEvent lowMemoryEvent) {
            this.lowMemory.set(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        MAX,
        HIGH,
        ABOVE_NORMAL,
        NORMAL,
        BELOW_NORMAL,
        LOW,
        MIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Request {
        private final CancellableTask<? extends CompilationInfo> task;
        private final Source javaSource;
        private final Phase phase;
        private final Priority priority;
        private final boolean reschedule;

        public Request(CancellableTask<? extends CompilationInfo> cancellableTask, Source source, Phase phase, Priority priority, boolean bl) {
            assert (cancellableTask != null);
            this.task = cancellableTask;
            this.javaSource = source;
            this.phase = phase;
            this.priority = priority;
            this.reschedule = bl;
        }

        public String toString() {
            if (this.reschedule) {
                return String.format("Periodic request for phase: %s with priority: %s to perform: %s", new Object[]{this.phase.name(), this.priority, this.task.toString()});
            }
            return String.format("One time request for phase: %s with priority: %d to perform: %s", new Object[]{this.phase != null ? this.phase.name() : "<null>", this.priority, this.task.toString()});
        }

        public int hashCode() {
            return this.priority.ordinal();
        }

        public boolean equals(Object object) {
            if (object instanceof Request) {
                Request request = (Request)object;
                return this.priority == request.priority && this.reschedule == request.reschedule && this.phase.equals((Object)request.phase) && this.task.equals(request.task);
            }
            return false;
        }

        static /* synthetic */ Phase access$1800(Request request) {
            return request.phase;
        }

        static /* synthetic */ boolean access$1900(Request request) {
            return request.reschedule;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestComparator
    implements Comparator<Request> {
        private RequestComparator() {
        }

        @Override
        public int compare(Request request, Request request2) {
            assert (request != null && request2 != null);
            return request.priority.compareTo(request2.priority);
        }
    }

    private static class SingleThreadFactory
    implements ThreadFactory {
        private Thread t;

        private SingleThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            assert (this.t == null);
            this.t = new Thread(runnable, "GSF Source Worker Thread");
            return this.t;
        }

        public boolean isDispatchThread(Thread thread) {
            assert (thread != null);
            return this.t == thread;
        }
    }
}

