/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.parsing;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.util.Comparator;
import org.netbeans.modules.gsf.api.ParserFile;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class FileObjects {
    public static final Comparator<String> SIMPLE_NAME_STRING_COMPARATOR = new SimpleNameStringComparator();
    public static final Comparator<FileObject> SIMPLE_NAME_FILEOBJECT_COMPARATOR = new SimpleNameFileObjectComparator();
    public static final String JAR = "jar";
    public static final String FILE = "file";
    public static final String ZIP = "zip";
    public static final String HTML = "html";
    public static final String SIG = "sig";
    public static final String RS = "rs";
    static final String encodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();

    private FileObjects() {
    }

    public static ParserFile fileFileObject(File file, File file2, boolean bl, Object object) {
        assert (file != null);
        assert (file2 != null);
        return new FileParserFile(file, file2, bl);
    }

    public static String stripExtension(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? string : string.substring(0, n);
    }

    public static String getName(FileObject fileObject, boolean bl) {
        assert (fileObject != null);
        return bl ? fileObject.getName() : fileObject.getNameExt();
    }

    public static String getBaseName(String string) {
        return FileObjects.getBaseName(string, File.separatorChar);
    }

    public static String getBaseName(String string, char c) {
        return FileObjects.getFolderAndBaseName(string, c)[1];
    }

    public static String[] getFolderAndBaseName(String string, char c) {
        int n = string.lastIndexOf(c);
        if (n == -1) {
            return new String[]{"", string};
        }
        return new String[]{string.substring(0, n), string.substring(n + 1)};
    }

    public static String getBinaryName(File file, File file2) {
        assert (file != null && file2 != null);
        String string = FileObjects.getRelativePath(file2, file);
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string.replace(File.separatorChar, '.');
    }

    public static String getSimpleName(FileObject fileObject) {
        String string = FileObjects.getName(fileObject, true);
        int n = string.lastIndexOf(36);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getSimpleName(String string) {
        String string2 = FileObjects.getBaseName(string);
        int n = string2.lastIndexOf(36);
        if (n == -1) {
            return string2;
        }
        return string2.substring(n + 1);
    }

    public static String convertPackage2Folder(String string) {
        return string.replace('.', '/');
    }

    public static String convertFolder2Package(String string) {
        return FileObjects.convertFolder2Package(string, '/');
    }

    public static String convertFolder2Package(String string, char c) {
        return string.replace(c, '.');
    }

    public static String getRelativePath(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.replace('.', '/'));
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String[] getParentRelativePathAndName(String string) {
        if (string.charAt(string.length() - 1) == '.') {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return new String[]{"", string};
        }
        return new String[]{string.substring(0, n).replace('.', '/'), string.substring(n + 1)};
    }

    public static File getRootFile(URL uRL) {
        File file = JAR.equals(uRL.getProtocol()) ? new File(URI.create(FileUtil.getArchiveFile((URL)uRL).toExternalForm())) : new File(URI.create(uRL.toExternalForm()));
        return file;
    }

    public static void deleteRecursively(File file) {
        File[] fileArray;
        assert (file != null);
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                FileObjects.deleteRecursively(file2);
            }
        }
        file.delete();
    }

    public static String getRelativePath(File file, File file2) {
        int n;
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        assert (string2.startsWith(string));
        int n2 = string.length();
        if (string.charAt(n2 - 1) != File.separatorChar) {
            ++n2;
        }
        if ((n = string2.length()) <= n2) {
            return "";
        }
        return string2.substring(n2);
    }

    private static class FileParserFile
    implements ParserFile {
        private File file;
        private File root;
        private FileObject fileObject;
        private String relative;
        private boolean platform;

        private FileParserFile(File file, File file2, boolean bl) {
            this.file = file;
            this.root = file2;
            this.platform = bl;
        }

        public FileObject getFileObject() {
            if (this.fileObject == null) {
                this.fileObject = FileUtil.toFileObject((File)this.file);
            }
            return this.fileObject;
        }

        public String getRelativePath() {
            if (this.relative == null) {
                this.relative = FileObjects.getRelativePath(this.root, this.file);
            }
            return this.relative;
        }

        public String getNameExt() {
            return this.file.getName();
        }

        public String getExtension() {
            String string = this.file.getName();
            int n = string.lastIndexOf(46);
            if (n != -1) {
                return string.substring(n + 1);
            }
            return "";
        }

        public String toString() {
            return "FileParserFile(" + this.getNameExt() + ")";
        }

        public boolean isPlatform() {
            return this.platform;
        }

        public File getFile() {
            return this.file;
        }
    }

    public static class InvalidFileException
    extends IOException {
        public InvalidFileException() {
        }

        public InvalidFileException(FileObject fileObject) {
            super(NbBundle.getMessage(FileObjects.class, (String)"FMT_InvalidFile", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleNameFileObjectComparator
    implements Comparator<FileObject> {
        private SimpleNameFileObjectComparator() {
        }

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            String string = FileObjects.getSimpleName(fileObject);
            String string2 = FileObjects.getSimpleName(fileObject2);
            return string.compareTo(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleNameStringComparator
    implements Comparator<String> {
        private SimpleNameStringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return FileObjects.getSimpleName(string).compareTo(FileObjects.getSimpleName(string2));
        }
    }
}

