/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistry;
import org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistryEvent;
import org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistryListener;
import org.netbeans.modules.gsfpath.api.queries.SourceForBinaryQuery;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.PathResourceImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalSourcePath {
    public static final String PROP_INCLUDES = "includes";
    private static GlobalSourcePath instance;
    private final GlobalPathRegistry gpr;
    private List<? extends PathResourceImplementation> resources;
    private List<? extends PathResourceImplementation> unknownResources;
    private List<? extends PathResourceImplementation> binaryResources;
    private Set<ClassPath> activeCps;
    private Map<URL, SourceForBinaryQuery.Result> sourceResults;
    private Map<URL, URL[]> translatedRoots;
    private Map<URL, WeakValue> unknownRoots;
    private long timeStamp = -1L;
    private Runnable debugCallBack;
    private final SourcePathImplementation sourcePath;
    private final BinaryPathImplementation binaryPath;
    private final UnknownSourcePathImplementation unknownSourcePath;
    private final Listener listener = new Listener();
    private PropertyChangeListener excludesListener;

    private GlobalSourcePath() {
        this.sourcePath = new SourcePathImplementation();
        this.binaryPath = new BinaryPathImplementation();
        this.unknownSourcePath = new UnknownSourcePathImplementation();
        this.gpr = GlobalPathRegistry.getDefault();
        this.activeCps = Collections.emptySet();
        this.sourceResults = Collections.emptyMap();
        this.unknownRoots = new HashMap<URL, WeakValue>();
        this.translatedRoots = new HashMap<URL, URL[]>();
        this.gpr.addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.listener, (Object)this.gpr));
    }

    public void setExcludesListener(PropertyChangeListener propertyChangeListener) throws TooManyListenersException {
        if (this.excludesListener != null) {
            throw new TooManyListenersException();
        }
        this.excludesListener = propertyChangeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getSourceRootForBinaryRoot(URL uRL, ClassPath classPath, boolean bl) {
        URL[] uRLArray = this.translatedRoots.get(uRL);
        if (uRLArray != null) {
            if (uRLArray.length > 0) {
                return uRLArray;
            }
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Collection<? extends PathResourceImplementation> collection = GlobalSourcePath.getSources(SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots(), arrayList, null);
        if (collection.isEmpty()) {
            return null;
        }
        uRLArray = new URL[arrayList.size()];
        GlobalSourcePath globalSourcePath = this;
        synchronized (globalSourcePath) {
            Iterator iterator = arrayList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                uRLArray[n] = (URL)iterator.next();
                this.unknownRoots.put(uRLArray[n], new WeakValue(classPath, uRLArray[n]));
                ++n;
            }
        }
        if (bl) {
            this.resetCacheAndFire();
        }
        return uRLArray;
    }

    public ClassPathImplementation getSourcePath() {
        return this.sourcePath;
    }

    public ClassPathImplementation getUnknownSourcePath() {
        return this.unknownSourcePath;
    }

    public ClassPathImplementation getBinaryPath() {
        return this.binaryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCacheAndFire() {
        GlobalSourcePath globalSourcePath = this;
        synchronized (globalSourcePath) {
            this.resources = null;
            this.binaryResources = null;
            this.unknownResources = null;
            ++this.timeStamp;
        }
        this.sourcePath.firePropertyChange();
        this.binaryPath.firePropertyChange();
        this.unknownSourcePath.firePropertyChange();
    }

    /*
     * WARNING - void declaration
     */
    private static Result createResources(Request request) {
        boolean bl;
        URL uRL2;
        assert (request != null);
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<PathResourceImplementation> hashSet2 = new HashSet<PathResourceImplementation>();
        HashSet<PathResourceImplementation> hashSet3 = new HashSet<PathResourceImplementation>();
        HashMap<URL, URL[]> hashMap = new HashMap<URL, URL[]>();
        HashSet<ClassPath> hashSet4 = new HashSet<ClassPath>();
        for (ClassPath object : request.sourceCps) {
            boolean bl2 = !request.oldCps.remove(object);
            for (ClassPath.Entry entry : object.entries()) {
                try {
                    uRL2 = entry.getURL();
                    if (!uRL2.toExternalForm().endsWith("/")) {
                        uRL2 = new URL(uRL2.toExternalForm() + "/");
                    }
                    hashSet.add(ClassPathSupport.createResource((URL)uRL2));
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            bl = hashSet4.add(object);
            if (!bl2 || !bl) continue;
            object.addPropertyChangeListener(request.propertyListener);
        }
        for (ClassPath classPath : request.bootCps) {
            boolean bl3 = !request.oldCps.remove(classPath);
            for (ClassPath.Entry entry : classPath.entries()) {
                try {
                    uRL2 = entry.getURL();
                    if (!uRL2.toExternalForm().endsWith("/")) {
                        uRL2 = new URL(uRL2.toExternalForm() + "/");
                    }
                    hashSet.add(ClassPathSupport.createResource((URL)uRL2));
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            bl = hashSet4.add(classPath);
            if (!bl3 || !bl) continue;
            classPath.addPropertyChangeListener(request.propertyListener);
        }
        HashMap hashMap2 = new HashMap();
        for (ClassPath classPath : request.compileCps) {
            bl = !request.oldCps.remove(classPath);
            for (URL uRL2 : classPath.entries()) {
                boolean bl4;
                URL uRL3 = uRL2.getURL();
                if (hashMap.containsKey(uRL3)) continue;
                SourceForBinaryQuery.Result result = request.oldSR.remove(uRL3);
                if (result == null) {
                    result = SourceForBinaryQuery.findSourceRoots((URL)uRL3);
                    bl4 = true;
                } else {
                    bl4 = false;
                }
                assert (!hashMap2.containsKey(uRL3));
                hashMap2.put(uRL3, result);
                ArrayList<URL> arrayList = new ArrayList<URL>();
                Collection<? extends PathResourceImplementation> collection = GlobalSourcePath.getSources(result.getRoots(), arrayList, request.unknownRoots);
                if (collection.isEmpty()) {
                    try {
                        if (!uRL3.toExternalForm().endsWith("/")) {
                            uRL3 = new URL(uRL3.toExternalForm() + "/");
                        }
                        hashSet3.add(ClassPathSupport.createResource((URL)uRL3));
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                } else {
                    hashSet.addAll(collection);
                }
                hashMap.put(uRL3, arrayList.toArray(new URL[arrayList.size()]));
                if (!bl4) continue;
                result.addChangeListener(request.changeListener);
            }
            boolean bl5 = hashSet4.add(classPath);
            if (!bl || !bl5) continue;
            classPath.addPropertyChangeListener(request.propertyListener);
        }
        for (ClassPath classPath : request.oldCps) {
            classPath.removePropertyChangeListener(request.propertyListener);
        }
        for (Map.Entry<URL, SourceForBinaryQuery.Result> entry : request.oldSR.entrySet()) {
            entry.getValue().removeChangeListener(request.changeListener);
        }
        for (URL uRL4 : request.unknownRoots.keySet()) {
            try {
                void var8_21;
                if (!uRL4.toExternalForm().endsWith("/")) {
                    URL uRL5 = new URL(uRL4.toExternalForm() + "/");
                }
                hashSet2.add(ClassPathSupport.createResource((URL)var8_21));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return new Result(request.timeStamp, new ArrayList(hashSet), new ArrayList(hashSet3), new ArrayList(hashSet2), hashSet4, hashMap2, hashMap, request.unknownRoots);
    }

    void setDebugCallBack(Runnable runnable) {
        this.debugCallBack = runnable;
    }

    private static Collection<? extends PathResourceImplementation> getSources(FileObject[] fileObjectArray, List<URL> list, Map<URL, WeakValue> map) {
        assert (fileObjectArray != null);
        URL[] uRLArray = new URL[fileObjectArray.length];
        boolean bl = true;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                URL uRL = fileObjectArray[i].getURL();
                if (!"file".equals(uRL.getProtocol())) {
                    bl = false;
                    break;
                }
                uRLArray[i] = uRL;
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
        if (bl) {
            ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>(fileObjectArray.length);
            for (int i = 0; i < uRLArray.length; ++i) {
                if (list != null) {
                    list.add(uRLArray[i]);
                }
                if (map != null) {
                    map.remove(uRLArray[i]);
                }
                try {
                    URL uRL = uRLArray[i];
                    if (!uRL.toExternalForm().endsWith("/")) {
                        uRL = new URL(uRL.toExternalForm() + "/");
                    }
                    arrayList.add(ClassPathSupport.createResource((URL)uRL));
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            return arrayList;
        }
        return Collections.emptySet();
    }

    private long getTimeStamp() {
        return this.timeStamp;
    }

    public static synchronized GlobalSourcePath getDefault() {
        if (instance == null) {
            instance = new GlobalSourcePath();
        }
        return instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BinaryPathImplementation
    implements ClassPathImplementation {
        private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

        private BinaryPathImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            Request request;
            Object object = GlobalSourcePath.this;
            synchronized (object) {
                if (GlobalSourcePath.this.binaryResources != null) {
                    return GlobalSourcePath.this.binaryResources;
                }
                request = new Request(GlobalSourcePath.this.getTimeStamp(), GlobalSourcePath.this.gpr.getPaths("classpath/source"), GlobalSourcePath.this.gpr.getPaths("classpath/boot"), GlobalSourcePath.this.gpr.getPaths("classpath/compile"), new HashSet<ClassPath>(GlobalSourcePath.this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result>(GlobalSourcePath.this.sourceResults), new HashMap<URL, WeakValue>(GlobalSourcePath.this.unknownRoots), GlobalSourcePath.this.listener, GlobalSourcePath.this.listener);
            }
            object = GlobalSourcePath.createResources(request);
            if (GlobalSourcePath.this.debugCallBack != null) {
                GlobalSourcePath.this.debugCallBack.run();
            }
            BinaryPathImplementation binaryPathImplementation = this;
            synchronized (binaryPathImplementation) {
                if (GlobalSourcePath.this.getTimeStamp() == ((Result)object).timeStamp) {
                    if (GlobalSourcePath.this.binaryResources == null) {
                        GlobalSourcePath.this.resources = ((Result)object).resources;
                        GlobalSourcePath.this.binaryResources = ((Result)object).binaryResources;
                        GlobalSourcePath.this.unknownResources = ((Result)object).unknownResources;
                        GlobalSourcePath.this.activeCps = ((Result)object).newCps;
                        GlobalSourcePath.this.sourceResults = ((Result)object).newSR;
                        GlobalSourcePath.this.translatedRoots = ((Result)object).translatedRoots;
                        GlobalSourcePath.this.unknownRoots = ((Result)object).unknownRoots;
                    }
                    return GlobalSourcePath.this.binaryResources;
                }
                return ((Result)object).binaryResources;
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            assert (propertyChangeListener != null);
            if (this.listeners == null) {
                this.listeners = new ArrayList<PropertyChangeListener>();
            }
            this.listeners.add(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            assert (propertyChangeListener != null);
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(propertyChangeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void firePropertyChange() {
            PropertyChangeListener[] propertyChangeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.listeners == null) {
                    return;
                }
                propertyChangeListenerArray = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
            }
            object = new PropertyChangeEvent(this, "resources", null, null);
            for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
                propertyChangeListener.propertyChange((PropertyChangeEvent)object);
            }
        }
    }

    private class Listener
    implements GlobalPathRegistryListener,
    PropertyChangeListener,
    ChangeListener {
        private Object lastPropagationId;

        private Listener() {
        }

        public void pathsAdded(GlobalPathRegistryEvent globalPathRegistryEvent) {
            GlobalSourcePath.this.resetCacheAndFire();
        }

        public void pathsRemoved(GlobalPathRegistryEvent globalPathRegistryEvent) {
            GlobalSourcePath.this.resetCacheAndFire();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("entries".equals(string)) {
                GlobalSourcePath.this.resetCacheAndFire();
            } else if (GlobalSourcePath.PROP_INCLUDES.equals(string) && GlobalSourcePath.this.excludesListener != null) {
                Object object = propertyChangeEvent.getPropagationId();
                if (object == null || this.lastPropagationId != object) {
                    PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(this, GlobalSourcePath.PROP_INCLUDES, propertyChangeEvent.getSource(), propertyChangeEvent.getSource());
                    GlobalSourcePath.this.excludesListener.propertyChange(propertyChangeEvent2);
                }
                this.lastPropagationId = object;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            GlobalSourcePath.this.resetCacheAndFire();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Request {
        final long timeStamp;
        final Set<ClassPath> sourceCps;
        final Set<ClassPath> bootCps;
        final Set<ClassPath> compileCps;
        final Set<ClassPath> oldCps;
        final Map<URL, SourceForBinaryQuery.Result> oldSR;
        final Map<URL, WeakValue> unknownRoots;
        final PropertyChangeListener propertyListener;
        final ChangeListener changeListener;

        public Request(long l, Set<ClassPath> set, Set<ClassPath> set2, Set<ClassPath> set3, Set<ClassPath> set4, Map<URL, SourceForBinaryQuery.Result> map, Map<URL, WeakValue> map2, PropertyChangeListener propertyChangeListener, ChangeListener changeListener) {
            assert (set != null);
            assert (set2 != null);
            assert (set3 != null);
            assert (set4 != null);
            assert (map != null);
            assert (map2 != null);
            assert (propertyChangeListener != null);
            assert (changeListener != null);
            this.timeStamp = l;
            this.sourceCps = set;
            this.bootCps = set2;
            this.compileCps = set3;
            this.oldCps = set4;
            this.oldSR = map;
            this.unknownRoots = map2;
            this.propertyListener = propertyChangeListener;
            this.changeListener = changeListener;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Result {
        final long timeStamp;
        final List<? extends PathResourceImplementation> resources;
        final List<? extends PathResourceImplementation> binaryResources;
        final List<? extends PathResourceImplementation> unknownResources;
        final Set<ClassPath> newCps;
        final Map<URL, SourceForBinaryQuery.Result> newSR;
        final Map<URL, URL[]> translatedRoots;
        final Map<URL, WeakValue> unknownRoots;

        public Result(long l, List<? extends PathResourceImplementation> list, List<? extends PathResourceImplementation> list2, List<? extends PathResourceImplementation> list3, Set<ClassPath> set, Map<URL, SourceForBinaryQuery.Result> map, Map<URL, URL[]> map2, Map<URL, WeakValue> map3) {
            assert (list != null);
            assert (list2 != null);
            assert (list3 != null);
            assert (set != null);
            assert (map != null);
            assert (map2 != null);
            this.timeStamp = l;
            this.resources = list;
            this.binaryResources = list2;
            this.unknownResources = list3;
            this.newCps = set;
            this.newSR = map;
            this.translatedRoots = map2;
            this.unknownRoots = map3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SourcePathImplementation
    implements ClassPathImplementation {
        private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

        private SourcePathImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            Request request;
            Object object = GlobalSourcePath.this;
            synchronized (object) {
                if (GlobalSourcePath.this.resources != null) {
                    return GlobalSourcePath.this.resources;
                }
                request = new Request(GlobalSourcePath.this.getTimeStamp(), GlobalSourcePath.this.gpr.getPaths("classpath/source"), GlobalSourcePath.this.gpr.getPaths("classpath/boot"), GlobalSourcePath.this.gpr.getPaths("classpath/compile"), new HashSet<ClassPath>(GlobalSourcePath.this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result>(GlobalSourcePath.this.sourceResults), new HashMap<URL, WeakValue>(GlobalSourcePath.this.unknownRoots), GlobalSourcePath.this.listener, GlobalSourcePath.this.listener);
            }
            object = GlobalSourcePath.createResources(request);
            if (GlobalSourcePath.this.debugCallBack != null) {
                GlobalSourcePath.this.debugCallBack.run();
            }
            SourcePathImplementation sourcePathImplementation = this;
            synchronized (sourcePathImplementation) {
                if (GlobalSourcePath.this.getTimeStamp() == ((Result)object).timeStamp) {
                    if (GlobalSourcePath.this.resources == null) {
                        GlobalSourcePath.this.resources = ((Result)object).resources;
                        GlobalSourcePath.this.binaryResources = ((Result)object).binaryResources;
                        GlobalSourcePath.this.unknownResources = ((Result)object).unknownResources;
                        GlobalSourcePath.this.activeCps = ((Result)object).newCps;
                        GlobalSourcePath.this.sourceResults = ((Result)object).newSR;
                        GlobalSourcePath.this.translatedRoots = ((Result)object).translatedRoots;
                        GlobalSourcePath.this.unknownRoots = ((Result)object).unknownRoots;
                    }
                    return GlobalSourcePath.this.resources;
                }
                return ((Result)object).resources;
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            assert (propertyChangeListener != null);
            if (this.listeners == null) {
                this.listeners = new ArrayList<PropertyChangeListener>();
            }
            this.listeners.add(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            assert (propertyChangeListener != null);
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(propertyChangeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void firePropertyChange() {
            PropertyChangeListener[] propertyChangeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.listeners == null) {
                    return;
                }
                propertyChangeListenerArray = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
            }
            object = new PropertyChangeEvent(this, "resources", null, null);
            for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
                propertyChangeListener.propertyChange((PropertyChangeEvent)object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnknownSourcePathImplementation
    implements ClassPathImplementation {
        private List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();

        private UnknownSourcePathImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            Request request;
            Object object = GlobalSourcePath.this;
            synchronized (object) {
                if (GlobalSourcePath.this.unknownResources != null) {
                    return GlobalSourcePath.this.unknownResources;
                }
                request = new Request(GlobalSourcePath.this.getTimeStamp(), GlobalSourcePath.this.gpr.getPaths("classpath/source"), GlobalSourcePath.this.gpr.getPaths("classpath/boot"), GlobalSourcePath.this.gpr.getPaths("classpath/compile"), new HashSet<ClassPath>(GlobalSourcePath.this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result>(GlobalSourcePath.this.sourceResults), new HashMap<URL, WeakValue>(GlobalSourcePath.this.unknownRoots), GlobalSourcePath.this.listener, GlobalSourcePath.this.listener);
            }
            object = GlobalSourcePath.createResources(request);
            if (GlobalSourcePath.this.debugCallBack != null) {
                GlobalSourcePath.this.debugCallBack.run();
            }
            UnknownSourcePathImplementation unknownSourcePathImplementation = this;
            synchronized (unknownSourcePathImplementation) {
                if (GlobalSourcePath.this.getTimeStamp() == ((Result)object).timeStamp) {
                    if (GlobalSourcePath.this.binaryResources == null) {
                        GlobalSourcePath.this.resources = ((Result)object).resources;
                        GlobalSourcePath.this.binaryResources = ((Result)object).binaryResources;
                        GlobalSourcePath.this.unknownResources = ((Result)object).unknownResources;
                        GlobalSourcePath.this.activeCps = ((Result)object).newCps;
                        GlobalSourcePath.this.sourceResults = ((Result)object).newSR;
                        GlobalSourcePath.this.translatedRoots = ((Result)object).translatedRoots;
                        GlobalSourcePath.this.unknownRoots = ((Result)object).unknownRoots;
                    }
                    return GlobalSourcePath.this.unknownResources;
                }
                return ((Result)object).unknownResources;
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            assert (propertyChangeListener != null);
            this.listeners.add(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            assert (propertyChangeListener != null);
            this.listeners.remove(propertyChangeListener);
        }

        void firePropertyChange() {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "resources", null, null);
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeakValue
    extends WeakReference<ClassPath>
    implements Runnable {
        private URL key;

        public WeakValue(ClassPath classPath, URL uRL) {
            super(classPath, Utilities.activeReferenceQueue());
            assert (uRL != null);
            this.key = uRL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            GlobalSourcePath globalSourcePath = GlobalSourcePath.this;
            synchronized (globalSourcePath) {
                bl = GlobalSourcePath.this.unknownRoots.remove(this.key) != null;
            }
            if (bl) {
                GlobalSourcePath.this.resetCacheAndFire();
            }
        }
    }
}

