/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.semantic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.gsfret.editor.semantic.ColoringManager;
import org.netbeans.modules.gsfret.editor.semantic.GsfSemanticLayer;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.gsfret.editor.semantic.SequenceElement;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticHighlighter
extends ScanningCancellableTask<CompilationInfo> {
    private FileObject file;

    SemanticHighlighter(FileObject fileObject) {
        this.file = fileObject;
    }

    public Document getDocument() {
        return DataLoadersBridge.getDefault().getDocument(this.file);
    }

    @Override
    public void run(CompilationInfo compilationInfo) {
        this.resume();
        Document document = this.getDocument();
        if (document == null) {
            Logger.global.log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        this.process(compilationInfo, document);
    }

    /*
     * WARNING - void declaration
     */
    boolean process(CompilationInfo compilationInfo, Document document) {
        List list;
        final TreeSet<SequenceElement> treeSet = new TreeSet<SequenceElement>();
        if (this.isCancelled() || compilationInfo.hasInvalidResults()) {
            return true;
        }
        long l = System.currentTimeMillis();
        Set<String> set = compilationInfo.getEmbeddedMimeTypes();
        EditHistory editHistory = compilationInfo.getHistory();
        final int n = editHistory.getVersion();
        LanguageRegistry languageRegistry = LanguageRegistry.getInstance();
        final GsfSemanticLayer gsfSemanticLayer = GsfSemanticLayer.getLayer(SemanticHighlighter.class, document);
        SortedSet<SequenceElement> sortedSet = gsfSemanticLayer.getColorings();
        int n2 = gsfSemanticLayer.getVersion();
        if (set.size() > 1 && compilationInfo.hasUnchangedResults() && sortedSet.size() > 0) {
            HashMap hashMap = new HashMap();
            Object object = null;
            Language language = null;
            for (SequenceElement sequenceElement : sortedSet) {
                if (sequenceElement.language == language) {
                    void var14_14;
                    list = var14_14;
                } else {
                    list = (List)hashMap.get(sequenceElement.language);
                    if (list == null) {
                        list = new ArrayList();
                        hashMap.put(sequenceElement.language, list);
                        language = sequenceElement.language;
                        ArrayList arrayList = list;
                    }
                }
                list.add(sequenceElement);
            }
            EditHistory editHistory2 = EditHistory.getCombinedEdits((int)n2, (EditHistory)editHistory);
            if (editHistory2 != null) {
                int n3 = editHistory2.getStart();
                for (String string : set) {
                    Object object2;
                    Object object3;
                    Object object4;
                    if (this.isCancelled()) {
                        return true;
                    }
                    Language language2 = languageRegistry.getLanguageByMimeType(string);
                    if (language2 == null) continue;
                    ParserResult parserResult = compilationInfo.getEmbeddedResult(string, 0);
                    if (parserResult != null && parserResult.getUpdateState().isUnchanged()) {
                        object4 = (List)hashMap.get(language2);
                        if (object4 == null) continue;
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            object2 = (SequenceElement)object3.next();
                            if (((SequenceElement)object2).language != language2) continue;
                            OffsetRange offsetRange = ((SequenceElement)object2).range;
                            if (offsetRange.getStart() > n3) {
                                ((SequenceElement)object2).range = new OffsetRange(editHistory2.convertOriginalToEdited(offsetRange.getStart()), editHistory2.convertOriginalToEdited(offsetRange.getEnd()));
                            }
                            treeSet.add((SequenceElement)object2);
                        }
                        continue;
                    }
                    object4 = language2.getColoringManager();
                    object3 = language2.getSemanticAnalyzer();
                    if (object3 == null) continue;
                    try {
                        object3.run((Object)compilationInfo);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                    if (this.isCancelled()) {
                        object3.cancel();
                        return true;
                    }
                    object2 = object3.getHighlights();
                    if (object2 == null) continue;
                    for (OffsetRange offsetRange : object2.keySet()) {
                        Set set2 = (Set)object2.get(offsetRange);
                        if (set2 == null) continue;
                        ColoringAttributes.Coloring coloring = ((ColoringManager)object4).getColoring(set2);
                        treeSet.add(new SequenceElement(language2, offsetRange, coloring));
                    }
                }
                gsfSemanticLayer.setColorings(treeSet, n);
                return true;
            }
        }
        for (String string : set) {
            if (this.isCancelled()) {
                return true;
            }
            long l2 = System.currentTimeMillis();
            Language language = languageRegistry.getLanguageByMimeType(string);
            if (language == null) continue;
            list = language.getColoringManager();
            SemanticAnalyzer semanticAnalyzer = language.getSemanticAnalyzer();
            if (semanticAnalyzer != null) {
                try {
                    semanticAnalyzer.run((Object)compilationInfo);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
                if (this.isCancelled()) {
                    semanticAnalyzer.cancel();
                    return true;
                }
                Map map = semanticAnalyzer.getHighlights();
                if (map != null) {
                    for (OffsetRange offsetRange : map.keySet()) {
                        Set set3 = (Set)map.get(offsetRange);
                        if (set3 == null) continue;
                        ColoringAttributes.Coloring coloring = ((ColoringManager)((Object)list)).getColoring(set3);
                        treeSet.add(new SequenceElement(language, offsetRange, coloring));
                    }
                }
            }
            long l3 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Semantic (" + string + ")", new Object[]{compilationInfo.getFileObject(), l3 - l2});
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                gsfSemanticLayer.setColorings(treeSet, n);
            }
        });
        return false;
    }
}

