/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Formatter;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;

public class GsfReformatTask
implements ReformatTask {
    private Context context;
    private Formatter formatter;
    private CompilationController controller;
    private Source source;

    GsfReformatTask(Source source, Context context) {
        this.context = context;
        this.source = source;
    }

    private synchronized Formatter getFormatter() {
        if (this.formatter == null) {
            MimePath mimePath = MimePath.parse((String)this.context.mimePath());
            String string = mimePath.size() > 1 ? mimePath.getMimeType(mimePath.size() - 1) : mimePath.getPath();
            Language language = LanguageRegistry.getInstance().getLanguageByMimeType(string);
            this.formatter = language.getFormatter();
        }
        return this.formatter;
    }

    public void reformat() throws BadLocationException {
        Formatter formatter = this.getFormatter();
        if (formatter != null) {
            if (!formatter.needsParserResult()) {
                this.controller = null;
            } else if (this.controller == null) {
                try {
                    this.source.runUserActionTask(new CancellableTask<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(Phase.PARSED);
                            GsfReformatTask.this.controller = compilationController;
                        }

                        public void cancel() {
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.controller == null) {
                    return;
                }
            }
            formatter.reformat(this.context, (CompilationInfo)this.controller);
        }
    }

    public ExtraLock reformatLock() {
        Formatter formatter = this.getFormatter();
        if (formatter != null && formatter.needsParserResult()) {
            return new Lock();
        }
        return null;
    }

    private class Lock
    implements ExtraLock {
        private Lock() {
        }

        public void lock() {
            SourceAccessor.getINSTANCE().lockParser();
        }

        public void unlock() {
            GsfReformatTask.this.controller = null;
            SourceAccessor.getINSTANCE().unlockParser();
        }
    }
}

