/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.bridge.kenai;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.KenaiUtil;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiNotification;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.api.KenaiUser;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.KenaiUserUI;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.modules.versioning.util.VCSKenaiSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class VCSKenaiSupportImpl
extends VCSKenaiSupport
implements PropertyChangeListener {
    private static final String KENAI_WEB_SOURCES_REVISION_PATH = "{0}/sources/{1}/revision/{2}";
    private static final String PROVIDED_EXTENSIONS_REMOTE_LOCATION = "ProvidedExtensions.RemoteLocation";
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final Set<KenaiProjectListener> registeredKenaiListenres = new HashSet<KenaiProjectListener>();

    public boolean isKenai(String string) {
        return KenaiUtil.isKenai((String)string);
    }

    public PasswordAuthentication getPasswordAuthentication() {
        return this.getPasswordAuthentication(true);
    }

    public PasswordAuthentication getPasswordAuthentication(boolean bl) {
        return KenaiUtil.getPasswordAuthentication((boolean)bl);
    }

    public boolean showLogin() {
        return KenaiUtil.showLogin();
    }

    public void setFirmAssociations(File[] fileArray, String string) {
        Repository repository = KenaiUtil.getKenaiRepository((String)string);
        if (repository == null) {
            LOG.warning("No issue tracker available for the given vcs url " + string);
            return;
        }
        BugtrackingOwnerSupport.getInstance().setFirmAssociations(fileArray, repository);
    }

    public boolean isLogged() {
        return KenaiUtil.isLoggedIn();
    }

    public VCSKenaiSupport.KenaiUser forName(String string) {
        return new KenaiUserImpl(new KenaiUserUI(string));
    }

    public void addVCSNoficationListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeListener[] propertyChangeListenerArray = this.support.getPropertyChangeListeners("kenai.vcs.notification");
        if (propertyChangeListenerArray == null || propertyChangeListenerArray.length == 0) {
            Kenai.getDefault().addPropertyChangeListener("login", (PropertyChangeListener)this);
            this.attachToDashboard(false);
        }
        this.support.addPropertyChangeListener("kenai.vcs.notification", propertyChangeListener);
    }

    public void removeVCSNoficationListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener("kenai.vcs.notification", propertyChangeListener);
        PropertyChangeListener[] propertyChangeListenerArray = this.support.getPropertyChangeListeners("kenai.vcs.notification");
        if (propertyChangeListenerArray == null || propertyChangeListenerArray.length == 0) {
            Kenai.getDefault().removePropertyChangeListener("login", (PropertyChangeListener)this);
            this.detachFromDashboard(false);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("openedProjects")) {
            this.registerVCSNotificationListener(Dashboard.getDefault().getOpenProjects());
        } else if (propertyChangeEvent.getPropertyName().equals("login")) {
            if (KenaiUtil.isLoggedIn()) {
                this.attachToDashboard(true);
            } else {
                this.detachFromDashboard(true);
            }
        }
    }

    private void attachToDashboard(boolean bl) {
        if (bl || KenaiUtil.isLoggedIn()) {
            Dashboard.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            this.registerVCSNotificationListener(Dashboard.getDefault().getOpenProjects());
        }
    }

    private void detachFromDashboard(boolean bl) {
        if (bl || KenaiUtil.isLoggedIn()) {
            Dashboard.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            this.unregisterVCSNotificationListener(Dashboard.getDefault().getOpenProjects());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerVCSNotificationListener(ProjectHandle[] projectHandleArray) {
        Set<KenaiProjectListener> set = this.registeredKenaiListenres;
        synchronized (set) {
            this.unregisterVCSNotificationListener(projectHandleArray);
            for (ProjectHandle projectHandle : projectHandleArray) {
                KenaiProject kenaiProject = KenaiUtil.getKenaiProject((ProjectHandle)projectHandle);
                KenaiProjectListener kenaiProjectListener = new KenaiProjectListener(kenaiProject);
                this.registeredKenaiListenres.add(kenaiProjectListener);
                kenaiProject.addPropertyChangeListener((PropertyChangeListener)kenaiProjectListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterVCSNotificationListener(ProjectHandle[] projectHandleArray) {
        Set<KenaiProjectListener> set = this.registeredKenaiListenres;
        synchronized (set) {
            for (KenaiProjectListener kenaiProjectListener : this.registeredKenaiListenres) {
                kenaiProjectListener.kp.removePropertyChangeListener((PropertyChangeListener)kenaiProjectListener);
            }
        }
    }

    public boolean isUserOnline(String string) {
        return KenaiUser.isOnline((String)string);
    }

    public String getRevisionUrl(String string, String string2) {
        if (string2 == null || string == null) {
            throw new NullPointerException("Null parameter");
        }
        String string3 = null;
        String string4 = KenaiUtil.getProjectUrl((String)string);
        String string5 = this.getRepositoryName(string);
        if (string4 != null && string5 != null) {
            string3 = KENAI_WEB_SOURCES_REVISION_PATH;
            string3 = MessageFormat.format(string3, string4, string5, string2);
        }
        return string3;
    }

    private String getRepositoryName(String string) {
        String string2;
        String string3 = null;
        int n = string.lastIndexOf(126) + 1;
        if (n > 0 && string.length() > n && (string2 = string.substring(n)).indexOf(47) == -1) {
            string3 = string2;
        }
        return string3;
    }

    public void logVcsUsage(String string, String string2) {
        if (string2 != null && this.isKenai(string2)) {
            UIUtils.logKenaiUsage((Object[])new Object[]{"SCM", string});
        }
    }

    private void handleKenaiProjectEvent(PropertyChangeEvent propertyChangeEvent, String string) {
        if (!propertyChangeEvent.getPropertyName().equals("project_notification")) {
            return;
        }
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof KenaiNotification) {
            Project[] projectArray;
            KenaiNotification kenaiNotification = (KenaiNotification)object;
            if (kenaiNotification.getType() != KenaiService.Type.SOURCE) {
                return;
            }
            for (Project project : projectArray = OpenProjects.getDefault().getOpenProjects()) {
                KenaiProject kenaiProject;
                FileObject fileObject = project.getProjectDirectory();
                String string2 = (String)fileObject.getAttribute(PROVIDED_EXTENSIONS_REMOTE_LOCATION);
                if (string2 == null || !string2.equals(kenaiNotification.getUri().toString())) continue;
                try {
                    kenaiProject = KenaiProject.forRepository((String)string2);
                }
                catch (KenaiException kenaiException) {
                    LOG.log(Level.WARNING, null, kenaiException);
                    return;
                }
                String string3 = kenaiProject.getName();
                if (!string3.equals(string)) continue;
                this.support.firePropertyChange("kenai.vcs.notification", null, (Object)new VCSKenaiNotificationImpl(kenaiNotification, kenaiProject, FileUtil.toFile((FileObject)fileObject)));
            }
        }
    }

    private class KenaiProjectListener
    implements PropertyChangeListener {
        private final KenaiProject kp;

        public KenaiProjectListener(KenaiProject kenaiProject) {
            this.kp = kenaiProject;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            VCSKenaiSupportImpl.this.handleKenaiProjectEvent(propertyChangeEvent, this.kp.getName());
        }
    }

    private static class KenaiUserImpl
    extends VCSKenaiSupport.KenaiUser {
        KenaiUserUI delegate;

        public KenaiUserImpl(KenaiUserUI kenaiUserUI) {
            this.delegate = kenaiUserUI;
        }

        public void startChat() {
            this.delegate.startChat();
        }

        public void startChat(String string) {
            this.delegate.startChat(string);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.delegate.getKenaiUser().removePropertyChangeListener(propertyChangeListener);
        }

        public boolean isOnline() {
            return this.delegate.getKenaiUser().isOnline();
        }

        public String getUser() {
            return this.delegate.getUserName();
        }

        public Icon getIcon() {
            return this.delegate.getIcon();
        }

        public JLabel createUserWidget() {
            return this.delegate.createUserWidget();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.delegate.getKenaiUser().addPropertyChangeListener(propertyChangeListener);
        }
    }

    private class VCSKenaiModificationImpl
    extends VCSKenaiSupport.VCSKenaiModification {
        private final KenaiNotification.Modification m;

        public VCSKenaiModificationImpl(KenaiNotification.Modification modification) {
            this.m = modification;
        }

        public VCSKenaiSupport.VCSKenaiModification.Type getType() {
            switch (this.m.getType()) {
                case NEW: {
                    return VCSKenaiSupport.VCSKenaiModification.Type.NEW;
                }
                case CHANGE: {
                    return VCSKenaiSupport.VCSKenaiModification.Type.CHANGE;
                }
                case DELETE: {
                    return VCSKenaiSupport.VCSKenaiModification.Type.DELETE;
                }
            }
            throw new IllegalStateException("unknown modification type" + this.m.getType());
        }

        public String getResource() {
            return this.m.getResource();
        }

        public String getId() {
            return this.m.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VCSKenaiNotificationImpl
    extends VCSKenaiSupport.VCSKenaiNotification {
        private final KenaiNotification kn;
        private final File projectDir;
        private final KenaiProject kp;
        private String serviceName;

        public VCSKenaiNotificationImpl(KenaiNotification kenaiNotification, KenaiProject kenaiProject, File file) {
            assert (kenaiProject != null);
            assert (kenaiNotification != null);
            assert (kenaiNotification.getType() == KenaiService.Type.SOURCE);
            this.kn = kenaiNotification;
            this.kp = kenaiProject;
            this.projectDir = file;
        }

        public URI getUri() {
            return this.kn.getUri();
        }

        public Date getStamp() {
            return this.kn.getStamp();
        }

        public VCSKenaiSupport.Service getService() {
            if (this.serviceName == null) {
                KenaiFeature[] kenaiFeatureArray = null;
                try {
                    for (KenaiFeature kenaiFeature : kenaiFeatureArray = this.kp.getFeatures(KenaiService.Type.SOURCE)) {
                        if (!kenaiFeature.getName().equals(this.kn.getServiceName())) continue;
                        this.serviceName = kenaiFeature.getService();
                        break;
                    }
                }
                catch (KenaiException kenaiException) {
                    LOG.log(Level.WARNING, null, kenaiException);
                }
                if (this.serviceName == null) {
                    this.serviceName = this.kn.getServiceName();
                }
            }
            if (this.serviceName.equals("subversion")) {
                return VCSKenaiSupport.Service.VCS_SVN;
            }
            if (this.serviceName.equals("mercurial")) {
                return VCSKenaiSupport.Service.VCS_HG;
            }
            LOG.warning("Unknown kenai scm service name " + this.serviceName);
            return VCSKenaiSupport.Service.UNKNOWN;
        }

        public List<VCSKenaiSupport.VCSKenaiModification> getModifications() {
            ArrayList<VCSKenaiModificationImpl> arrayList = new ArrayList<VCSKenaiModificationImpl>(this.kn.getModifications().size());
            for (KenaiNotification.Modification modification : this.kn.getModifications()) {
                arrayList.add(new VCSKenaiModificationImpl(modification));
            }
            return Collections.unmodifiableList(arrayList);
        }

        public String getAuthor() {
            return this.kn.getAuthor();
        }

        public File getProjectDirectory() {
            return this.projectDir;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append(this.projectDir);
            stringBuffer.append(",");
            stringBuffer.append(this.getUri());
            stringBuffer.append(",");
            stringBuffer.append(this.getService());
            stringBuffer.append(",");
            stringBuffer.append(this.getStamp());
            return stringBuffer.toString();
        }
    }
}

