/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.BasicSearchForm;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SearchScopeRegistry;
import org.netbeans.modules.search.SearchTypePanel;
import org.netbeans.modules.search.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openidex.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchPanel
extends JPanel
implements PropertyChangeListener,
FocusListener,
ChangeListener,
ActionListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private final BasicSearchForm basicCriteriaPanel;
    private final boolean projectWide;
    private final boolean searchAndReplace;
    private final JButton okButton;
    private final JButton cancelButton;
    private Dialog dialog;
    private int returnStatus = 0;
    private List<SearchTypePanel> orderedSearchTypePanels;
    private JTabbedPane tabbedPane;

    SearchPanel(Map<SearchScope, Boolean> map, String string, boolean bl) {
        this(map, string, null, Utils.cloneSearchTypes(Utils.getSearchTypes()), false, bl);
    }

    SearchPanel(Map<SearchScope, Boolean> map, String string, BasicSearchCriteria basicSearchCriteria, Collection<? extends SearchType> collection) {
        this(map, string, basicSearchCriteria, collection, true, basicSearchCriteria.isSearchAndReplace());
    }

    private SearchPanel(Map<SearchScope, Boolean> map, String string, BasicSearchCriteria basicSearchCriteria, Collection<? extends SearchType> collection, boolean bl, boolean bl2) {
        assert (collection != null);
        if (collection == null) {
            collection = Collections.emptyList();
        }
        this.projectWide = SearchScopeRegistry.hasProjectSearchScopes(map.keySet());
        this.searchAndReplace = bl2;
        this.basicCriteriaPanel = new BasicSearchForm(map, string, basicSearchCriteria, bl2, bl);
        this.basicCriteriaPanel.setUsabilityChangeListener(this);
        this.setLayout(new GridLayout(1, 1));
        if (!collection.isEmpty()) {
            this.orderedSearchTypePanels = new ArrayList<SearchTypePanel>(collection.size());
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add(this.basicCriteriaPanel);
            HashSet<String> hashSet = new HashSet<String>();
            for (SearchType searchType : collection) {
                SearchTypePanel searchTypePanel;
                int n;
                String string2 = searchType.getClass().getName();
                if (!hashSet.add(string2) || (n = this.orderedSearchTypePanels.indexOf(searchTypePanel = new SearchTypePanel(searchType))) != -1) continue;
                this.orderedSearchTypePanels.add(searchTypePanel);
                searchTypePanel.addPropertyChangeListener(this);
                this.tabbedPane.add(searchTypePanel);
            }
            this.add(this.tabbedPane);
            int n = 0;
            if (bl) {
                int n2 = this.getIndexOfSearchType(FindDialogMemory.getDefault().getLastSearchType());
                n = n2 + 1;
            }
            this.tabbedPane.setSelectedIndex(n);
            this.updateFirstTabText();
            this.updateExtraTabsTexts();
        } else {
            this.orderedSearchTypePanels = null;
            this.tabbedPane = null;
            this.add(this.basicCriteriaPanel);
        }
        this.setName(NbBundle.getMessage(SearchPanel.class, (String)"TEXT_TITLE_CUSTOMIZE"));
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"TEXT_BUTTON_SEARCH"));
        this.updateIsCustomized();
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"TEXT_BUTTON_CANCEL"));
        this.initAccessibility();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doClose(actionEvent.getSource() == this.okButton ? 1 : 0);
    }

    SearchScope getSearchScope() {
        return this.basicCriteriaPanel.getSelectedSearchScope();
    }

    BasicSearchCriteria getBasicSearchCriteria() {
        BasicSearchCriteria basicSearchCriteria = this.basicCriteriaPanel.getBasicSearchCriteria();
        return basicSearchCriteria.isUsable() ? basicSearchCriteria : null;
    }

    List<SearchType> getSearchTypes() {
        List<SearchType> list;
        if (this.orderedSearchTypePanels == null) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList<SearchType>(this.orderedSearchTypePanels.size());
            for (SearchTypePanel searchTypePanel : this.orderedSearchTypePanels) {
                list.add(searchTypePanel.getSearchType());
            }
        }
        return list;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACS_SearchPanel"));
        if (this.tabbedPane != null) {
            this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle(SearchPanel.class).getString("ACSN_Tabs"));
            this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACSD_Tabs"));
        }
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACS_TEXT_BUTTON_SEARCH"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACS_TEXT_BUTTON_CANCEL"));
    }

    private String getTabText(int n) {
        String string;
        if (n == 0) {
            string = NbBundle.getMessage(this.getClass(), (String)"BasicSearchForm.tabText");
            if (this.basicCriteriaPanel.getBasicSearchCriteria().isUsable()) {
                string = string + " *";
            }
        } else {
            string = this.orderedSearchTypePanels.get(n - 1).getName();
        }
        return string;
    }

    List<SearchType> getCustomizedSearchTypes() {
        if (this.orderedSearchTypePanels == null) {
            return Collections.emptyList();
        }
        ArrayList<SearchType> arrayList = new ArrayList<SearchType>(this.orderedSearchTypePanels.size());
        for (SearchTypePanel searchTypePanel : this.orderedSearchTypePanels) {
            if (!searchTypePanel.isCustomized()) continue;
            arrayList.add(searchTypePanel.getSearchType());
        }
        return arrayList;
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void doClose(int n) {
        int n2;
        if (this.orderedSearchTypePanels != null) {
            for (SearchTypePanel searchTypePanel : this.orderedSearchTypePanels) {
                searchTypePanel.removePropertyChangeListener(this);
            }
        }
        int n3 = n2 = this.tabbedPane == null ? 0 : this.tabbedPane.getSelectedIndex();
        if (n2 == 0) {
            if (n == 1) {
                FindDialogMemory.getDefault().setLastUsedSearchType(null);
                this.basicCriteriaPanel.onOk();
            }
        } else if (n2 > 0) {
            SearchTypePanel searchTypePanel;
            searchTypePanel = this.getSearchTypePanel(n2);
            if (n == 1) {
                FindDialogMemory.getDefault().setLastUsedSearchType(searchTypePanel.getSearchType());
                searchTypePanel.onOk();
            } else {
                searchTypePanel.onCancel();
            }
        }
        this.returnStatus = n;
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    void showDialog() {
        String string = this.projectWide ? (this.searchAndReplace ? "LBL_ReplaceInProjects" : "LBL_FindInProjects") : (this.searchAndReplace ? "LBL_ReplaceInFiles" : "LBL_FindInFiles");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)string), true, new Object[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, new HelpCtx(this.getClass()), (ActionListener)this);
        dialogDescriptor.setTitle(NbBundle.getMessage(this.getClass(), (String)string));
        this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.setModal(true);
        if (this.tabbedPane != null) {
            this.tabbedPane.addFocusListener(this);
        }
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        SearchTypePanel searchTypePanel;
        assert (this.tabbedPane != null);
        this.tabbedPane.removeFocusListener(this);
        Component component = null;
        int n = this.tabbedPane.getSelectedIndex();
        if (n == 0) {
            component = this.basicCriteriaPanel;
        } else if (n > 0 && (searchTypePanel = this.getSearchTypePanel(n)) != null) {
            component = searchTypePanel.customizerComponent;
        }
        if (component != null) {
            ((Component)component).requestFocusInWindow();
        }
        this.tabbedPane.addChangeListener(this);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.basicCriteriaPanel) {
            this.updateIsCustomized();
            if (this.tabbedPane != null) {
                this.updateFirstTabText();
            }
        } else {
            this.tabSelectionChanged();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("customized".equals(propertyChangeEvent.getPropertyName())) {
            this.updateIsCustomized();
            if (this.tabbedPane != null) {
                this.updateExtraTabsTexts();
            }
        }
    }

    private void updateFirstTabText() {
        assert (this.tabbedPane != null);
        this.tabbedPane.setTitleAt(0, this.getTabText(0));
    }

    private void updateExtraTabsTexts() {
        assert (this.tabbedPane != null);
        int n = this.tabbedPane.getTabCount();
        for (int i = 1; i < n; ++i) {
            this.tabbedPane.setTitleAt(i, this.getTabText(i));
        }
    }

    private void updateIsCustomized() {
        this.okButton.setEnabled(this.checkIsCustomized());
    }

    private boolean checkIsCustomized() {
        if (this.basicCriteriaPanel.isUsable()) {
            return true;
        }
        if (this.orderedSearchTypePanels != null && !this.orderedSearchTypePanels.isEmpty()) {
            for (SearchTypePanel searchTypePanel : this.orderedSearchTypePanels) {
                if (!searchTypePanel.isCustomized()) continue;
                return true;
            }
        }
        return false;
    }

    private void tabSelectionChanged() {
        SearchTypePanel searchTypePanel;
        assert (this.tabbedPane != null);
        int n = this.tabbedPane.getSelectedIndex();
        if (n != 0 && n > 0 && (searchTypePanel = this.getSearchTypePanel(n)) != null) {
            searchTypePanel.initializeWithObject();
        }
    }

    private SearchTypePanel getSearchTypePanel(int n) {
        assert (this.orderedSearchTypePanels != null);
        assert (n >= 1);
        return --n < this.orderedSearchTypePanels.size() ? this.orderedSearchTypePanels.get(n) : null;
    }

    private int getIndexOfSearchType(SearchType searchType) {
        if (searchType == null) {
            return -1;
        }
        int n = -1;
        for (SearchTypePanel searchTypePanel : this.orderedSearchTypePanels) {
            ++n;
            if (searchTypePanel.getSearchType().getClass() != searchType.getClass()) continue;
            return n;
        }
        return -1;
    }
}

