/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.SyntaxParser;
import org.netbeans.editor.ext.html.parser.SyntaxParserContext;
import org.netbeans.editor.ext.html.parser.SyntaxParserResult;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlElementHandle;
import org.netbeans.modules.html.editor.gsf.HtmlParserResultAccessor;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;

public class HtmlGSFParser
extends Parser {
    private HtmlParserResult lastResult;
    private static final Logger TIMERS = Logger.getLogger("TIMER.j2ee.parser");
    private static final Logger LOGGER = Logger.getLogger(HtmlGSFParser.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sourceModificationEvent) throws ParseException {
        this.lastResult = this.parse(snapshot, sourceModificationEvent);
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private HtmlParserResult parse(Snapshot snapshot, SourceModificationEvent sourceModificationEvent) {
        boolean bl = snapshot.getMimePath().size() > 1;
        Document document = snapshot.getSource().getDocument(false);
        DTD dTD = document != null ? (DTD)document.getProperty("fallbackDTD") : null;
        SyntaxParserContext syntaxParserContext = SyntaxParserContext.createContext((CharSequence)snapshot.getText()).setDTD(dTD);
        if (bl) {
            syntaxParserContext.setProperty(SyntaxParser.Behaviour.DISABLE_STRUCTURE_CHECKS.name(), (Object)Boolean.TRUE);
        }
        SyntaxParserResult syntaxParserResult = SyntaxParser.parse((SyntaxParserContext)syntaxParserContext);
        HtmlParserResult htmlParserResult = HtmlParserResultAccessor.get().createInstance(snapshot, syntaxParserResult);
        if (TIMERS.isLoggable(Level.FINE)) {
            LogRecord logRecord = new LogRecord(Level.FINE, "HTML parse result");
            logRecord.setParameters(new Object[]{htmlParserResult});
            TIMERS.log(logRecord);
        }
        return htmlParserResult;
    }

    public static ElementHandle resolveHandle(ParserResult parserResult, ElementHandle elementHandle) {
        if (elementHandle instanceof HtmlElementHandle) {
            HtmlElementHandle htmlElementHandle = (HtmlElementHandle)elementHandle;
            AstNode astNode = htmlElementHandle.node();
            AstNode astNode2 = AstNodeUtils.getRoot((AstNode)astNode);
            HtmlParserResult htmlParserResult = (HtmlParserResult)parserResult;
            AstNode astNode3 = htmlParserResult.root();
            if (astNode3 == null) {
                return null;
            }
            AstNode astNode4 = HtmlGSFParser.find(astNode2, astNode, astNode3);
            if (astNode4 != null) {
                return new HtmlElementHandle(astNode4, parserResult.getSnapshot().getSource().getFileObject());
            }
        }
        return null;
    }

    private static AstNode find(AstNode astNode, AstNode astNode2, AstNode astNode3) {
        if (astNode == astNode2) {
            return astNode3;
        }
        List list = astNode.children();
        List list2 = astNode3.children();
        for (int i = 0; i < list.size(); ++i) {
            AstNode astNode4 = (AstNode)list.get(i);
            if (i == list2.size()) {
                return null;
            }
            AstNode astNode5 = (AstNode)list2.get(i);
            if (astNode4 == astNode2) {
                return astNode5;
            }
            AstNode astNode6 = HtmlGSFParser.find(astNode4, astNode2, astNode5);
            if (astNode6 == null) continue;
            return astNode6;
        }
        return null;
    }
}

