/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.Collections;
import java.util.Set;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstPath;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlGSFParser;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlElementHandle
implements ElementHandle {
    private AstNode node;
    private FileObject fo;

    HtmlElementHandle(AstNode astNode, FileObject fileObject) {
        this.node = astNode;
        this.fo = fileObject;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public String getMimeType() {
        return "text/html";
    }

    public String getName() {
        return this.node.name();
    }

    public String getIn() {
        return null;
    }

    public ElementKind getKind() {
        return ElementKind.TAG;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean signatureEquals(ElementHandle elementHandle) {
        if (!(elementHandle instanceof HtmlElementHandle)) {
            return false;
        }
        AstNode astNode = ((HtmlElementHandle)elementHandle).node();
        if (this.node == astNode) {
            return true;
        }
        AstPath astPath = astNode.path();
        AstPath astPath2 = this.node.path();
        return astPath2.equals((Object)astPath);
    }

    AstNode node() {
        return this.node;
    }

    public int from() {
        return this.node().getLogicalRange()[0];
    }

    public int to() {
        return this.node().getLogicalRange()[1];
    }

    public OffsetRange getOffsetRange(ParserResult parserResult) {
        ElementHandle elementHandle = HtmlGSFParser.resolveHandle(parserResult, this);
        if (elementHandle instanceof HtmlElementHandle) {
            HtmlElementHandle htmlElementHandle = (HtmlElementHandle)elementHandle;
            return new OffsetRange(parserResult.getSnapshot().getOriginalOffset(htmlElementHandle.from()), parserResult.getSnapshot().getOriginalOffset(htmlElementHandle.to()));
        }
        throw new IllegalArgumentException("Foreign element: " + elementHandle + " of type " + (elementHandle != null ? elementHandle.getClass().getName() : "null"));
    }
}

