/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttrValuesCompletion {
    private static final Map<String, Map<String, AttrValuesCompletion>> SUPPORTS = new HashMap<String, Map<String, AttrValuesCompletion>>();
    private static final AttrValuesCompletion FILE_NAME_SUPPORT = new FilenameSupport();

    private static void putSupport(String string, String string2, AttrValuesCompletion attrValuesCompletion) {
        Map<String, AttrValuesCompletion> map = SUPPORTS.get(string);
        if (map == null) {
            map = new HashMap<String, AttrValuesCompletion>();
            SUPPORTS.put(string, map);
        }
        map.put(string2, attrValuesCompletion);
    }

    public static AttrValuesCompletion getSupport(String string, String string2) {
        Map<String, AttrValuesCompletion> map = SUPPORTS.get(string.toLowerCase(Locale.ENGLISH));
        if (map == null) {
            return null;
        }
        return map.get(string2.toLowerCase(Locale.ENGLISH));
    }

    public abstract List<HtmlCompletionItem> getValueCompletionItems(Document var1, int var2, String var3);

    static {
        AttrValuesCompletion.putSupport("a", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("area", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("link", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("base", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("script", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("img", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("img", "longdesc", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("img", "usemap", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("input", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("frame", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("iframe", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("body", "background", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("input", "usemap", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "classid", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "codebase", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "data", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "usemap", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("applet", "codebase", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("q", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("blackquote", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("ins", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("del", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("form", "action", FILE_NAME_SUPPORT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilenameSupport
    extends AttrValuesCompletion {
        static final ImageIcon PACKAGE_ICON = ImageUtilities.loadImageIcon((String)"org/openide/loaders/defaultFolder.gif", (boolean)false);

        @Override
        public List<HtmlCompletionItem> getValueCompletionItems(Document document, int n, String string) {
            ArrayList<HtmlCompletionItem> arrayList = new ArrayList<HtmlCompletionItem>();
            String string2 = "";
            String string3 = string;
            int n2 = string.lastIndexOf(47);
            if (n2 == 0) {
                string2 = "/";
                string3 = string.substring(1);
            } else if (n2 > 0) {
                string2 = string.substring(0, n2);
                string3 = n2 == string.length() ? "" : string.substring(n2 + 1);
            }
            int n3 = n - string.length() + n2 + 1;
            try {
                FileObject fileObject = DataLoadersBridge.getDefault().getFileObject(document);
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                FileObject fileObject2 = project != null ? project.getProjectDirectory() : fileObject;
                String string4 = Utils.resolveRelativeURL("/" + fileObject.getPath(), string2);
                string4 = string2.startsWith("/") ? fileObject2.getPath() + string2 : string4.substring(1);
                FileSystem fileSystem = fileObject.getFileSystem();
                FileObject fileObject3 = fileSystem.findResource(string4);
                if (fileObject3 != null) {
                    arrayList.addAll(this.files(n3, fileObject3, string3));
                    if (!(fileObject3.equals(fileObject2) || string2.startsWith("/") || string2.length() != 0 && string2.lastIndexOf("../") + 3 != string2.length())) {
                        arrayList.add(HtmlCompletionItem.createGoUpFileCompletionItem(n3, Color.BLUE, PACKAGE_ICON));
                    }
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return arrayList;
        }

        private List<HtmlCompletionItem> files(int n, FileObject fileObject, String string) {
            ArrayList<HtmlCompletionItem> arrayList = new ArrayList<HtmlCompletionItem>();
            TreeMap<String, HtmlCompletionItem> treeMap = new TreeMap<String, HtmlCompletionItem>();
            TreeMap<String, HtmlCompletionItem> treeMap2 = new TreeMap<String, HtmlCompletionItem>();
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                String string2 = fileObject2.getNameExt();
                if (!string2.startsWith(string) || "cvs".equalsIgnoreCase(string2)) continue;
                if (fileObject2.isFolder()) {
                    treeMap.put(fileObject2.getNameExt(), HtmlCompletionItem.createFileCompletionItem(fileObject2.getNameExt() + "/", n, Color.BLUE, PACKAGE_ICON));
                    continue;
                }
                Image image = Utils.getIcon(fileObject2);
                if (image != null) {
                    treeMap2.put(fileObject2.getNameExt(), HtmlCompletionItem.createFileCompletionItem(fileObject2.getNameExt(), n, Color.BLACK, new ImageIcon(image)));
                    continue;
                }
                treeMap2.put(fileObject2.getNameExt(), HtmlCompletionItem.createFileCompletionItem(fileObject2.getNameExt(), n, Color.BLACK, null));
            }
            arrayList.addAll(treeMap.values());
            arrayList.addAll(treeMap2.values());
            return arrayList;
        }
    }
}

