/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HtmlVersion {
    UNKNOWN(new String[0], -1),
    HTML32(new String[]{"-//W3C//DTD HTML 3.2 Final//EN"}, 0),
    HTML40(new String[]{"-//W3C//DTD HTML 4.0//EN", "-//W3C//DTD HTML 4.0 Transitional//EN", "-//W3C//DTD HTML 4.0 Frameset//EN"}, 1),
    HTML41(new String[]{"-//W3C//DTD HTML 4.01//EN", "-//W3C//DTD HTML 4.01 Transitional//EN", "-//W3C//DTD HTML 4.01 Frameset//EN"}, 1),
    XHTML10(new String[]{"-//W3C//DTD XHTML 1.0 Strict//EN", "-//W3C//DTD XHTML 1.0 Transitional//EN", "-//W3C//DTD XHTML 1.0 Frameset//EN"}, 1, "http://www.w3.org/1999/xhtml", true);

    private final String[] publicIDs;
    private final String defaultNamespace;
    private boolean isXhtml;
    private int fallbackPublicIdIndex;

    public static HtmlVersion findHtmlVersion(String string) {
        for (HtmlVersion htmlVersion : HtmlVersion.values()) {
            if (!htmlVersion.getPublicIDs().contains(string)) continue;
            return htmlVersion;
        }
        return UNKNOWN;
    }

    private HtmlVersion(String[] stringArray, int n2) {
        this(stringArray, n2, null, false);
    }

    private HtmlVersion(String[] stringArray, int n2, String string2, boolean bl) {
        this.publicIDs = stringArray;
        this.defaultNamespace = string2;
        this.isXhtml = bl;
        this.fallbackPublicIdIndex = n2;
    }

    public Collection<String> getPublicIDs() {
        return Arrays.asList(this.publicIDs);
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public boolean isXhtml() {
        return this.isXhtml;
    }

    public String getFallbackPublicId() {
        return this.publicIDs[this.fallbackPublicIdIndex];
    }
}

