/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.formatting.api.LexUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.xhtml.XhtmlElTokenId;
import org.openide.util.Exceptions;

public class HtmlAutoCompletion {
    private static DocumentInsertIgnore insertIgnore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean beforeCharInserted(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        try {
            if (insertIgnore != null && insertIgnore.getOffset() == n && insertIgnore.getChar() == c) {
                if (insertIgnore.getMoveCaretTo() != -1) {
                    caret.setDot(insertIgnore.moveCaretTo);
                    Completion.get().hideAll();
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            insertIgnore = null;
        }
        return false;
    }

    public static void charInserted(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (c == '=') {
            HtmlAutoCompletion.completeQuotes(baseDocument, n, caret);
        } else if (c == '\"') {
            HtmlAutoCompletion.handleQuotationMark(baseDocument, n, caret);
        } else if (c == '{') {
            HtmlAutoCompletion.handleEL(baseDocument, n, caret);
        } else if (c == '/') {
            HtmlAutoCompletion.handleEmptyTagCloseSymbol(baseDocument, n, caret);
        } else if (c == '>') {
            HtmlAutoCompletion.handleTagClosingSymbol(baseDocument, n, c);
        }
    }

    private static void handleTagClosingSymbol(final BaseDocument baseDocument, int n, char c) throws BadLocationException {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        for (LanguagePath languagePath : tokenHierarchy.languagePaths()) {
            if (languagePath.innerLanguage() != HTMLTokenId.language()) continue;
            TokenSequence tokenSequence = LexUtilities.getTokenSequence((BaseDocument)baseDocument, (int)n, (Language)HTMLTokenId.language());
            if (tokenSequence == null) {
                return;
            }
            tokenSequence.move(n);
            boolean bl = false;
            while (tokenSequence.movePrevious()) {
                if (tokenSequence.token().id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                    bl = true;
                    break;
                }
                if (tokenSequence.token().id() == HTMLTokenId.ARGUMENT || tokenSequence.token().id() == HTMLTokenId.OPERATOR || tokenSequence.token().id() == HTMLTokenId.VALUE || tokenSequence.token().id() == HTMLTokenId.VALUE_CSS || tokenSequence.token().id() == HTMLTokenId.VALUE_JAVASCRIPT || tokenSequence.token().id() == HTMLTokenId.WS || tokenSequence.token().id() == HTMLTokenId.TAG_CLOSE || tokenSequence.token().id() == HTMLTokenId.TAG_OPEN) continue;
            }
            if (!bl) {
                return;
            }
            try {
                int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)tokenSequence.offset());
                if (n2 != tokenSequence.offset()) {
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            final Position position = baseDocument.createPosition(Utilities.getRowStart((BaseDocument)baseDocument, (int)n));
            final Position position2 = baseDocument.createPosition(Utilities.getRowEnd((BaseDocument)baseDocument, (int)n));
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    final Indent indent = Indent.get((Document)baseDocument);
                    indent.lock();
                    try {
                        baseDocument.runAtomic(new Runnable(){

                            public void run() {
                                try {
                                    indent.reindent(position.getOffset(), position2.getOffset());
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    finally {
                        indent.unlock();
                    }
                }
            });
            return;
        }
    }

    private static void handleEmptyTagCloseSymbol(BaseDocument baseDocument, int n, Caret caret) throws BadLocationException {
        TokenSequence tokenSequence = LexUtilities.getTokenSequence((BaseDocument)baseDocument, (int)n, (Language)HTMLTokenId.language());
        if (tokenSequence == null) {
            return;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return;
        }
        Token token = tokenSequence.token();
        if (token.id() == HTMLTokenId.ERROR && tokenSequence.movePrevious() && (tokenSequence.token().id() == HTMLTokenId.TAG_OPEN || tokenSequence.token().id() == HTMLTokenId.WS || tokenSequence.token().id() == HTMLTokenId.VALUE)) {
            baseDocument.insertString(n + 1, ">", null);
            insertIgnore = new DocumentInsertIgnore(n + 2, '>', -1);
        }
    }

    private static void handleQuotationMark(BaseDocument baseDocument, int n, Caret caret) throws BadLocationException {
        TokenSequence tokenSequence = LexUtilities.getTokenSequence((BaseDocument)baseDocument, (int)n, (Language)HTMLTokenId.language());
        if (tokenSequence == null) {
            return;
        }
        int n2 = tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return;
        }
        Token token = tokenSequence.token();
        if (token.id() == HTMLTokenId.VALUE) {
            try {
                if ("\"\"".equals(baseDocument.getText(n, 2))) {
                    baseDocument.remove(n, 1);
                    caret.setDot(n + 1);
                } else if (n2 == 0 && token.text().charAt(0) == '\"') {
                    baseDocument.insertString(n, "\"", null);
                    caret.setDot(n + 1);
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    private static void completeQuotes(BaseDocument baseDocument, int n, Caret caret) {
        TokenSequence tokenSequence = LexUtilities.getTokenSequence((BaseDocument)baseDocument, (int)n, (Language)HTMLTokenId.language());
        if (tokenSequence == null) {
            return;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return;
        }
        Token token = tokenSequence.token();
        int n2 = n + 1;
        if (token != null && token.id() == HTMLTokenId.OPERATOR) {
            try {
                baseDocument.insertString(n2, "\"\"", null);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            caret.setDot(n2 + 1);
        }
    }

    private static void handleEL(BaseDocument baseDocument, int n, Caret caret) {
        char c;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(XhtmlElTokenId.language());
        if (tokenSequence == null) {
            return;
        }
        int n2 = tokenSequence.move(n);
        if (n2 == 0) {
            return;
        }
        if (!tokenSequence.moveNext()) {
            return;
        }
        Token token = tokenSequence.token();
        int n3 = n + 1;
        if (token.id() == XhtmlElTokenId.EL && ((c = token.text().charAt(n2 - 1)) == '$' || c == '#')) {
            try {
                baseDocument.insertString(n3, "}", null);
                caret.setDot(n3);
                Completion.get().showCompletion();
                insertIgnore = new DocumentInsertIgnore(n3, '}', n3 + 1);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    private static class DocumentInsertIgnore {
        private int offset;
        private char ch;
        private int moveCaretTo;

        public DocumentInsertIgnore(int n, char c, int n2) {
            this.offset = n;
            this.ch = c;
            this.moveCaretTo = n2;
        }

        public char getChar() {
            return this.ch;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getMoveCaretTo() {
            return this.moveCaretTo;
        }
    }
}

