/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateLicenseImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.ModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateLicense;
import org.netbeans.updater.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoupdateInfoParser
extends DefaultHandler {
    private static final String INFO_NAME = "info";
    private static final String INFO_EXT = ".xml";
    private static final String INFO_FILE = "info.xml";
    private static final String INFO_DIR = "Info";
    private static final String INFO_LOCALE = "locale";
    private final Map<String, UpdateItem> items;
    private final EntityResolver entityResolver;
    private final File nbmFile;
    private UpdateLicenseImpl currentUpdateLicenseImpl;
    private static final Logger ERR = Logger.getLogger(AutoupdateInfoParser.class.getName());
    private static final String LICENSE_ATTR_NAME = "name";
    private static final String MODULE_ATTR_CODE_NAME_BASE = "codenamebase";
    private static final String MODULE_ATTR_HOMEPAGE = "homepage";
    private static final String MODULE_ATTR_DOWNLOAD_SIZE = "downloadsize";
    private static final String MODULE_ATTR_NEEDS_RESTART = "needsrestart";
    private static final String MODULE_ATTR_MODULE_AUTHOR = "moduleauthor";
    private static final String MODULE_ATTR_RELEASE_DATE = "releasedate";
    private static final String MODULE_ATTR_IS_GLOBAL = "global";
    private static final String MODULE_ATTR_TARGET_CLUSTER = "targetcluster";
    private static final String MODULE_ATTR_EAGER = "eager";
    private static final String MODULE_ATTR_AUTOLOAD = "autoload";
    private static final String MODULE_ATTR_LICENSE = "license";
    private static final String MANIFEST_ATTR_SPECIFICATION_VERSION = "OpenIDE-Module-Specification-Version";
    private static final String L10N_ATTR_LOCALE = "langcode";
    private static final String L10N_ATTR_BRANDING = "brandingcode";
    private static final String L10N_ATTR_MODULE_SPECIFICATION = "module_spec_version";
    private static final String L10N_ATTR_MODULE_MAJOR_VERSION = "module_major_version";
    private static final String L10N_ATTR_LOCALIZED_MODULE_NAME = "OpenIDE-Module-Name";
    private static final String L10N_ATTR_LOCALIZED_MODULE_DESCRIPTION = "OpenIDE-Module-Long-Description";
    private Stack<ModuleDescriptor> currentModule = new Stack();
    private Stack<String> currentLicense = new Stack();
    private List<String> lines = new ArrayList<String>();

    private AutoupdateInfoParser(Map<String, UpdateItem> map, File file) {
        this.items = map;
        this.entityResolver = this.newEntityResolver();
        this.nbmFile = file;
    }

    private EntityResolver newEntityResolver() {
        try {
            Class.forName("org.netbeans.updater.XMLUtil");
        }
        catch (ClassNotFoundException classNotFoundException) {
            File file = new File(System.getProperty("netbeans.home"));
            File file2 = new File(System.getProperty("netbeans.user"));
            File file3 = new File(file, "modules/ext/updater.jar");
            File file4 = new File(file2, "modules/ext/updater.jar");
            File file5 = new File(file, "update/new_updater/updater.jar");
            File file6 = new File(file2, "update/new_updater/updater.jar");
            String string = "    org.netbeans.updater.XMLUtil is not accessible\n    platform dir = " + file.getAbsolutePath() + "\n" + "    userdir  dir = " + file2.getAbsolutePath() + "\n" + "    updater in platform exist = " + file3.exists() + (file3.exists() ? ", length = " + file3.length() + " bytes" : "") + "\n" + "    updater in userdir  exist = " + file4.exists() + (file4.exists() ? ", length = " + file4.length() + " bytes" : "") + "\n" + "    new updater in platform exist = " + file5.exists() + (file5.exists() ? ", length = " + file5.length() + " bytes" : "") + "\n" + "    new updater in userdir  exist = " + file6.exists() + (file6.exists() ? ", length = " + file6.length() + " bytes" : "") + "\n";
            ERR.log(Level.WARNING, string);
        }
        return XMLUtil.createAUResolver();
    }

    public static Map<String, UpdateItem> getUpdateItems(File file) throws IOException, SAXException {
        HashMap<String, UpdateItem> hashMap = new HashMap<String, UpdateItem>();
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(AutoupdateInfoParser.getAutoupdateInfoInputStream(file), (DefaultHandler)new AutoupdateInfoParser(hashMap, file));
        }
        catch (SAXException sAXException) {
            ERR.log(Level.INFO, sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, iOException.getMessage(), iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ERR.log(Level.INFO, parserConfigurationException.getMessage(), parserConfigurationException);
        }
        return hashMap;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.lines.add(new String(cArray, n, n2));
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (ELEMENTS.valueOf(string3)) {
            case module: {
                assert (!this.currentModule.empty()) : "Premature end of module " + string3;
                this.currentModule.pop();
                break;
            }
            case l10n: {
                break;
            }
            case manifest: {
                break;
            }
            case description: {
                ERR.info("Not supported yet.");
                break;
            }
            case module_notification: {
                ModuleDescriptor moduleDescriptor = this.currentModule.peek();
                assert (moduleDescriptor != null) : "ModuleDescriptor found for " + this.nbmFile;
                StringBuffer stringBuffer = new StringBuffer();
                for (String string4 : this.lines) {
                    stringBuffer.append(string4);
                }
                moduleDescriptor.appendNotification(stringBuffer.toString());
                break;
            }
            case external_package: {
                ERR.info("Not supported yet.");
                break;
            }
            case license: {
                assert (!this.currentLicense.empty()) : "Premature end of license " + string3;
                StringBuffer stringBuffer = new StringBuffer();
                for (String string5 : this.lines) {
                    stringBuffer.append(string5);
                }
                assert (this.currentUpdateLicenseImpl != null) : "UpdateLicenseImpl found for " + this.nbmFile;
                this.currentUpdateLicenseImpl.setAgreement(stringBuffer.toString());
                this.currentLicense.pop();
                break;
            }
            default: {
                ERR.warning("Unknown element " + string3);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        ERR.fine("End parsing " + this.nbmFile + " at " + System.currentTimeMillis());
    }

    @Override
    public void startDocument() throws SAXException {
        ERR.fine("Start parsing " + this.nbmFile + " at " + System.currentTimeMillis());
    }

    @Override
    public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
        this.lines.clear();
        switch (ELEMENTS.valueOf(string3)) {
            case module: {
                ModuleDescriptor moduleDescriptor = new ModuleDescriptor(this.nbmFile);
                moduleDescriptor.appendModuleAttributes(attributes);
                this.currentModule.push(moduleDescriptor);
                break;
            }
            case l10n: {
                break;
            }
            case manifest: {
                ModuleDescriptor moduleDescriptor = this.currentModule.peek();
                moduleDescriptor.appendManifest(attributes);
                UpdateItem updateItem = moduleDescriptor.createUpdateItem();
                UpdateItemImpl updateItemImpl = Trampoline.SPI.impl(updateItem);
                this.currentUpdateLicenseImpl = updateItemImpl.getUpdateLicenseImpl();
                this.items.put(moduleDescriptor.getId(), updateItem);
                break;
            }
            case description: {
                ERR.info("Not supported yet.");
                break;
            }
            case module_notification: {
                break;
            }
            case external_package: {
                ERR.info("Not supported yet.");
                break;
            }
            case license: {
                this.currentLicense.push(attributes.getValue(LICENSE_ATTR_NAME));
                break;
            }
            default: {
                ERR.warning("Unknown element " + string3);
            }
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        return this.entityResolver.resolveEntity(string, string2);
    }

    private static Manifest getManifest(org.xml.sax.Attributes attributes) {
        Manifest manifest = new Manifest();
        Attributes attributes2 = manifest.getMainAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            attributes2.put(new Attributes.Name(attributes.getQName(i)), attributes.getValue(i));
        }
        return manifest;
    }

    static InputSource getAutoupdateInfoInputStream(File file) throws IOException, SAXException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Cannot open NBM file " + file + ": " + iOException).initCause(iOException);
        }
        String string = Locale.getDefault().toString();
        ZipEntry zipEntry = jarFile.getEntry("Info/locale/info_" + string + INFO_EXT);
        if (zipEntry == null) {
            zipEntry = jarFile.getEntry("Info/info.xml");
        }
        if (zipEntry == null) {
            throw new IllegalArgumentException("info.xml found in file " + file);
        }
        return new InputSource(new BufferedInputStream(jarFile.getInputStream(zipEntry)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ELEMENTS {
        module,
        description,
        module_notification,
        external_package,
        manifest,
        l10n,
        license;

    }

    private static class ModuleDescriptor {
        private String moduleCodeName;
        private String targetcluster;
        private String homepage;
        private String downloadSize;
        private String author;
        private String publishDate;
        private String notification;
        private Boolean needsRestart;
        private Boolean isGlobal;
        private Boolean isEager;
        private Boolean isAutoload;
        private String specVersion;
        private Manifest mf;
        private UpdateLicense lic;
        private final File nbmFile;

        public ModuleDescriptor(File file) {
            this.nbmFile = file;
        }

        public void appendModuleAttributes(org.xml.sax.Attributes attributes) {
            this.moduleCodeName = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_CODE_NAME_BASE);
            this.targetcluster = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_TARGET_CLUSTER);
            this.homepage = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_HOMEPAGE);
            this.downloadSize = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_DOWNLOAD_SIZE);
            this.author = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_MODULE_AUTHOR);
            this.publishDate = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_RELEASE_DATE);
            if (this.publishDate == null || this.publishDate.length() == 0) {
                this.publishDate = Utilities.formatDate(new Date(this.nbmFile.lastModified()));
            }
            String string = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_NEEDS_RESTART);
            String string2 = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_IS_GLOBAL);
            String string3 = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_EAGER);
            String string4 = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_AUTOLOAD);
            this.needsRestart = string == null || string.trim().length() == 0 ? null : Boolean.valueOf(string);
            this.isGlobal = string2 == null || string2.trim().length() == 0 ? null : Boolean.valueOf(string2);
            this.isEager = Boolean.parseBoolean(string3);
            this.isAutoload = Boolean.parseBoolean(string4);
            String string5 = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_LICENSE);
            this.lic = UpdateLicense.createUpdateLicense(string5, null);
        }

        public void appendManifest(org.xml.sax.Attributes attributes) {
            this.specVersion = attributes.getValue(AutoupdateInfoParser.MANIFEST_ATTR_SPECIFICATION_VERSION);
            this.mf = AutoupdateInfoParser.getManifest(attributes);
        }

        public void appendNotification(String string) {
            this.notification = string;
        }

        public String getId() {
            return this.moduleCodeName + '_' + this.specVersion;
        }

        public UpdateItem createUpdateItem() {
            URL uRL = null;
            try {
                uRL = this.nbmFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                ERR.log(Level.INFO, null, malformedURLException);
            }
            UpdateItem updateItem = UpdateItem.createModule(this.moduleCodeName, this.specVersion, uRL, this.author, this.downloadSize, this.homepage, this.publishDate, null, this.mf, this.isEager, this.isAutoload, this.needsRestart, this.isGlobal, this.targetcluster, this.lic);
            UpdateItemImpl updateItemImpl = Trampoline.SPI.impl(updateItem);
            ((ModuleItem)updateItemImpl).setModuleNotification(this.notification);
            return updateItem;
        }
    }
}

