/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.ModuleDeleterImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.NativeComponentUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.UpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.spi.autoupdate.CustomInstaller;
import org.netbeans.spi.autoupdate.CustomUninstaller;
import org.openide.LifecycleManager;
import org.openide.modules.ModuleInfo;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationSupportImpl {
    private static final OperationSupportImpl FOR_INSTALL = new ForInstall();
    private static final OperationSupportImpl FOR_UPDATE = new ForUpdate();
    private static final OperationSupportImpl FOR_ENABLE = new ForEnable();
    private static final OperationSupportImpl FOR_DISABLE = new ForDisable();
    private static final OperationSupportImpl FOR_DIRECT_DISABLE = new ForDirectDisable();
    private static final OperationSupportImpl FOR_UNINSTALL = new ForUninstall();
    private static final OperationSupportImpl FOR_DIRECT_UNINSTALL = new ForDirectUninstall();
    private static final OperationSupportImpl FOR_CUSTOM_INSTALL = new ForCustomInstall();
    private static final OperationSupportImpl FOR_CUSTOM_UNINSTALL = new ForCustomUninstall();
    private static final OperationSupportImpl FOR_INTERNAL_UPDATE = new ForInternalUpdate();
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.autoupdate.services.OperationSupportImpl");

    public static OperationSupportImpl forInstall() {
        return FOR_INSTALL;
    }

    public static OperationSupportImpl forUpdate() {
        return FOR_UPDATE;
    }

    public static OperationSupportImpl forUninstall() {
        return FOR_UNINSTALL;
    }

    public static OperationSupportImpl forDirectUninstall() {
        return FOR_DIRECT_UNINSTALL;
    }

    public static OperationSupportImpl forEnable() {
        return FOR_ENABLE;
    }

    public static OperationSupportImpl forDisable() {
        return FOR_DISABLE;
    }

    public static OperationSupportImpl forDirectDisable() {
        return FOR_DIRECT_DISABLE;
    }

    public static OperationSupportImpl forCustomInstall() {
        return FOR_CUSTOM_INSTALL;
    }

    public static OperationSupportImpl forCustomUninstall() {
        return FOR_CUSTOM_UNINSTALL;
    }

    public static OperationSupportImpl forInternalUpdate() {
        return FOR_INTERNAL_UPDATE;
    }

    public abstract Boolean doOperation(ProgressHandle var1, OperationContainer<?> var2) throws OperationException;

    public abstract void doCancel() throws OperationException;

    public abstract void doRestart(OperationSupport.Restarter var1, ProgressHandle var2) throws OperationException;

    public abstract void doRestartLater(OperationSupport.Restarter var1);

    private OperationSupportImpl() {
    }

    private static void markForRestart() {
        try {
            LifecycleManager.getDefault().markForRestart();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.log(Level.INFO, null, unsupportedOperationException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForCustomInstall
    extends OperationSupportImpl {
        private Collection<UpdateElement> affectedModules = null;

        private ForCustomInstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            boolean bl = false;
            boolean bl2 = false;
            try {
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                ArrayList<NativeComponentUpdateElementImpl> arrayList = new ArrayList<NativeComponentUpdateElementImpl>();
                for (OperationContainer.OperationInfo<?> object : list) {
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(object.getUpdateElement());
                    assert (updateElementImpl instanceof NativeComponentUpdateElementImpl) : "Impl of " + object.getUpdateElement() + " instanceof NativeComponentUpdateElementImpl.";
                    arrayList.add((NativeComponentUpdateElementImpl)updateElementImpl);
                }
                assert (arrayList != null) : "Some elements with custom installer found.";
                if (progressHandle != null) {
                    progressHandle.start(arrayList.size());
                }
                bl2 = true;
                int n = 0;
                this.affectedModules = new HashSet<UpdateElement>();
                for (NativeComponentUpdateElementImpl nativeComponentUpdateElementImpl : arrayList) {
                    if (progressHandle != null) {
                        progressHandle.progress(NbBundle.getMessage(OperationSupportImpl.class, (String)"OperationSupportImpl_Custom_Install", (Object)nativeComponentUpdateElementImpl.getDisplayName()), ++n);
                    }
                    CustomInstaller customInstaller = nativeComponentUpdateElementImpl.getInstallInfo().getCustomInstaller();
                    assert (customInstaller != null) : "CustomInstaller must found for " + nativeComponentUpdateElementImpl.getUpdateElement();
                    ProgressHandle progressHandle2 = ProgressHandleFactory.createHandle((String)("Installing " + nativeComponentUpdateElementImpl.getDisplayName()));
                    bl = customInstaller.install(nativeComponentUpdateElementImpl.getCodeName(), nativeComponentUpdateElementImpl.getSpecificationVersion() == null ? null : nativeComponentUpdateElementImpl.getSpecificationVersion().toString(), progressHandle2);
                    try {
                        progressHandle2.finish();
                    }
                    catch (IllegalStateException illegalStateException) {
                        LOGGER.log(Level.FINE, "Can`t stop progress handle, likely was not started ", illegalStateException);
                    }
                    if (bl) {
                        UpdateUnitImpl updateUnitImpl = Trampoline.API.impl(nativeComponentUpdateElementImpl.getUpdateUnit());
                        updateUnitImpl.setInstalled(nativeComponentUpdateElementImpl.getUpdateElement());
                        this.affectedModules.add(nativeComponentUpdateElementImpl.getUpdateElement());
                        continue;
                    }
                    throw new OperationException(OperationException.ERROR_TYPE.INSTALL, nativeComponentUpdateElementImpl.getDisplayName());
                }
            }
            finally {
                if (progressHandle != null && bl2) {
                    progressHandle.finish();
                }
            }
            return bl;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            OperationSupportImpl.markForRestart();
            LifecycleManager.getDefault().exit();
            this.doRestartLater(restarter);
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            OperationSupportImpl.markForRestart();
            if (this.affectedModules != null) {
                for (UpdateElement updateElement : this.affectedModules) {
                    UpdateUnitFactory.getDefault().scheduleForRestart(updateElement);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForCustomUninstall
    extends OperationSupportImpl {
        private Collection<UpdateElement> affectedModules = null;

        private ForCustomUninstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            boolean bl = false;
            boolean bl2 = false;
            try {
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                ArrayList<NativeComponentUpdateElementImpl> arrayList = new ArrayList<NativeComponentUpdateElementImpl>();
                for (OperationContainer.OperationInfo<?> object : list) {
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(object.getUpdateElement());
                    assert (updateElementImpl instanceof NativeComponentUpdateElementImpl) : "Impl of " + object.getUpdateElement() + " instanceof NativeComponentUpdateElementImpl.";
                    arrayList.add((NativeComponentUpdateElementImpl)updateElementImpl);
                }
                assert (arrayList != null) : "Some elements with custom installer found.";
                progressHandle.start(arrayList.size());
                bl2 = true;
                int n = 0;
                this.affectedModules = new HashSet<UpdateElement>();
                for (NativeComponentUpdateElementImpl nativeComponentUpdateElementImpl : arrayList) {
                    progressHandle.progress(NbBundle.getMessage(OperationSupportImpl.class, (String)"OperationSupportImpl_Custom_Uninstall", (Object)nativeComponentUpdateElementImpl.getDisplayName()), ++n);
                    CustomUninstaller customUninstaller = nativeComponentUpdateElementImpl.getNativeItem().getUpdateItemDeploymentImpl().getCustomUninstaller();
                    assert (customUninstaller != null) : "CustomInstaller must found for " + nativeComponentUpdateElementImpl.getUpdateElement();
                    ProgressHandle progressHandle2 = ProgressHandleFactory.createHandle((String)("Installing " + nativeComponentUpdateElementImpl.getDisplayName()));
                    bl = customUninstaller.uninstall(nativeComponentUpdateElementImpl.getCodeName(), nativeComponentUpdateElementImpl.getSpecificationVersion() == null ? null : nativeComponentUpdateElementImpl.getSpecificationVersion().toString(), progressHandle2);
                    progressHandle2.finish();
                    if (bl) {
                        UpdateUnitImpl updateUnitImpl = Trampoline.API.impl(nativeComponentUpdateElementImpl.getUpdateUnit());
                        updateUnitImpl.setAsUninstalled();
                        this.affectedModules.add(nativeComponentUpdateElementImpl.getUpdateElement());
                        continue;
                    }
                    throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL, nativeComponentUpdateElementImpl.getDisplayName());
                }
            }
            finally {
                if (progressHandle != null && bl2) {
                    progressHandle.finish();
                }
            }
            return bl;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            OperationSupportImpl.markForRestart();
            LifecycleManager.getDefault().exit();
            this.doRestartLater(restarter);
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            OperationSupportImpl.markForRestart();
            if (this.affectedModules != null) {
                for (UpdateElement updateElement : this.affectedModules) {
                    UpdateUnitFactory.getDefault().scheduleForRestart(updateElement);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForDirectDisable
    extends OperationSupportImpl {
        private ForDirectDisable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            try {
                Object object;
                if (progressHandle != null) {
                    progressHandle.start();
                }
                ModuleManager moduleManager = null;
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                HashSet<ModuleInfo> hashSet = new HashSet<ModuleInfo>();
                for (OperationContainer.OperationInfo<?> object22 : list) {
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(object22.getUpdateElement());
                    hashSet.addAll(updateElementImpl.getModuleInfos());
                }
                final HashSet hashSet2 = new HashSet();
                for (ModuleInfo moduleInfo : hashSet) {
                    object = Utilities.toModule(moduleInfo);
                    if (Utilities.canDisable(object)) {
                        hashSet2.add(object);
                        LOGGER.log(Level.FINE, "Module will be disabled " + object.getCodeNameBase());
                    }
                    if (moduleManager != null) continue;
                    moduleManager = object.getManager();
                }
                assert (moduleManager != null);
                final ModuleManager moduleManager2 = moduleManager;
                try {
                    moduleManager2.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                        public Boolean run() throws Exception {
                            return ForDirectDisable.disable(moduleManager2, hashSet2);
                        }
                    });
                }
                catch (MutexException mutexException) {
                    object = mutexException.getException();
                    assert (object instanceof OperationException) : object + " is instanceof OperationException";
                    if (object instanceof OperationException) {
                        throw (OperationException)object;
                    }
                }
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
            return false;
        }

        private static boolean disable(ModuleManager moduleManager, Set<Module> set) throws OperationException {
            boolean bl = false;
            try {
                moduleManager.disable(set);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE, illegalArgumentException);
            }
            return bl;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForDirectUninstall
    extends OperationSupportImpl {
        private ForDirectUninstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            try {
                Object object;
                if (progressHandle != null) {
                    progressHandle.start();
                }
                ModuleDeleterImpl moduleDeleterImpl = new ModuleDeleterImpl();
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                HashSet<ModuleInfo> hashSet = new HashSet<ModuleInfo>();
                HashSet<UpdateUnit> hashSet2 = new HashSet<UpdateUnit>();
                HashSet<UpdateUnit> hashSet3 = new HashSet<UpdateUnit>();
                block9: for (OperationContainer.OperationInfo<?> object2 : list) {
                    object = object2.getUpdateElement();
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl((UpdateElement)object);
                    switch (updateElementImpl.getType()) {
                        case KIT_MODULE: 
                        case MODULE: {
                            hashSet.add(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                            hashSet2.add(updateElementImpl.getUpdateUnit());
                            continue block9;
                        }
                        case STANDALONE_MODULE: 
                        case FEATURE: {
                            for (ModuleUpdateElementImpl moduleUpdateElementImpl : ((FeatureUpdateElementImpl)updateElementImpl).getContainedModuleElements()) {
                                hashSet.add(moduleUpdateElementImpl.getModuleInfo());
                                if (moduleUpdateElementImpl.getUpdateUnit().getInstalled() == null) continue;
                                hashSet2.add(moduleUpdateElementImpl.getUpdateUnit());
                            }
                            hashSet3.add(((UpdateElement)object).getUpdateUnit());
                            continue block9;
                        }
                    }
                    assert (false) : "Not supported for impl " + updateElementImpl;
                }
                try {
                    moduleDeleterImpl.delete(hashSet.toArray(new ModuleInfo[0]), progressHandle);
                }
                catch (IOException iOException) {
                    throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL, iOException);
                }
                for (UpdateUnit updateUnit : hashSet2) {
                    assert (updateUnit.getInstalled() != null) : "Module " + updateUnit + " is installed while doing uninstall.";
                    LOGGER.log(Level.FINE, "Module was uninstalled " + updateUnit.getCodeName());
                    object = Trampoline.API.impl(updateUnit);
                    ((UpdateUnitImpl)object).setAsUninstalled();
                }
                for (UpdateUnit updateUnit : hashSet3) {
                    assert (updateUnit.getInstalled() != null) : "Feature " + updateUnit + " is installed while doing uninstall.";
                    LOGGER.log(Level.FINE, "Feature was uninstalled " + updateUnit.getCodeName());
                    object = Trampoline.API.impl(updateUnit);
                    ((UpdateUnitImpl)object).setAsUninstalled();
                }
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
            return false;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForDisable
    extends OperationSupportImpl {
        private Collection<File> controlFileForDisable = null;
        private Collection<UpdateElement> affectedModules = null;

        private ForDisable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            try {
                if (progressHandle != null) {
                    progressHandle.start();
                }
                ModuleManager moduleManager = null;
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                this.affectedModules = new HashSet<UpdateElement>();
                HashSet<ModuleInfo> hashSet = new HashSet<ModuleInfo>();
                for (OperationContainer.OperationInfo<?> object2 : list) {
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(object2.getUpdateElement());
                    this.affectedModules.add(object2.getUpdateElement());
                    hashSet.addAll(updateElementImpl.getModuleInfos());
                }
                HashSet hashSet2 = new HashSet();
                for (ModuleInfo moduleInfo : hashSet) {
                    Module module = Utilities.toModule(moduleInfo);
                    if (Utilities.canDisable(module)) {
                        hashSet2.add(module);
                        LOGGER.log(Level.FINE, "Mark module " + module.getCodeNameBase() + " for disable.");
                    }
                    if (moduleManager != null) continue;
                    moduleManager = module.getManager();
                }
                assert (moduleManager != null);
                ModuleDeleterImpl moduleDeleterImpl = new ModuleDeleterImpl();
                this.controlFileForDisable = moduleDeleterImpl.markForDisable(hashSet2, progressHandle);
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
            return true;
        }

        @Override
        public void doCancel() throws OperationException {
            if (this.controlFileForDisable != null) {
                this.controlFileForDisable = null;
            }
            if (this.affectedModules != null) {
                this.affectedModules = null;
            }
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            Utilities.writeFileMarkedForDisable(this.controlFileForDisable);
            Utilities.deleteAllDoLater();
            LifecycleManager.getDefault().exit();
            this.doRestartLater(restarter);
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            Utilities.writeFileMarkedForDisable(this.controlFileForDisable);
            for (UpdateElement updateElement : this.affectedModules) {
                UpdateUnitFactory.getDefault().scheduleForRestart(updateElement);
            }
            Utilities.writeDeactivateLater(this.controlFileForDisable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForEnable
    extends OperationSupportImpl {
        private ForEnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            try {
                Object object;
                if (progressHandle != null) {
                    progressHandle.start();
                }
                ModuleManager moduleManager = null;
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                HashSet<ModuleInfo> hashSet = new HashSet<ModuleInfo>();
                for (OperationContainer.OperationInfo<?> object22 : list) {
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(object22.getUpdateElement());
                    hashSet.addAll(updateElementImpl.getModuleInfos());
                }
                final HashSet hashSet2 = new HashSet();
                for (ModuleInfo moduleInfo : hashSet) {
                    object = Utilities.toModule(moduleInfo);
                    if (Utilities.canEnable(object)) {
                        hashSet2.add(object);
                        LOGGER.log(Level.FINE, "Module will be enabled " + object.getCodeNameBase());
                    }
                    if (moduleManager != null) continue;
                    moduleManager = object.getManager();
                }
                assert (moduleManager != null);
                final ModuleManager moduleManager2 = moduleManager;
                try {
                    moduleManager2.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                        public Boolean run() throws Exception {
                            return ForEnable.enable(moduleManager2, hashSet2);
                        }
                    });
                }
                catch (MutexException mutexException) {
                    object = mutexException.getException();
                    assert (object instanceof OperationException) : object + " is instanceof OperationException";
                    if (object instanceof OperationException) {
                        throw (OperationException)object;
                    }
                }
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
            return false;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        private static boolean enable(ModuleManager moduleManager, Set<Module> set) throws OperationException {
            boolean bl = false;
            try {
                moduleManager.enable(set);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE, illegalArgumentException);
            }
            catch (InvalidException invalidException) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE, (Exception)((Object)invalidException));
            }
            return bl;
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class ForInstall
    extends OperationSupportImpl {
        private ForInstall() {
        }

        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer operationContainer) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class ForInternalUpdate
    extends OperationSupportImpl {
        private ForInternalUpdate() {
        }

        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer operationContainer) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForUninstall
    extends OperationSupportImpl {
        private Collection<File> files4remove = null;
        private Collection<UpdateElement> affectedModules = null;

        private ForUninstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            try {
                if (progressHandle != null) {
                    progressHandle.start();
                }
                ModuleDeleterImpl moduleDeleterImpl = new ModuleDeleterImpl();
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                HashSet<ModuleInfo> hashSet = new HashSet<ModuleInfo>();
                this.affectedModules = new HashSet<UpdateElement>();
                block10: for (OperationContainer.OperationInfo<?> operationInfo : list) {
                    UpdateElement updateElement = operationInfo.getUpdateElement();
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
                    switch (updateElementImpl.getType()) {
                        case KIT_MODULE: 
                        case MODULE: {
                            hashSet.add(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                            this.affectedModules.add(updateElementImpl.getUpdateElement());
                            break;
                        }
                        case STANDALONE_MODULE: 
                        case FEATURE: {
                            for (ModuleUpdateElementImpl moduleUpdateElementImpl : ((FeatureUpdateElementImpl)updateElementImpl).getContainedModuleElements()) {
                                hashSet.add(moduleUpdateElementImpl.getModuleInfo());
                                if (moduleUpdateElementImpl.getUpdateUnit().getInstalled() == null) continue;
                                this.affectedModules.add(moduleUpdateElementImpl.getUpdateElement());
                            }
                            continue block10;
                        }
                        case CUSTOM_HANDLED_COMPONENT: {
                            break;
                        }
                        default: {
                            assert (false) : "Not supported for impl " + updateElementImpl;
                            continue block10;
                        }
                    }
                }
                try {
                    this.files4remove = moduleDeleterImpl.markForDelete(hashSet, progressHandle);
                }
                catch (IOException iOException) {
                    throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL, iOException);
                }
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
            return true;
        }

        @Override
        public void doCancel() throws OperationException {
            if (this.files4remove != null) {
                this.files4remove = null;
            }
            if (this.affectedModules != null) {
                this.affectedModules = null;
            }
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            Utilities.writeFileMarkedForDelete(this.files4remove);
            Utilities.deleteAllDoLater();
            LifecycleManager.getDefault().exit();
            this.doRestartLater(restarter);
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            Utilities.writeFileMarkedForDelete(this.files4remove);
            for (UpdateElement updateElement : this.affectedModules) {
                UpdateUnitFactory.getDefault().scheduleForRestart(updateElement);
            }
            Utilities.writeDeactivateLater(this.files4remove);
        }
    }

    private static class ForUpdate
    extends OperationSupportImpl {
        private ForUpdate() {
        }

        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer operationContainer) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

