/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.services.DependencyChecker;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.ArtificialFeaturesProvider;
import org.netbeans.modules.autoupdate.updateprovider.FeatureItem;
import org.netbeans.modules.autoupdate.updateprovider.InstallInfo;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureUpdateElementImpl
extends UpdateElementImpl {
    private String codeName;
    private String displayName;
    private SpecificationVersion specVersion;
    private String description;
    private String homepage;
    private String category;
    private InstallInfo installInfo;
    private FeatureItem featureItem;
    private static Logger LOG = null;
    private Set<ModuleUpdateElementImpl> moduleElementsImpl;
    private UpdateManager.TYPE type;

    public FeatureUpdateElementImpl(FeatureItem featureItem, String string, Set<ModuleUpdateElementImpl> set, UpdateManager.TYPE tYPE) {
        super(featureItem, string);
        this.type = tYPE;
        this.moduleElementsImpl = set;
        this.codeName = featureItem.getCodeName();
        String string2 = featureItem.getSpecificationVersion();
        if (string2 == null) {
            FeatureUpdateElementImpl.getLogger().log(Level.INFO, this.codeName + " has no specificationVersion.");
        } else {
            this.specVersion = new SpecificationVersion(string2);
        }
        this.installInfo = new InstallInfo(featureItem);
        this.displayName = featureItem.getDisplayName();
        this.description = featureItem.getDescription();
        this.featureItem = featureItem;
        this.category = featureItem.getCategory();
        if (this.category == null) {
            this.category = NbBundle.getMessage(UpdateElementImpl.class, (String)"UpdateElementImpl_Feature_CategoryName");
        }
    }

    @Override
    public String getCodeName() {
        return this.codeName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public SpecificationVersion getSpecificationVersion() {
        if (this.specVersion == null) {
            this.specVersion = new SpecificationVersion(ArtificialFeaturesProvider.createVersion(this.getModuleInfos()));
        }
        return this.specVersion;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getNotification() {
        return null;
    }

    @Override
    public String getAuthor() {
        String string = "";
        HashSet<String> hashSet = new HashSet<String>();
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            if (moduleUpdateElementImpl.getAuthor() == null || !hashSet.add(moduleUpdateElementImpl.getAuthor())) continue;
            string = string + (string.length() == 0 ? moduleUpdateElementImpl.getAuthor() : ", " + moduleUpdateElementImpl.getAuthor());
        }
        return string;
    }

    @Override
    public String getHomepage() {
        return this.homepage;
    }

    @Override
    public int getDownloadSize() {
        int n = 0;
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            if (moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().isEmpty()) continue;
            n += moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().get(0).getDownloadSize();
        }
        return n;
    }

    @Override
    public String getSource() {
        String string = "";
        HashSet<String> hashSet = new HashSet<String>();
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            if (!hashSet.add(moduleUpdateElementImpl.getSource())) continue;
            string = string + (string.length() == 0 ? moduleUpdateElementImpl.getSource() : ", " + moduleUpdateElementImpl.getSource());
        }
        return string;
    }

    @Override
    public String getCategory() {
        if (this.isAutoload() || this.isFixed()) {
            this.category = UpdateUnitFactory.LIBRARIES_CATEGORY;
        } else if (this.isEager()) {
            this.category = UpdateUnitFactory.BRIDGES_CATEGORY;
        } else if (this.category == null || this.category.length() == 0) {
            this.category = UpdateUnitFactory.UNSORTED_CATEGORY;
        }
        return this.category;
    }

    @Override
    public String getDate() {
        String string = null;
        Date date = null;
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            String string2 = moduleUpdateElementImpl.getDate();
            if (string2 == null) continue;
            try {
                Date date2 = Utilities.parseDate(string2);
                date = date == null ? date2 : new Date(Math.max(date.getTime(), date2.getTime()));
            }
            catch (ParseException parseException) {
                assert (false) : parseException + " cannot happened.";
            }
        }
        if (date != null) {
            string = Utilities.formatDate(date);
        }
        return string;
    }

    @Override
    public String getLicence() {
        String string = "";
        HashSet<String> hashSet = new HashSet<String>();
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            String string2;
            if (moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().isEmpty() || !hashSet.add(string2 = moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().get(0).getLicence())) continue;
            string = string + (string.length() == 0 ? string2 : "<br>" + string2);
        }
        return string;
    }

    @Override
    public InstallInfo getInstallInfo() {
        return this.installInfo;
    }

    @Override
    public List<ModuleInfo> getModuleInfos() {
        ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            if (arrayList.contains(moduleUpdateElementImpl.getModuleInfo())) continue;
            arrayList.add(moduleUpdateElementImpl.getModuleInfo());
        }
        return arrayList;
    }

    public Set<ModuleUpdateElementImpl> getContainedModuleElements() {
        assert (this.moduleElementsImpl != null) : "FeatureUpdateElementImpl contains modules " + this.moduleElementsImpl;
        return this.moduleElementsImpl;
    }

    @Override
    public UpdateManager.TYPE getType() {
        return this.type;
    }

    @Override
    public boolean isEnabled() {
        boolean bl = true;
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            bl &= moduleUpdateElementImpl.isEnabled();
        }
        return bl;
    }

    @Override
    public boolean isAutoload() {
        boolean bl = true;
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            bl &= moduleUpdateElementImpl.isAutoload();
        }
        return bl;
    }

    @Override
    public boolean isEager() {
        boolean bl = true;
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            bl &= moduleUpdateElementImpl.isEager();
        }
        return bl;
    }

    @Override
    public boolean isFixed() {
        boolean bl = true;
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.getContainedModuleElements()) {
            bl &= moduleUpdateElementImpl.isFixed();
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)object;
        if (!(this.specVersion == featureUpdateElementImpl.specVersion || this.specVersion != null && this.specVersion.equals((Object)featureUpdateElementImpl.specVersion))) {
            return false;
        }
        return this.codeName == featureUpdateElementImpl.codeName || this.codeName != null && this.codeName.equals(featureUpdateElementImpl.codeName);
    }

    public int hashCode() {
        int n = 5;
        n = 61 * n + (this.codeName != null ? this.codeName.hashCode() : 0);
        n = 61 * n + (this.specVersion != null ? this.specVersion.hashCode() : 0);
        return n;
    }

    private static Logger getLogger() {
        if (LOG == null) {
            LOG = Logger.getLogger(FeatureUpdateElementImpl.class.getName());
        }
        return LOG;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Agent
    extends FeatureUpdateElementImpl {
        private Set<ModuleUpdateElementImpl> moduleElementsImpl;
        private FeatureItem featureItem;

        public Agent(FeatureItem featureItem, String string, UpdateManager.TYPE tYPE) {
            super(featureItem, string, null, tYPE);
            this.featureItem = featureItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<ModuleUpdateElementImpl> getContainedModuleElements() {
            Agent agent = this;
            synchronized (agent) {
                if (this.moduleElementsImpl == null) {
                    this.moduleElementsImpl = this.processContainedModules(this.featureItem.getModuleCodeNames(), null);
                }
            }
            assert (this.moduleElementsImpl != null) : "FeatureUpdateElementImpl contains modules " + this.moduleElementsImpl;
            return this.moduleElementsImpl;
        }

        private Set<ModuleUpdateElementImpl> processContainedModules(Set<String> set, UpdateUnitProvider updateUnitProvider) {
            HashSet<ModuleUpdateElementImpl> hashSet = new HashSet<ModuleUpdateElementImpl>();
            assert (set != null) : "Invalid Feature " + this + " with null modules.";
            if (set == null) {
                set = Collections.emptySet();
            }
            HashSet hashSet2 = new HashSet();
            for (String object2 : set) {
                hashSet2.addAll(Dependency.create((int)1, (String)object2));
            }
            List<UpdateUnit> list = updateUnitProvider == null ? UpdateManager.getDefault().getUpdateUnits(UpdateManager.TYPE.MODULE) : updateUnitProvider.getUpdateUnits(UpdateManager.TYPE.MODULE);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                UpdateUnit updateUnit = (UpdateUnit)iterator.next();
                for (Dependency dependency : hashSet2) {
                    assert (1 == dependency.getType()) : "Only Dependency.TYPE_MODULE supported, but " + dependency;
                    String string = dependency.getName();
                    if (string.indexOf(47) != -1) {
                        int updateElement = string.indexOf(47);
                        string = string.substring(0, updateElement);
                    }
                    if (!updateUnit.getCodeName().equals(string)) continue;
                    UpdateElement updateElement = Agent.getMatchedUpdateElement(updateUnit, dependency);
                    if (updateElement != null) {
                        assert (Trampoline.API.impl(updateElement) instanceof ModuleUpdateElementImpl) : "Impl of " + updateElement + " is instanceof ModuleUpdateElementImpl.";
                        ModuleUpdateElementImpl moduleUpdateElementImpl = (ModuleUpdateElementImpl)Trampoline.API.impl(updateElement);
                        hashSet.add(moduleUpdateElementImpl);
                        continue;
                    }
                    LOG.log(Level.INFO, this.getUpdateUnit() + " requires a module " + string + " what is not present.");
                }
            }
            return hashSet;
        }

        private static UpdateElement getMatchedUpdateElement(UpdateUnit updateUnit, Dependency dependency) {
            if (Agent.match(updateUnit.getInstalled(), dependency)) {
                return updateUnit.getInstalled();
            }
            if (!updateUnit.getAvailableUpdates().isEmpty() && Agent.match(updateUnit.getAvailableUpdates().get(0), dependency)) {
                return updateUnit.getAvailableUpdates().get(0);
            }
            return null;
        }

        private static boolean match(UpdateElement updateElement, Dependency dependency) {
            if (updateElement == null) {
                return false;
            }
            return DependencyChecker.checkDependencyModuleAllowEqual(dependency, Utilities.takeModuleInfo(updateElement));
        }
    }
}

