/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.general;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.core.ui.options.general.WebBrowsersOptionsModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WebBrowsersOptionsPanel
extends JPanel
implements ListSelectionListener {
    private WebBrowsersOptionsModel browsersModel;
    private DocumentListener fieldDocListener;
    private JButton addButton;
    private JLabel browsersLabel;
    private JList browsersList;
    private JPanel customPropertyPanel;
    private JScrollPane jScrollPane1;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton removeButton;

    public WebBrowsersOptionsPanel(WebBrowsersOptionsModel webBrowsersOptionsModel, String string) {
        this.browsersModel = webBrowsersOptionsModel;
        this.initComponents();
        List<WebBrowsersOptionsModel.PropertyPanelDesc> list = this.browsersModel.getPropertyPanels();
        for (WebBrowsersOptionsModel.PropertyPanelDesc propertyPanelDesc : list) {
            this.customPropertyPanel.add((Component)propertyPanelDesc.panel, propertyPanelDesc.id);
        }
        this.browsersList.setModel(this.browsersModel);
        this.browsersList.addListSelectionListener(this);
        this.browsersList.setSelectedValue(string, true);
        this.fieldDocListener = new BrowsersDocListener();
        this.addListenerToField();
    }

    private void initComponents() {
        this.browsersLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.browsersList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.customPropertyPanel = new JPanel();
        this.browsersLabel.setLabelFor(this.browsersList);
        Mnemonics.setLocalizedText((JLabel)this.browsersLabel, (String)NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.browsersLabel.text"));
        this.jScrollPane1.setViewportView(this.browsersList);
        this.browsersList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.browsersList.AccessibleContext.accessibleName"));
        this.browsersList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.browsersList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebBrowsersOptionsPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebBrowsersOptionsPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.nameLabel.text"));
        this.nameTextField.setText(NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.nameTextField.text"));
        this.customPropertyPanel.setMaximumSize(new Dimension(350, 250));
        this.customPropertyPanel.setPreferredSize(new Dimension(300, 200));
        this.customPropertyPanel.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 170, -2).add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.nameLabel).add(18, 18, 18).add((Component)this.nameTextField, -1, 299, Short.MAX_VALUE)).add((Component)this.customPropertyPanel, -1, 348, Short.MAX_VALUE))).add((Component)this.browsersLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addButton, this.removeButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.browsersLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameTextField, -2, -1, -2)).add(18, 18, 18).add((Component)this.customPropertyPanel, -2, 188, -2)).add(2, (Component)this.jScrollPane1, -1, 259, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.addButton).add((Component)this.removeButton)).addContainerGap()));
        this.browsersLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.browsersLabel.AccessibleContext.accessibleDescription"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.addButton.AccessibleContext.accessibleDescription"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.removeButton.AccessibleContext.accessibleDescription"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.nameLabel.AccessibleContext.accessibleDescription"));
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.nameTextField.AccessibleContext.accessibleName"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.nameTextField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebBrowsersOptionsPanel.class, (String)"WebBrowsersOptionsPanel.AccessibleContext.accessibleDescription"));
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.browsersList.getSelectedIndex();
        this.browsersModel.removeBrowser(n);
        if (n > 1) {
            this.browsersList.setSelectedIndex(n - 1);
        } else {
            this.browsersList.setSelectedIndex(0);
        }
        if (this.browsersModel.getSize() == 0) {
            this.removeButton.setEnabled(false);
            this.removeListenerFromField();
            this.nameTextField.setText("");
            this.addListenerToField();
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.browsersModel.addBrowser();
        int n = this.browsersModel.getSize() - 1;
        this.customPropertyPanel.add((Component)this.browsersModel.getPropertyPanel(n), this.browsersModel.getPropertyPanelID(n));
        this.browsersList.setSelectedIndex(n);
        this.browsersList.ensureIndexIsVisible(n);
        if (this.browsersModel.getSize() > 0 && !this.removeButton.isEnabled()) {
            this.removeButton.setEnabled(true);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && !this.browsersModel.isAdjusting()) {
            int n = this.browsersList.getSelectedIndex();
            String string = this.browsersModel.getPropertyPanelID(n);
            ((CardLayout)this.customPropertyPanel.getLayout()).show(this.customPropertyPanel, string);
            this.nameTextField.setText(this.browsersModel.getBrowserName(n));
            if (this.browsersModel.isDefaultBrowser(n)) {
                this.nameTextField.setEditable(false);
                this.removeButton.setEnabled(false);
            } else {
                this.nameTextField.setEditable(true);
                this.removeButton.setEnabled(true);
            }
            this.browsersModel.setSelectedValue(this.browsersList.getSelectedValue());
        }
    }

    private void removeListenerFromField() {
        this.nameTextField.getDocument().removeDocumentListener(this.fieldDocListener);
    }

    private void addListenerToField() {
        this.nameTextField.getDocument().addDocumentListener(this.fieldDocListener);
    }

    private class BrowsersDocListener
    implements DocumentListener {
        private BrowsersDocListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void update(DocumentEvent documentEvent) {
            int n = WebBrowsersOptionsPanel.this.browsersList.getSelectedIndex();
            Document document = documentEvent.getDocument();
            if (document.equals(WebBrowsersOptionsPanel.this.nameTextField.getDocument())) {
                WebBrowsersOptionsPanel.this.browsersModel.setBrowserName(n, WebBrowsersOptionsPanel.this.nameTextField.getText());
            }
        }
    }
}

