/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.notifications;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.core.ui.notifications.NotificationImpl;
import org.netbeans.core.ui.notifications.PopupList;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NotificationDisplayerImpl
extends NotificationDisplayer {
    static final String PROP_NOTIFICATION_ADDED = "notificationAdded";
    static final String PROP_NOTIFICATION_REMOVED = "notificationRemoved";
    private final List<NotificationImpl> model = new LinkedList<NotificationImpl>();
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport((Object)this);

    static NotificationDisplayerImpl getInstance() {
        return (NotificationDisplayerImpl)((Object)Lookup.getDefault().lookup(NotificationDisplayer.class));
    }

    public Notification notify(String string, Icon icon, String string2, ActionListener actionListener, NotificationDisplayer.Priority priority) {
        if (null == string2) {
            throw new NullPointerException("detailsText cannot be null.");
        }
        JComponent jComponent = this.createDetails(string2, actionListener);
        JComponent jComponent2 = this.createDetails(string2, actionListener);
        return this.notify(string, icon, jComponent, jComponent2, priority);
    }

    public Notification notify(String string, Icon icon, JComponent jComponent, JComponent jComponent2, NotificationDisplayer.Priority priority) {
        NotificationImpl notificationImpl = new NotificationImpl();
        return this.notify(notificationImpl, string, icon, jComponent, jComponent2, priority);
    }

    private Notification notify(NotificationImpl notificationImpl, String string, Icon icon, JComponent jComponent, JComponent jComponent2, NotificationDisplayer.Priority priority) {
        if (null == string) {
            throw new NullPointerException("title cannot be null.");
        }
        if (null == icon) {
            throw new NullPointerException("icon cannot be null.");
        }
        if (null == jComponent) {
            throw new NullPointerException("balloonDetails cannot be null.");
        }
        if (null == jComponent2) {
            throw new NullPointerException("popupDetails cannot be null.");
        }
        if (null == priority) {
            throw new NullPointerException("priority cannot be null.");
        }
        try {
            string = XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            throw new IllegalArgumentException(charConversionException);
        }
        JComponent jComponent3 = this.createTitle(string);
        JComponent jComponent4 = this.createContent(icon, jComponent3, jComponent, notificationImpl);
        jComponent4.setBorder(BorderFactory.createEmptyBorder(8, 5, 0, 0));
        jComponent3 = this.createTitle(string);
        JComponent jComponent5 = this.createContent(icon, jComponent3, jComponent2, notificationImpl);
        notificationImpl.init(string, icon, priority, jComponent4, jComponent5);
        this.add(notificationImpl);
        return notificationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(NotificationImpl notificationImpl) {
        List<NotificationImpl> list = this.model;
        synchronized (list) {
            this.model.add(notificationImpl);
            Collections.sort(this.model);
        }
        this.firePropertyChange(PROP_NOTIFICATION_ADDED, notificationImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(NotificationImpl notificationImpl) {
        List<NotificationImpl> list = this.model;
        synchronized (list) {
            if (!this.model.contains(notificationImpl)) {
                return;
            }
            this.model.remove(notificationImpl);
        }
        this.firePropertyChange(PROP_NOTIFICATION_REMOVED, notificationImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        List<NotificationImpl> list = this.model;
        synchronized (list) {
            return this.model.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<NotificationImpl> getNotifications() {
        ArrayList<NotificationImpl> arrayList = null;
        List<NotificationImpl> list = this.model;
        synchronized (list) {
            arrayList = new ArrayList<NotificationImpl>(this.model);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NotificationImpl getTopNotification() {
        NotificationImpl notificationImpl = null;
        List<NotificationImpl> list = this.model;
        synchronized (list) {
            if (!this.model.isEmpty()) {
                notificationImpl = this.model.get(0);
            }
        }
        return notificationImpl;
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private JComponent createContent(Icon icon, JComponent jComponent, JComponent jComponent2, final Notification notification) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)new JLabel(icon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)jComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)jComponent2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                notification.clear();
                PopupList.dismiss();
            }
        };
        this.addActionListener(jComponent2, actionListener);
        return jPanel;
    }

    private void addActionListener(Container container, ActionListener actionListener) {
        if (container instanceof AbstractButton) {
            ((AbstractButton)container).addActionListener(actionListener);
        }
        for (Component component : container.getComponents()) {
            if (!(component instanceof Container)) continue;
            this.addActionListener((Container)component, actionListener);
        }
    }

    private JComponent createTitle(String string) {
        return new JLabel("<html>" + string);
    }

    private JComponent createDetails(String string, ActionListener actionListener) {
        if (null == actionListener) {
            return new JLabel(string);
        }
        try {
            string = "<html><u>" + XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            throw new IllegalArgumentException(charConversionException);
        }
        JButton jButton = new JButton(string);
        jButton.setFocusable(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setOpaque(false);
        jButton.setContentAreaFilled(false);
        jButton.addActionListener(actionListener);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setForeground(Color.blue);
        return jButton;
    }

    private void firePropertyChange(final String string, final NotificationImpl notificationImpl) {
        Runnable runnable = new Runnable(){

            public void run() {
                NotificationDisplayerImpl.this.propSupport.firePropertyChange(string, null, notificationImpl);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

