/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.options.keymap.Utils;

public class ShortcutListener
implements KeyListener {
    private JTextField textField;
    private boolean enterConfirms;
    private KeyStroke backspaceKS = KeyStroke.getKeyStroke(8, 0);
    private KeyStroke enterKS = KeyStroke.getKeyStroke(10, 0);
    private String key = "";

    public ShortcutListener(boolean bl) {
        this.enterConfirms = bl;
    }

    public void clear() {
        this.key = "";
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        assert (keyEvent.getSource() instanceof JTextField);
        if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 27) {
            return;
        }
        this.textField = (JTextField)keyEvent.getSource();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
        boolean bl2 = bl = keyEvent.getKeyCode() != 16 && keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 18 && keyEvent.getKeyCode() != 157 && keyEvent.getKeyCode() != 65406;
        if (!this.enterConfirms || !keyStroke.equals(this.enterKS)) {
            if (keyStroke.equals(this.backspaceKS) && !this.key.equals("")) {
                int n = this.key.lastIndexOf(32);
                this.key = n < 0 ? "" : this.key.substring(0, n);
                this.textField.setText(this.key);
            } else {
                this.addKeyStroke(keyStroke, bl);
            }
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    private void addKeyStroke(KeyStroke keyStroke, boolean bl) {
        String string = Utils.getKeyStrokeAsText(keyStroke);
        if (this.key.equals("")) {
            this.textField.setText(string);
            if (bl) {
                this.key = string;
            }
        } else {
            this.textField.setText(this.key + " " + string);
            if (bl) {
                this.key = this.key + " " + string;
            }
        }
    }
}

