/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.hints.infrastructure;

import java.awt.Dialog;
import java.awt.Dimension;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.lexer.Language;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

final class PreviewHintFix
implements EnhancedFix {
    private ParserResult info;
    private PreviewableFix fix;
    private final String sortText;

    PreviewHintFix(ParserResult parserResult, PreviewableFix previewableFix, String string) {
        this.info = parserResult;
        this.fix = previewableFix;
        this.sortText = string;
    }

    public String getText() {
        return "    " + NbBundle.getMessage(PreviewHintFix.class, (String)"PreviewHint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeInfo implement() throws Exception {
        EditList editList = this.fix.getEditList();
        Document document = this.info.getSnapshot().getSource().getDocument(true);
        OffsetRange offsetRange = new OffsetRange(0, document.getLength());
        String string = document.getText(offsetRange.getStart(), offsetRange.getEnd());
        BaseDocument baseDocument = new BaseDocument(null, false);
        Language language = (Language)document.getProperty(Language.class);
        baseDocument.putProperty(Language.class, (Object)language);
        String string2 = (String)document.getProperty("mimeType");
        baseDocument.putProperty((Object)"mimeType", (Object)string2);
        baseDocument.insertString(0, string, null);
        editList.applyToDocument(baseDocument);
        String string3 = baseDocument.getText(0, baseDocument.getLength());
        String string4 = NbBundle.getMessage(PreviewHintFix.class, (String)"CurrentSource");
        String string5 = NbBundle.getMessage(PreviewHintFix.class, (String)"FixedSource");
        final DiffController diffController = DiffController.create((StreamSource)new DiffSource(string, string4), (StreamSource)new DiffSource(string3, string5));
        JComponent jComponent = diffController.getJComponent();
        jComponent.setPreferredSize(new Dimension(800, 600));
        final int n = diffController.getDifferenceCount() == 0 ? NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)editList.getRange().getStart()) : -1;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (n != -1) {
                    diffController.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.LineNumber, n);
                } else if (diffController.getDifferenceCount() > 0) {
                    diffController.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.DifferenceIndex, 0);
                }
            }
        });
        JButton jButton = new JButton(NbBundle.getMessage(PreviewHintFix.class, (String)"Apply"));
        JButton jButton2 = new JButton(NbBundle.getMessage(PreviewHintFix.class, (String)"Ok"));
        JButton jButton3 = new JButton(NbBundle.getMessage(PreviewHintFix.class, (String)"Cancel"));
        String string6 = NbBundle.getMessage(PreviewHintFix.class, (String)"PreviewTitle", (Object)this.fix.getDescription());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jComponent, string6, true, new Object[]{jButton, jButton2, jButton3}, (Object)jButton2, 0, null, null, true);
        Dialog dialog = null;
        try {
            dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == jButton) {
                this.fix.implement();
            }
        }
        finally {
            if (dialog != null) {
                dialog.dispose();
            }
        }
        return null;
    }

    public CharSequence getSortText() {
        return this.sortText;
    }

    private class DiffSource
    extends StreamSource {
        private String source;
        private String title;

        private DiffSource(String string, String string2) {
            this.source = string;
            this.title = string2;
        }

        public String getName() {
            return "?";
        }

        public String getTitle() {
            return this.title;
        }

        public String getMIMEType() {
            return PreviewHintFix.this.info.getSnapshot().getMimeType();
        }

        public Reader createReader() throws IOException {
            return new StringReader(this.source);
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isEditable() {
            return false;
        }
    }
}

