/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JToolTip;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.GsfLanguage;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.editor.completion.GsfCompletionDoc;
import org.netbeans.modules.csl.editor.completion.GsfCompletionItem;
import org.netbeans.modules.csl.editor.completion.MethodParamsTipPaintComponent;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class GsfCompletionProvider
implements CompletionProvider {
    private static boolean caseSensitive = true;
    private static boolean autoPopup = true;
    private static boolean inited;
    private static PreferenceChangeListener settingsListener;

    private static org.netbeans.modules.csl.core.Language getCompletableLanguage(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        List<org.netbeans.modules.csl.core.Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
        for (org.netbeans.modules.csl.core.Language language : list) {
            if (language.getCompletionProvider() == null) continue;
            return language;
        }
        return null;
    }

    public static CodeCompletionHandler getCompletable(Document document, int n) {
        org.netbeans.modules.csl.core.Language language = GsfCompletionProvider.getCompletableLanguage(document, n);
        if (language != null) {
            return language.getCompletionProvider();
        }
        return null;
    }

    public static CodeCompletionHandler getCompletable(ParserResult parserResult) {
        org.netbeans.modules.csl.core.Language language = LanguageRegistry.getInstance().getLanguageByMimeType(parserResult.getSnapshot().getMimeType());
        if (language != null) {
            return language.getCompletionProvider();
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        CodeCompletionHandler codeCompletionHandler;
        if (!autoPopup) {
            return 0;
        }
        if (string.length() > 0 && (codeCompletionHandler = GsfCompletionProvider.getCompletable(jTextComponent.getDocument(), jTextComponent.getCaretPosition())) != null) {
            CodeCompletionHandler.QueryType queryType = codeCompletionHandler.getAutoQuery(jTextComponent, string);
            switch (queryType) {
                case NONE: {
                    return 0;
                }
                case STOP: {
                    Completion.get().hideAll();
                    return 0;
                }
                case COMPLETION: {
                    return 1;
                }
                case DOCUMENTATION: {
                    return 2;
                }
                case TOOLTIP: {
                    return 4;
                }
                case ALL_COMPLETION: {
                    return 9;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJavaContext(JTextComponent jTextComponent, int n) {
        Document document = jTextComponent.getDocument();
        Language language = (Language)document.getProperty(Language.class);
        if (language == null) {
            return true;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            TokenSequence tokenSequence = TokenHierarchy.get((Document)jTextComponent.getDocument()).tokenSequence();
            if (tokenSequence == null) {
                boolean bl = false;
                return bl;
            }
            if (!tokenSequence.moveNext() || tokenSequence.move(n) == 0) {
                boolean bl = true;
                return bl;
            }
            if (!tokenSequence.moveNext()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
    }

    public static boolean startsWith(String string, String string2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        return GsfCompletionProvider.isCaseSensitive() ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if ((n & 1) != 0 || n == 4 || n == 2) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new JavaCompletionQuery(n, jTextComponent.getSelectionStart()), jTextComponent);
        }
        return null;
    }

    static CompletionTask createDocTask(ElementHandle elementHandle, ParserResult parserResult) {
        JavaCompletionQuery javaCompletionQuery = new JavaCompletionQuery(2, -1);
        javaCompletionQuery.element = elementHandle;
        return new AsyncCompletionTask((AsyncCompletionQuery)javaCompletionQuery, EditorRegistry.lastFocusedComponent());
    }

    private static boolean isCaseSensitive() {
        GsfCompletionProvider.lazyInit();
        return caseSensitive;
    }

    private static void setCaseSensitive(boolean bl) {
        GsfCompletionProvider.lazyInit();
        caseSensitive = bl;
    }

    private static void setAutoPopup(boolean bl) {
        GsfCompletionProvider.lazyInit();
        autoPopup = bl;
    }

    private static void lazyInit() {
        if (!inited) {
            inited = true;
            Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)settingsListener, (Object)preferences));
            GsfCompletionProvider.setCaseSensitive(preferences.getBoolean("completion-case-sensitive", false));
            GsfCompletionProvider.setAutoPopup(preferences.getBoolean("completion-auto-popup", false));
        }
    }

    static {
        settingsListener = new SettingsListener();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class JavaCompletionQuery
    extends AsyncCompletionQuery {
        private Collection<CompletionItem> results;
        private JToolTip toolTip;
        private CompletionDocumentation documentation;
        private int anchorOffset;
        private JTextComponent component;
        private int queryType;
        private int caretOffset;
        private String filterPrefix;
        private ElementHandle element;
        private boolean isTruncated;
        private boolean isFilterable;

        private JavaCompletionQuery(int n, int n2) {
            this.queryType = n;
            this.caretOffset = n2;
        }

        protected void preQueryUpdate(JTextComponent jTextComponent) {
            int n = jTextComponent.getSelectionStart();
            if (n >= this.caretOffset) {
                try {
                    Document document = jTextComponent.getDocument();
                    org.netbeans.modules.csl.core.Language language = GsfCompletionProvider.getCompletableLanguage(document, this.caretOffset);
                    if (this.isJavaIdentifierPart(language, document.getText(this.caretOffset, n - this.caretOffset))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            Completion.get().hideCompletion();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet completionResultSet, Document document, final int n) {
            try {
                this.caretOffset = n;
                if (this.queryType == 4 || this.queryType == 2 || GsfCompletionProvider.isJavaContext(this.component, n)) {
                    this.results = null;
                    this.isTruncated = false;
                    this.isFilterable = true;
                    this.documentation = null;
                    this.toolTip = null;
                    this.anchorOffset = -1;
                    Source source = Source.create((Document)document);
                    if (source == null) {
                        FileObject fileObject = null;
                        if (this.element != null && (fileObject = this.element.getFileObject()) != null) {
                            source = Source.create((FileObject)fileObject);
                        }
                    }
                    if (source != null) {
                        if (IndexingManager.getDefault().isIndexing()) {
                            completionResultSet.setWaitText(NbBundle.getMessage(GsfCompletionProvider.class, (String)"scanning-in-progress"));
                        }
                        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                Parser.Result result = resultIterator.getParserResult(n);
                                if (!(result instanceof ParserResult)) {
                                    return;
                                }
                                ParserResult parserResult = (ParserResult)result;
                                if (parserResult == null) {
                                    return;
                                }
                                if ((JavaCompletionQuery.this.queryType & 1) != 0) {
                                    JavaCompletionQuery.this.resolveCompletion(parserResult);
                                } else if (JavaCompletionQuery.this.queryType == 4) {
                                    JavaCompletionQuery.this.resolveToolTip(parserResult);
                                } else if (JavaCompletionQuery.this.queryType == 2) {
                                    JavaCompletionQuery.this.resolveDocumentation(parserResult);
                                }
                                GsfCompletionItem.tipProposal = null;
                            }

                            public void cancel() {
                            }
                        });
                        if ((this.queryType & 1) != 0) {
                            if (this.results != null) {
                                completionResultSet.addAllItems(this.results);
                            }
                        } else if (this.queryType == 4) {
                            if (this.toolTip != null) {
                                completionResultSet.setToolTip(this.toolTip);
                            }
                        } else if (this.queryType == 2 && this.documentation != null) {
                            completionResultSet.setDocumentation(this.documentation);
                        }
                        if (this.results != null && this.results.size() == 0) {
                            this.isFilterable = false;
                        }
                        if (this.anchorOffset > -1) {
                            completionResultSet.setAnchorOffset(this.anchorOffset);
                        }
                    }
                }
            }
            catch (ParseException parseException) {
                Exceptions.printStackTrace((Throwable)parseException);
            }
            finally {
                completionResultSet.finish();
            }
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            this.filterPrefix = null;
            int n = jTextComponent.getSelectionStart();
            if ((this.queryType & 1) != 0) {
                if (this.isTruncated || !this.isFilterable) {
                    return false;
                }
                int n2 = Math.min(this.anchorOffset, this.caretOffset);
                if (n2 > -1) {
                    if (n < n2) {
                        return true;
                    }
                    if (n >= this.caretOffset) {
                        try {
                            Document document = jTextComponent.getDocument();
                            org.netbeans.modules.csl.core.Language language = GsfCompletionProvider.getCompletableLanguage(document, this.caretOffset);
                            String string = document.getText(n2, n - n2);
                            String string2 = this.filterPrefix = this.isJavaIdentifierPart(language, string) ? string : null;
                            if (this.filterPrefix != null && this.filterPrefix.length() == 0) {
                                this.anchorOffset = n;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        return true;
                    }
                }
                return false;
            }
            if (this.queryType == 4) {
                try {
                    if (n == this.caretOffset) {
                        this.filterPrefix = "";
                    } else if (n - this.caretOffset > 0) {
                        this.filterPrefix = jTextComponent.getDocument().getText(this.caretOffset, n - this.caretOffset);
                    } else if (n - this.caretOffset < 0) {
                        this.filterPrefix = jTextComponent.getDocument().getText(n, this.caretOffset - n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return this.filterPrefix != null && this.filterPrefix.indexOf(44) == -1 && this.filterPrefix.indexOf(40) == -1 && this.filterPrefix.indexOf(41) == -1;
            }
            return false;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            try {
                if ((this.queryType & 1) != 0) {
                    if (this.results != null) {
                        if (this.filterPrefix != null) {
                            completionResultSet.addAllItems(this.getFilteredData(this.results, this.filterPrefix));
                        } else {
                            Completion.get().hideDocumentation();
                            Completion.get().hideCompletion();
                        }
                    }
                } else if (this.queryType == 4) {
                    completionResultSet.setToolTip(this.toolTip);
                }
                completionResultSet.setAnchorOffset(this.anchorOffset);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            completionResultSet.finish();
        }

        private void resolveToolTip(ParserResult parserResult) throws IOException {
            int n;
            ParameterInfo parameterInfo;
            CompletionProposal completionProposal = GsfCompletionItem.tipProposal;
            Env env = this.getCompletionEnvironment(parserResult, false);
            CodeCompletionHandler codeCompletionHandler = env.getCompletable();
            if (codeCompletionHandler != null && (parameterInfo = codeCompletionHandler.parameters(parserResult, n = env.getOffset(), completionProposal)) != ParameterInfo.NONE) {
                List<String> list = parameterInfo.getNames();
                int n2 = 50;
                int n3 = 0;
                ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    String string = list.get(i);
                    if (i < n4 - 1) {
                        string = string + ", ";
                    }
                    arrayList2.add(string);
                    if ((n3 += string.length()) <= n2) continue;
                    n3 = 0;
                    arrayList.add(arrayList2);
                    arrayList2 = new ArrayList();
                }
                if (arrayList2.size() > 0) {
                    arrayList.add(arrayList2);
                }
                n4 = parameterInfo.getCurrentIndex();
                this.anchorOffset = parameterInfo.getAnchorOffset();
                if (this.anchorOffset == -1) {
                    this.anchorOffset = n;
                }
                this.toolTip = new MethodParamsTipPaintComponent(arrayList, n4, this.component);
                return;
            }
        }

        private void resolveDocumentation(ParserResult parserResult) throws IOException {
            if (this.element != null) {
                this.documentation = GsfCompletionDoc.create(parserResult, this.element);
            } else {
                Env env = this.getCompletionEnvironment(parserResult, false);
                int n = env.getOffset();
                String string = env.getPrefix();
                this.results = new ArrayList<CompletionItem>();
                this.isTruncated = false;
                this.isFilterable = true;
                this.anchorOffset = env.getOffset() - (string != null ? string.length() : 0);
                CodeCompletionHandler codeCompletionHandler = env.getCompletable();
                if (codeCompletionHandler != null) {
                    CodeCompletionContextImpl codeCompletionContextImpl = new CodeCompletionContextImpl(n, parserResult, string, false, CodeCompletionHandler.QueryType.DOCUMENTATION);
                    CodeCompletionResult codeCompletionResult = codeCompletionHandler.complete(codeCompletionContextImpl);
                    if (codeCompletionResult == null) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, codeCompletionHandler.getClass().getName() + " should return CodeCompletionResult.NONE rather than null");
                        codeCompletionResult = CodeCompletionResult.NONE;
                    }
                    if (codeCompletionResult != CodeCompletionResult.NONE) {
                        for (CompletionProposal completionProposal : codeCompletionResult.getItems()) {
                            ElementHandle elementHandle = completionProposal.getElement();
                            if (elementHandle == null) continue;
                            this.documentation = GsfCompletionDoc.create(parserResult, elementHandle);
                            if (this.documentation.getText() == null || this.documentation.getText().length() <= 0) continue;
                            break;
                        }
                    }
                }
            }
        }

        private void resolveCompletion(ParserResult parserResult) throws IOException {
            Env env = this.getCompletionEnvironment(parserResult, true);
            int n = env.getOffset();
            String string = env.getPrefix();
            this.results = new ArrayList<CompletionItem>();
            this.isTruncated = false;
            this.isFilterable = true;
            this.anchorOffset = env.getOffset() - (string != null ? string.length() : 0);
            CodeCompletionHandler codeCompletionHandler = env.getCompletable();
            if (codeCompletionHandler != null) {
                this.addCodeCompletionItems(parserResult, codeCompletionHandler, n, string);
                if (this.isTruncated) {
                    GsfCompletionItem gsfCompletionItem = GsfCompletionItem.createTruncationItem();
                    this.results.add(gsfCompletionItem);
                }
            }
        }

        private void addCodeCompletionItems(ParserResult parserResult, CodeCompletionHandler codeCompletionHandler, int n, String string) {
            CodeCompletionContextImpl codeCompletionContextImpl = new CodeCompletionContextImpl(n, parserResult, string, true, CodeCompletionHandler.QueryType.COMPLETION);
            CodeCompletionResult codeCompletionResult = codeCompletionHandler.complete(codeCompletionContextImpl);
            if (codeCompletionResult == null) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, codeCompletionHandler.getClass().getName() + " should return CodeCompletionResult.NONE rather than null");
                codeCompletionResult = CodeCompletionResult.NONE;
            }
            if (codeCompletionResult != CodeCompletionResult.NONE) {
                if (codeCompletionResult.isTruncated()) {
                    this.isTruncated = true;
                }
                if (!codeCompletionResult.isFilterable()) {
                    this.isFilterable = false;
                }
                for (CompletionProposal completionProposal : codeCompletionResult.getItems()) {
                    GsfCompletionItem gsfCompletionItem = GsfCompletionItem.createItem(completionProposal, codeCompletionResult, parserResult);
                    if (gsfCompletionItem == null) continue;
                    this.results.add(gsfCompletionItem);
                }
            }
        }

        private boolean isJavaIdentifierPart(org.netbeans.modules.csl.core.Language language, String string) {
            GsfLanguage gsfLanguage = language != null ? language.getGsfLanguage() : null;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!(gsfLanguage == null ? !Character.isJavaIdentifierPart(c) : !gsfLanguage.isIdentifierChar(c))) continue;
                return false;
            }
            return true;
        }

        private Collection getFilteredData(Collection<CompletionItem> collection, String string) {
            if (string.length() == 0) {
                return collection;
            }
            ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
            for (CompletionItem completionItem : collection) {
                if (!GsfCompletionProvider.startsWith(((Object)completionItem.getInsertPrefix()).toString(), string)) continue;
                arrayList.add(completionItem);
            }
            return arrayList;
        }

        private Env getCompletionEnvironment(ParserResult parserResult, boolean bl) throws IOException {
            int n;
            Document document = parserResult.getSnapshot().getSource().getDocument(false);
            int n2 = n = document != null ? document.getLength() : (int)parserResult.getSnapshot().getSource().getFileObject().getSize();
            if (this.caretOffset > n) {
                this.caretOffset = n;
            }
            int n3 = this.caretOffset;
            String string = null;
            CodeCompletionHandler codeCompletionHandler = GsfCompletionProvider.getCompletable(parserResult);
            try {
                int n4;
                int[] nArray;
                if (codeCompletionHandler != null) {
                    string = codeCompletionHandler.getPrefix(parserResult, n3, bl);
                }
                if (string == null && document != null && (nArray = Utilities.getIdentifierBlock((BaseDocument)((BaseDocument)document), (int)n3)) != null && (n4 = nArray[0]) < n3) {
                    string = bl ? document.getText(n4, n3 - n4) : document.getText(n4, nArray[1] - n4);
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            return new Env(n3, string, parserResult, codeCompletionHandler);
        }

        private static class CodeCompletionContextImpl
        extends CodeCompletionContext {
            private final int caretOffset;
            private final ParserResult info;
            private final String prefix;
            private final boolean prefixMatch;
            private final CodeCompletionHandler.QueryType queryType;

            public CodeCompletionContextImpl(int n, ParserResult parserResult, String string, boolean bl, CodeCompletionHandler.QueryType queryType) {
                this.caretOffset = n;
                this.info = parserResult;
                this.prefix = string;
                this.prefixMatch = bl;
                this.queryType = queryType;
            }

            public int getCaretOffset() {
                return this.caretOffset;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public CodeCompletionHandler.QueryType getQueryType() {
                return this.queryType;
            }

            public boolean isPrefixMatch() {
                return this.prefixMatch;
            }

            public boolean isCaseSensitive() {
                return GsfCompletionProvider.isCaseSensitive();
            }

            public ParserResult getParserResult() {
                return this.info;
            }
        }

        private class Env {
            private int offset;
            private String prefix;
            private ParserResult controller;
            private CodeCompletionHandler completable;
            private boolean autoCompleting;

            private Env(int n, String string, ParserResult parserResult, CodeCompletionHandler codeCompletionHandler) {
                this.offset = n;
                this.prefix = string;
                this.controller = parserResult;
                this.completable = codeCompletionHandler;
            }

            public int getOffset() {
                return this.offset;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public boolean isAutoCompleting() {
                return this.autoCompleting;
            }

            public void setAutoCompleting(boolean bl) {
                this.autoCompleting = bl;
            }

            public ParserResult getController() {
                return this.controller;
            }

            public CodeCompletionHandler getCompletable() {
                return this.completable;
            }
        }
    }

    private static class SettingsListener
    implements PreferenceChangeListener {
        private SettingsListener() {
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if (preferenceChangeEvent.getKey() == null || "completion-case-sensitive".equals(preferenceChangeEvent.getKey())) {
                GsfCompletionProvider.setCaseSensitive(Boolean.valueOf(preferenceChangeEvent.getNewValue()));
            } else if ("completion-auto-popup".equals(preferenceChangeEvent.getKey())) {
                GsfCompletionProvider.setAutoPopup(Boolean.valueOf(preferenceChangeEvent.getNewValue()));
            }
        }
    }
}

