/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class EditList {
    private static final Logger LOG = Logger.getLogger(EditList.class.getName());
    private BaseDocument doc;
    private List<Edit> edits;
    private boolean formatAll;
    private List<DelegatedPosition> positions = new ArrayList<DelegatedPosition>();

    public EditList(BaseDocument baseDocument) {
        this.doc = baseDocument;
        this.edits = new ArrayList<Edit>();
    }

    public String toString() {
        return "EditList(" + this.edits + ")";
    }

    public Position createPosition(int n) {
        return this.createPosition(n, Position.Bias.Forward);
    }

    public Position createPosition(int n, Position.Bias bias) {
        DelegatedPosition delegatedPosition = new DelegatedPosition(n, bias);
        this.positions.add(delegatedPosition);
        return delegatedPosition;
    }

    public EditList replace(int n, int n2, String string, boolean bl, int n3) {
        this.edits.add(new Edit(n, n2, string, bl, n3));
        return this;
    }

    public void applyToDocument(BaseDocument baseDocument) {
        EditList editList = new EditList(baseDocument);
        editList.formatAll = this.formatAll;
        editList.edits = this.edits;
        editList.apply();
    }

    public void setFormatAll(boolean bl) {
        this.formatAll = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() {
        Edit edit;
        if (this.edits.size() == 0) {
            return;
        }
        Collections.sort(this.edits);
        Collections.reverse(this.edits);
        final Position[] positionArray = new Position[]{null};
        Iterator<Edit> iterator = this.edits.iterator();
        while (iterator.hasNext()) {
            Edit edit2;
            edit = edit2 = iterator.next();
            final int[] nArray = new int[]{-1};
            this.doc.runAtomic(new Runnable(){

                public void run() {
                    try {
                        if (positionArray[0] == null) {
                            positionArray[0] = EditList.this.doc.createPosition(((Edit)((EditList)EditList.this).edits.get((int)0)).offset, Position.Bias.Forward);
                        }
                        if (edit.removeLen > 0) {
                            EditList.this.doc.remove(edit.offset, edit.removeLen);
                            LOG.fine("Remove text: <" + edit.offset + ", " + (edit.offset + edit.removeLen) + ">");
                        }
                        if (edit.getInsertText() != null) {
                            EditList.this.doc.insertString(edit.offset, edit.insertText, null);
                            LOG.fine("Insert text: offset=" + edit.offset + ", text='" + edit.insertText + "'\n");
                            nArray[0] = edit.offset + edit.insertText.length();
                            for (int i = 0; i < EditList.this.positions.size(); ++i) {
                                DelegatedPosition delegatedPosition = (DelegatedPosition)EditList.this.positions.get(i);
                                int n = delegatedPosition.originalOffset;
                                if (edit.getOffset() > n || nArray[0] < n) continue;
                                delegatedPosition.delegate = EditList.this.doc.createPosition(n, delegatedPosition.bias);
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
            if (!edit2.format) continue;
            final Reformat reformat = Reformat.get((Document)this.doc);
            reformat.lock();
            try {
                this.doc.runAtomic(new Runnable(){

                    public void run() {
                        try {
                            reformat.reformat(edit.offset, nArray[0]);
                            LOG.fine("Formatting: <" + edit.offset + ", " + nArray[0] + ">");
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                });
            }
            finally {
                reformat.unlock();
            }
        }
        if (this.formatAll) {
            int n = this.edits.get((int)(this.edits.size() - 1)).offset;
            int n2 = positionArray[0].getOffset();
            edit = Reformat.get((Document)this.doc);
            edit.lock();
            try {
                this.doc.runAtomic(new Runnable((Reformat)edit, n, n2){
                    final /* synthetic */ Reformat val$r;
                    final /* synthetic */ int val$firstOffset;
                    final /* synthetic */ int val$lastOffset;
                    {
                        this.val$r = reformat;
                        this.val$firstOffset = n;
                        this.val$lastOffset = n2;
                    }

                    public void run() {
                        try {
                            this.val$r.reformat(this.val$firstOffset, this.val$lastOffset);
                            LOG.fine("Formatting all: <" + this.val$firstOffset + ", " + this.val$lastOffset + ">");
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                });
            }
            finally {
                edit.unlock();
            }
        }
    }

    public OffsetRange getRange() {
        int n;
        int n2 = n = this.edits.get((int)0).offset;
        for (Edit edit : this.edits) {
            if (edit.offset < n) {
                n = edit.offset;
            }
            if (edit.offset <= n2) continue;
            n2 = edit.offset;
        }
        return new OffsetRange(n, n2);
    }

    public int firstLine(BaseDocument baseDocument) {
        OffsetRange offsetRange = this.getRange();
        return NbDocument.findLineNumber((StyledDocument)((StyledDocument)baseDocument), (int)offsetRange.getStart());
    }

    private class DelegatedPosition
    implements Position {
        private int originalOffset;
        private Position delegate;
        private Position.Bias bias;

        private DelegatedPosition(int n, Position.Bias bias) {
            this.originalOffset = n;
            this.bias = bias;
        }

        public int getOffset() {
            if (this.delegate != null) {
                return this.delegate.getOffset();
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Edit
    implements Comparable<Edit> {
        int offset;
        int removeLen;
        String insertText;
        boolean format;
        int offsetOrdinal;

        private Edit(int n, int n2, String string, boolean bl) {
            this.offset = n;
            this.removeLen = n2;
            this.insertText = string;
            this.format = bl;
        }

        private Edit(int n, int n2, String string, boolean bl, int n3) {
            this(n, n2, string, bl);
            this.offsetOrdinal = n3;
        }

        @Override
        public int compareTo(Edit edit) {
            if (this.offset == edit.offset) {
                return edit.offsetOrdinal - this.offsetOrdinal;
            }
            return this.offset - edit.offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getRemoveLen() {
            return this.removeLen;
        }

        public String getInsertText() {
            return this.insertText;
        }

        public String toString() {
            return "Edit(pos=" + this.offset + ",delete=" + this.removeLen + ",insert=" + this.insertText + ")";
        }
    }
}

