/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.formatting.api.support;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.css.formatting.api.support.AbstractIndenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndenterFormattingContext {
    private boolean firstIndenter = false;
    private boolean lastIndenter = false;
    private boolean initialized = false;
    private BaseDocument doc;
    private DocumentListener listener;
    private List<Change> changes;
    private List<List<AbstractIndenter.Line>> indentedLines;
    private IndenterFormattingContext delegate;

    public IndenterFormattingContext(BaseDocument baseDocument) {
        this.doc = baseDocument;
    }

    void initFirstIndenter() {
        assert (!this.initialized);
        if (this.isInitialized()) {
            return;
        }
        this.firstIndenter = true;
        this.initialized = true;
        this.changes = new ArrayList<Change>();
        this.listener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                IndenterFormattingContext.this.changes.add(new Change(documentEvent.getOffset(), documentEvent.getLength()));
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                IndenterFormattingContext.this.changes.add(new Change(documentEvent.getOffset(), -documentEvent.getLength()));
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.doc.addDocumentListener(this.listener);
        this.indentedLines = new ArrayList<List<AbstractIndenter.Line>>();
    }

    void setDelegate(IndenterFormattingContext indenterFormattingContext) {
        assert (!this.initialized);
        assert (indenterFormattingContext.isFirstIndenter());
        this.initialized = true;
        this.delegate = indenterFormattingContext;
    }

    List<Change> getAndClearChanges() {
        if (this.delegate != null) {
            return this.delegate.getAndClearChanges();
        }
        ArrayList<Change> arrayList = new ArrayList<Change>(this.changes);
        this.changes.clear();
        return arrayList;
    }

    public boolean isFirstIndenter() {
        return this.firstIndenter;
    }

    void setLastIndenter() {
        this.lastIndenter = true;
    }

    public boolean isLastIndenter() {
        return this.lastIndenter;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    void disableListener() {
        if (this.delegate != null) {
            this.delegate.disableListener();
            return;
        }
        assert (this.listener != null);
        this.doc.removeDocumentListener(this.listener);
    }

    void enableListener() {
        if (this.delegate != null) {
            this.delegate.enableListener();
            return;
        }
        assert (this.listener != null);
        this.doc.addDocumentListener(this.listener);
    }

    void removeListener() {
        if (this.delegate != null) {
            this.delegate.removeListener();
            this.initialized = false;
            return;
        }
        assert (this.listener != null);
        this.doc.removeDocumentListener(this.listener);
        this.initialized = false;
        this.listener = null;
    }

    List<List<AbstractIndenter.Line>> getIndentationData() {
        if (this.delegate != null) {
            return this.delegate.getIndentationData();
        }
        return this.indentedLines;
    }

    static class Change {
        public int offset;
        public int change;

        public Change(int n, int n2) {
            this.offset = n;
            this.change = n2;
        }

        public String toString() {
            return "Change[" + this.offset + ":" + this.change + "]";
        }
    }
}

