/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.formatting.api.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.formatting.api.LexUtilities;
import org.netbeans.modules.css.formatting.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.css.formatting.api.embedding.VirtualSource;
import org.netbeans.modules.css.formatting.api.support.IndentCommand;
import org.netbeans.modules.css.formatting.api.support.IndenterContextData;
import org.netbeans.modules.css.formatting.api.support.IndenterFormattingContext;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIndenter<T1 extends TokenId> {
    private Language<T1> language;
    private Context context;
    private int indentationSize;
    private static final Logger LOG = Logger.getLogger(AbstractIndenter.class.getName());
    protected static final boolean DEBUG = LOG.isLoggable(Level.FINE);
    public static boolean inUnitTestRun = false;
    private IndenterFormattingContext formattingContext;
    private boolean used = false;

    public AbstractIndenter(Language<T1> language, Context context) {
        this.language = language;
        this.context = context;
        this.indentationSize = IndentUtils.indentLevelSize((Document)this.getDocument());
        this.formattingContext = new IndenterFormattingContext(this.getDocument());
    }

    public final IndenterFormattingContext createFormattingContext() {
        return this.formattingContext;
    }

    public final void beforeReindent(Collection<? extends IndenterFormattingContext> collection) {
        assert (collection.size() > 0) : "your IndentTask must implement Lookup.Provider and return an instance of IndenterFormattingContext in it";
        IndenterFormattingContext indenterFormattingContext = null;
        IndenterFormattingContext indenterFormattingContext2 = null;
        for (IndenterFormattingContext indenterFormattingContext3 : collection) {
            if (indenterFormattingContext3.isInitialized()) {
                return;
            }
            if (indenterFormattingContext == null) {
                indenterFormattingContext = indenterFormattingContext3;
                indenterFormattingContext.initFirstIndenter();
            } else {
                indenterFormattingContext3.setDelegate(indenterFormattingContext);
            }
            indenterFormattingContext2 = indenterFormattingContext3;
        }
        assert (indenterFormattingContext != null);
        assert (indenterFormattingContext2 != null);
        indenterFormattingContext2.setLastIndenter();
    }

    protected final int getIndentationSize() {
        return this.indentationSize;
    }

    protected final Context getContext() {
        return this.context;
    }

    protected final BaseDocument getDocument() {
        return (BaseDocument)this.context.document();
    }

    protected final Language<T1> getLanguage() {
        return this.language;
    }

    protected abstract int getFormatStableStart(JoinedTokenSequence<T1> var1, int var2, int var3, OffsetRanges var4) throws BadLocationException;

    protected abstract List<IndentCommand> getLineIndent(IndenterContextData<T1> var1, List<IndentCommand> var2) throws BadLocationException;

    protected abstract boolean isWhiteSpaceToken(Token<T1> var1);

    protected abstract void reset();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reindent() {
        if (this.used && DEBUG) {
            System.err.println("WARNING: indentation task cannot be reused! is this ok?");
        }
        this.used = true;
        this.reset();
        this.beforeReindent(this.context.getLookup().lookupAll(IndenterFormattingContext.class));
        this.formattingContext.disableListener();
        try {
            List<IndenterFormattingContext.Change> list;
            if (!this.formattingContext.isFirstIndenter() && (list = this.formattingContext.getAndClearChanges()).size() > 0) {
                this.updateLineOffsets(list);
            }
            this.calculateIndentation();
            this.applyIndentation();
        }
        catch (BadLocationException badLocationException) {
            if (inUnitTestRun) {
                throw new RuntimeException(badLocationException);
            }
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        finally {
            if (this.formattingContext.isLastIndenter()) {
                this.formattingContext.removeListener();
            } else {
                this.formattingContext.enableListener();
            }
        }
    }

    private void calculateIndentation() throws BadLocationException {
        ArrayList<Line> arrayList;
        VirtualSource virtualSource;
        List<JoinedTokenSequence.CodeBlock<T1>> list;
        BaseDocument baseDocument = this.getDocument();
        int n = this.context.startOffset();
        int n2 = this.context.endOffset();
        if (DEBUG) {
            System.err.println(">> AbstractIndenter based indenter: " + this.getClass().toString());
        }
        if (LOG.isLoggable(Level.FINER)) {
            System.err.println(">> TokenHierarchy of file to be indented:");
            System.err.println(TokenHierarchy.get((Document)baseDocument));
        }
        if ((list = LexUtilities.createCodeBlocks(baseDocument, this.language, virtualSource = this.createVirtualSource())) == null) {
            return;
        }
        if (DEBUG) {
            // empty if block
        }
        JoinedTokenSequence<T1> joinedTokenSequence = JoinedTokenSequence.createFromCodeBlocks(list);
        int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2) + 1;
        if (n4 > baseDocument.getLength()) {
            n4 = baseDocument.getLength();
        }
        int n5 = 0;
        OffsetRanges offsetRanges = new OffsetRanges();
        if (n3 > 0) {
            arrayList = LexUtilities.getTokenSequence(baseDocument, n3, this.language);
            if (arrayList == null) {
                int n6 = this.findPreviousOccuranceOfOurLanguage(joinedTokenSequence, n3);
                if (n6 == -1) {
                    return;
                }
                arrayList = LexUtilities.getTokenSequence(baseDocument, n6, this.language);
                assert (arrayList != null) : "start=" + n3 + " newStart=" + n6 + " jts=" + joinedTokenSequence;
                n3 = n6;
            }
            n5 = this.getFormatStableStart(joinedTokenSequence, n3, n4, offsetRanges);
            if (DEBUG && !offsetRanges.isEmpty()) {
                System.err.println("Ignored ranges: " + offsetRanges.dump());
            }
        }
        arrayList = new ArrayList<Line>();
        List<LinePair> list2 = this.calculateLinePairs(list, n5, n4);
        if (DEBUG) {
            System.err.println("line pairs to process=" + list2);
        }
        this.processLanguage(joinedTokenSequence, list2, n5, n4, arrayList, offsetRanges);
        assert (this.formattingContext.getIndentationData() != null);
        List<List<Line>> list3 = this.formattingContext.getIndentationData();
        list3.add(arrayList);
    }

    private int findPreviousOccuranceOfOurLanguage(JoinedTokenSequence<T1> joinedTokenSequence, int n) throws BadLocationException {
        int n2;
        int n3 = Utilities.getRowStart((BaseDocument)this.getDocument(), (int)n);
        if (n3 > 0) {
            --n3;
        }
        if ((n2 = Utilities.getFirstNonWhiteRow((BaseDocument)this.getDocument(), (int)n, (boolean)false)) == -1) {
            n2 = 0;
        }
        if (joinedTokenSequence.move(n3 = Utilities.getRowStart((BaseDocument)this.getDocument(), (int)n2), true)) {
            if (!joinedTokenSequence.moveNext()) {
                joinedTokenSequence.movePrevious();
            }
            if ((n2 = joinedTokenSequence.offset()) > n) {
                return -1;
            }
            return n2;
        }
        return -1;
    }

    private void applyIndentation() throws BadLocationException {
        if (!this.formattingContext.isLastIndenter()) {
            return;
        }
        this.recalculateLineIndexes();
        int n = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)this.context.startOffset());
        int n2 = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)this.context.endOffset());
        assert (this.formattingContext.getIndentationData() != null);
        List<List<Line>> list = this.formattingContext.getIndentationData();
        List<Line> list2 = this.mergeIndentedLines(list);
        if (DEBUG) {
            System.err.println("Merged line data:");
            for (Line line : list2) {
                this.debugIndentation(line.lineStartOffset, line.lineIndent, this.getDocument().getText(line.lineStartOffset, line.lineEndOffset - line.lineStartOffset + 1).replace("\n", "").replace("\r", "").trim(), line.indentThisLine);
            }
        }
        if (list2.size() == 0) {
            return;
        }
        this.applyIndents(list2, n, n2);
    }

    private VirtualSource createVirtualSource() {
        boolean bl;
        String string = (String)this.getDocument().getProperty((Object)"mimeType");
        boolean bl2 = bl = !this.getLanguage().mimeType().equals(string);
        if (!bl) {
            return null;
        }
        for (VirtualSource.Factory factory : Lookup.getDefault().lookupAll(VirtualSource.Factory.class)) {
            VirtualSource virtualSource = factory.createVirtualSource((Document)this.getDocument(), this.language.mimeType());
            if (virtualSource == null) continue;
            if (DEBUG) {
                System.err.println("Virtual Source found:" + virtualSource.toString());
            }
            return virtualSource;
        }
        return null;
    }

    private List<ForeignLanguageBlock> eliminateUnneededBlocks(List<ForeignLanguageBlock> list, List<Line> list2) {
        ArrayList<ForeignLanguageBlock> arrayList = new ArrayList<ForeignLanguageBlock>();
        for (ForeignLanguageBlock object2 : list) {
            if (this.findLineByLineIndex(list2, object2.startLine + 1) != null) continue;
            arrayList.add(object2);
        }
        Comparator<ForeignLanguageBlock> comparator = new Comparator<ForeignLanguageBlock>(){

            @Override
            public int compare(ForeignLanguageBlock foreignLanguageBlock, ForeignLanguageBlock foreignLanguageBlock2) {
                int n = foreignLanguageBlock.startLine - foreignLanguageBlock2.startLine;
                if (n == 0) {
                    n = foreignLanguageBlock.endLine - foreignLanguageBlock2.endLine;
                }
                return n;
            }
        };
        Collections.sort(arrayList, comparator);
        ArrayList<ForeignLanguageBlock> arrayList2 = new ArrayList<ForeignLanguageBlock>();
        for (ForeignLanguageBlock foreignLanguageBlock : arrayList) {
            this.addBlockAndMergeIfNeeded(arrayList2, foreignLanguageBlock);
        }
        return arrayList2;
    }

    private void addBlockAndMergeIfNeeded(List<ForeignLanguageBlock> list, ForeignLanguageBlock foreignLanguageBlock) {
        if (list.size() == 0) {
            list.add(foreignLanguageBlock);
            return;
        }
        ForeignLanguageBlock foreignLanguageBlock2 = list.get(list.size() - 1);
        assert (foreignLanguageBlock.startLine >= foreignLanguageBlock2.startLine || foreignLanguageBlock.endLine <= foreignLanguageBlock2.endLine) : "blocks: " + list + " toAdd:" + foreignLanguageBlock;
        if (foreignLanguageBlock.startLine < foreignLanguageBlock2.startLine || foreignLanguageBlock.endLine > foreignLanguageBlock2.endLine) {
            if (foreignLanguageBlock.startLine >= foreignLanguageBlock2.startLine && foreignLanguageBlock.startLine <= foreignLanguageBlock2.endLine) {
                foreignLanguageBlock2.endLine = foreignLanguageBlock.endLine;
            } else {
                list.add(foreignLanguageBlock);
            }
        }
    }

    private void extractForeignLanguageBlocks(List<ForeignLanguageBlock> list, List<Line> list2) throws BadLocationException {
        int n = -1;
        for (Line line : list2) {
            ArrayList<IndentCommand> arrayList = new ArrayList<IndentCommand>();
            for (IndentCommand indentCommand : line.lineIndent) {
                if (indentCommand.getType() == IndentCommand.Type.BLOCK_START) {
                    assert (n == -1) : "" + line;
                    n = line.index;
                    continue;
                }
                if (indentCommand.getType() == IndentCommand.Type.BLOCK_END) {
                    if (n == -1) continue;
                    int n2 = line.index;
                    if (n2 - n > 1) {
                        list.add(new ForeignLanguageBlock(n, n2));
                    }
                    n = -1;
                    continue;
                }
                arrayList.add(indentCommand);
            }
            if (arrayList.size() == line.lineIndent.size()) continue;
            line.lineIndent = arrayList;
            if (arrayList.size() != 0) continue;
            arrayList.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, line.offset));
        }
    }

    private void applyStoredBlocks(List<Line> list, List<ForeignLanguageBlock> list2) {
        for (ForeignLanguageBlock foreignLanguageBlock : list2) {
            Line line = this.findLineByLineIndex(list, foreignLanguageBlock.startLine);
            assert (line != null) : "" + foreignLanguageBlock;
            line.foreignLanguageBlockStart = true;
            line = this.findLineByLineIndex(list, foreignLanguageBlock.endLine);
            assert (line != null) : "fb=" + foreignLanguageBlock + " lines=" + list;
            line.foreignLanguageBlockEnd = true;
        }
    }

    private List<Line> mergeIndentedLines(List<List<Line>> list) throws BadLocationException {
        List<Line> list222;
        for (List<Line> list222 : list) {
            this.addLanguageEndLine(list222);
        }
        List<ForeignLanguageBlock> list3 = new ArrayList();
        list222 = new ArrayList<Line>();
        for (List<Line> object : list) {
            this.simplifyIndentationCommands(list222, object);
            this.extractForeignLanguageBlocks(list3, object);
            this.handleLanguageGaps(list222, object);
            this.extractCommandsFromNonIndentableLines(list222, object);
        }
        List<Line> list4 = new ArrayList();
        for (List<Line> list2 : list) {
            list4 = AbstractIndenter.mergeProcessedIndentedLines(list4, list2);
        }
        if (list4.size() == 0) {
            return list4;
        }
        list3 = this.eliminateUnneededBlocks(list3, list4);
        this.applyStoredBlocks(list4, list3);
        this.applyStoredCommads(list4, list222);
        return list4;
    }

    private void handleLanguageGaps(List<LineCommandsPair> list, List<Line> list2) {
        ArrayList<Line> arrayList = new ArrayList<Line>();
        Line line = null;
        for (Line line2 : list2) {
            if (line != null && line.index + 1 != line2.index) {
                ArrayList<IndentCommand> arrayList2 = new ArrayList<IndentCommand>();
                ArrayList<IndentCommand> arrayList3 = new ArrayList<IndentCommand>();
                boolean bl = true;
                for (IndentCommand indentCommand : line2.lineIndent) {
                    if (bl && indentCommand.getType() == IndentCommand.Type.INDENT) {
                        arrayList2.add(indentCommand);
                        continue;
                    }
                    arrayList3.add(indentCommand);
                    bl = false;
                }
                line2.lineIndent = arrayList3;
                if (line2.lineIndent.size() == 0) {
                    line2.lineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, line2.offset));
                }
                if (arrayList2.size() > 0) {
                    list.add(new LineCommandsPair(line.index + 1, arrayList2));
                }
            }
            arrayList.add(line2);
            line = line2;
        }
        list2.clear();
        list2.addAll(arrayList);
    }

    private void extractCommandsFromNonIndentableLines(List<LineCommandsPair> list, List<Line> list2) {
        ArrayList<Line> arrayList = new ArrayList<Line>();
        Line line = null;
        for (Line line2 : list2) {
            if (!line2.indentThisLine) {
                ArrayList<IndentCommand> arrayList2 = new ArrayList<IndentCommand>();
                ArrayList<IndentCommand> arrayList3 = new ArrayList<IndentCommand>();
                for (IndentCommand indentCommand : line2.lineIndent) {
                    if (indentCommand.getType() == IndentCommand.Type.INDENT) {
                        arrayList2.add(indentCommand);
                        continue;
                    }
                    if (indentCommand.getType() != IndentCommand.Type.RETURN) continue;
                    if (!(line != null && line.index + 1 == line2.index || line2.emptyLine)) {
                        arrayList3.add(indentCommand);
                        continue;
                    }
                    arrayList2.add(indentCommand);
                }
                if (arrayList2.size() > 0) {
                    list.add(new LineCommandsPair(line2.index, arrayList2));
                }
                if (arrayList3.size() > 0) {
                    list.add(new LineCommandsPair(line2.index + 1, arrayList3));
                }
                line2.lineIndent = new ArrayList();
                line2.lineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, line2.offset));
                arrayList.add(line2);
            } else {
                arrayList.add(line2);
            }
            line = line2;
        }
        list2.clear();
        list2.addAll(arrayList);
    }

    private void addLanguageEndLine(List<Line> list) throws BadLocationException {
        if (list.size() == 0) {
            return;
        }
        Line line = list.get(list.size() - 1);
        if (line.preliminaryNextLineIndent.size() == 0) {
            return;
        }
        int n = line.index + 1;
        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)this.getDocument(), (int)n);
        if (n2 == -1) {
            return;
        }
        Line line2 = this.generateBasicLine(n);
        line2.indentThisLine = false;
        line2.lineIndent = new ArrayList(line.preliminaryNextLineIndent);
        list.add(line2);
    }

    private static List<Line> mergeProcessedIndentedLines(List<Line> list, List<Line> list2) {
        ArrayList<Line> arrayList = new ArrayList<Line>();
        Iterator<Line> iterator = list.iterator();
        Iterator<Line> iterator2 = list2.iterator();
        Line line = null;
        Line line2 = null;
        if (iterator.hasNext()) {
            line = iterator.next();
        }
        if (iterator2.hasNext()) {
            line2 = iterator2.next();
        }
        while (line != null && line2 != null) {
            boolean bl;
            boolean bl2;
            if (line.index < line2.index) {
                arrayList.add(line);
                bl2 = true;
                bl = false;
            } else if (line.index > line2.index) {
                arrayList.add(line2);
                bl2 = false;
                bl = true;
            } else {
                if (line.indentThisLine) {
                    arrayList.add(line);
                } else {
                    assert (!line.indentThisLine);
                    arrayList.add(line2);
                }
                bl2 = true;
                bl = true;
            }
            if (bl2) {
                line = iterator.hasNext() ? iterator.next() : null;
            }
            if (!bl) continue;
            if (iterator2.hasNext()) {
                line2 = iterator2.next();
                continue;
            }
            line2 = null;
        }
        if (line != null) {
            arrayList.add(line);
        } else if (line2 != null) {
            arrayList.add(line2);
        }
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        while (iterator2.hasNext()) {
            arrayList.add(iterator2.next());
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private void applyStoredCommads(List<Line> list, List<LineCommandsPair> list2) throws BadLocationException {
        Comparator<LineCommandsPair> comparator = new Comparator<LineCommandsPair>(){

            @Override
            public int compare(LineCommandsPair lineCommandsPair, LineCommandsPair lineCommandsPair2) {
                return lineCommandsPair.line - lineCommandsPair2.line;
            }
        };
        ArrayList<LineCommandsPair> arrayList = new ArrayList<LineCommandsPair>(list2);
        Collections.sort(arrayList, comparator);
        ArrayList<LineCommandsPair> arrayList2 = new ArrayList<LineCommandsPair>();
        LineCommandsPair lineCommandsPair = null;
        for (LineCommandsPair object2 : arrayList) {
            if (lineCommandsPair != null && lineCommandsPair.line == object2.line) {
                lineCommandsPair.commands.addAll(object2.commands);
                continue;
            }
            arrayList2.add(object2);
            lineCommandsPair = object2;
        }
        Iterator<Object> iterator = list.iterator();
        assert (list.size() > 0);
        Object var8_9 = null;
        Line line = null;
        for (LineCommandsPair lineCommandsPair2 : arrayList2) {
            void var8_10;
            while (iterator.hasNext() && (var8_10 == null || ((Line)var8_10).index < lineCommandsPair2.line)) {
                Line line2 = (Line)iterator.next();
            }
            assert (var8_10 != null);
            if (((Line)var8_10).index >= lineCommandsPair2.line) {
                ArrayList<IndentCommand> arrayList3 = new ArrayList<IndentCommand>(lineCommandsPair2.commands);
                for (IndentCommand indentCommand : ((Line)var8_10).lineIndent) {
                    if (indentCommand.getType() == IndentCommand.Type.NO_CHANGE && (indentCommand.getType() != IndentCommand.Type.NO_CHANGE || arrayList3.size() != 0)) continue;
                    arrayList3.add(indentCommand);
                }
                ((Line)var8_10).lineIndent = arrayList3;
                continue;
            }
            assert (!iterator.hasNext());
            if (line == null) {
                int n = Utilities.getRowStartFromLineOffset((BaseDocument)this.getDocument(), (int)lineCommandsPair2.line);
                if (n == -1) break;
                line = this.generateBasicLine(lineCommandsPair2.line);
                line.lineIndent = new ArrayList(lineCommandsPair2.commands);
                continue;
            }
            line.lineIndent.addAll(lineCommandsPair2.commands);
        }
        if (line != null) {
            list.add(line);
        }
    }

    private void simplifyIndentationCommands(List<LineCommandsPair> list, List<Line> list2) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        Line line = null;
        for (Line line2 : list2) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (IndentCommand indentCommand : line2.lineIndent) {
                ArrayList<IndentCommand> arrayList2;
                if (indentCommand.getType() == IndentCommand.Type.CONTINUE) {
                    if (bl) {
                        if (indentCommand.getFixedIndentSize() != -1) {
                            arrayList2 = new IndentCommand(IndentCommand.Type.INDENT, indentCommand.getLineOffset());
                            ((IndentCommand)((Object)arrayList2)).setFixedIndentSize(indentCommand.getFixedIndentSize());
                            ((IndentCommand)((Object)arrayList2)).setWasContinue();
                            arrayList.add(arrayList2);
                            bl3 = true;
                        } else {
                            arrayList2 = new IndentCommand(IndentCommand.Type.INDENT, indentCommand.getLineOffset());
                            ((IndentCommand)((Object)arrayList2)).setWasContinue();
                            arrayList.add(arrayList2);
                            bl3 = false;
                        }
                        bl = false;
                        bl2 = true;
                    }
                    line = line2;
                    continue;
                }
                if (bl2 && indentCommand.getType() != IndentCommand.Type.PRESERVE_INDENTATION) {
                    arrayList2 = arrayList;
                    assert (line != null);
                    if (line2.index - line.index > 1) {
                        ArrayList<IndentCommand> arrayList3 = new ArrayList<IndentCommand>();
                        list.add(new LineCommandsPair(line.index + 1, arrayList3));
                        arrayList2 = arrayList3;
                    }
                    if (bl3) {
                        arrayList2.add(new IndentCommand(IndentCommand.Type.RETURN, indentCommand.getLineOffset()));
                    } else {
                        arrayList2.add(new IndentCommand(IndentCommand.Type.RETURN, indentCommand.getLineOffset()));
                    }
                    bl2 = false;
                    bl = true;
                }
                if (indentCommand.getType() == IndentCommand.Type.NO_CHANGE && (indentCommand.getType() != IndentCommand.Type.NO_CHANGE || arrayList.size() != 0)) continue;
                arrayList.add(indentCommand);
            }
            if (arrayList.size() == 0) {
                IndentCommand indentCommand = new IndentCommand(IndentCommand.Type.NO_CHANGE, line2.lineStartOffset);
                if (bl2) {
                    indentCommand.setWasContinue();
                }
                arrayList.add(indentCommand);
            }
            line2.lineIndent = arrayList;
        }
    }

    private void updateLineOffsets(List<IndenterFormattingContext.Change> list) {
        if (DEBUG) {
            System.err.println("update line offset with following deltas:" + list);
        }
        for (List<Line> list2 : this.formattingContext.getIndentationData()) {
            for (Line line : list2) {
                for (IndenterFormattingContext.Change change : list) {
                    if (change.offset > line.offset) continue;
                    line.updateOffset(change.change);
                }
            }
        }
    }

    private void recalculateLineIndexes() throws BadLocationException {
        for (List<Line> list : this.formattingContext.getIndentationData()) {
            ArrayList<Line> arrayList = new ArrayList<Line>();
            Line line = null;
            for (Line line2 : list) {
                line2.recalculateLineIndex(this.getDocument());
                if (line != null && line.index == line2.index) {
                    if (DEBUG) {
                        System.err.println("WARNING: some lines where deleted by other formatter. merging " + line + " with " + line2);
                    }
                    line.lineIndent.addAll(line2.lineIndent);
                } else {
                    arrayList.add(line2);
                }
                line = line2;
            }
            if (arrayList.size() == list.size()) continue;
            list.clear();
            list.addAll(arrayList);
        }
    }

    private List<LinePair> calculateLinePairs(List<JoinedTokenSequence.CodeBlock<T1>> list, int n, int n2) throws BadLocationException {
        ArrayList<LinePair> arrayList = new ArrayList<LinePair>();
        LinePair linePair = null;
        int n3 = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)n);
        int n4 = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)n2);
        block0: for (JoinedTokenSequence.CodeBlock<T1> codeBlock : list) {
            for (JoinedTokenSequence.TokenSequenceWrapper tokenSequenceWrapper : codeBlock.tss) {
                if (tokenSequenceWrapper.isVirtual()) continue;
                LinePair linePair2 = new LinePair();
                linePair2.startingLine = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)LexUtilities.getTokenSequenceStartOffset(tokenSequenceWrapper.getTokenSequence()));
                linePair2.endingLine = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)LexUtilities.getTokenSequenceEndOffset(tokenSequenceWrapper.getTokenSequence()));
                if (linePair2.startingLine > n4) continue block0;
                if (linePair2.startingLine < n3) {
                    if (n3 >= linePair2.endingLine) continue;
                    linePair2.startingLine = n3;
                }
                if (linePair2.endingLine > n4) {
                    linePair2.endingLine = n4;
                }
                if (linePair != null && linePair.endingLine == linePair2.startingLine) {
                    linePair.endingLine = linePair2.endingLine;
                    continue;
                }
                arrayList.add(linePair2);
                linePair = linePair2;
            }
        }
        return arrayList;
    }

    private void processLanguage(JoinedTokenSequence<T1> joinedTokenSequence, List<LinePair> list, int n, int n2, List<Line> list2, OffsetRanges offsetRanges) throws BadLocationException {
        BaseDocument baseDocument = this.getDocument();
        joinedTokenSequence.moveStart();
        joinedTokenSequence.moveNext();
        Object object = list.iterator();
        while (object.hasNext()) {
            LinePair linePair = object.next();
            int n3 = linePair.startingLine;
            int n4 = linePair.endingLine;
            if (n4 > n3 && !this.doesLineStartWithOurLanguage(baseDocument, n3, joinedTokenSequence)) {
                ++n3;
            }
            if (n4 > n3 && !this.doesLineStartWithOurLanguage(baseDocument, n4, joinedTokenSequence)) {
                --n4;
            }
            for (int i = linePair.startingLine; i <= linePair.endingLine; ++i) {
                Object object2;
                int n5 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)i);
                if (n5 < n) {
                    n5 = n;
                }
                int n6 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n5);
                int n7 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n5);
                int n8 = n7 + 1;
                if (offsetRanges.contains(n5, n7)) continue;
                boolean bl = true;
                boolean bl2 = false;
                if (n6 != -1) {
                    int n9 = this.findLanguageOffset(joinedTokenSequence, n5, n7, true);
                    if (n9 > n2) continue;
                    n7 = this.findLanguageOffset(joinedTokenSequence, n7, n5, false);
                    n5 = n9;
                    if (n5 == -1 || n7 == -1 || n5 > n7) continue;
                    if (n7 > n2) {
                        n7 = n2;
                    }
                    boolean bl3 = bl = n6 == n5;
                    if (!bl && n5 - n6 == 2 && ("#{".equals(object2 = baseDocument.getText(n6, 2)) || "${".equals(object2))) {
                        bl = true;
                    }
                } else {
                    bl2 = true;
                    Language<? extends TokenId> language = LexUtilities.getLanguage(this.getDocument(), n5);
                    if (language == null || !language.equals(this.language)) continue;
                }
                int[] nArray = new int[2];
                if (offsetRanges.calculateUncoveredArea(n5, n7, nArray)) {
                    n5 = nArray[0];
                    n7 = nArray[1];
                    if (n5 == -1 && n7 == -1) continue;
                }
                if (n6 < n5) {
                    n6 = n5;
                }
                object2 = new IndenterContextData<T1>(joinedTokenSequence, n5, n7, n6, n8, bl2, bl);
                ((IndenterContextData)object2).setLanguageBlockStart(i == n3);
                ((IndenterContextData)object2).setLanguageBlockEnd(i == n4);
                ArrayList<IndentCommand> arrayList = new ArrayList<IndentCommand>();
                List<IndentCommand> list3 = this.getLineIndent((IndenterContextData<T1>)object2, (List<IndentCommand>)arrayList);
                if (list3.isEmpty()) {
                    throw new IllegalStateException("getLineIndent must always return at least IndentInstance.Type.NO_CHANGE");
                }
                if (arrayList.isEmpty()) {
                    throw new IllegalStateException("preliminaryNextLineIndent from getLineIndent must always return at least IndentInstance.Type.NO_CHANGE");
                }
                Line line = this.generateBasicLine(i);
                line.lineIndent = list3;
                line.preliminaryNextLineIndent = arrayList;
                line.lineStartOffset = n5;
                line.lineEndOffset = n7;
                line.indentThisLine = bl;
                line.emptyLine = bl2;
                list2.add(line);
                if (!DEBUG) continue;
                this.debugIndentation(((IndenterContextData)object2).getLineStartOffset(), list3, this.getDocument().getText(n5, n7 - n5 + 1).replace("\n", "").replace("\r", "").trim(), line.indentThisLine);
            }
        }
        if (DEBUG && list2.size() > 0 && (object = list2.get(list2.size() - 1).preliminaryNextLineIndent).size() > 0) {
            System.err.println("Preliminary indent commands for next line:" + object);
        }
    }

    private boolean doesLineStartWithOurLanguage(BaseDocument baseDocument, int n, JoinedTokenSequence<T1> joinedTokenSequence) throws BadLocationException {
        int n2;
        int n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n);
        int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3);
        int n5 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
        return n5 == -1 || (n2 = this.findLanguageOffset(joinedTokenSequence, n3, n4, true)) != -1;
    }

    private int findLanguageOffset(JoinedTokenSequence<T1> joinedTokenSequence, int n, int n2, boolean bl) {
        if (!joinedTokenSequence.move(n, bl)) {
            return -1;
        }
        if (!joinedTokenSequence.moveNext()) {
            if (!bl) {
                if (!joinedTokenSequence.movePrevious()) {
                    return -1;
                }
            } else {
                return -1;
            }
        }
        while (bl ? joinedTokenSequence.offset() <= n2 : joinedTokenSequence.offset() + ((Object)joinedTokenSequence.token().text()).toString().length() >= n2) {
            boolean bl2;
            int n3;
            TokenSequence<?> tokenSequence;
            boolean bl3;
            int n4 = joinedTokenSequence.offset();
            int n5 = joinedTokenSequence.offset() + ((Object)joinedTokenSequence.token().text()).toString().length();
            boolean bl4 = bl3 = joinedTokenSequence.embedded() == null;
            if (!bl3 && !(tokenSequence = joinedTokenSequence.embedded()).isEmpty()) {
                n3 = LexUtilities.getTokenSequenceStartOffset(tokenSequence);
                int n6 = LexUtilities.getTokenSequenceEndOffset(tokenSequence);
                if (bl) {
                    if (n3 > n4 && n4 >= n) {
                        bl3 = true;
                        n5 = n4 + (n3 - n4);
                    } else if (n6 < n5 && n6 >= n) {
                        bl3 = true;
                        n4 = n6;
                    }
                } else if (n6 < n5 && n5 <= n) {
                    bl3 = true;
                    n4 = n6;
                } else if (n3 > n4 && n3 <= n) {
                    bl3 = true;
                    n5 = n4 + (n3 - n4);
                }
            }
            if (bl3 && joinedTokenSequence.language() == this.language && !joinedTokenSequence.isCurrentTokenSequenceVirtual() && !(bl2 = this.isWhiteSpaceToken(joinedTokenSequence, n, n2, bl))) {
                n3 = n >= n4 && n <= n5 ? n : (n < n4 ? n4 : n5);
                n3 = this.findNonWhiteSpaceCharacter(joinedTokenSequence, n3, bl);
                return n3;
            }
            if (!(bl ? !joinedTokenSequence.moveNext() : !joinedTokenSequence.movePrevious())) continue;
            break;
        }
        return -1;
    }

    private boolean isWhiteSpaceToken(JoinedTokenSequence<T1> joinedTokenSequence, int n, int n2, boolean bl) {
        String string;
        int n3 = joinedTokenSequence.offset();
        int n4 = joinedTokenSequence.offset() + ((Object)joinedTokenSequence.token().text()).toString().length();
        if (bl) {
            if (n > n3) {
                n3 = Math.min(n, n4);
            }
            if (n2 < n4) {
                n4 = Math.max(n2, n3);
            }
        } else {
            if (n2 > n3) {
                n3 = Math.min(n2, n4);
            }
            if (n < n4) {
                n4 = Math.max(n, n3);
            }
        }
        return (string = ((Object)joinedTokenSequence.token().text()).toString().substring(n3 - joinedTokenSequence.offset(), n4 - joinedTokenSequence.offset()).trim()).length() == 0;
    }

    private int findNonWhiteSpaceCharacter(JoinedTokenSequence<T1> joinedTokenSequence, int n, boolean bl) {
        String string = ((Object)joinedTokenSequence.token().text()).toString();
        int n2 = joinedTokenSequence.offset();
        int n3 = n - n2;
        if (!bl && n3 == string.length()) {
            --n3;
        }
        while ((bl ? n3 < string.length() : n3 > 0) && string.charAt(n3) == ' ') {
            if (bl) {
                ++n3;
                continue;
            }
            --n3;
        }
        return n2 + n3;
    }

    private static int getCalulatedIndexOfPreviousIndent(List<IndentCommand> list, int n) {
        int n2 = 1;
        int n3 = list.size();
        if (n3 == 0) {
            return -1;
        }
        do {
            if (list.get(--n3).getType() == IndentCommand.Type.RETURN) {
                ++n2;
            }
            if (list.get(n3).getType() != IndentCommand.Type.INDENT) continue;
            --n2;
        } while (n2 != 0 && n3 > 0);
        if (n2 != 0 || list.get(n3).getType() != IndentCommand.Type.INDENT) {
            if (DEBUG) {
                System.err.println("WARNING: cannot find INDENT command corresponding to RETURN command at index " + (list.size() - 1) + ". make sure RETURN and INDENT commands are always paired. " + "this can be caused by wrong getFormatStableStart but also by user typing code which is not " + "syntactically correct. commands:" + (list.size() < 30 ? list : "[too many commands]"));
            }
            if (n3 + n < 0) {
                n3 = 0 - n;
            }
        }
        if (n3 + n < 0) {
            return -1;
        }
        return n3 + n;
    }

    private int calculateLineIndent(int n, List<Line> list, Line line, List<IndentCommand> list2, List<IndentCommand> list3, boolean bl, int n2) throws BadLocationException {
        list2 = this.cleanUpAndPossiblyClone(list2, !bl);
        boolean bl2 = line != null ? line.index >= n2 : false;
        int n3 = 0;
        ArrayList<IndentCommand> arrayList = new ArrayList<IndentCommand>(list3);
        int n4 = -1;
        for (IndentCommand indentCommand : list2) {
            switch (indentCommand.getType()) {
                case NO_CHANGE: {
                    break;
                }
                case INDENT: {
                    if (indentCommand.getFixedIndentSize() != -1) {
                        n3 = indentCommand.getFixedIndentSize();
                        break;
                    }
                    n3 += this.indentationSize;
                    break;
                }
                case RETURN: {
                    int n5 = AbstractIndenter.getCalulatedIndexOfPreviousIndent(arrayList, -1);
                    if (n5 == -1) break;
                    n = ((IndentCommand)arrayList.get(n5)).getCalculatedIndentation();
                    n3 = 0;
                    break;
                }
                case DO_NOT_INDENT_THIS_LINE: {
                    if (!bl) break;
                    line.indentThisLine = false;
                    break;
                }
                case PRESERVE_INDENTATION: {
                    if (!bl) break;
                    line.preserveThisLineIndent = true;
                    if (line.index != n2 || indentCommand.getFixedIndentSize() == -1 || !this.context.isIndent()) break;
                    n4 = indentCommand.getFixedIndentSize();
                }
            }
            indentCommand.setCalculatedIndentation(n + n3);
            arrayList.add(indentCommand);
        }
        int n6 = list2.get(list2.size() - 1).getCalculatedIndentation();
        int n7 = 0;
        if (!(line == null || line.preserveThisLineIndent || bl2 || line.emptyLine)) {
            n7 = line.existingLineIndent - n6;
        }
        IndentCommand indentCommand = list2.get(list2.size() - 1);
        if (n7 != 0 && !bl2) {
            indentCommand.setCalculatedIndentation(indentCommand.getCalculatedIndentation() + n7);
        }
        if (bl2) {
            n6 = list2.get(list2.size() - 1).getCalculatedIndentation();
        }
        if (bl) {
            line.indentation = n6;
            line.indentationAdjustment = n7;
        }
        if (n4 != -1) {
            line.indentation = n4;
            assert (line.indentationAdjustment == 0);
        }
        return list2.get(list2.size() - 1).getCalculatedIndentation();
    }

    private List<IndentCommand> cleanUpAndPossiblyClone(List<IndentCommand> list, boolean bl) {
        if (!bl) {
            return list;
        }
        ArrayList<IndentCommand> arrayList = new ArrayList<IndentCommand>();
        for (int i = 0; i < list.size(); ++i) {
            IndentCommand indentCommand = list.get(i);
            arrayList.add(bl ? indentCommand.cloneMe() : indentCommand);
        }
        return arrayList;
    }

    private Line findLineByLineIndex(List<Line> list, int n) {
        for (Line line : list) {
            if (line == null) continue;
            if (line.index == n) {
                return line;
            }
            if (line.index <= n) continue;
            break;
        }
        return null;
    }

    private void applyIndents(final List<Line> list, final int n, final int n2) throws BadLocationException {
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
        this.getDocument().runAtomic(new Runnable(){

            public void run() {
                try {
                    AbstractIndenter.this.applyIndents0(list, n, n2);
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        });
        if (badLocationExceptionArray[0] != null) {
            throw badLocationExceptionArray[0];
        }
    }

    private void applyIndents0(List<Line> list, int n, int n2) throws BadLocationException {
        if (DEBUG) {
            System.err.println(">> reindentation done by all AbstractIndenter subclasses:");
        }
        boolean bl = this.context.isIndent();
        int n3 = 0;
        ArrayList<IndentCommand> arrayList = new ArrayList<IndentCommand>();
        int n4 = -1;
        Line line = null;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Line line2 : list) {
            if (line != null && line.index + 1 != line2.index) {
                for (int i = line.index + 1; i < line2.index; ++i) {
                    hashMap.put(i, n4);
                }
            }
            n3 = this.calculateLineIndent(n3, list, line2, line2.lineIndent, arrayList, true, n);
            if (line2.emptyLine && !bl) {
                line2.indentation = 0;
            }
            arrayList.addAll(line2.lineIndent);
            if (!line2.indentThisLine) {
                hashMap.put(line2.index, n3);
            }
            n4 = this.calculateLineIndent(n3, list, null, line2.preliminaryNextLineIndent, arrayList, false, n);
            line = line2;
        }
        for (int i = line.index + 1; i <= n2; ++i) {
            hashMap.put(i, n4);
        }
        this.updateIndentationForPreservedLines(list, this.context.isIndent() ? n : -1);
        list = this.generateBlockIndentsForForeignLanguage(list, hashMap);
        if (DEBUG) {
            System.err.println(">> line data:");
            for (Line line2 : list) {
                System.err.println(" " + line2.dump());
            }
            System.err.println(">> line indentations:");
            for (Line line2 : list) {
                if (!line2.indentThisLine) continue;
                this.debugLineIndentation(line2, line2.index >= n && line2.index <= n2);
            }
        }
        this.storeIndentsForOtherFormatters(hashMap);
        this.modifyDocument(list, n, n2);
    }

    private void storeIndentsForOtherFormatters(Map<Integer, Integer> map) {
        this.getDocument().putProperty((Object)"AbstractIndenter.lineIndents", map);
        if (DEBUG && !map.isEmpty()) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>(map.keySet());
            System.err.print("AbstractIndenter.lineIndents:");
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                System.err.print("" + (n + 1) + ":" + map.get(n) + " ");
            }
            System.err.println("");
        }
    }

    private List<Line> generateBlockIndentsForForeignLanguage(List<Line> list, Map<Integer, Integer> map) throws BadLocationException {
        ArrayList<Line> arrayList = new ArrayList<Line>();
        ArrayList<Line> arrayList2 = new ArrayList<Line>();
        int n = -1;
        Line line = null;
        for (Line line2 : list) {
            if (line2.foreignLanguageBlockStart) {
                n = line2.index;
                line = line2;
            }
            if (line2.foreignLanguageBlockEnd) {
                if (n == -1) assert (false) : "found line.compoundEnd without start: " + list;
                if (n != line2.index) {
                    int n2 = line2.index;
                    if (!line2.indentThisLine) {
                        ++n2;
                    }
                    for (int i = n + 1; i < n2; ++i) {
                        Line line3 = this.findLineByLineIndex(arrayList2, i);
                        if (line3 == null) {
                            line3 = this.generateBasicLine(i);
                            line3.indentThisLine = true;
                            line3.preserveThisLineIndent = true;
                            line3.indentation = this.calculatePreservedLineIndentation(line, line3.offset);
                        } else if (!line3.indentThisLine) {
                            line3.preserveThisLineIndent = true;
                            line3.indentThisLine = true;
                            line3.indentation = this.calculatePreservedLineIndentation(line, line3.offset);
                        }
                        if (!line3.emptyLine) {
                            arrayList.add(line3);
                        }
                        map.remove(i);
                    }
                    arrayList2.clear();
                }
                n = -1;
            }
            if (n != -1 && line2.index > n) {
                arrayList2.add(line2);
                continue;
            }
            arrayList.add(line2);
        }
        return arrayList;
    }

    private Line generateBasicLine(int n) throws BadLocationException {
        Line line = new Line();
        line.index = n;
        line.offset = Utilities.getRowStartFromLineOffset((BaseDocument)this.getDocument(), (int)n);
        line.existingLineIndent = IndentUtils.lineIndent((Document)this.getDocument(), (int)line.offset);
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)this.getDocument(), (int)line.offset);
        line.emptyLine = n2 == -1;
        line.tabIndentation = n2 == -1 || line.existingLineIndent != n2 - line.offset;
        line.lineStartOffset = line.offset;
        line.lineEndOffset = Utilities.getRowEnd((BaseDocument)this.getDocument(), (int)line.offset);
        line.lineIndent = new ArrayList();
        line.lineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, line.offset));
        line.preliminaryNextLineIndent = new ArrayList();
        line.preliminaryNextLineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, line.offset));
        return line;
    }

    private void updateIndentationForPreservedLines(List<Line> list, int n) throws BadLocationException {
        Line line = null;
        for (Line line2 : list) {
            if (!line2.indentThisLine) continue;
            if (line2.preserveThisLineIndent) {
                if (line != null) {
                    if (n != -1 && line2.index == n) continue;
                    line2.indentation = this.calculatePreservedLineIndentation(line, line2.offset);
                    continue;
                }
                assert (false) : "lineBeforePreserveIndent was not found: " + list;
                continue;
            }
            line = line2;
        }
    }

    private int calculatePreservedLineIndentation(Line line, int n) throws BadLocationException {
        int n2 = IndentUtils.lineIndent((Document)this.getDocument(), (int)line.offset);
        int n3 = IndentUtils.lineIndent((Document)this.getDocument(), (int)n);
        return line.indentation + (n3 - n2);
    }

    private void modifyDocument(List<Line> list, int n, int n2) throws BadLocationException {
        for (int i = list.size() - 1; i >= 0; --i) {
            Line line = list.get(i);
            if (!line.indentThisLine || line.index < n || line.index > n2) continue;
            int n3 = line.indentation;
            if (n3 < 0) {
                n3 = 0;
            }
            assert (line.existingLineIndent != -1) : "line is missing existingLineIndent " + line;
            if (line.existingLineIndent == n3 && !line.tabIndentation) continue;
            this.context.modifyIndent(line.offset, n3);
        }
    }

    private void debugIndentation(int n, List<IndentCommand> list, String string, boolean bl) throws BadLocationException {
        int n2 = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)n);
        char c = ' ';
        if (bl) {
            c = '*';
        }
        System.err.println(String.format("%1c[%4d]", Character.valueOf(c), n2 + 1) + string);
        for (IndentCommand indentCommand : list) {
            System.err.println("      " + indentCommand);
        }
    }

    private void debugLineIndentation(Line line, boolean bl) throws BadLocationException {
        String string = "";
        if (line.lineStartOffset != line.lineEndOffset) {
            string = this.getDocument().getText(line.lineStartOffset, line.lineEndOffset - line.lineStartOffset + 1).replace("\n", "").replace("\r", "").trim();
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = ' ';
        if (bl) {
            c = '*';
        } else if (line.preserveThisLineIndent) {
            c = 'P';
        }
        stringBuilder.append(String.format("%1c[%4d]", Character.valueOf(c), line.index + 1));
        for (int i = 0; i < line.indentation; ++i) {
            stringBuilder.append('.');
        }
        stringBuilder.append(string);
        if (stringBuilder.length() > 75) {
            stringBuilder.setLength(75);
        }
        System.err.println(stringBuilder.toString());
    }

    private static class ForeignLanguageBlock {
        private int startLine;
        private int endLine;

        public ForeignLanguageBlock(int n, int n2) {
            this.startLine = n;
            this.endLine = n2;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public String toString() {
            return "ForeignLangBlock[" + this.startLine + "-" + this.endLine + "]";
        }
    }

    static final class Line {
        private List<IndentCommand> lineIndent;
        private List<IndentCommand> preliminaryNextLineIndent;
        private int offset;
        private int lineStartOffset;
        private int lineEndOffset;
        private int index;
        private boolean indentThisLine = true;
        private boolean preserveThisLineIndent;
        private int indentation;
        private boolean emptyLine;
        private boolean foreignLanguageBlockStart;
        private boolean foreignLanguageBlockEnd;
        private int existingLineIndent = -1;
        private boolean tabIndentation;
        private int indentationAdjustment = 0;

        Line() {
        }

        private void updateOffset(int n) {
            this.offset += n;
            this.lineStartOffset += n;
            this.lineEndOffset += n;
            for (IndentCommand indentCommand : this.lineIndent) {
                indentCommand.updateOffset(n);
            }
            for (IndentCommand indentCommand : this.preliminaryNextLineIndent) {
                indentCommand.updateOffset(n);
            }
        }

        private void recalculateLineIndex(BaseDocument baseDocument) throws BadLocationException {
            this.index = Utilities.getLineOffset((BaseDocument)baseDocument, (int)this.offset);
            int n = Utilities.getRowStart((BaseDocument)baseDocument, (int)this.offset);
            if (n != this.offset) {
                if (DEBUG) {
                    System.err.println("WARNING: disabling line indentability because its start has changed: " + this);
                }
                this.indentThisLine = false;
            }
        }

        public String dump() {
            return String.format("[%4d]", this.index + 1) + " offset=" + this.offset + " (" + this.lineStartOffset + "-" + this.lineEndOffset + ") indent=" + this.indentation + (this.indentationAdjustment != 0 ? "(" + this.indentationAdjustment + ")" : "") + (this.existingLineIndent != -1 ? " existingIndent=" + this.existingLineIndent : "") + (this.foreignLanguageBlockStart ? " foreignLangBlockStart" : "") + (this.foreignLanguageBlockEnd ? " foreignLangBlockEnd" : "") + (this.preserveThisLineIndent ? " preserve" : "") + (this.emptyLine ? " empty" : "") + (!this.indentThisLine ? " noIndent" : "");
        }

        public String toString() {
            return "Line[index=" + this.index + ",lineOffset=" + this.offset + ",startOffset=" + this.lineStartOffset + ",endOffset=" + this.lineEndOffset + ",indentation=" + this.indentation + (this.indentationAdjustment != 0 ? "(" + this.indentationAdjustment + ")" : "") + (this.existingLineIndent != -1 ? ",existingIndent=" + this.existingLineIndent : "") + (this.preserveThisLineIndent ? ",preserveThisLineIndent" : "") + (this.emptyLine ? ",empty" : "") + (!this.indentThisLine ? ",doNotIndentThisLine" : "") + ",lineIndent=" + this.lineIndent + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LineCommandsPair {
        private int line;
        private List<IndentCommand> commands;

        public LineCommandsPair(int n, List<IndentCommand> list) {
            this.line = n;
            this.commands = list;
        }

        public String toString() {
            return "LineCommandsPair[" + this.line + ":" + this.commands + "]";
        }
    }

    private final class LinePair {
        private int startingLine;
        private int endingLine;

        private LinePair() {
        }

        public int getEndingLine() {
            return this.endingLine;
        }

        public int getStartingLine() {
            return this.startingLine;
        }

        public String toString() {
            return "LP[" + this.startingLine + ":" + this.endingLine + "]";
        }
    }

    private static final class OffsetRange {
        private int start;
        private int end;

        public OffsetRange(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }

        public String toString() {
            return "OffsetRange[" + this.start + "-" + this.end + "]";
        }
    }

    public static final class OffsetRanges {
        List<OffsetRange> ranges = new ArrayList<OffsetRange>();

        public void add(int n, int n2) {
            for (OffsetRange offsetRange : this.ranges) {
                if (offsetRange.end == n) {
                    offsetRange.end = n2;
                    return;
                }
                if (offsetRange.start != n2) continue;
                offsetRange.start = n;
                return;
            }
            this.ranges.add(new OffsetRange(n, n2));
        }

        private boolean contains(int n, int n2) {
            for (OffsetRange offsetRange : this.ranges) {
                if (n < offsetRange.getStart() || n2 > offsetRange.getEnd()) continue;
                return true;
            }
            return false;
        }

        private boolean calculateUncoveredArea(int n, int n2, int[] nArray) {
            boolean bl = false;
            for (OffsetRange offsetRange : this.ranges) {
                if (n < offsetRange.getStart() && n2 > offsetRange.getEnd()) continue;
                if (n >= offsetRange.getStart() && n2 <= offsetRange.getEnd()) {
                    nArray[0] = -1;
                    nArray[1] = -1;
                    return true;
                }
                if (n >= offsetRange.getStart() && n <= offsetRange.getEnd()) {
                    assert (offsetRange.getEnd() + 1 <= n2) : "" + n + "-" + n2 + " range=" + offsetRange;
                    n = offsetRange.getEnd() + 1;
                    bl = true;
                }
                if (n2 < offsetRange.getStart() || n2 > offsetRange.getEnd()) continue;
                assert (n <= offsetRange.getStart() - 1) : "" + n + "-" + n2 + " range=" + offsetRange;
                n2 = offsetRange.getStart() - 1;
                bl = true;
            }
            if (bl) {
                nArray[0] = n;
                nArray[1] = n2;
            }
            return bl;
        }

        public boolean isEmpty() {
            return this.ranges.size() == 0;
        }

        public String dump() {
            StringBuilder stringBuilder = new StringBuilder();
            for (OffsetRange offsetRange : this.ranges) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("[" + offsetRange.start + "-" + offsetRange.end + "]");
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return "OffsetRanges[" + this.dump() + "]";
        }
    }
}

